/** ###################################################################
**     Filename  : BLDC Motor Control PT60
**     Author    : Alex Liu
**     Project   : ProcessorExpert
**     Processor : MC9S08PT60CLH
**     Version   : Driver 01.12
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 2012-02-08, 09:23, # CodeGen: 0
**     Abstract  :
**         Main module.
**         This module contains user's application code.
**     Settings  :
**     Contents  :
**         No public methods
**
** ###################################################################*/
/* MODULE ProcessorExpert */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "FTM2.h"
#include "FTM0.h"
#include "ADC.h"
#include "GPIO2.h"
#include "GPIO3.h"
#include "MTIM1.h"
#include "PortH.h"
#include "SCI.h"
#include "SPI.h"
#include "GPIO1.h"
/* Include shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
/**************************************************************************
 * 
 * added header files
 * 
 **************************************************************************/
#include "main.h"
#include "types.h"
#include "hw_config.h"
#include "intrinsic_math.h"
#include "adc_drv.h"
#include "zc_detection_drv.h"
#include "3pps_bldc_drv.h"
#include "control.h"
#include "ECLIB_Ramp16.h"
#include "S08math.h"
//added the two header file to drive low voltage tower board demo
#include "MC33927/MC33927.h"
#include "00364_01/SPI_00364_01.h"
#include "freemaster.h"
/**************************************************************************
 * 
 * Data structure declaration
 * 
 **************************************************************************/

typedef enum
{   BLDC_APP_INIT,
    BLDC_STOP,
    BLDC_ALIGNMENT,
    BLDC_START_VECTOR,
    BLDC_OPEN_LOOP_START,
    BLDC_SHIFT_VECTOR,
    BLDC_SL_RUN_DIRECT,
    BLDC_SL_RUN_SYNC_PLL,
    BLDC_SL_RUN_FORCED_PLL,
    BLDC_FAULT,
    BLDC_RESTART
} BLDC_STATE_ENUM;



typedef union {
  byte Byte;
  struct {
    byte AlignmentTimeout   :1;         /* Alignment Timeout */
    byte AlignmentIsTimed   :1;         /* Alignment is Timed */
    byte InitTimBDone       :1;         /* Timer Base Initialisation Done */
    byte CurLimit           :1;         /* Current Limitation */
    byte RestartTimeout     :1;         /* Restart Timeout */
    byte RestartIsTimed     :1;         /* Restart is Timed */
    byte Bit6               :1;         /*  */
    byte Bit7               :1;         /*  */
  } Bits;
} BLDC_INTTIMB_FLAGS;
typedef union {
  byte Byte;
  struct 
  {
    byte FaultInput1        :1;        
    byte CmtFault           :1;         
    byte DCBUndervoltage    :1;         
    byte DCBOvervoltage     :1;        
    byte Bit4               :1;        
    byte Bit5               :1;         
    byte Bit6               :1;         
    byte MC3397DTFault      :1;        
  } Bits;
} APP_FAULT_FLAGS;

typedef union{
	byte Byte;
	struct 
	{
		byte AdcSaved		    :1; 	   
		byte Bit1			    :1; 		
		byte Bit2	            :1; 		
		byte Bit3 	            :1; 	   
		byte Bit4				:1; 	   
		byte Bit5				:1; 		
		byte Bit6				:1; 		
		byte Bit7        		:1; 	   
	  } Bits;
	} ADC_CMT_FLAGS;

typedef union {
  byte Byte;
  struct 
  {
    byte CalculationDone    :1;         /* zero crsoosing periods Calculation done */
    byte CmtStabilized      :1;         /* Commutation Stabilized */
    byte CmtError           :1;         /* CommutationError */
    byte Bit3               :1;         /*  */
    byte Bit4               :1;         /*  */
    byte Bit5               :1;         /*  */
    byte Bit6               :1;         /*  */
    byte Bit7               :1;         /*  */
  } Bits;
} CMT_FLAGS;
typedef union {
  byte Byte;
  struct {
    byte BldcStart          :1;         /* BLDC motor Start request */
    byte FaultClear         :1;         /* Fault Clear request */
    byte InfinitAlignment   :1;         /* Infinite Alignment request */
    byte StartSwitchState   :1;         /* h/w start stop switch state */
    byte Bit4               :1;         /*  */
    byte Bit5               :1;         /*  */
    byte Bit6               :1;         /*  */
    byte Bit7               :1;         /*  */
  } Bits;
} APP_CONTROL_FLAGS;

typedef struct
{
    unsigned char proportionalGainConst8;
    unsigned char integralGain8;
    unsigned char gainShift;
    UWord24H16L8 integralPortionK_1_24;
    unsigned int lowerLimit;
    unsigned int upperLimit;
} REG_SYNC_PARAMS;




/***************************************************************************
 * 
 * Function declaration
 * 
 ***************************************************************************/
static void VariableLimitation_Init(void);

void FilterMAInit_F16(FILTER_MA_T_F16 *pParam);
signed int FilterMA_F16 (signed int f16In, FILTER_MA_T_F16 * pParam);

static void BLDCProcessState_AppInitEnter(void);
static void BLDCProcessState_RestartEnter(void);

static void FaultCheck_Main(void);
static void BLDCProcessState_CmtInit(void);/*motor without startup*/
static void BLDCProcessState_AlignmentEnter(void);
static void PWM_SetDutyCycle(void);
static void UpDownSwitchVelocitySet(void);
static void PeriodToVelocityOLConversion (void);
static void BLDCProcessState_OpenLoopStartEnter(void);
static void CommutationControlFalling(void);
static void CommutationControlRising(void);
void CalculZC_periodsCmtTime(void);
void CalculZC_CmtPreset(void);


/*main loop function*/
static void BLDCProcessState_AppInit_Main();
static void BLDCProcessState_Stop_Main();
static void BLDCProcessState_Alignment_Main();
static void BLDCProcessState_StartVector_Main();
static void BLDCProcessState_OpenLoopStart_Main();
static void BLDCProcessState_ShiftVector_Main();
static void BLDCProcessState_SLRunDirect_Main();
static void BLDCProcessState_SLRunSyncPLL_Main();
static void BLDCProcessState_SLRunForcedPLL_Main();
static void BLDCProcessState_Fault_Main();
static void BLDCProcessState_Restart_Main();
static FCN_POINTER BLDCProcess_MainIndexFcn[] = {   BLDCProcessState_AppInit_Main,
                                                    BLDCProcessState_Stop_Main,
                                                    BLDCProcessState_Alignment_Main,
                                                    BLDCProcessState_StartVector_Main,
                                                    BLDCProcessState_OpenLoopStart_Main,
                                                    BLDCProcessState_ShiftVector_Main,
                                                    BLDCProcessState_SLRunDirect_Main,
                                                    BLDCProcessState_SLRunSyncPLL_Main,
                                                    BLDCProcessState_SLRunForcedPLL_Main,
                                                    BLDCProcessState_Fault_Main,
                                                    BLDCProcessState_Restart_Main 
                                                 };

/*time base interrupt for main loop*/
static void BLDCProcessState_AppInit_IntTimB(void);
static void BLDCProcessState_Stop_IntTimB(void);
static void BLDCProcessState_Alignment_IntTimB(void);
static void BLDCProcessState_StartVector_IntTimB(void);
static void BLDCProcessState_OpenLoopStart_IntTimB(void);
static void BLDCProcessState_ShiftVector_IntTimB(void);
static void BLDCProcessState_SLRunDirect_IntTimB(void);
static void BLDCProcessState_SLRunSyncPLL_IntTimB(void);
static void BLDCProcessState_SLRunForcedPLL_IntTimB(void);
static void BLDCProcessState_Fault_IntTimB(void);
static void BLDCProcessState_Restart_IntTimB(void);
static FCN_POINTER BLDCProcess_IntTimBIndexFcn[] = { BLDCProcessState_AppInit_IntTimB,
                                                     BLDCProcessState_Stop_IntTimB,
                                                     BLDCProcessState_Alignment_IntTimB,
                                                     BLDCProcessState_StartVector_IntTimB,
                                                     BLDCProcessState_OpenLoopStart_IntTimB,
                                                     BLDCProcessState_ShiftVector_IntTimB,
                                                     BLDCProcessState_SLRunDirect_IntTimB,
                                                     BLDCProcessState_SLRunSyncPLL_IntTimB,
                                                     BLDCProcessState_SLRunForcedPLL_IntTimB,
                                                     BLDCProcessState_Fault_IntTimB,
                                                     BLDCProcessState_Restart_IntTimB 
                                                    };

/*commutation for FTM0ch0 output compare interrupt*/
static void BLDCProcessState_AppInit_TimerCmt(void);
static void BLDCProcessState_Stop_TimerCmt(void);
static void BLDCProcessState_Alignment_TimerCmt(void);
static void BLDCProcessState_StartVector_TimerCmt(void);
static void BLDCProcessState_OpenLoopStart_TimerCmt(void);
static void BLDCProcessState_ShiftVector_TimerCmt(void);
static void BLDCProcessState_SLRunDirect_TimerCmt(void);
static void BLDCProcessState_SLRunSyncPLL_TimerCmt(void);
static void BLDCProcessState_SLRunForcedPLL_TimerCmt(void);
static void BLDCProcessState_Fault_TimerCmt(void);
static void BLDCProcessState_Restart_TimerCmt(void);
static FCN_POINTER BLDCProcess_TimerCmtIndexFcn[] = { BLDCProcessState_AppInit_TimerCmt,
                                                      BLDCProcessState_Stop_TimerCmt,
                                                      BLDCProcessState_Alignment_TimerCmt,
                                                      BLDCProcessState_StartVector_TimerCmt,
                                                      BLDCProcessState_OpenLoopStart_TimerCmt,
                                                      BLDCProcessState_ShiftVector_TimerCmt,
                                                      BLDCProcessState_SLRunDirect_TimerCmt,
                                                      BLDCProcessState_SLRunSyncPLL_TimerCmt,
                                                      BLDCProcessState_SLRunForcedPLL_TimerCmt,
                                                      BLDCProcessState_Fault_TimerCmt,
                                                      BLDCProcessState_Restart_TimerCmt
                                                    };

/*BEMF zero-crossing detection relevant function*/
static void SensorlessCmt_Idle (void);
static void SensorlessCmtDirect_Stg0 (void);
static void SensorlessCmtDirect_Stg1CurrRecirculation (void);
static void SensorlessCmtDirect_Stg2ZCDetectionProc (void);
static void SensorlessCmtDirect_Stg3ZCDetected (void);
static FCN_POINTER SensorlessCmtDirect_IndexFcn[] = { SensorlessCmt_Idle,
                                                      SensorlessCmtDirect_Stg0,
                                                      SensorlessCmtDirect_Stg1CurrRecirculation,
                                                      SensorlessCmtDirect_Stg2ZCDetectionProc,
                                                      SensorlessCmtDirect_Stg3ZCDetected 
                                                    };

static void ForcedPLLregulator_zcdetected (void);

static void ForcedPLLregulator_ErrorPositive(void);
static void ForcedPLLregulator_ErrorNegative(void);

static void SensorlessCmtSyncPLL_Stg2ZCDetectionProc (void);
static void SensorlessCmForcedPLL_Stg3ZCDetected (void);
static FCN_POINTER SensorlessCmForcedPLL_IndexFcn[] = { SensorlessCmt_Idle,
                                                        SensorlessCmtDirect_Stg0,
                                                        SensorlessCmtDirect_Stg1CurrRecirculation,
                                                        SensorlessCmtSyncPLL_Stg2ZCDetectionProc,
                                                        SensorlessCmForcedPLL_Stg3ZCDetected 
                                                      };

static void MC33927Config(void);
//debug
static void Alextest(void);

/***************************************************************************
 * 
 * Variable declaration
 * 
 ***************************************************************************/
#pragma DATA_SEG SHORT MY_ZEROPAGE
static signed char          cmtFaultCounter;
static signed char          cmtCounterModeThreshold;
static unsigned char        periodErrorThresholdToPLL;
static unsigned char        periodErrorThresholdToDirectSL;
static signed int           iDCBLimit;
static signed int           iDCBAlignment;
static unsigned char        coefZcToCmt;
static unsigned char        coefZcOff;
static unsigned char        coefCmtPresetHlf;
static unsigned int         periodBLDCZcToff;
static unsigned int         periodBLDCZcCurDecayOff;
static unsigned int         dutyCyclePrev;
static unsigned int         periodBLDCZcToffMin;
static signed char          cmtCounter;

static unsigned int         dutyCycleU16;
static unsigned int         dutyCyclePWMU16;
static signed int           iDcbZcFilt;
static unsigned int         periodBLDCOpenLoopCmt;
static unsigned int         timeBLDCCmt;
static unsigned int			timeBLDCCmt1;
static unsigned int         periodBLDCZcFlt;
static unsigned int         periodBLDCZc;
static unsigned int         timeBLDCZcPrev;
static unsigned int         periodBLDCZc0;
static unsigned int         periodBLDCCmtPreset;
static unsigned int         timeBLDCCmtNext;
static unsigned int         periodBLDCZcToCmt;
static signed char          pwm3ppsSector;


//static unsigned int ADValue_Half_Average;
static signed int ADValue_Half_Voltage;
static signed int ADValue_Voltage;

static signed int ADValue_BEMF;
static unsigned int timeBLDCZc;
static unsigned int timeBackEmf;
static unsigned int timeOldBackEmf;


static unsigned int ADVALUE_Current;

static unsigned int AdcBemfPossible;

static signed int bemfVoltage;
static signed int bemfVoltageOld;
static signed int Udchalf;




static BLDC_INTTIMB_FLAGS   bldcIntTimBFlags;
static CMT_FLAGS            cmtFlags;
static BLDC_MAIN_FLAGS      bldcMainFlags;
static BLDC_STATE_ENUM      bldcStateIndex;
static REG_SYNC_PARAMS      regSyncPLLParams;
static REG_SYNC_PARAMS      regForcedPLLParams;
static ADC_CMT_FLAGS        AdcCmtFlags;


#pragma DATA_SEG DEFAULT

static unsigned int 		currentHWrangeMaxmA;
static unsigned int 		voltageHWrangeMaxV;
static unsigned int 		velocityHWrangeMaxRPM;
static unsigned int     	coefVelocityPeriodScale;
static unsigned short       velocityThresholdOLtoRunU;
static unsigned short       velocityThresholdRuntoOLU;
//static signed char          cmtFaultCounterThreshold;
static signed int           delayZCDisPWMOff;
static signed int           delayPWMOnZCEnbl;
static signed short         velocityDesiredStart;
static signed short         rampAccelOL;
static signed short         rampAccelCL;
static unsigned short       velocityErrDirToPLLMode;
static signed char          cmtStabilizedCounterThreshold;
static signed char          zcErrorCounterThreshold;
static signed char          zcErrorCounterExitPLLThreshold;
static signed char          cmtFaultCounterThreshold;
static unsigned int         pwmModulo;
static signed short         velocityDesired;
static unsigned short       velocityRampActU;
static unsigned int         velocityAct;
static unsigned int         velocityActU;
static signed short         velocityRampAct;
static signed int           timBExtendedCntr;
static signed int           alignmentPeriodTimB;
static signed int           restartPeriodTimB;

signed int k = 0;

/*debug*/
char zcCompZCOpposite1[] = {
   3,
   4,
   5,
   0,
   1,
   2
};

/*MC33927 relevant for drive low voltage demo board*/
static byte mc33927Deadtime;
static char dTimeSWTimer;                       /* MUST BE in zero page <=> MY_ZEROPAGE for correct Dead Time generation */
static MC33927_LATCH_T mc33927StatusRegister0;
static MC33927_MODE_T mc33927StatusRegister1;
static MC33927_LATCH_T mc33927StatusRegister2;
static MC33927_MODE_COMMAND_T mc33927ModeCommands;
static MC33927_LATCH_T mc33927MaskInterrupts;
static MC33927_LATCH_T mc33927ClearFlags;


static APP_FAULT_FLAGS      appFaultPendingFlags;
static CTR_sPIparams        regSpeedPIparams;
static CTR_sPIparams        regCurrPIparams;
static APP_FAULT_FLAGS      appFaultFlags;
static APP_CONTROL_FLAGS    appControlFlags;
/* User includes (#include below this line is not maintained by Processor Expert) */
#pragma optimization_level 0

void Alextest(void)
{
	bldcMainFlags.Bits.Dir024 = 1;
	dutyCyclePWMU16 = 1000;
	for (k=0;k<6;k++)
	{
		FTM2_SYNC_SYNCHOM = 0;
    	FTM2_pwm3pps_Compl_OutMaskVector(k);
    	FTM2_SYNC_SYNCHOM = 1; 
		FTM2_pwm3pps_UnipVectorCommutatePreset(k, bldcMainFlags);
		PWM_SetDutyCycle();
	}
}
void main(void)
{
  /* Write your local variable definition here */

  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
	PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/
	VariableLimitation_Init();
	/*added this function to drive low voltage tower demo board*/
	MC33927Config();
	
    BLDCProcessState_AppInitEnter();

    MTIM_TimB_EnableInterrupt();
	EnableInterrupts;
/*debug*/	
	PORT_PTAD_PTAD1 = 0;
	PORT_PTAD_PTAD2 = 0;
	PORT_PTAD_PTAD3 = 1;
	PORT_PTED_PTED6 = 0;
	AdcBemfPossible = 0;

	FMSTR_Init();
	for(;;)
	{
		FaultCheck_Main();
        if (appFaultFlags.Byte!=0)
        {
            bldcStateIndex = BLDC_FAULT;
        }
        else if(((appControlFlags.Bits.BldcStart == 0)|(velocityDesired == 0))&(bldcStateIndex != BLDC_APP_INIT))
        {
            velocityDesired = 0;
            bldcStateIndex = BLDC_STOP;
        };
        if(abs16(velocityDesired)<velocityDesiredStart)
        {
            velocityDesired = 0;
        }
        BLDCProcess_MainIndexFcn[bldcStateIndex]();
        MC33927_GetSR0(&mc33927StatusRegister0); /* SR0 */
        MC33927_GetSR1(&mc33927StatusRegister1); /* SR1 */
        MC33927_GetSR2(&mc33927StatusRegister2); /* SR2 */
        mc33927Deadtime = MC33927_GetSR3(); /* SR3, deadtime value */
        //__RESET_WATCHDOG();
        FMSTR_Poll();
	}
}


void FilterMAInit_F16(FILTER_MA_T_F16 *pParam)
{
    pParam->f32Acc  = (signed long) 0;
}

signed int FilterMA_F16(signed int f16In, FILTER_MA_T_F16 *pParam)
{
	signed long  f32Temp;
	signed long  f32Acc;
    
    f32Acc  = pParam->f32Acc + (signed long)f16In;
    f32Temp = f32Acc >> (pParam->u16NSamples);
    f32Acc  = f32Acc - f32Temp;

    /* Store new accumulator state */
    pParam->f32Acc    = f32Acc;
    
    return((signed int)f32Temp);
}
/***************************************************************************
 * 
 * destination:added this function to drive low voltage tower demo board 
 * 
 ***************************************************************************/
static void MC33927Config(void)
{
    /* This command reads Status Register 0 of MC33927 and stores it in the mc33927StatusRegister0 structure */
    MC33927_GetSR0(&mc33927StatusRegister0);
    
    /* This command reads Status Register 1 of MC33927 and stores it in the mc33927StatusRegister1 structure */    
    MC33927_GetSR1(&mc33927StatusRegister1);
    
    /* This command reads Status Register 2 of MC33927 and stores it in the mc33927StatusRegister2 structure */
    MC33927_GetSR2(&mc33927StatusRegister2);

    /* This command reads Status Register 3 (deadtime) of MC33927 and stores it in the mc33927Deadtime variable */
    mc33927Deadtime = MC33927_GetSR3();

    /***** Mode setup *****/
    mc33927ModeCommands.B.Lock = 0;
    mc33927ModeCommands.B.FullOnMode = 0;     
    mc33927ModeCommands.B.DesatFaultMode = 1; 
    
  
    MC33927_ModeCommand(&mc33927ModeCommands);

    /***** Interrupts setup *****/    
    mc33927MaskInterrupts.B.TLim = 0; 
    mc33927MaskInterrupts.B.Desat = 0; 
    mc33927MaskInterrupts.B.LowVLS = 1; 
    mc33927MaskInterrupts.B.Overcurrent = 1; 
    mc33927MaskInterrupts.B.PhaseError = 0; 
    mc33927MaskInterrupts.B.FramingError = 0; 
    mc33927MaskInterrupts.B.WriteError = 0; 
    mc33927MaskInterrupts.B.ResetEvent = 0; 
    
    /* This command controls interrupt mask registers */
    MC33927_MaskInterrupts(&mc33927MaskInterrupts);

    /***** Flags clearing *****/    
    mc33927ClearFlags.B.TLim = 1; /* overtemperature flag 0: untouched; 1: clears */
    mc33927ClearFlags.B.Desat = 1; /* dasaturation flag 0: untouched; 1: clears */
    mc33927ClearFlags.B.LowVLS = 1; /* VLS undervoltage flag 0: untouched; 1: clears */
    mc33927ClearFlags.B.Overcurrent = 1; /* overcurrent flag 0: untouched; 1: clears */
    mc33927ClearFlags.B.PhaseError = 1; /* phase error flag 0: untouched; 1: clears */
    mc33927ClearFlags.B.FramingError = 1; /* SPI framing error flag 0: untouched; 1: clears */
    mc33927ClearFlags.B.WriteError = 1; /* write after lock is on flag 0: untouched; 1: clears */
    mc33927ClearFlags.B.ResetEvent = 1; /* driver set upon exiting /RST flag 0: untouched; 1: clears */

    /* This command clears the flag registers */
    MC33927_ClearFlags(&mc33927ClearFlags);
    
    /* This command sets the zero deadtime */
    MC33927_ZeroDeadtime();
    
    /***** Deadtime setup *****/
    /* This command sets the deadtime calibration mode */
    MC33927_DeadtimeCalibration();
    
    SPI0_C2_MODFEN = 0;   /* /SS reverts to General Purpose I/O */
    
    DRIVER33937_SS_LOW(); /* SS to 0 */
    
    /* generates a delay that corresponds to desired deadtime */

    /* duration ((1+2+3)*x + 2+1+3)*CPU clock */
    for (dTimeSWTimer = DRIVERMC33937_PWM_DEAD_TIME; dTimeSWTimer > 0; dTimeSWTimer--);     
    /* /SS low for 8us -> 0.5 us active dead-time */
    
    DRIVER33937_SS_HIGH(); /* SS to 1 */    
    
    SPI0_C2_MODFEN = 1;   /* /SS reverts to General Purpose I/O  */
        
    /* Reading the status registers to check if it was set correctly */
    MC33927_GetSR0(&mc33927StatusRegister0); /* SR0 */
    MC33927_GetSR1(&mc33927StatusRegister1); /* SR1 */
    MC33927_GetSR2(&mc33927StatusRegister2); /* SR2 */
    mc33927Deadtime = MC33927_GetSR3(); /* SR3, deadtime value */

    /* If deadtime is 0, it breaks */
    if (mc33927Deadtime == 0)
    {
        DRIVER33937_DISABLE();
        asm(stop);
    }
    DRIVER33937_ENABLE();
}



static void VariableLimitation_Init(void)
{
	
    FilterMAInit_F16(&Udcb_filt);
    Udcb_filt.u16NSamples = 2;

	/*this variable is the flag of BEMF ADC sample zero crossing*/
	CommutationFlag = 1;
	
	appControlFlags.Byte = 0;
	appControlFlags.Bits.InfinitAlignment = 0;
	
    alignmentPeriodTimB = ALIGNMENT_PERIOD_TIMB;
    restartPeriodTimB = RESTART_PERIOD_TIMB;
	
    currentHWrangeMaxmA = CURRENT_HW_RANGE_MAX_MA;
	voltageHWrangeMaxV = VOLTAGE_HW_RANGE_MAX_V;
	velocityHWrangeMaxRPM = VELOCITY_RANGE_MAX_RPM;
	
	coefVelocityPeriodScale = COEF_VELOCITY_PERIOD_SCALE16;
	coefZcToCmt = COEF_ZC_TO_CMT_INIT_U8;
	coefZcOff = COEF_ZC_OFF_INIT_U8;
	coefCmtPresetHlf = COEF_CMT_PRESET_HALF_U8;
	periodBLDCZcToff = periodBLDCZcToffMin = BLDC_ZC_TOFF_MIN_PERIOD_TIM_CMT;//pass half of commutation time can detect zero-crossing point
	periodBLDCZcCurDecayOff = BLDC_ZC_CUR_DECAY_OFF_PERIOD_TIM_CMT;//current decay,this state can not be sensed

	velocityThresholdOLtoRunU = VELOCITY_THRESHOLD_OL_TO_RUN;//openloop start  to run RPM threshold is 450RPM
	velocityThresholdRuntoOLU = VELOCITY_THRESHOLD_RUN_TO_OL;//run to openloop RPM threshold is 300RPM, can't not detected BEMF
	dutyCyclePrev = 0;

    delayPWMOnZCEnbl = DELAY_PWM_EDGE_ZC_COMP_ENABLE;     
    delayZCDisPWMOff = DELAY_ZC_COMP_DISABLE_PWM_EDGE;
    velocityDesiredStart = VELOCITY_DESIRED_START;//initial min RPM 
    rampAccelOL = RAMP_ACCELERATION_OL;
    rampAccelCL = RAMP_ACCELERATION_CL;
    velocityErrDirToPLLMode = VELOCITY_ERR_DIR_TO_PLL_MODE;
    cmtStabilizedCounterThreshold = CMT_STABILIZED_THRESHOLD;//commutation times to stabilize  threshold
    zcErrorCounterThreshold = ZC_ERROR_COUNTER_THRESHOLD;//restart for zero crossing error counter
    zcErrorCounterExitPLLThreshold = ZC_ERROR_COUNTER_EXIT_PLL_THRESHOLD;
    cmtFaultCounterThreshold = CMT_FAULT_RESTART_COUNTER_THRESHOLD;// to set zero-crossing not be detected number to take place error: commutation fault counter

    cmtCounterModeThreshold = CMT_COUNTER_MODE_THRESHOLD;
    periodErrorThresholdToPLL = PERIOD_ERROR_THRESHOLD_TO_PLL;
    periodErrorThresholdToDirectSL = PERIOD_ERROR_THRESHOLD_TO_DIRECT_SL;
    regSyncPLLParams.integralGain8 = SYNC_PLL_INTEGRAL_GAIN;
    regSyncPLLParams.integralPortionK_1_24.H16L8.H16 = 0;
    regSyncPLLParams.integralPortionK_1_24.H16L8.L8 = 0; 
    regSyncPLLParams.proportionalGainConst8 = SYNC_PLL_PROPORTIONAL_GAIN;

    regForcedPLLParams.gainShift = FORCED_PLL_GAIN_SHIFT;
    regForcedPLLParams.integralGain8 = FORCED_PLL_INTEGRAL_GAIN;
    regForcedPLLParams.integralPortionK_1_24.H16L8.H16 = 0;
    regForcedPLLParams.integralPortionK_1_24.H16L8.L8 = 0;
    regForcedPLLParams.proportionalGainConst8 = FORCED_PLL_PROPORTIONAL_GAIN;
    regForcedPLLParams.lowerLimit = FORCED_PLL_REG_LOWER_LIMIT_S16;
    regForcedPLLParams.upperLimit = FORCED_PLL_REG_UPPER_LIMIT_S16;
    pwmModulo = (unsigned int)PWM_MODULO;//PWM Peak value

    regSpeedPIparams.propGain = SPEED_REG_PROP_GAIN_U8;
    regSpeedPIparams.propGainShift = SPEED_REG_PROP_GAIN_SHFT_S8;
    regSpeedPIparams.intGain = SPEED_REG_INT_GAIN_U8;
    regSpeedPIparams.intGainShift = SPEED_REG_INT_GAIN_SHFT_S8;
    regSpeedPIparams.lowerLimit = SPEED_REG_LOWER_LIMIT_S16;
    regSpeedPIparams.upperLimit = SPEED_REG_UPPER_LIMIT_S16;
    regSpeedPIparams.integralPortionK_1_32.S32 = 0;

    iDCBLimit = CURRENT_DCB_LIMIT;//DC_Bus current limit
    iDCBAlignment = CURRENT_DCB_ALIGNMENT;//rotor align current

    regCurrPIparams.propGain = CURRENT_REG_PROP_GAIN_U8;//PI control P parameters
    regCurrPIparams.propGainShift = CURRENT_REG_PROP_GAIN_SHFT_S8;
    regCurrPIparams.intGain = CURRENT_REG_INT_GAIN_U8;
    regCurrPIparams.intGainShift = CURRENT_REG_INT_GAIN_SHFT_S8;
    regCurrPIparams.lowerLimit = CURRENT_REG_LOWER_LIMIT_S16;//current loop output limit according to zerocrossing can be detected
    regCurrPIparams.upperLimit = CURRENT_REG_UPPER_LIMIT_S16;//generally to set the value by PWM modulo
    regCurrPIparams.integralPortionK_1_32.S32 = 0;//increment PI adapted, indicated K-1 step integral
}

void UpDownSwitchVelocitySet(void)
{
    if(UP_SWITCH == 0)
    {
        if(velocityDesired == 0)
        {
        	velocityDesired = velocityDesiredStart;
        } 
        else
        {
            velocityDesired=add16(velocityDesired, (signed int)VELOCITY_HW_STEP);//5RPM ramp
        }
    } 
#if 0
    if(DOWN_SWITCH == 0)
    {
        if(velocityDesired == 0)
        {
            velocityDesired = -velocityDesiredStart;
        } 
        else
        {
            velocityDesired=sub16(velocityDesired, (signed int)VELOCITY_HW_STEP);
        }
    }
#endif
}

static void BLDCProcessState_AppInitEnter(void)
{
    bldcStateIndex = BLDC_APP_INIT;

    ZCDetect_SetIdle();

    ADCSensing_I_UT_Init();//ADC initialization
    
    FTM2_pwm3pps_PWMOff();
    FTM2_pwm3pps_FaultFlagReadClear();
    FTM0ch0_TimerCmt_CmtDisableInterrupt();
    
}

static void BLDCProcessState_AppInit_Main()
{
	if (adcSensingStateIndex != ADC_INIT)
	{
		/*motor speed initialization relevance*/
		velocityDesired =  0;
		velocityRampActU = velocityRampAct = 0;
		velocityAct = velocityActU = 0;

		/*relevant variable of motor state*/
        appControlFlags.Bits.BldcStart = 1;
        appControlFlags.Bits.StartSwitchState = 0;
        appControlFlags.Bits.FaultClear = 0;

        bldcMainFlags.Byte = 0;

        /* zero cross point and commutation relevance*/
        zcErrorCounter = 0;
        cmtFlags.Bits.CmtError = 0;
        cmtFlags.Bits.CmtStabilized = 0;
        cmtCounter = 0;
        
        
		/*relevant variable of time for alignment and restart state*/
        bldcIntTimBFlags.Byte = 0;
        bldcStateIndex = BLDC_STOP;
	}
}



static void BLDCProcessState_AppInit_IntTimB(void)
{
	;
}

static void BLDCProcessState_AppInit_TimerCmt(void)
{
	;
}
static void BLDCProcessState_Stop_Main()
{
	if((appControlFlags.Bits.BldcStart == 1)&(velocityDesired !=0))
	{

		bldcIntTimBFlags.Byte = 0;
		pwm3ppsSector = ALIGNMENT_PWM_SECTOR_INIT;
		BLDCProcessState_AlignmentEnter();
        if (velocityDesired>0)
        {
            bldcMainFlags.Bits.Dir024 = 1;
        }
        else
        {
            bldcMainFlags.Bits.Dir024 = 0;
        }
#ifdef PWM_BIPOLAR_SWITCHING
            FTM2_pwm3pps_BipolVectorSet(pwm3ppsSector, bldcMainFlags);
#else
            FTM2_pwm3pps_UnipVectorSet(pwm3ppsSector, bldcMainFlags);
#endif
	}
	else
	{
		BLDCProcessState_CmtInit();
		dutyCycleU16 = (unsigned int)ALIGNMENT_DUTY_CYCLE_U16;
		PWM_SetDutyCycle();
	}
}

static void BLDCProcessState_Stop_IntTimB(void)
{
    iDcbZcFilt = iDcb;	
}

static void BLDCProcessState_Stop_TimerCmt(void)
{
	;
}

static void BLDCProcessState_AlignmentEnter(void)
{
	regCurrPIparams.integralPortionK_1_32.HL_W16.H = (unsigned int)ALIGNMENT_DUTY_CYCLE_U16;
    regCurrPIparams.integralPortionK_1_32.HL_W16.L = 0x8000;
    dutyCycleU16 = (unsigned int)ALIGNMENT_DUTY_CYCLE_U16;
    PWM_SetDutyCycle();
    bldcIntTimBFlags.Bits.AlignmentIsTimed = 0;
    bldcIntTimBFlags.Bits.CurLimit = 0;
    bldcStateIndex = BLDC_ALIGNMENT;   
}


static void BLDCProcessState_Alignment_Main()
{
	;
}

static void BLDCProcessState_Alignment_IntTimB(void)
{
	iDcbZcFilt = iDcb;
    if (bldcIntTimBFlags.Bits.AlignmentIsTimed == 0)
    {
        timBExtendedCntr = alignmentPeriodTimB;
        bldcIntTimBFlags.Bits.AlignmentTimeout = 0;
        bldcIntTimBFlags.Bits.AlignmentIsTimed = 1;
        velocityRampAct = 0;
        velocityAct = velocityActU = 0;
    }
    else
    {
    	if(bldcIntTimBFlags.Bits.CurLimit)
    	{
            dutyCycleU16 = CTR_ControllerPI16(sub16(iDCBAlignment, iDcbZcFilt), &regCurrPIparams);
            regSpeedPIparams.integralPortionK_1_32.HL_W16.H = regCurrPIparams.integralPortionK_1_32.HL_W16.H;
            regSpeedPIparams.integralPortionK_1_32.HL_W16.L = regCurrPIparams.integralPortionK_1_32.HL_W16.L;
            if(dutyCycleU16 > (unsigned int)ALIGNMENT_DUTY_CYCLE_U16)
            {
                bldcIntTimBFlags.Bits.CurLimit = 0;
            }
    	}
    	else
    	{
    		dutyCycleU16 = (unsigned int)ALIGNMENT_DUTY_CYCLE_U16;
            if(iDcbZcFilt > iDCBAlignment)
            {
                bldcIntTimBFlags.Bits.CurLimit = 1;
                regCurrPIparams.integralPortionK_1_32.HL_W16.H = (unsigned int)ALIGNMENT_DUTY_CYCLE_U16;
                regCurrPIparams.integralPortionK_1_32.HL_W16.L = 0x8000;
				bldcMainFlags.Bits.ForcedPLLModeRq = 0;
            }
    	}
    	PWM_SetDutyCycle();
        if(timBExtendedCntr-- < 0)
        {
            bldcIntTimBFlags.Bits.AlignmentTimeout = 1;
            dutyCycleU16 = (unsigned int)OL_START_DUTY_CYCLE_U16;
            bldcIntTimBFlags.Bits.CurLimit = 0;
            regSpeedPIparams.integralPortionK_1_32.HL_W16.H = (unsigned int)OL_START_DUTY_CYCLE_U16;
            regSpeedPIparams.integralPortionK_1_32.HL_W16.L = 0x8000;
            bldcMainFlags.Bits.StartVectorSet = 0;
            bldcStateIndex = BLDC_START_VECTOR;
			
        }
    }
}

static void BLDCProcessState_Alignment_TimerCmt(void)
{
	;
}

static void PeriodToVelocityOLConversion (void)
{
	unsigned int periodBLDCOpenLoopCmtLoc;
    periodBLDCOpenLoopCmtLoc = udiv16(coefVelocityPeriodScale, velocityRampActU);
    if(periodBLDCOpenLoopCmtLoc<=MAX_S16)
    {
        periodBLDCOpenLoopCmt = periodBLDCOpenLoopCmtLoc; 
    } 
    else
    {
        periodBLDCOpenLoopCmt = MAX_S16;
    }
}

static void BLDCProcessState_OpenLoopStartEnter(void)
{
    bldcStateIndex = BLDC_OPEN_LOOP_START;
    dutyCycleU16 = (unsigned int)OL_START_DUTY_CYCLE_U16;
}

static void BLDCProcessState_StartVector_Main(void)
{
    if(bldcMainFlags.Bits.StartVectorSet == 0)
    {
        if(velocityDesired>0)
        {
            if(velocityRampAct<(signed int)VELOCITY_MIN)
            {
                velocityRampAct = VELOCITY_MIN;
            }
            velocityRampActU = (unsigned int)velocityRampAct;
            bldcMainFlags.Bits.Dir024 = 1;
        }
        else
        {
            if(velocityRampAct>(signed int)(-VELOCITY_MIN))
            {
                velocityRampAct = (unsigned int)(-VELOCITY_MIN);
            }
            velocityRampActU = (unsigned int)(-velocityRampAct);
            bldcMainFlags.Bits.Dir024 = 0;
        }
        velocityAct = velocityRampAct;
        velocityActU = velocityRampActU;
        
        PeriodToVelocityOLConversion();

#ifdef PWM_BIPOLAR_SWITCHING
        FTM2_pwm3pps_BipolVectorCommutateSet(pwm3ppsSector, bldcMainFlags);
#else
        FTM2_pwm3pps_UnipVectorCommutateSet(pwm3ppsSector, bldcMainFlags);
#endif

        timeBLDCCmt = 0;
        timeBLDCCmt = timeBLDCCmt + periodBLDCOpenLoopCmt;
        FTM0_CNT = 0;
        FTM0_C0V = FTM0_RISINGEDGE_TIME;
        FTM0_MOD = periodBLDCOpenLoopCmt;
        /* Prepare next step */
#ifdef PWM_BIPOLAR_SWITCHING
        FTM2_pwm3pps_BipolVectorCommutatePreset(pwm3ppsSector, bldcMainFlags);
#else
        FTM2_pwm3pps_UnipVectorCommutatePreset(pwm3ppsSector, bldcMainFlags);
#endif
        FTM2_SYNC_TRIG1 = 1;
    
        FTM0ch0_TimerCmt_CmtEnableInterrupt();
 
        bldcMainFlags.Bits.StartVectorSet = 1;

        bldcIntTimBFlags.Bits.AlignmentIsTimed = 0;
        bldcIntTimBFlags.Bits.AlignmentTimeout = 0;
        bldcStateIndex = BLDC_OPEN_LOOP_START;
    }
}

static void BLDCProcessState_StartVector_IntTimB(void)
{
	;
}

static void BLDCProcessState_StartVector_TimerCmt(void)
{
	;
}

static void BLDCProcessState_OpenLoopStart_Main(void)
{
	if (velocityRampActU>velocityThresholdOLtoRunU)
	{
	    if(cmtCounter == 0)
	    {
	        bldcMainFlags.Bits.ShftVector = 0;
	        bldcStateIndex = BLDC_SHIFT_VECTOR;
	    }
	}
}

static void BLDCProcessState_OpenLoopStart_IntTimB(void)
{
    iDcbZcFilt = iDcb;
    /*acceleration speed calculation*/
    velocityRampAct = ECLIB_Ramp16(rampAccelOL, velocityDesired, velocityRampAct);
	
    if (velocityRampAct>0)
    {
        if(velocityRampAct<(signed int)VELOCITY_MIN)
        {
            velocityRampAct = (unsigned int)(-VELOCITY_MIN);
        } 
    }
    else 
    {
        if(velocityRampAct>(signed int)(-VELOCITY_MIN))
        {
            velocityRampAct = VELOCITY_MIN;
        }
    }
    
    if (velocityRampAct>0)
    {
        velocityRampActU = (unsigned int)velocityRampAct;
        bldcMainFlags.Bits.Dir024 = 1;
    }
    else
    {
        velocityRampActU = (unsigned int)(-velocityRampAct);
        bldcMainFlags.Bits.Dir024 = 0;
    }
    velocityAct = velocityRampAct;
    velocityActU = velocityRampActU;
    PeriodToVelocityOLConversion();

    PWM_SetDutyCycle();

    bldcIntTimBFlags.Bits.CurLimit = 0;
}

static void BLDCProcessState_OpenLoopStart_TimerCmt(void)
{
	
    zcErrorCounter = 0;
    cmtFlags.Bits.CmtError = 0;
    cmtFlags.Bits.CmtStabilized = 0;
    bldcMainFlags.Bits.ForcedPLLModeRq = 0;
    bldcMainFlags.Bits.SyncPLLModeRq = 0;
    cmtCounter = 0; 

    
#ifdef PWM_BIPOLAR_SWITCHING
    FTM2_pwm3pps_BipolVectorCommutatePreset(pwm3ppsSector,bldcMainFlags);
#else
    FTM2_pwm3pps_UnipVectorCommutatePreset(pwm3ppsSector, bldcMainFlags);
#endif
   
    timeBLDCCmt = timeBLDCCmt + periodBLDCOpenLoopCmt;

  	
    FTM0_C0V = FTM0_RISINGEDGE_TIME;
	FTM0_SC_CLKS0 = 0;
	FTM0_SC_CLKS1 = 0;
    FTM0_MOD = periodBLDCOpenLoopCmt;
	
	FTM0_SC_CLKS0 = 1;
	FTM0_SC_CLKS1 = 0;
    
    FTM2_SYNC_TRIG1 = 1; 
	//PORT_PTAD_PTAD2 = ~PORT_PTAD_PTAD2;
}

static void BLDCProcessState_ShiftVector_Main(void)
{
	
	if(bldcMainFlags.Bits.ShftVector == 1)
	{
		PORT_PTED_PTED6 =1;
	    bldcStateIndex = BLDC_SL_RUN_DIRECT;
	}
}

static void BLDCProcessState_ShiftVector_IntTimB(void)
{
	;
}

static void BLDCProcessState_ShiftVector_TimerCmt(void)
{

#ifdef PWM_BIPOLAR_SWITCHING
        FTM2_pwm3pps_BipolVectorCommutateSet(pwm3ppsSector, bldcMainFlags);
#else
        FTM2_pwm3pps_UnipVectorCommutateSet(pwm3ppsSector, bldcMainFlags);
#endif

        periodBLDCZcFlt = periodBLDCOpenLoopCmt;        
        timeBLDCZc = timeBLDCCmt-(periodBLDCZcFlt>>1);
        periodBLDCZc = periodBLDCZcFlt;
        timeBLDCZcPrev = timeBLDCZc;
        periodBLDCZc0 = periodBLDCZc;
		
        if(bldcMainFlags.Bits.Dir024)
        {
            ZCDetect_BeginABC(pwm3ppsSector);
        }
        else
        {
            ZCDetect_BeginCBA(pwm3ppsSector);  
        }
#ifdef PWM_BIPOLAR_SWITCHING
        FTM2_pwm3pps_BipolVectorCommutatePreset(pwm3ppsSector, bldcMainFlags);
#else
        FTM2_pwm3pps_UnipVectorCommutatePreset(pwm3ppsSector, bldcMainFlags);
#endif
        CalculZC_CmtPreset();
        bldcMainFlags.Bits.ShftVector = 1;
        SensorlessCmtDirect_IndexFcn[zcDetectStateIndex]();
		
}
static void BLDCProcessState_SLRunDirect_Main(void)
{
	;
}

static void BLDCProcessState_SLRunDirect_IntTimB(void)
{


	if(cmtFlags.Bits.CmtStabilized)
	{
        velocityRampAct = ECLIB_Ramp16(rampAccelCL, velocityDesired, velocityRampAct);
        if (velocityRampAct>0)
        {
            velocityRampActU = (unsigned int)velocityRampAct;
        } 
        else
        {
            velocityRampActU = (unsigned int)(-velocityRampAct);
        }
        velocityActU = udiv16(coefVelocityPeriodScale, periodBLDCZcFlt);
        if (bldcMainFlags.Bits.Dir024 == 1)
        {
            if(velocityActU<=MAX_S16)
            {
                velocityAct = (signed int)velocityActU;   
            } 
            else
            {
                velocityAct = MAX_S16;
            }
        }
        else
        {
            if(velocityActU<=MAX_S16)
            {
                velocityAct = -(signed int)velocityActU;   
            } 
            else
            {
                velocityAct = MIN_S16;
            }
        }
        if(bldcIntTimBFlags.Bits.CurLimit)
        {
            if(velocityActU > velocityRampActU)
            {
                regSpeedPIparams.integralPortionK_1_32.HL_W16.H = dutyCycleU16;
                regSpeedPIparams.integralPortionK_1_32.HL_W16.L = 0x8000;
                bldcIntTimBFlags.Bits.CurLimit = 0;
            }
        }
        else
        {
            if(iDcbZcFilt > iDCBLimit)
            {
                regCurrPIparams.integralPortionK_1_32.HL_W16.H = dutyCycleU16;
                regCurrPIparams.integralPortionK_1_32.HL_W16.L = 0x8000;
                bldcIntTimBFlags.Bits.CurLimit = 1;
                bldcMainFlags.Bits.ForcedPLLModeRq = 0;
            }

        }
		
        if(bldcIntTimBFlags.Bits.CurLimit)//Debug 10.01.22set duty  according to PI controller
        {
            dutyCycleU16 = CTR_ControllerPI16(sub16(iDCBLimit, iDcbZcFilt), &regCurrPIparams);
			
        } 
        else
        {
            if (bldcMainFlags.Bits.Dir024 == 1)
            {
                dutyCycleU16 = (unsigned int)CTR_ControllerPI16(sub16(velocityRampAct, velocityAct), &regSpeedPIparams);
                //PORT_PTAD_PTAD1 = ~PORT_PTAD_PTAD1 ;
            } 
            else
            {
                dutyCycleU16 = (unsigned int)CTR_ControllerPI16(sub16(velocityAct, velocityRampAct), &regSpeedPIparams);
            }
			
        }
	
        if(velocityActU < velocityThresholdRuntoOLU)
        {
        	//PORT_PTAD_PTAD2 = ~PORT_PTAD_PTAD2;
            regSpeedPIparams.integralPortionK_1_32.HL_W16.H = (unsigned int)OL_START_DUTY_CYCLE_U16;
            velocityRampAct = velocityAct;
            BLDCProcessState_OpenLoopStartEnter();
        }
        PWM_SetDutyCycle();
        if(cmtFlags.Bits.CmtError == 1)
        {
            BLDCProcessState_RestartEnter();
        }     
  
	}

}

static void BLDCProcessState_SLRunDirect_TimerCmt(void)
{
    if(zcDetectStateIndex == ZCDETECT_STG1CURR_RECIRCULATION)
    { 
        ZCDetect_SetStg2ZCDetectionProc();
		//PORT_PTAD_PTAD2= ~PORT_PTAD_PTAD2;
    }
    else
    {
        //PORT_PTED_PTED6 = ~PORT_PTED_PTED6;
        if(zcDetectStateIndex != ZCDETECT_STG3ZCDETECTED)
        {
            zcErrorCounter++;

        	//timeBLDCZc = timeBLDCCmt - (periodBLDCZcFlt>>1);
        	//timeBackEmf = timeBLDCCmt - (periodBLDCZcFlt>>1);
        	timeBackEmf = timeBLDCCmt + FTM0_CNT ;
			CommutationFlag = 1;
           	CalculZC_periodsCmtTime();
			//PORT_PTAD_PTAD3 = ~PORT_PTAD_PTAD3;
        }
        CalculZC_CmtPreset(); 
        if(bldcMainFlags.Bits.Dir024)
        {
            ZCDetect_SetStg0ABC(pwm3ppsSector);   
        }
        else
        {
            ZCDetect_SetStg0CBA(pwm3ppsSector);   
        }
        ZCDetect_SetStg1CurrRecirculation();
		BEMF_ADC_Channel_distinguish();
#ifdef PWM_BIPOLAR_SWITCHING
            FTM2_pwm3pps_BipolVectorCommutatePreset(pwm3ppsSector, bldcMainFlags);
#else
            FTM2_pwm3pps_UnipVectorCommutatePreset(pwm3ppsSector, bldcMainFlags);
#endif
            cmtCounter++;
            index1 = 0;
            index2 = 0;
            ADCSample_zcDetectEnable = 0;
			AdcCmtFlags.Bits.AdcSaved = 0;
    } 
    SensorlessCmtDirect_IndexFcn[zcDetectStateIndex]();
}

static void SensorlessCmt_Idle (void)
{
	 ;
}

static void SensorlessCmtDirect_Stg0 (void)
{
	
    FTM2_SYNC_TRIG1 = 0;
    timeBLDCCmtNext = timeBLDCCmt + periodBLDCZcCurDecayOff;
    //FTM0ch0_TimerCmt_OCISetNext(timeBLDCCmtNext);
    
	FTM0_SC_CLKS0 = 0;
	FTM0_SC_CLKS1 = 0;
    FTM0_MOD = periodBLDCZcCurDecayOff;
	FTM0_SC_CLKS0 = 1;
	FTM0_SC_CLKS1 = 0;
    FTM0_C0V = FTM0_RISINGEDGE_TIME;
    FTM0_CNT = 0;
}

static void SensorlessCmtDirect_Stg1CurrRecirculation (void)
{
	
	PORT_PTAD_PTAD1= 0;
    FTM2_SYNC_TRIG1 = 0;
    timeBLDCCmt = timeBLDCCmt + periodBLDCZcToff;
    FTM0_C0V = FTM0_RISINGEDGE_TIME;
	FTM0_SC_CLKS0 = 0;
	FTM0_SC_CLKS1 = 0;
 	FTM0_MOD = periodBLDCZcToff ;
	FTM0_SC_CLKS0 = 1;
	FTM0_SC_CLKS1 = 0;
 }

static void SensorlessCmtDirect_Stg2ZCDetectionProc (void)
{
	//PORT_PTAD_PTAD2= 0;
	timeBLDCCmt1 = timeBLDCCmt;
    timeBLDCCmt = timeBLDCCmt + periodBLDCCmtPreset;
    FTM0_C0V = FTM0_RISINGEDGE_TIME;
	
	FTM0_SC_CLKS0 = 0;
	FTM0_SC_CLKS1 = 0;
 	FTM0_MOD = periodBLDCCmtPreset ;
	FTM0_SC_CLKS0 = 1;
	FTM0_SC_CLKS1 = 0;
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
	FTM2_SYNC_TRIG1 = 1;
 }

static void SensorlessCmtDirect_Stg3ZCDetected (void)
{
    CalculZC_periodsCmtTime(); 
    timeBLDCCmt = timeBLDCZc + periodBLDCZcToCmt;
    FTM0_C0V = FTM0_RISINGEDGE_TIME;
	/*solve hazard*/
    if(timeBLDCCmt - timeBLDCCmt1 - FTM0_CNT > MAX_S16)
    {
    	
		FTM0_SC_CLKS0 = 0;
		FTM0_SC_CLKS1 = 0;
        FTM0_MOD = FTM0_CNT+TIME_MIN_SET_TIMER_CMT;
		FTM0_SC_CLKS0 = 1;
		FTM0_SC_CLKS1 = 0;
		timeBLDCCmt = timeBLDCCmt1 + FTM0_MOD;
    }
	else if(timeBLDCCmt - timeBLDCCmt1 - FTM0_CNT < TIME_MIN_SET_TIMER_CMT)
	{
		
		FTM0_SC_CLKS0 = 0;
		FTM0_SC_CLKS1 = 0;
		FTM0_MOD = FTM0_CNT+TIME_MIN_SET_TIMER_CMT;
		FTM0_SC_CLKS0 = 1;
		FTM0_SC_CLKS1 = 0;
		timeBLDCCmt = timeBLDCCmt1 + FTM0_MOD;
	}
	else
	{
		
		FTM0_SC_CLKS0 = 0;
		FTM0_SC_CLKS1 = 0;
		FTM0_MOD = timeBLDCCmt - timeBLDCCmt1;
		FTM0_SC_CLKS0 = 1;
		FTM0_SC_CLKS1 = 0;
	}
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
	FTM2_SYNC_TRIG1 = 1;
	//PORT_PTAD_PTAD3 = 1;
 }

void CalculZC_periodsCmtTime(void)
{
    if(cmtFlags.Bits.CalculationDone == 0)
    {
    	timeBLDCZcPrev = timeBLDCZc;
    	timeBLDCZc = timeBackEmf;
        periodBLDCZc = timeBLDCZc - timeBLDCZcPrev;
        
        periodBLDCZcFlt = uadd16(periodBLDCZc0>>1, periodBLDCZc>>1);
        periodBLDCZc0 = periodBLDCZc;
        periodBLDCZcToCmt = umul16_8to16(periodBLDCZcFlt, coefZcToCmt);
        cmtFlags.Bits.CalculationDone = 1;
    }
}

void CalculZC_CmtPreset(void)
{
	 unsigned int tempU16;
    periodBLDCZcToff = umul16_8to16(periodBLDCZcFlt, coefZcOff);
    if (periodBLDCZcToff < periodBLDCZcToffMin)
    {
        periodBLDCZcToff = periodBLDCZcToffMin;
    }
    tempU16 = umul16_8to16(periodBLDCZcFlt, coefCmtPresetHlf);
    periodBLDCCmtPreset = uadd16(tempU16, tempU16);
    cmtFlags.Bits.CalculationDone = 0;
}

static void BLDCProcessState_SLRunSyncPLL_Main(void)
{
	;
}

static void BLDCProcessState_SLRunSyncPLL_IntTimB(void)
{
	;
}

static void BLDCProcessState_SLRunSyncPLL_TimerCmt(void)
{
	;
}

static void BLDCProcessState_SLRunForcedPLL_Main(void)
{
	;
}

static void BLDCProcessState_SLRunForcedPLL_IntTimB(void)
{
}

static void BLDCProcessState_SLRunForcedPLL_TimerCmt(void)
{
}

static void SensorlessCmtSyncPLL_Stg2ZCDetectionProc (void)
{
}

static void SensorlessCmForcedPLL_Stg3ZCDetected (void)
{
}

static void ForcedPLLregulator_ErrorPositive(void)
{
}

static void ForcedPLLregulator_ErrorNegative(void) 
{
}

static void BLDCProcessState_Fault_Main(void)
{
    FTM2_pwm3pps_PWMOff();
    FTM2_pwm3pps_FaultFlagReadClear();
    FTM0ch0_TimerCmt_CmtDisableInterrupt();
    ZCDetect_SetIdle();    
    if ((appFaultPendingFlags.Byte == 0) & ((appControlFlags.Bits.FaultClear==1)|(appControlFlags.Bits.BldcStart==0)))
    {
        appFaultFlags.Byte = 0;
        appControlFlags.Bits.FaultClear = 0;
        BLDCProcessState_AppInitEnter();
    }

}

static void BLDCProcessState_Fault_IntTimB(void)
{
	;
}

static void BLDCProcessState_Fault_TimerCmt(void)
{
	;
}

static void BLDCProcessState_Restart_Main(void)
{
	;
}

static void BLDCProcessState_Restart_IntTimB(void)
{
    iDcbZcFilt = iDcb;
    if (bldcIntTimBFlags.Bits.RestartIsTimed == 0)
    {
        {
            timBExtendedCntr = restartPeriodTimB;
            bldcIntTimBFlags.Bits.RestartTimeout = 0;
            bldcIntTimBFlags.Bits.RestartIsTimed = 1;
            velocityRampAct = 0;
            velocityAct = velocityActU = 0;
        }
    }
    else
    {
        if(timBExtendedCntr-- < 0)
        {
            bldcIntTimBFlags.Bits.RestartTimeout = 1;
            cmtFaultCounter++; 

            BLDCProcessState_CmtInit();
            BLDCProcessState_AlignmentEnter();
        }
    }
}

static void BLDCProcessState_Restart_TimerCmt(void)
{
	;
}
void BLDCProcessState_CmtInit(void)
{
    velocityAct = velocityActU = 0;
    FTM0ch0_TimerCmt_CmtDisableInterrupt();
    //ADC_DisableInterrupt();
    ZCDetect_SetIdle();
    FTM2_pwm3pps_PWMOff();
    FTM2_pwm3pps_FaultFlagReadClear();

    bldcMainFlags.Byte = 0;

    zcErrorCounter = 0;
    cmtFlags.Bits.CmtError = 0;
    cmtFlags.Bits.CmtStabilized = 0;
    zcSeqCorrectCounter = 0;
    cmtCounter = 0;
}
 static void FaultCheck_Main(void)
 {

	 if (FTM2_FMS_FAULTF == 0)
	 {
	     appFaultPendingFlags.Bits.FaultInput1 = 0;
	 }
     if(bldcStateIndex != BLDC_APP_INIT)
     {
         if(uDcbFilt > (unsigned int)FAULT_OVERVOLTAGE_THRESHOLD)// over voltage software detection: over voltage is 28V
         {
             appFaultFlags.Bits.DCBOvervoltage = 1;
             appFaultPendingFlags.Bits.DCBOvervoltage = 1;

         } 
         else 
         {
        	 appFaultFlags.Bits.DCBOvervoltage = 0;
             if (uDcbFilt < (unsigned int)FAULT_UNDERVOLTAGE_THRESHOLD)//under voltage software detection: under voltage is 10V
             {
                 appFaultFlags.Bits.DCBUndervoltage = 1;
             } 
             else
             {
            	 appFaultFlags.Bits.DCBUndervoltage = 0;
             }
          }
          if(cmtFaultCounter >= cmtFaultCounterThreshold)//commutation fault count
          {
              appFaultFlags.Bits.CmtFault = 1;
              cmtFaultCounter = 0;
          }
      }
  }
 
 static void BLDCProcessState_RestartEnter(void)
 {
     FTM0ch0_TimerCmt_CmtDisableInterrupt();
     ZCDetect_SetIdle();
     FTM2_pwm3pps_PWMOff();
     
     bldcIntTimBFlags.Bits.RestartIsTimed = 0;
     bldcStateIndex = BLDC_RESTART;   
 }

 static void PWM_SetDutyCycle(void)
 {
 	unsigned char ccrStore;
 #ifdef PWM_BIPOLAR_SWITCHING
     dutyCyclePWMU16 = (unsigned int)((dutyCycleU16/2+(unsigned int)(PWM_MODULO/2)));
 #else
     dutyCyclePWMU16 = dutyCycleU16;
 #endif
	 SYS_SOPT3 = SYS_SOPT3_BUSREF0_MASK | SYS_SOPT3_BUSREF1_MASK ;
     if(dutyCyclePWMU16>dutyCyclePrev)
     {
         ccrStore = irq_disable();
         FTM2_pwm3pps_ComplDutyCycleUpdate((unsigned int) dutyCyclePWMU16);
         irq_restore(ccrStore);
		 SYS_SOPT4 = (unsigned char)(dutyCyclePWMU16>>4);
     } 
     else
     {
     	 SYS_SOPT4 = (unsigned char)(dutyCyclePWMU16>>4);
         ccrStore = irq_disable();
         FTM2_pwm3pps_ComplDutyCycleUpdate((unsigned int) dutyCyclePWMU16);
         irq_restore(ccrStore);
     }
     dutyCyclePrev = dutyCyclePWMU16;
 }
 
 void CommutationControlFalling(void)
 {
	 	signed int delta;
		
 		CommutationFlag = 1;
 		ZCDetect_Stg3ZCDetected();
 		delta = bemfVoltage - bemfVoltageOld;
 		if((delta < bemfVoltage) && (AdcCmtFlags.Bits.AdcSaved == 1))
 		{
 		    timeBackEmf -= umul16_16to16(udiv16(abs16(bemfVoltage), abs16(delta)), (timeBackEmf - timeOldBackEmf));
 		}
 		else
 		{
 		    timeBackEmf -= ((timeBackEmf - timeOldBackEmf) >> 1);
 		}
	    SensorlessCmtDirect_Stg3ZCDetected();
	    iDcbZcFilt = iDcb;
	    IPC_SC_PULIPM = 1;
 }
 
 void CommutationControlRising(void)
  {
	 	signed int delta;
		
 		ZCDetect_Stg3ZCDetected();
  		CommutationFlag = 1;
  		delta = bemfVoltage - bemfVoltageOld;
 		if((delta > bemfVoltage) && (AdcCmtFlags.Bits.AdcSaved == 1))
 		{
 		    timeBackEmf -= umul16_16to16(udiv16(abs16(bemfVoltage), abs16(delta)), (timeBackEmf - timeOldBackEmf));
 		}
 		else
 		{
 		    timeBackEmf -= ((timeBackEmf - timeOldBackEmf) >> 1);
 		}
 	    SensorlessCmtDirect_Stg3ZCDetected();
 	    iDcbZcFilt = iDcb;
 	    IPC_SC_PULIPM = 1;
 	   //PORT_PTAD_PTAD2 = ~ PORT_PTAD_PTAD2;
  }
 
 __interrupt void Mtim1Overflow(void)
  {
	//PORT_PTAD_PTAD3 = ~PORT_PTAD_PTAD3;
	//PORT_PTAD_PTAD1= 0;
	  MTIM1_SC_TOF = 0;
	  EnableInterrupts;
	  if(!cmtFlags.Bits.CmtStabilized)
	  {   
		  if(cmtCounter > cmtStabilizedCounterThreshold)
	      {
			  cmtFlags.Bits.CmtStabilized = 1;
			  cmtCounter =0;
	      }
	   }
	  BLDCProcess_IntTimBIndexFcn[bldcStateIndex]();
	  if(adcSensing_AverageUDCBCounter >= ADC_SENSING_UDCB_FILT_COUNT)
	  {
		  Udchalf = ADCSensing_FilterAverageU(&uDcbSum32, &adcSensing_AverageUDCBCounter, ADValue_Half_Voltage);
		  Udchalf &= 0x0FFF;
		  adcFlags.Bits.UFiltInitialized = 1;
		  uDcbFilt = (Udchalf<<1);
		  uDcbFilt &= 0x0FFF;
	  }
	  ADCSensingCheckInit();
	  UpDownSwitchVelocitySet();
	  IPC_SC_PULIPM = 1;
	  //PORT_PTAD_PTAD1= 1;
  }
 __interrupt void Ftm0Ch0timeroverflow(void)
  {
  	PORT_PTAD_PTAD1= 1;
	//PORT_PTAD_PTAD2= 1;
  	PORT_PTAD_PTAD3 = ~PORT_PTAD_PTAD3;
	    FTM0_SC_TOF = 0;
	    BLDCProcess_TimerCmtIndexFcn[bldcStateIndex]();
	    
	    if(zcErrorCounter>zcErrorCounterThreshold)
	    {
	        cmtFlags.Bits.CmtError = 1;
	    } 
	    else
	    {
	       cmtFlags.Bits.CmtError = 0;
	    }
	    IPC_SC_PULIPM = 1;
		//PORT_PTAD_PTAD3 = 1;
  }

  __interrupt void PWMFault(void)
  {
	  FTM0ch0_TimerCmt_CmtDisableInterrupt();
	  ZCDetect_SetIdle();
	  FTM2_pwm3pps_PWMOff();
	  appFaultFlags.Bits.FaultInput1 = 1;
	  FTM2_pwm3pps_FaultFlagReadClear();
	  IPC_SC_PULIPM = 1;
	  bldcStateIndex = BLDC_FAULT;
  }
  /****************************************************
  *
  *use ADC fifo mode
  *
  *****************************************************/
  /*
  __interrupt void AdcBackEMFdetection(void) 
  {
  	ADVALUE_Current = ADC_R;
  	ADValue_Half_Voltage = ADC_R;
  	ADValue_BEMFA = ADC_R;
  	ADValue_BEMFB = ADC_R;
  	ADValue_BEMFC = ADC_R;
  	ADC_SC1_AIEN = 0;
  	ADC_SC2_ADTRG = 0;
  	ADValue_Voltage = (ADValue_Half_Voltage << 1);
	if (zcDetectStateIndex == ZCDETECT_STG2ZCDETECTION_PROC)
	{
		timeOldBackEmf = timeBackEmf;
    	timeBackEmf =  timeBLDCCmt1 + FTM0_CNT;
	}
  	if (adcFlags.Bits.ICalibrated == 0)
  	{
  		iDcbSum32 = uadd32_16_32(iDcbSum32, ADVALUE_Current);
  	    if(++adcSensing_CalibrationCounter >= ADC_SENSING_CALIBRATION_COUNT) 
  	    {   
  	        iDcboffset = udiv32i8to16(iDcbSum32, adcSensing_CalibrationCounter);
  	        iDcbSum32 = 0;
  	        //adcSensing_AverageIDCBCounter = 0;
  	        adcFlags.Bits.ICalibrated = 1;
  	     }
  	 }
  	 else
  	 {
  		 if(zcDetectStateIndex != ZCDETECT_STG1CURR_RECIRCULATION)
  		 {
  	         if(zcDetectStateIndex != ZCDETECT_STG0)//Changed 09.12.23
  	         {
  	             iDcb = subu16_u16to16(ADVALUE_Current, iDcboffset);
  	         }
  	     }
  	  }
  	ADCSensing_FilterSampleU(uDcbSum32, adcSensing_AverageUDCBCounter, ADValue_Half_Voltage);
	
  	u_dc_bus_filt = (signed int)(FilterMA_F16(ADValue_Voltage, &Udcb_filt));
  	
  	EnableInterrupts;	
  	//debug
  	zcCompSector = zcCompZCOpposite1[pwm3ppsSector];
      //if(bldcStateIndex == BLDC_SL_RUN_DIRECT) 
      {
    	  //if (CommutationFlag == 0) 
    	  if (FTM0_CNT >= periodBLDCOpenLoopCmt/4)
    	  {
    		  switch (zcCompSector)
    		  {
    			case 0:
    						PORT_PTAD_PTAD1 = 0;
              		PORT_PTAD_PTAD2 = 0;
    				//ADValue_BEMFB_Average = uadd16(ADValue_BEMFB>>1, ADValue_BEMFB1>>1);
    				bemfVoltage = (ADValue_BEMFC - (u_dc_bus_filt >> 1));
    				 
    				if (bemfVoltage > 0)
                	{
    					//FTM0_CNT = 0;
                	  	//CommutationControlFalling();
                	}
                	
                	break;
              	case 1:
   
              		
        			//ADValue_BEMFA_Average = uadd16(ADValue_BEMFA>>1, ADValue_BEMFA1>>1);
              		bemfVoltage = (ADValue_BEMFB - (u_dc_bus_filt >> 1));
              		
                  if (bemfVoltage < 0)
                  {
                	   //   					FTM0_CNT = 0;
                	 //CommutationControlRising();
                	 
                  }
                  
                  break;
            		case 2:
            			
            			
            			
            			bemfVoltage = (ADValue_BEMFA - (u_dc_bus_filt >> 1));
            			
                	if (bemfVoltage > 0)
                	{
                		 //   					FTM0_CNT = 0;
                	 	//CommutationControlFalling();
                		
                	}
                	break;
            		case 3:
                  		           
            			bemfVoltage = (ADValue_BEMFC- (u_dc_bus_filt >> 1));
                	if (bemfVoltage < 0)
                	{
                		  //  				FTM0_CNT = 0;
                		//CommutationControlRising();
                	}
                	
                	break;
            		case 4:

            			bemfVoltage = (ADValue_BEMFB - (u_dc_bus_filt >> 1));
                	if (bemfVoltage > 0)
                	{
                		  //  					FTM0_CNT = 0;
                	  	//CommutationControlFalling();
                		
                	}
                	break;
            		case 5:
						PORT_PTAD_PTAD1 = 1;
            			bemfVoltage = (ADValue_BEMFA - (u_dc_bus_filt >> 1));
                	if (bemfVoltage < 0)
                	{
                		  //  					FTM0_CNT = 0;
                	  //	CommutationControlRising(); 
                	  //PORT_PTAD_PTAD2 = 1;
                	}
                	break;
            		default:
            		{
                	  	;
                	}
				}
				bemfVoltageOld = bemfVoltage;
          }
      }
      
      ADC_SC2_ADTRG = 1;
      ADCFIFOSetting();
      FMSTR_Recorder();
      IPC_SC_PULIPM = 1;
      //PORT_PTAD_PTAD1 = 0;
  }
  */
  /****************************************************
  *
  *unuse ADC fifo mode
  *
  *****************************************************/
  
  __interrupt void AdcBackEMFdetection(void) 
  {
  	//PORT_PTAD_PTAD2= 0;
  	ADC_SC1_AIEN = 0;
  	ADC_SC2_ADTRG = 0;
	ADValue_BEMF = ADC_R;
	if (zcDetectStateIndex == ZCDETECT_STG2ZCDETECTION_PROC)
	{
		timeOldBackEmf = timeBackEmf;
    	timeBackEmf =  timeBLDCCmt1 + FTM0_CNT;
	}
	ADC_StartOneConversionDisInt(adcI_UTSecondSample_InputSelectTab[adcSensing_SecondSampState]);
	//EnableInterrupts;
	while (ADC_SC1_COCO == 0);
	if (adcSensing_SecondSampState == 0)
	{
	//PORT_PTED_PTED6 = 0;
		ADValue_Half_Voltage = ADC_R;	
		ADValue_Voltage = (ADValue_Half_Voltage << 1);
		
		ADCSensing_FilterSampleU(uDcbSum32, adcSensing_AverageUDCBCounter, ADValue_Half_Voltage);
		
		u_dc_bus_filt = (signed int)(FilterMA_F16(ADValue_Voltage, &Udcb_filt));
		//PORT_PTED_PTED6 = 1;
	}
	else
	{
		ADVALUE_Current = ADC_R;
		
		if (adcFlags.Bits.ICalibrated == 0)
		{
			iDcbSum32 = uadd32_16_32(iDcbSum32, ADVALUE_Current);
			if(++adcSensing_CalibrationCounter >= ADC_SENSING_CALIBRATION_COUNT) 
			{	
				iDcboffset = udiv32i8to16(iDcbSum32, adcSensing_CalibrationCounter);
				iDcbSum32 = 0;
				//adcSensing_AverageIDCBCounter = 0;
				adcFlags.Bits.ICalibrated = 1;
			 }
		 }
		 else
		 {
			 if(zcDetectStateIndex != ZCDETECT_STG1CURR_RECIRCULATION)
			 {
				 if(zcDetectStateIndex != ZCDETECT_STG0)//Changed 09.12.23
				 {
					 iDcb = subu16_u16to16(ADVALUE_Current, iDcboffset);
				 }
			 }
		  }
	}
	
	if (adcSensing_SecondSampState++ >= 1) 
	{
		adcSensing_SecondSampState = 0; 
	}
	//bemfVoltage = (ADValue_BEMF - Udchalf);
	bemfVoltage = ADValue_BEMF - (u_dc_bus_filt>>1);
	if(bldcStateIndex == BLDC_SL_RUN_DIRECT) 
	{
		if (CommutationFlag == 0) 
		{
			switch (zcCompSector)
			{
			  	case 0:
				  	if (bemfVoltage < 0)
				  	{
					PORT_PTAD_PTAD2= ~PORT_PTAD_PTAD2;
						CommutationControlFalling();
				  	}
				  break;
			  	case 1:
					if (bemfVoltage >0)
					{
					PORT_PTAD_PTAD2= ~PORT_PTAD_PTAD2;
						CommutationControlRising();
					}
				break;
				  case 2:
				  if (bemfVoltage < 0)
				  {
				 PORT_PTAD_PTAD2= ~PORT_PTAD_PTAD2;
						CommutationControlFalling();
				  }
				  break;
				  case 3:
				  if (bemfVoltage > 0)
				  {
				  PORT_PTAD_PTAD2= ~PORT_PTAD_PTAD2;
						CommutationControlRising();
				  }
				  break;
				  case 4:
				  if (bemfVoltage < 0)
				  {
				  PORT_PTAD_PTAD2= ~PORT_PTAD_PTAD2;
						CommutationControlFalling();
				  }
				  break;
				  case 5:
				  if (bemfVoltage> 0)
				  {
				  PORT_PTAD_PTAD2= ~PORT_PTAD_PTAD2;
						CommutationControlRising();
				  }
				  break;
				  default:
				  {
					  ;
				  }
				  break;
			  }
			bemfVoltageOld = bemfVoltage;
			AdcCmtFlags.Bits.AdcSaved = 1;
		}
	}
	ADC_SC2_ADTRG = 1;
	ADC_SC1 = adc_BEMF_InputSelectTab[zcCompSector];
	ADC_SC1_AIEN = 1;
	IPC_SC_PULIPM = 1;
	//PORT_PTAD_PTAD2= 1;
 }
  
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/ /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END ProcessorExpert */
/*
** ###################################################################
**
**     This file was created by Processor Expert 5.1 [04.49]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
