/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* $File Name:	3pps_bldc_drv.c$
*
* $Author:		r30322$
* 
* $Version:		1.0.41.0$
* 
* $Date:		Jan-21-2010$
* 
* $Brief: 		3-phase power stage drivers for six-step BLDC PWM
*               using Flextimer FTM2 for the PWM and FTM1 for commutation timing
*
* Target:		MC9S08MP16 device
*
*******************************************************************************/

#include "hw_config.h"      /* include hardware configurations */
#include "main.h"           /* include main definitions */
#include "3pps_bldc_drv.h"  /* include 3phase power stage bldc control driver header file */
#include "IO_Map.h"



char pwmVector_Compl_OutMask[] = {
  FTM2_OUTMASK_CH2OM_MASK | FTM2_OUTMASK_CH3OM_MASK,    /* Phase B off */
   FTM2_OUTMASK_CH0OM_MASK | FTM2_OUTMASK_CH1OM_MASK,    /* Phase A off */
   FTM2_OUTMASK_CH4OM_MASK | FTM2_OUTMASK_CH5OM_MASK,    /* Phase C off */
  FTM2_OUTMASK_CH2OM_MASK | FTM2_OUTMASK_CH3OM_MASK,    /* Phase B off */
   FTM2_OUTMASK_CH0OM_MASK | FTM2_OUTMASK_CH1OM_MASK,    /* Phase A off */
   FTM2_OUTMASK_CH4OM_MASK | FTM2_OUTMASK_CH5OM_MASK     /* Phase C off */
};

 signed char pwmVector_UniCompl_C0ValDir024[] = {
    0,      /* Phase A PWM */
    -1,     /* Phase A pull to GND */
    -1,     /* Phase A pull to GND */
    -1,     /* Phase A pull to GND */
    0,      /* Phase A PWM */
    0       /* Phase A PWM */
};

 signed char pwmVector_UniCompl_C2ValDir024[] = {
    0,      /* Phase B PWM */
    0,      /* Phase B PWM */
    0,      /* Phase B PWM */
    -1,     /* Phase B pull to GND */
    -1,     /* Phase B pull to GND */
    -1,     /* Phase B pull to GND */
};

 signed char pwmVector_UniCompl_C4ValDir024[] = {
    -1,     /* Phase C pull to GND */
    -1,     /* Phase C pull to GND */
    0,      /* Phase C PWM */ 
    0,      /* Phase C PWM */ 
    0,      /* Phase C PWM */
    -1      /* Phase C pull to GND */
};

 signed char pwmVector_UniCompl_C0ValDir420[] = {
    0,      /* Phase A PWM */ 
    0,      /* Phase A pull to GND */
    -1,     /* Phase A pull to GND */
    -1,     /* Phase A pull to GND */
    -1,     /* Phase A pull to GND */
    0       /* Phase A PWM */ 
};

 signed char pwmVector_UniCompl_C2ValDir420[] = {
    -1,     /* Phase B pull to GND */
    0,      /* Phase B PWM */ 
    0,      /* Phase B PWM */ 
    0,      /* Phase B PWM */ 
    -1,     /* Phase B pull to GND */
    -1      /* Phase B pull to GND */
};

 signed char pwmVector_UniCompl_C4ValDir420[] = {
    -1,     /* Phase C pull to GND */
    -1,     /* Phase C pull to GND */
    -1,     /* Phase C pull to GND */
    0,      /* Phase C PWM */
    0,      /* Phase C PWM */
    0       /* Phase C PWM */
};





 char pwmVector_BipCompl_ElsCh0Dir024[] = {
    FTM2_C0SC_ELSB_MASK | FTM2_C0SC_MSB_MASK,
    FTM2_C0SC_ELSA_MASK | FTM2_C0SC_MSB_MASK,
    FTM2_C0SC_ELSA_MASK | FTM2_C0SC_MSB_MASK,
    FTM2_C0SC_ELSA_MASK | FTM2_C0SC_MSB_MASK,
    FTM2_C0SC_ELSB_MASK | FTM2_C0SC_MSB_MASK,
    FTM2_C0SC_ELSB_MASK | FTM2_C0SC_MSB_MASK
};

 

 char pwmVector_BipCompl_ElsCh2Dir024[] = {
    FTM2_C2SC_ELSB_MASK | FTM2_C2SC_MSB_MASK,
    FTM2_C2SC_ELSB_MASK | FTM2_C2SC_MSB_MASK,
    FTM2_C2SC_ELSB_MASK | FTM2_C2SC_MSB_MASK,
    FTM2_C2SC_ELSA_MASK | FTM2_C2SC_MSB_MASK,
    FTM2_C2SC_ELSA_MASK | FTM2_C2SC_MSB_MASK,
    FTM2_C2SC_ELSA_MASK | FTM2_C2SC_MSB_MASK
};

 

char pwmVector_BipCompl_ElsCh4Dir024[] = {
    FTM2_C4SC_ELSA_MASK | FTM2_C4SC_MSB_MASK,
    FTM2_C4SC_ELSA_MASK | FTM2_C4SC_MSB_MASK,
    FTM2_C4SC_ELSB_MASK | FTM2_C4SC_MSB_MASK,
    FTM2_C4SC_ELSB_MASK | FTM2_C4SC_MSB_MASK,
    FTM2_C4SC_ELSB_MASK | FTM2_C4SC_MSB_MASK,
    FTM2_C4SC_ELSA_MASK | FTM2_C4SC_MSB_MASK
};


 
 char pwmVector_BipCompl_ElsCh0Dir420[] = {
    FTM2_C0SC_ELSB_MASK | FTM2_C0SC_MSB_MASK,
    FTM2_C0SC_ELSB_MASK | FTM2_C0SC_MSB_MASK,
    FTM2_C0SC_ELSA_MASK | FTM2_C0SC_MSB_MASK,
    FTM2_C0SC_ELSA_MASK | FTM2_C0SC_MSB_MASK,
    FTM2_C0SC_ELSA_MASK | FTM2_C0SC_MSB_MASK,
    FTM2_C0SC_ELSB_MASK | FTM2_C0SC_MSB_MASK
};

 char pwmVector_BipCompl_ElsCh2Dir420[] = {
    FTM2_C2SC_ELSA_MASK | FTM2_C2SC_MSB_MASK,
    FTM2_C2SC_ELSB_MASK | FTM2_C2SC_MSB_MASK,
    FTM2_C2SC_ELSB_MASK | FTM2_C2SC_MSB_MASK,
    FTM2_C2SC_ELSB_MASK | FTM2_C2SC_MSB_MASK,
    FTM2_C2SC_ELSA_MASK | FTM2_C2SC_MSB_MASK,
    FTM2_C2SC_ELSA_MASK | FTM2_C2SC_MSB_MASK,
};


 char pwmVector_BipCompl_ElsCh4Dir420[] = {
    FTM2_C4SC_ELSA_MASK | FTM2_C4SC_MSB_MASK,
    FTM2_C4SC_ELSA_MASK | FTM2_C4SC_MSB_MASK,
    FTM2_C4SC_ELSA_MASK | FTM2_C4SC_MSB_MASK,
    FTM2_C4SC_ELSB_MASK | FTM2_C4SC_MSB_MASK,
    FTM2_C4SC_ELSB_MASK | FTM2_C4SC_MSB_MASK,
    FTM2_C4SC_ELSB_MASK | FTM2_C4SC_MSB_MASK
};

void FTM0ch0_TimerCmt_OCISetNext(unsigned int timeOCNext)
{
	
    FTM0_C0V = timeOCNext;
}

void FTM0ch0_TimerCmt_OCISetNextTrigWait(unsigned int timeOCNext)
{
    FTM0_C0V = timeOCNext;
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
    asm(brn 0);
 
    //FTM0_C0SC &= ~FTM0_C0SC_CHF_MASK;
    FTM0_SC_TOF = 0;
    /* Init FTM1 for next SYNC_PWM3pps<-TimerCmt SyncA */
    //FTM1_MODE_INIT = 1;//???????????????????????????
    FTM2_SYNC_TRIG1 = 1;
}

unsigned int FTM0ch0_TimerCmt_OCICorrectLow(unsigned int timeOCNext)
{
unsigned int TempU16;
    TempU16 = FTM0_CNT;
    TempU16 = timeOCNext-TempU16;
    if(TempU16<TIME_MIN_SET_TIMER_CMT)
    {
        return(FTM0_CNT+TIME_MIN_SET_TIMER_CMT);
    } else if(TempU16>MAX_S16)
    {
        return(FTM0_CNT+TIME_MIN_SET_TIMER_CMT);
    } else return(timeOCNext);
}
#if 0
void FTM2_pwm3pps_BipolVectorCommutateSet(signed char *pwmSectorLoc, BLDC_MAIN_FLAGS *BLDCMainFlagsLoc) 
    {
		if (*BLDCMainFlagsLoc->Bits.Dir024) 
        { 
            if (++(*pwmSectorLoc)>PWM_SECTOR_MAX) 
            { 
                *pwmSectorLoc = 0; 
            } 
            FTM2_pwm3pps_BipComplBLDCSetVectorDir024(*pwmSectorLoc); 
        } 
        else 
        {
            if (*pwmSectorLoc-- == 0) 
            {
                *pwmSectorLoc = PWM_SECTOR_MAX; 
            } 
            FTM2_pwm3pps_BipComplBLDCSetVectorDir420(*pwmSectorLoc); 
        }
    }

static byte ftm2_val = 0;
void FTM2_pwm3pps_BipolVectorCommutatePreset(signed char*pwmSectorLoc, BLDC_MAIN_FLAGS*BLDCMainFlagsLoc) 
    {
		
		
		if (BLDCMainFlagsLoc->Bits.Dir024) 
        { 
            FTM2_pwm3pps_BipCompl_ElsVectorDir024(*pwmSectorLoc); 
            if (++(*pwmSectorLoc)>PWM_SECTOR_MAX) 
            { 
                *pwmSectorLoc = 0; 
            } 
        } 
        else 
        { 
            FTM2_pwm3pps_BipCompl_ElsVectorDir420(*pwmSectorLoc); 
            if ((*pwmSectorLoc)-- == 0) 
            { 
                *pwmSectorLoc = PWM_SECTOR_MAX; 
            } 
        } 
        //FTM2_pwm3pps_Compl_OutMaskVector(*pwmSectorLoc);
		ftm2_val = pwmVector_Compl_OutMask[*pwmSectorLoc];
		FTM2_SYNC_SYNCHOM = 0;
		   // FTM2_pwm3pps_Compl_OutMaskVector(pwmSectorLoc);
		FTM2_OUTMASK = ftm2_val;
		    FTM2_SYNC_SYNCHOM = 1; 
		//FTM2_OUTMASK = ftm2_val;		
		FTM2_SYNC_SWSYNC = 1;
    }
#endif 
