/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
******************************************************************************* 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      SPI_00364_01.c
*
* @author    RE900C
* 
* @version   1.0.2.0
* 
* @date      Jul-31-2009
* 
* @brief     SPI driver to support MC33927 on the board 00364_01
*
*******************************************************************************
*
* SPI driver to support MC33927 on the board 00364_01 plugged on 00315_01.
*
******************************************************************************/

/******************************************************************************
* Includes
******************************************************************************/
#include "00364_01/SPI_00364_01.h"

/*****************************************************************************
* External objects
******************************************************************************/

/******************************************************************************
* Global variables
******************************************************************************/

/******************************************************************************
* Constants and macros
******************************************************************************/

/******************************************************************************
* Local function prototypes
******************************************************************************/

/******************************************************************************
* Local variables
******************************************************************************/

/******************************************************************************
* Local functions
******************************************************************************/

/******************************************************************************
* Global functions
******************************************************************************/

/***************************************************************************//*!
*
* @brief  SPI initialization function
*
* @remarks 	Initializes the SPI module for communication with 3pp.
*
****************************************************************************/

/***************************************************************************//*!
*
* @brief  Send/Receive data to/from SPI
*
* @param  in    		byte bytData
*                         - 8-bit data to be send
*
* @return This function returns
*     - UWord8 8-bit data
*		
* @remarks 	The function sends data via SPI with a length of 8 bits and
*           at the same instants receives 8 bit data. This routine is used
*           for communication with 3pp.
*
****************************************************************************/
byte SPI_Send(byte bytData)
{
    /* waits until empty buffer */
    while(!SPI0_S_SPTEF); 
    
    /* Sends data */
    SPI0_D = bytData;

    /* waits until data transferred  */
    while(!SPI0_S_SPRF);

    /* Return received data */
    return((byte)SPI0_D);        
}
