/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************//*!
*
* @file      intrinsic_math.h
*
* @author    r30322
* 
* @version   1.0.21.0
* 
* @date      Nov-11-2009
* 
* @brief     basic mathematical functions header file
*
* target     HCS08
*
* tested on compiler:  
*            CodeWarrior Development Studio for Microcontrollers V6.2 Release
*
*******************************************************************************/

/* DEFINITION_START */

#ifndef _INTRINSIC_MATH_H
#define _INTRINSIC_MATH_H

/******************************************************************************/
/*              I N C L U D E  H E A D E R  F I L E S                         */
/******************************************************************************/
#include <stdlib.h>
#include "types.h"     /* include type definitions */

/******************************************************************************/
/*              FUNCTION DECLARATION                                          */
/******************************************************************************/

/*****************************************************************************
*
* Macro: unsigned int umul16_8to16_macro(unsigned int x, unsigned char y)
*
* Description:
*   x(L)*y/256+x(H)*y
*
* Returns: x*y/256
*
*****************************************************************************/
#define umul16_8to16macro(x, y) (unsigned int)((unsigned int)((unsigned char)((x)>>8)*\
    (unsigned char)(y))+(unsigned char)(((unsigned char)(x)*(unsigned char)(y))>>8))
#define umul8_8to16macro(x, y) (unsigned int)((unsigned char)x*(unsigned char)y);

unsigned int umul16_8to16 (unsigned int x, unsigned char y);
unsigned int umul8_8to16(unsigned char x, unsigned char y);
unsigned int umul16_16to16 (unsigned int x, unsigned int y);

unsigned char udiv16_8to8(unsigned int x, unsigned char y);
unsigned int udiv16i8to16(unsigned int x, unsigned int y);
unsigned int udiv32i8to16(unsigned long x, unsigned char y);
unsigned char udiv16_16to8(unsigned int x, unsigned int y);
unsigned int udiv16(unsigned int x, unsigned int y);

void add24_mult16_8_24(UWord24H16L8 *zSum24, unsigned int x, unsigned char y);
void sub24_mult16_8_24(UWord24H16L8 *zSum24, unsigned int x, unsigned char y);
signed int add16(signed int  x, signed int y);
unsigned char uadd8(unsigned char x, unsigned char y);
unsigned int uadd16(unsigned int x, unsigned int y);
#define sub16(x,y) (signed int)sub16yx ((signed int)y, (signed int) x)
signed int sub16yx(signed int y, signed int x);
signed int subu16_u16to16(unsigned int x, unsigned int y);
unsigned char usub8(unsigned char x, unsigned char y);
unsigned int usub16yx (unsigned int y, unsigned int x);
#define  usub16(x,y) (unsigned int)usub16yx ((unsigned int)y, (unsigned int) x)
unsigned long uadd32(unsigned long x, unsigned long y);
signed long add32(signed long x, signed long y);
unsigned long usub32(unsigned long x, unsigned long y);
signed long sub32(signed long x, signed long y);
unsigned long uadd32_16_32(unsigned long x, unsigned int y);
signed long add32_16_32(signed long x, signed int y);

signed int abs16(signed int x);
signed char neg8(signed char x);
signed int neg16(signed int x);                   /* source math.asm */

unsigned long umul16_8to32(unsigned int x, unsigned char y);
signed int shl16_u8to16(signed int x, unsigned char n);
signed int shr16_u8to16(signed int x, unsigned char n);
signed long shl32_u8to32(signed long x, unsigned char n);
signed long shr32_u8to32(signed long x, unsigned char n);



unsigned char irq_disable(void);
void irq_restore(unsigned char previous);

#endif  /* _INTRINSIC_MATH_H */
