/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename  : Cpu.c
**     Project   : ProcessorExpert
**     Processor : MC9S08PT60CLH
**     Component : MC9S08PT60_64
**     Version   : Component 01.103, Driver 01.40, CPU db: 3.00.000
**     Datasheet : MC9S08PT60RM Rev. 1, 9/2011
**     Compiler  : CodeWarrior HCS08 C Compiler
**     Date/Time : 2012-05-31, 15:37, # CodeGen: 226
**     Abstract  :
**         This component "MC9S08PT60_64" contains initialization 
**         of the CPU and provides basic methods and events for 
**         CPU core settings.
**     Settings  :
**
**     Contents  :
**         EnableInt  - void Cpu_EnableInt(void);
**         DisableInt - void Cpu_DisableInt(void);
**
**     Copyright : 1997 - 2011 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE Cpu. */

#pragma MESSAGE DISABLE C4002 /* WARNING C4002: Result not used is ignored */

#include "FTM2.h"
#include "FTM0.h"
#include "MTIM1.h"
#include "PortH.h"
#include "SCI.h"
#include "SPI.h"
#include "GPIO1.h"
#include "ADC.h"
#include "GPIO2.h"
#include "GPIO3.h"
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"
#include "Events.h"
#include "Cpu.h"


/* Global variables */
volatile byte CCR_reg;                 /* Current CCR register */


/*
** ===================================================================
**     Method      :  Cpu_Interrupt (component MC9S08PT60_64)
**
**     Description :
**         The method services unhandled interrupt vectors.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
ISR(Cpu_Interrupt)
{
  /* This code can be changed using the CPU component property "Build Options / Unhandled int code" */
  /*lint -save -e950 Disable MISRA rule (1.1) checking. */
  asm(BGND);
  /*lint -restore Enable MISRA rule (1.1) checking. */
}


/*
** ===================================================================
**     Method      :  Cpu_DisableInt (component MC9S08PT60_64)
**
**     Description :
**         Disables maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_DisableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  Cpu_EnableInt (component MC9S08PT60_64)
**
**     Description :
**         Enables maskable interrupts
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
/*
void Cpu_EnableInt(void)

**      This method is implemented as macro in the header module. **
*/

/*
** ===================================================================
**     Method      :  _EntryPoint (component MC9S08PT60_64)
**
**     Description :
**         Initializes the whole system like timing and so on. At the end 
**         of this function, the C startup is invoked to initialize stack,
**         memory areas and so on.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
extern void _Startup(void);            /* Forward declaration of external startup function declared in file Start12.c */

#pragma NO_FRAME
#pragma NO_EXIT
void _EntryPoint(void)
{
  /* ### MC9S08PT60_64 "Cpu" init code ... */
  /*  PE initialization code after reset */
  /* WDOG_CNT: CNT=0xC520 */
  setReg16(WDOG_CNT, 0xC520U);         /* First part of the WDG unlock sequence */ 
  /* WDOG_CNT: CNT=0xD928 */
  setReg16(WDOG_CNT, 0xD928U);         /* Second part of the WDG unlock sequence */ 
  /* WDOG_TOVAL: TOVAL=4 */
  setReg16(WDOG_TOVAL, 0x04U);          
  /* WDOG_CS2: WIN=0,FLG=0,??=0,PRES=0,??=0,??=0,CLK=1 */
  setReg8(WDOG_CS2, 0x01U);             
  /* WDOG_CS1: EN=0,INT=0,UPDATE=0,TST=0,DBG=0,WAIT=0,STOP=0 */
  setReg8(WDOG_CS1, 0x00U);            /* Disable watchdog */ 
  /* Common initialization of the write once registers */
  /* SYS_SOPT1: SCI0PS=0,SPI0PS=1,FTM2PS=0,BKGDPE=1,RSTPE=1,FWAKE=0,STOPE=0 */
  clrSetReg8Bits(SYS_SOPT1, 0x93U, 0x4CU); 
  /* PMC_SPMSC1: LVWIE=0,LVDRE=1,LVDSE=1,LVDE=1,BGBDS=0,BGBE=0 */
  clrSetReg8Bits(PMC_SPMSC1, 0x23U, 0x1CU); 
  /* PMC_SPMSC2: LVDV=0,LVWV=0 */
  clrReg8Bits(PMC_SPMSC2, 0x70U);       
  /*  System clock initialization */
  /*lint -save  -e923 Disable MISRA rule (11.3) checking. */
  if (*(uint8_t*)0xFF6FU != 0xFFU) {   /* Test if the device trim value is stored on the specified address */
    ICS_C3 = *(uint8_t*)0xFF6FU;       /* Initialize ICS_C3 register from a non volatile memory */
    ICS_C4 = (uint8_t)((*(uint8_t*)0xFF6EU) & (uint8_t)0x01U); /* Initialize ICS_C4 register from a non volatile memory */
  }
  /*lint -restore Enable MISRA rule (11.3) checking. */
  /* ICS_C1: CLKS=0,RDIV=0,IREFS=1,IRCLKEN=1,IREFSTEN=0 */
  setReg8(ICS_C1, 0x06U);              /* Initialization of the ICS control register 1 */ 
  /* ICS_C2: BDIV=0,LP=0,??=0,??=0,??=0,??=0 */
  setReg8(ICS_C2, 0x00U);              /* Initialization of the ICS control register 2 */ 
  /* ICS_C4: LOLIE=0,CME=0 */
  clrReg8Bits(ICS_C4, 0xA0U);           

  /*** End of PE initialization code after reset ***/
  /*lint -save  -e950 Disable MISRA rule (1.1) checking. */
  __asm   jmp _Startup ;               /* Jump to C startup code */
  /*lint -restore Enable MISRA rule (1.1) checking. */
}

/*
** ===================================================================
**     Method      :  PE_low_level_init (component MC9S08PT60_64)
**
**     Description :
**         Initializes components and provides common register 
**         initialization. The method is called automatically as a part 
**         of the application initialization code.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
void PE_low_level_init(void)
{
  /* SCG_C1: FTM2=1,FTM1=1,FTM0=1,??=0,??=0,MTIM1=1,MTIM0=1,RTC=1 */
  setReg8(SCG_C1, 0xE7U);               
  /* SCG_C2: ??=0,??=0,DBG=1,NVM=1,IPC=1,CRC=1,??=0,??=0 */
  setReg8(SCG_C2, 0x3CU);               
  /* SCG_C3: ??=0,SCI2=1,SCI1=1,SCI0=1,SPI1=1,SPI0=1,IIC=1,??=0 */
  setReg8(SCG_C3, 0x7EU);               
  /* SCG_C4: ACMP=1,??=0,ADC=1,??=0,IRQ=1,TSI=1,KBI1=1,KBI0=1 */
  setReg8(SCG_C4, 0xAFU);               
  /* Common initialization of the CPU registers */
  /* SYS_SOPT2: TXDME=1 */
  setReg8Bits(SYS_SOPT2, 0x80U);        
  /* SYS_SOPT3: DLYACT=0,??=0,??=0,??=0,CLKOE=0,BUSREF=3 */
  setReg8(SYS_SOPT3, 0x03U);            
  /* IPC_SC: IPCE=0,??=0,PSE=0,PSF=0,PULIPM=0,??=0,IPM=0 */
  setReg8(IPC_SC, 0x00U);               
      /* Initialization of the PORT module */
  /* ### Shared modules init code ... */
  /* ### Init_FTM "FTM2" init code ... */
  FTM2_Init();
  /* ### Init_FTM "FTM0" init code ... */
  FTM0_Init();
  /* ### Init_MTIM "MTIM1" init code ... */
  MTIM1_Init();
  /* ### Init_GPIO "PortH" init code ... */
  PortH_Init();
  /* ### Init_SCI "SCI" init code ... */
  SCI_Init();
  /* ### Init_SPI "SPI" init code ... */
  SPI_Init();
  /* ### Init_GPIO "GPIO1" init code ... */
  GPIO1_Init();
  /* ### Init_ADC "ADC" init code ... */
  ADC_Init();
  /* ### Init_GPIO "GPIO2" init code ... */
  GPIO2_Init();
  /* ### Init_GPIO "GPIO3" init code ... */
  GPIO3_Init();
  __DI();                              /* Disable interrupts */
}

/*lint -save  -e950 Disable MISRA rule (1.1) checking. */
/* Initialization of the CPU registers in FLASH */
/*lint -restore Enable MISRA rule (1.1) checking. */

/* END Cpu. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.1 [04.49]
**     for the Freescale HCS08 series of microcontrollers.
**
** ###################################################################
*/
