/** ###################################################################
**     THIS COMPONENT MODULE IS GENERATED BY THE TOOL. DO NOT MODIFY IT.
**     Filename    : SegLCD1.c
**     Project     : ProcessorExpert
**     Processor   : MK40DX256ZVLQ10
**     Component   : SegLCD_LDD
**     Version     : Component 01.005, Driver 01.03, CPU db: 3.00.001
**     Compiler    : CodeWarrior ARM C Compiler
**     Date/Time   : 2012-04-25, 17:08, # CodeGen: 82
**     Abstract    :
**         This component "SegLCD_LDD" implements the segment Liquid Crystal Display (SegLCD)
**         driver module. It can drive an LCD which is composed of variable number
**         of frontplanes and backplanes. It can control also current mode of display.
**     Settings    :
**          Component name                                 : SegLCD1
**          Segment LCD module                             : LCD
**          Interrupt service/event                        : Disabled
**          Stop in Wait mode                              : no
**          Stop in Stop mode                              : no
**          Power supply                                   : 
**            LCD operation voltage                        : 3V
**            Power mode selection                         : Charge Pump
**            Voltage supply control                       : Drive VLL3 internally from VDD
**            Charge pump                                  : Enabled
**              Charge pump clock adjust                   : Fastest clock
**              Charge pump clock                          : 5.46 kHz
**              Voltage regulator                          : Disabled
**            Bias voltage VLL1                            : (VLL3 * 1/3) = 0.99V
**            Bias voltage VLL2                            : (VLL3 * 2/3) = 1.98V
**            Bias voltage VLL3                            : Connect internally to VDD(must be 3V)
**          Blink rate bits value                          : 3
**          Blink rate                                     : 0.999755 Hz
**          LCD frame frequency                            : 51.187 Hz
**          Base clock                                     : 800 Hz
**          Fault detect                                   : Disabled
**          Backplane pins                                 : 8
**            Backplane pin0                               : 
**              Backplane pin                              : PTD0/SPI0_PCS0/UART2_RTS_b/LCD_P40
**              Backplane pin signal                       : 
**            Backplane pin1                               : 
**              Backplane pin                              : PTD1/SPI0_SCK/UART2_CTS_b/LCD_P41/ADC0_SE5b
**              Backplane pin signal                       : 
**            Backplane pin2                               : 
**              Backplane pin                              : PTD2/SPI0_SOUT/UART2_RX/LCD_P42
**              Backplane pin signal                       : 
**            Backplane pin3                               : 
**              Backplane pin                              : PTD3/SPI0_SIN/UART2_TX/LCD_P43
**              Backplane pin signal                       : 
**            Backplane pin4                               : 
**              Backplane pin                              : PTD4/SPI0_PCS1/UART0_RTS_b/FTM0_CH4/EWM_IN/LCD_P44
**              Backplane pin signal                       : 
**            Backplane pin5                               : 
**              Backplane pin                              : PTD5/SPI0_PCS2/UART0_CTS_b/FTM0_CH5/EWM_OUT_b/LCD_P45/ADC0_SE6b
**              Backplane pin signal                       : 
**            Backplane pin6                               : 
**              Backplane pin                              : PTD6/SPI0_PCS3/UART0_RX/FTM0_CH6/FTM0_FLT0/LCD_P46/ADC0_SE7b
**              Backplane pin signal                       : 
**            Backplane pin7                               : 
**              Backplane pin                              : PTD7/CMT_IRO/UART0_TX/FTM0_CH7/FTM0_FLT1/LCD_P47
**              Backplane pin signal                       : 
**          Frontplane pins                                : 39
**            Frontplane pin0                              : 
**              Frontplane  pin                            : PTB1/I2C0_SDA/FTM1_CH1/FTM1_QD_PHB/LCD_P1/ADC0_SE9/ADC1_SE9/TSI0_CH6
**              Frontplane pin signal                      : 
**            Frontplane pin1                              : 
**              Frontplane  pin                            : PTB2/I2C0_SCL/UART0_RTS_b/FTM0_FLT3/LCD_P2/ADC0_SE12/TSI0_CH7
**              Frontplane pin signal                      : 
**            Frontplane pin2                              : 
**              Frontplane  pin                            : PTB3/I2C0_SDA/UART0_CTS_b/FTM0_FLT0/LCD_P3/ADC0_SE13/TSI0_CH8
**              Frontplane pin signal                      : 
**            Frontplane pin3                              : 
**              Frontplane  pin                            : PTB4/FTM1_FLT0/LCD_P4/ADC1_SE10
**              Frontplane pin signal                      : 
**            Frontplane pin4                              : 
**              Frontplane  pin                            : PTB5/FTM2_FLT0/LCD_P5/ADC1_SE11
**              Frontplane pin signal                      : 
**            Frontplane pin5                              : 
**              Frontplane  pin                            : PTB6/LCD_P6/ADC1_SE12
**              Frontplane pin signal                      : 
**            Frontplane pin6                              : 
**              Frontplane  pin                            : PTB7/LCD_P7/ADC1_SE13
**              Frontplane pin signal                      : 
**            Frontplane pin7                              : 
**              Frontplane  pin                            : PTB8/UART3_RTS_b/LCD_P8
**              Frontplane pin signal                      : 
**            Frontplane pin8                              : 
**              Frontplane  pin                            : PTB9/SPI1_PCS1/UART3_CTS_b/LCD_P9
**              Frontplane pin signal                      : 
**            Frontplane pin9                              : 
**              Frontplane  pin                            : PTB10/SPI1_PCS0/UART3_RX/FTM0_FLT1/LCD_P10/ADC1_SE14
**              Frontplane pin signal                      : 
**            Frontplane pin10                             : 
**              Frontplane  pin                            : PTB11/SPI1_SCK/UART3_TX/FTM0_FLT2/LCD_P11/ADC1_SE15
**              Frontplane pin signal                      : 
**            Frontplane pin11                             : 
**              Frontplane  pin                            : PTB16/SPI1_SOUT/UART0_RX/EWM_IN/LCD_P12/TSI0_CH9
**              Frontplane pin signal                      : 
**            Frontplane pin12                             : 
**              Frontplane  pin                            : PTB17/SPI1_SIN/UART0_TX/EWM_OUT_b/LCD_P13/TSI0_CH10
**              Frontplane pin signal                      : 
**            Frontplane pin13                             : 
**              Frontplane  pin                            : PTB18/CAN0_TX/FTM2_CH0/I2S0_TX_BCLK/FTM2_QD_PHA/LCD_P14/TSI0_CH11
**              Frontplane pin signal                      : 
**            Frontplane pin14                             : 
**              Frontplane  pin                            : PTB19/CAN0_RX/FTM2_CH1/I2S0_TX_FS/FTM2_QD_PHB/LCD_P15/TSI0_CH12
**              Frontplane pin signal                      : 
**            Frontplane pin15                             : 
**              Frontplane  pin                            : PTB20/SPI2_PCS0/CMP0_OUT/LCD_P16
**              Frontplane pin signal                      : 
**            Frontplane pin16                             : 
**              Frontplane  pin                            : PTB21/SPI2_SCK/CMP1_OUT/LCD_P17
**              Frontplane pin signal                      : 
**            Frontplane pin17                             : 
**              Frontplane  pin                            : PTB22/SPI2_SOUT/CMP2_OUT/LCD_P18
**              Frontplane pin signal                      : 
**            Frontplane pin18                             : 
**              Frontplane  pin                            : PTB23/SPI2_SIN/SPI0_PCS5/LCD_P19
**              Frontplane pin signal                      : 
**            Frontplane pin19                             : 
**              Frontplane  pin                            : PTC0/SPI0_PCS4/PDB0_EXTRG/I2S0_TXD/LCD_P20/ADC0_SE14/TSI0_CH13
**              Frontplane pin signal                      : 
**            Frontplane pin20                             : 
**              Frontplane  pin                            : PTC1/SPI0_PCS3/UART1_RTS_b/FTM0_CH0/LCD_P21/ADC0_SE15/TSI0_CH14
**              Frontplane pin signal                      : 
**            Frontplane pin21                             : 
**              Frontplane  pin                            : PTC2/SPI0_PCS2/UART1_CTS_b/FTM0_CH1/LCD_P22/ADC0_SE4b/CMP1_IN0/TSI0_CH15
**              Frontplane pin signal                      : 
**            Frontplane pin22                             : 
**              Frontplane  pin                            : PTC3/SPI0_PCS1/UART1_RX/FTM0_CH2/LCD_P23/CMP1_IN1
**              Frontplane pin signal                      : 
**            Frontplane pin23                             : 
**              Frontplane  pin                            : PTC4/SPI0_PCS0/UART1_TX/FTM0_CH3/CMP1_OUT/LCD_P24
**              Frontplane pin signal                      : 
**            Frontplane pin24                             : 
**              Frontplane  pin                            : PTC5/SPI0_SCK/LPT0_ALT2/CMP0_OUT/LCD_P25
**              Frontplane pin signal                      : 
**            Frontplane pin25                             : 
**              Frontplane  pin                            : PTC6/SPI0_SOUT/PDB0_EXTRG/LCD_P26/CMP0_IN0
**              Frontplane pin signal                      : 
**            Frontplane pin26                             : 
**              Frontplane  pin                            : PTC7/SPI0_SIN/LCD_P27/CMP0_IN1
**              Frontplane pin signal                      : 
**            Frontplane pin27                             : 
**              Frontplane  pin                            : PTC8/I2S0_MCLK/I2S0_CLKIN/LCD_P28/ADC1_SE4b/CMP0_IN2
**              Frontplane pin signal                      : 
**            Frontplane pin28                             : 
**              Frontplane  pin                            : PTC9/I2S0_RX_BCLK/FTM2_FLT0/LCD_P29/ADC1_SE5b/CMP0_IN3
**              Frontplane pin signal                      : 
**            Frontplane pin29                             : 
**              Frontplane  pin                            : PTC10/I2C1_SCL/I2S0_RX_FS/LCD_P30/ADC1_SE6b/CMP0_IN4
**              Frontplane pin signal                      : 
**            Frontplane pin30                             : 
**              Frontplane  pin                            : PTC11/I2C1_SDA/I2S0_RXD/LCD_P31/ADC1_SE7b
**              Frontplane pin signal                      : 
**            Frontplane pin31                             : 
**              Frontplane  pin                            : PTC12/UART4_RTS_b/LCD_P32
**              Frontplane pin signal                      : 
**            Frontplane pin32                             : 
**              Frontplane  pin                            : PTC13/UART4_CTS_b/LCD_P33
**              Frontplane pin signal                      : 
**            Frontplane pin33                             : 
**              Frontplane  pin                            : PTC14/UART4_RX/LCD_P34
**              Frontplane pin signal                      : 
**            Frontplane pin34                             : 
**              Frontplane  pin                            : PTC15/UART4_TX/LCD_P35
**              Frontplane pin signal                      : 
**            Frontplane pin35                             : 
**              Frontplane  pin                            : PTC16/CAN1_RX/UART3_RX/LCD_P36
**              Frontplane pin signal                      : 
**            Frontplane pin36                             : 
**              Frontplane  pin                            : PTC17/CAN1_TX/UART3_TX/LCD_P37
**              Frontplane pin signal                      : 
**            Frontplane pin37                             : 
**              Frontplane  pin                            : PTC18/UART3_RTS_b/LCD_P38
**              Frontplane pin signal                      : 
**            Frontplane pin38                             : 
**              Frontplane  pin                            : PTC19/UART3_CTS_b/LCD_P39
**              Frontplane pin signal                      : 
**          Initialization                                 : 
**            Enable in init. code                         : yes
**            Auto initialization                          : no
**            Event mask                                   : 
**              OnFrameFrequency                           : Disabled
**              OnFaultDetectComplete                      : Disabled
**          CPU clock/configuration selection              : 
**            Clock configuration 0                        : This component enabled
**            Clock configuration 1                        : This component disabled
**            Clock configuration 2                        : This component disabled
**     Contents    :
**         Init              - LDD_TDeviceData* SegLCD1_Init(LDD_TUserData *UserDataPtr);
**         Deinit            - void SegLCD1_Deinit(LDD_TDeviceData *DeviceDataPtr);
**         Enable            - LDD_TError SegLCD1_Enable(LDD_TDeviceData *DeviceDataPtr);
**         Disable           - LDD_TError SegLCD1_Disable(LDD_TDeviceData *DeviceDataPtr);
**         GetEventStatus    - LDD_TError SegLCD1_GetEventStatus(LDD_TDeviceData *DeviceDataPtr,...
**         SetFrontplaneData - LDD_TError SegLCD1_SetFrontplaneData(LDD_TDeviceData *DeviceDataPtr,...
**         GetFrontplaneData - LDD_TError SegLCD1_GetFrontplaneData(LDD_TDeviceData *DeviceDataPtr,...
**         SetBlinking       - LDD_TError SegLCD1_SetBlinking(LDD_TDeviceData *DeviceDataPtr,...
**         SetBlank          - LDD_TError SegLCD1_SetBlank(LDD_TDeviceData *DeviceDataPtr,...
**
**     Copyright : 1997 - 2011 Freescale Semiconductor, Inc. All Rights Reserved.
**     
**     http      : www.freescale.com
**     mail      : support@freescale.com
** ###################################################################*/

/* MODULE SegLCD1. */
/*lint -save  Disable MISRA rule () checking. */

#include "SegLCD1.h"
#include "LCD_PDD.h"
/* {Default RTOS Adapter} No RTOS includes */
#include "IO_Map.h"

typedef struct {
  bool EnUser;                         /* Enable/Disable device */
  LDD_TUserData *UserData;             /* RTOS device data structure */
} SegLCD1_TDeviceData;

typedef SegLCD1_TDeviceData *SegLCD1_TDeviceDataPtr; /* Pointer to the device data structure. */


/* {Default RTOS Adapter} Static object used for simulation of dynamic driver memory allocation */
static SegLCD1_TDeviceData DeviceDataPrv__DEFAULT_RTOS_ALLOC;

#define  BACKPLANE_NUMBER        0x08U
#define  FRONTPLANE_NUMBER       0x27U

static const uint8_t FrontplaneLCDxxPin[FRONTPLANE_NUMBER] = {0x01U, 0x02U, 0x03U, 0x04U, 0x05U, 0x06U, 0x07U, 0x08U, 0x09U, 0x0AU, 0x0BU, 0x0CU, 0x0DU, 0x0EU, 0x0FU, 0x10U, 0x11U, 0x12U, 0x13U, 0x14U, 0x15U, 0x16U, 0x17U, 0x18U, 0x19U, 0x1AU, 0x1BU, 0x1CU, 0x1DU, 0x1EU, 0x1FU, 0x20U, 0x21U, 0x22U, 0x23U, 0x24U, 0x25U, 0x26U, 0x27U}; /* List of used LCDxx frontplane pin */

/* Internal method prototypes */
static void HWEnDi(LDD_TDeviceData *DeviceDataPtr);


/*
** ===================================================================
**     Method      :  SegLCD1_Init (component SegLCD_LDD)
**
**     Description :
**         Initializes the device. Allocates memory for the device data
**         structure, allocates interrupt vectors and sets interrupt
**         priority, sets pin routing, sets timing, etc.
**         If the "Enable in init. code" is set to "yes" value then the
**         device is also enabled(see the description of the Enable()
**         method). In this case the Enable() method is not necessary
**         and needn't to be generated. 
**         This method can be called only once. Before the second call
**         of Init() the Deinit() must be called first.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * UserDataPtr     - Pointer to the user or
**                           RTOS specific data. This pointer will be
**                           passed as an event or callback parameter.
**     Returns     :
**         ---             - Pointer to the device data structure.
** ===================================================================
*/
LDD_TDeviceData* SegLCD1_Init(LDD_TUserData *UserDataPtr)
{
  /* Allocate HAL device structure */
  SegLCD1_TDeviceData *DeviceDataPrv;
  /* {Default RTOS Adapter} Driver memory allocation: Dynamic allocation is simulated by a pointer to the static object */
  DeviceDataPrv = &DeviceDataPrv__DEFAULT_RTOS_ALLOC;

  DeviceDataPrv->UserData = UserDataPtr; /* Store the RTOS device structure */
  DeviceDataPrv->EnUser = TRUE;        /* Enable device */
  /* SIM_SCGC3: SLCD=1 */
  SIM_SCGC3 |= (uint32_t)0x40000000UL;                       
  /* LCD_GCR: LCDEN=0 */
  LCD_GCR &= (uint32_t)~0x80UL;        /* Disable LCD device */
  /* PORTD_PCR0: ISF=0,MUX=0 */
  PORTD_PCR0 &= (uint32_t)~0x01000700UL;                      
  /* PORTD_PCR1: ISF=0,MUX=0 */
  PORTD_PCR1 &= (uint32_t)~0x01000700UL;                      
  /* PORTD_PCR2: ISF=0,MUX=0 */
  PORTD_PCR2 &= (uint32_t)~0x01000700UL;                      
  /* PORTD_PCR3: ISF=0,MUX=0 */
  PORTD_PCR3 &= (uint32_t)~0x01000700UL;                      
  /* PORTD_PCR4: ISF=0,MUX=0 */
  PORTD_PCR4 &= (uint32_t)~0x01000700UL;                      
  /* PORTD_PCR5: ISF=0,MUX=0 */
  PORTD_PCR5 &= (uint32_t)~0x01000700UL;                      
  /* PORTD_PCR6: ISF=0,MUX=0 */
  PORTD_PCR6 &= (uint32_t)~0x01000700UL;                      
  /* PORTD_PCR7: ISF=0,MUX=0 */
  PORTD_PCR7 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR1: ISF=0,MUX=0 */
  PORTB_PCR1 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR2: ISF=0,MUX=0 */
  PORTB_PCR2 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR3: ISF=0,MUX=0 */
  PORTB_PCR3 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR4: ISF=0,MUX=0 */
  PORTB_PCR4 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR5: ISF=0,MUX=0 */
  PORTB_PCR5 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR6: ISF=0,MUX=0 */
  PORTB_PCR6 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR7: ISF=0,MUX=0 */
  PORTB_PCR7 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR8: ISF=0,MUX=0 */
  PORTB_PCR8 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR9: ISF=0,MUX=0 */
  PORTB_PCR9 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR10: ISF=0,MUX=0 */
  PORTB_PCR10 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR11: ISF=0,MUX=0 */
  PORTB_PCR11 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR16: ISF=0,MUX=0 */
  PORTB_PCR16 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR17: ISF=0,MUX=0 */
  PORTB_PCR17 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR18: ISF=0,MUX=0 */
  PORTB_PCR18 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR19: ISF=0,MUX=0 */
  PORTB_PCR19 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR20: ISF=0,MUX=0 */
  PORTB_PCR20 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR21: ISF=0,MUX=0 */
  PORTB_PCR21 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR22: ISF=0,MUX=0 */
  PORTB_PCR22 &= (uint32_t)~0x01000700UL;                      
  /* PORTB_PCR23: ISF=0,MUX=0 */
  PORTB_PCR23 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR0: ISF=0,MUX=0 */
  PORTC_PCR0 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR1: ISF=0,MUX=0 */
  PORTC_PCR1 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR2: ISF=0,MUX=0 */
  PORTC_PCR2 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR3: ISF=0,MUX=0 */
  PORTC_PCR3 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR4: ISF=0,MUX=0 */
  PORTC_PCR4 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR5: ISF=0,MUX=0 */
  PORTC_PCR5 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR6: ISF=0,MUX=0 */
  PORTC_PCR6 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR7: ISF=0,MUX=0 */
  PORTC_PCR7 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR8: ISF=0,MUX=0 */
  PORTC_PCR8 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR9: ISF=0,MUX=0 */
  PORTC_PCR9 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR10: ISF=0,MUX=0 */
  PORTC_PCR10 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR11: ISF=0,MUX=0 */
  PORTC_PCR11 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR12: ISF=0,MUX=0 */
  PORTC_PCR12 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR13: ISF=0,MUX=0 */
  PORTC_PCR13 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR14: ISF=0,MUX=0 */
  PORTC_PCR14 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR15: ISF=0,MUX=0 */
  PORTC_PCR15 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR16: ISF=0,MUX=0 */
  PORTC_PCR16 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR17: ISF=0,MUX=0 */
  PORTC_PCR17 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR18: ISF=0,MUX=0 */
  PORTC_PCR18 &= (uint32_t)~0x01000700UL;                      
  /* PORTC_PCR19: ISF=0,MUX=0 */
  PORTC_PCR19 &= (uint32_t)~0x01000700UL;                      
  /* LCD_GCR: RVEN=0,??=0,??=0,??=0,RVTRIM=0,CPSEL=1,HREFSEL=0,LADJ=0,??=0,??=0,VSUPPLY=1,LCDIEN=0,FDCIEN=0,ALTDIV=0,??=0,??=0,LCDWAIT=0,LCDSTP=0,LCDEN=0,SOURCE=1,LCLK=1,DUTY=7 */
  LCD_GCR = (uint32_t)0x0081004FUL;    /* Set general control register */
  /* LCD_AR: ??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,??=0,LCDIF=1,??=0,??=0,??=0,??=0,??=0,??=0,??=0,BLINK=0,ALT=0,BLANK=0,??=0,BMODE=0,BRATE=3 */
  LCD_AR = (uint32_t)0x8003UL;         /* Set auxillary register */
  /* LCD_PENL: PEN=0xFFFFFFFE */
  LCD_PENL = (uint32_t)0xFFFFFFFEUL;   /* Set pin enable register low */
  /* LCD_PENH: PEN=0xFFFF */
  LCD_PENH = (uint32_t)0xFFFFUL;       /* Set pin enable register high */
  /* LCD_BPENL: BPEN=0 */
  LCD_BPENL = (uint32_t)0x00UL;        /* Set backplane enable register low */
  /* LCD_BPENH: BPEN=0xFF00 */
  LCD_BPENH = (uint32_t)0xFF00UL;      /* Set backplane enable register high */
  /* LCD_WF3TO0: WF3=0,WF2=0,WF1=0,WF0=0 */
  LCD_WF3TO0 = (uint32_t)0x00UL;       /* Clear waveform register */
  /* LCD_WF7TO4: WF7=0,WF6=0,WF5=0,WF4=0 */
  LCD_WF7TO4 = (uint32_t)0x00UL;       /* Clear waveform register */
  /* LCD_WF11TO8: WF11=0,WF10=0,WF9=0,WF8=0 */
  LCD_WF11TO8 = (uint32_t)0x00UL;      /* Clear waveform register */
  /* LCD_WF15TO12: WF15=0,WF14=0,WF13=0,WF12=0 */
  LCD_WF15TO12 = (uint32_t)0x00UL;     /* Clear waveform register */
  /* LCD_WF19TO16: WF19=0,WF18=0,WF17=0,WF16=0 */
  LCD_WF19TO16 = (uint32_t)0x00UL;     /* Clear waveform register */
  /* LCD_WF23TO20: WF23=0,WF22=0,WF21=0,WF20=0 */
  LCD_WF23TO20 = (uint32_t)0x00UL;     /* Clear waveform register */
  /* LCD_WF27TO24: WF27=0,WF26=0,WF25=0,WF24=0 */
  LCD_WF27TO24 = (uint32_t)0x00UL;     /* Clear waveform register */
  /* LCD_WF31TO28: WF31=0,WF30=0,WF29=0,WF28=0 */
  LCD_WF31TO28 = (uint32_t)0x00UL;     /* Clear waveform register */
  /* LCD_WF35TO32: WF35=0,WF34=0,WF33=0,WF32=0 */
  LCD_WF35TO32 = (uint32_t)0x00UL;     /* Clear waveform register */
  /* LCD_WF39TO36: WF39=0,WF38=0,WF37=0,WF36=0 */
  LCD_WF39TO36 = (uint32_t)0x00UL;     /* Clear waveform register */
  /* LCD_WF43TO40: WF43=8,WF42=4,WF41=2,WF40=1 */
  LCD_WF43TO40 = (uint32_t)0x08040201UL; /* Configure which phase the backplane pins are active in. */
  /* LCD_WF47TO44: WF47=0x80,WF46=0x40,WF45=0x20,WF44=0x10 */
  LCD_WF47TO44 = (uint32_t)0x80402010UL; /* Configure which phase the backplane pins are active in. */
  /* LCD_WF51TO48: WF51=0,WF50=0,WF49=0,WF48=0 */
  LCD_WF51TO48 = (uint32_t)0x00UL;     /* Clear waveform register */
  /* LCD_WF55TO52: WF55=0,WF54=0,WF53=0,WF52=0 */
  LCD_WF55TO52 = (uint32_t)0x00UL;     /* Clear waveform register */
  /* LCD_WF59TO56: WF59=0,WF58=0,WF57=0,WF56=0 */
  LCD_WF59TO56 = (uint32_t)0x00UL;     /* Clear waveform register */
  /* LCD_WF63TO60: WF63=0,WF62=0,WF61=0,WF60=0 */
  LCD_WF63TO60 = (uint32_t)0x00UL;     /* Clear waveform register */
  HWEnDi(DeviceDataPrv);               /* Enable/disable device according to status flags */
  /* Registration of the device structure */
  PE_LDD_RegisterDeviceStructure(PE_LDD_COMPONENT_SegLCD1_ID,DeviceDataPrv);
  return ((LDD_TDeviceData *)DeviceDataPrv); /* Return pointer to the data data structure */
}

/*
** ===================================================================
**     Method      :  SegLCD1_Deinit (component SegLCD_LDD)
**
**     Description :
**         Deinitializes the device. Switches off the device, frees the
**         device data structure memory, interrupts vectors, etc.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer.
**     Returns     : Nothing
** ===================================================================
*/
void SegLCD1_Deinit(LDD_TDeviceData *DeviceDataPtr)
{
  SegLCD1_TDeviceData *DeviceDataPrv = (SegLCD1_TDeviceData *)DeviceDataPtr;

  (void)DeviceDataPrv;                 /* Parameter is not used, suppress unused argument warning */
  /* LCD_GCR: RVEN=0,??=0,??=0,??=0,RVTRIM=8,CPSEL=0,HREFSEL=0,LADJ=3,??=0,??=1,VSUPPLY=1,LCDIEN=0,FDCIEN=0,ALTDIV=0,??=0,??=0,LCDWAIT=0,LCDSTP=0,LCDEN=0,SOURCE=0,LCLK=0,DUTY=3 */
  LCD_GCR = (uint32_t)0x08350003UL;    /* Reset LCD general control register */
  /* Restoring the interrupt vector */
  /* Unregistration of the device structure */
  PE_LDD_UnregisterDeviceStructure(PE_LDD_COMPONENT_SegLCD1_ID);
  /* Deallocation of the device structure */
  /* {Default RTOS Adapter} Driver memory deallocation: Dynamic allocation is simulated, no deallocation code is generated */
  /* SIM_SCGC3: SLCD=0 */
  SIM_SCGC3 &= (uint32_t)~0x40000000UL;                      
}

/*
** ===================================================================
**     Method      :  SegLCD1_Enable (component SegLCD_LDD)
**
**     Description :
**         Enables the device - it starts the segment LCD module.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active clock configuration
** ===================================================================
*/
LDD_TError SegLCD1_Enable(LDD_TDeviceData *DeviceDataPtr)
{
  SegLCD1_TDeviceData *DeviceDataPrv = (SegLCD1_TDeviceData *)DeviceDataPtr;

  if(!DeviceDataPrv->EnUser) {         /* Is the device disabled by user? */
    DeviceDataPrv->EnUser = TRUE;      /* If yes then set the flag "device enabled" */
    HWEnDi(DeviceDataPrv);             /* Enable the device */
  }
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  SegLCD1_Disable (component SegLCD_LDD)
**
**     Description :
**         Disables the device - it stops the segment LCD module.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_SPEED - This device does not work in
**                           the active clock configuration
** ===================================================================
*/
LDD_TError SegLCD1_Disable(LDD_TDeviceData *DeviceDataPtr)
{
  SegLCD1_TDeviceData *DeviceDataPrv = (SegLCD1_TDeviceData *)DeviceDataPtr;

  if(DeviceDataPrv->EnUser) {          /* Is the device enabled by user? */
    DeviceDataPrv->EnUser = FALSE;     /* If yes then set the flag "device disabled" */
    HWEnDi(DeviceDataPrv);             /* Disable the device */
  }
  return ERR_OK;                       /* OK */
}

/*
** ===================================================================
**     Method      :  SegLCD1_GetEventStatus (component SegLCD_LDD)
**
**     Description :
**         Gets current pending flags and clears them. This method is
**         available if the interrupt service property is disabled.
**         This method must be called in polling mode, when is called
**         method StartFaultDetectFrame.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer.
**       * EventMaskPtr    - Pointer to address of
**                           the EventMask definition variable.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_DISABLED - This component is disabled
**                           by user.
**                           ERR_SPEED - This device does not work in
**                           the active clock configuration
** ===================================================================
*/
LDD_TError SegLCD1_GetEventStatus(LDD_TDeviceData *DeviceDataPtr, LDD_TEventMask *EventMaskPtr)
{
  SegLCD1_TDeviceData *DeviceDataPrv = (SegLCD1_TDeviceData *)DeviceDataPtr;
  LDD_TEventMask EventMaskTemp = 0x00U;

  /* Device state test - this test can be disabled by setting the "Ignore enable test"
     property to the "yes" value in the "Configuration inspector" */
  if(!DeviceDataPrv->EnUser) {         /* Is the device disabled by user? */
    return ERR_DISABLED;               /* If yes then error */
  }
  if(LCD_PDD_GetFrameFreqInterruptFlag(LCD_BASE_PTR)){ /* Is set interrupt flag?? */
    LCD_PDD_ClearFrameFreqInterruptFlag(LCD_BASE_PTR);
    EventMaskTemp |= LDD_SEGLCD_ON_FRAME_FREQUENCY;
  }
  *EventMaskPtr = (LDD_TEventMask)EventMaskTemp;
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  SegLCD1_SetFrontplaneData (component SegLCD_LDD)
**
**     Description :
**         Set data to the LCD frontplane data registers. It
**         sets/clears all used segments.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer.
**         Index           - Index of frontplane waveform. Value
**                           corresponds with the index frontplane pins,
**                           what is connected to LCD segment.
**         Data            - Value of the frontplane segment. Each
**                           value is the array boolean, word - that
**                           defines state of an LCD segment (On - 1/Off
**                           - 0). Bit position of the word (number of
**                           backplane..0), when is segment on/off,
**                           corresponds with the value of backplane
**                           pins index.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_DISABLED - This component is disabled
**                           by user.
**                           ERR_SPEED - This device does not work in
**                           the active clock configuration
**                           ERR_PARAM_INDEX - Value of index is out of
**                           range.
**                           ERR_PARAM_DATA - Value of frontplane is out
**                           of range.
** ===================================================================
*/
LDD_TError SegLCD1_SetFrontplaneData(LDD_TDeviceData *DeviceDataPtr, LDD_SegLCD_TPinIndex Index, LDD_SegLCD_TFrontplaneData Data)
{
  SegLCD1_TDeviceData *DeviceDataPrv = (SegLCD1_TDeviceData *)DeviceDataPtr;

  /* Device state test - this test can be disabled by setting the "Ignore enable test"
     property to the "yes" value in the "Configuration inspector" */
  if(!DeviceDataPrv->EnUser) {         /* Is the device disabled by user? */
    return ERR_DISABLED;               /* If yes then error */
  }
  /* FrontPlane index value test - this test can be disabled by setting the "Ignore range checking"
     property to the "yes" value in the "Configuration inspector" */
  if(Index >= FRONTPLANE_NUMBER) {     /* Is the parameter Index within an expected range? */
    return ERR_PARAM_INDEX;            /* If no then error. */
  }
  LCD_PDD_SetWaveform(LCD_BASE_PTR,FrontplaneLCDxxPin[Index],Data);
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  SegLCD1_GetFrontplaneData (component SegLCD_LDD)
**
**     Description :
**         Get data from the LCD frontplane data registers.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer.
**         Index           - Index of frontplane waveform. Value
**                           corresponds with the index frontplane pins,
**                           what is connected to LCD segment.
**       * DataPtr         - Pointer to a variable where value
**                           of the frontplane will be stored. Each
**                           value is the array boolean word that
**                           defines state of an LCD segment (On - 1/Off
**                           - 0). Bit position of the word (number of
**                           backplane..0), when is segment on/off,
**                           corresponds with value of backplane pins
**                           index.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_DISABLED - This component is disabled
**                           by user.
**                           ERR_SPEED - This device does not work in
**                           the active clock configuration
**                           ERR_PARAM_INDEX - Value of index is out of
**                           range.
** ===================================================================
*/
LDD_TError SegLCD1_GetFrontplaneData(LDD_TDeviceData *DeviceDataPtr, LDD_SegLCD_TPinIndex Index, LDD_SegLCD_TFrontplaneData *DataPtr)
{
  SegLCD1_TDeviceData *DeviceDataPrv = (SegLCD1_TDeviceData *)DeviceDataPtr;

  /* Device state test - this test can be disabled by setting the "Ignore enable test"
     property to the "yes" value in the "Configuration inspector" */
  if(!DeviceDataPrv->EnUser) {         /* Is the device disabled by user? */
    return ERR_DISABLED;               /* If yes then error */
  }
  /* FrontPlane index value test - this test can be disabled by setting the "Ignore range checking"
     property to the "yes" value in the "Configuration inspector" */
  if(Index >= FRONTPLANE_NUMBER) {     /* Testing value of input parameters */
    return ERR_PARAM_INDEX;
  }
  *DataPtr = (LDD_SegLCD_TFrontplaneData)(0xFFu & LCD_PDD_GetWaveform(LCD_BASE_PTR,FrontplaneLCDxxPin[Index]));
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  SegLCD1_SetBlinking (component SegLCD_LDD)
**
**     Description :
**         Activates/deactivates blinking of all segments (according to
**         parameter BlinkMode).
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer.
**         BlinkMode       - Parameter for setting blink
**                           mode of segments.
**                           LDD_SEGLCD_BLINK_OFF: Disable blinking.
**                           LDD_SEGLCD_BLINK_ALL: Enable blinking of
**                           all segments (blank display during blink
**                           period)
**                           LDD_SEGLCD_BLINK_ALL_ALTERNATE: Enable
**                           blinking of all segments in alternate mode
**                           (alternate display during blink period) -
**                           available only if supported by the HW.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_DISABLED - This component is disabled
**                           by user.
**                           ERR_SPEED - This device does not work in
**                           the active clock configuration
**                           ERR_PARAM_MODE - Value of BlinkMode
**                           parameter is out of range.
** ===================================================================
*/
LDD_TError SegLCD1_SetBlinking(LDD_TDeviceData *DeviceDataPtr, LDD_SegLCD_TBlinking BlinkMode)
{
  SegLCD1_TDeviceData *DeviceDataPrv = (SegLCD1_TDeviceData *)DeviceDataPtr;

  /* Device state test - this test can be disabled by setting the "Ignore enable test"
     property to the "yes" value in the "Configuration inspector" */
  if(!DeviceDataPrv->EnUser) {         /* Is the device disabled by user? */
    return ERR_DISABLED;               /* If yes then error */
  }
  switch(BlinkMode) {
    case LDD_SEGLCD_BLINK_OFF:
        LCD_PDD_EnableBlinking(LCD_BASE_PTR,PDD_DISABLE); /* Disable blinking display mode. */
      break;
    case LDD_SEGLCD_BLINK_ALL:
        LCD_PDD_SetBlinkMode(LCD_BASE_PTR,LCD_PDD_BLANK_BLINK); /* Set blank blinking display mode. */
        LCD_PDD_EnableBlinking(LCD_BASE_PTR,PDD_ENABLE); /* Enable blinking display mode. */
      break;
    default:
      return ERR_PARAM_MODE;           /* If other value of BlinkMode, then return error */
  }
  return ERR_OK;                       /* ERR_OK */
}

/*
** ===================================================================
**     Method      :  SegLCD1_SetBlank (component SegLCD_LDD)
**
**     Description :
**         This method sets the blank display without affecting state
**         of each segment. If supported by the LCD module, the method
**         allows alternate display setting. A segment state is set by
**         method SetFrontplaneData or SetAlternateFrontplaneData.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * DeviceDataPtr   - Device data structure
**                           pointer.
**         BlankMode       - Parameter for setting segment
**                           mode of display.
**                           LDD_SEGLCD_BLANK_STATE: It sets the blank
**                           display, all LCD segments are off, but
**                           internal state of the segments is not
**                           affected. It is possible to modify internal
**                           segment state using appropriate methods of
**                           the component.
**                           LDD_SEGLCD_NORMAL_STATE: A segment state
**                           (active/deactive/blinking) is displayed.
**                           LDD_SEGLCD_ALTERNATE_STATE: Sets the
**                           display to alternate mode - available only
**                           if supported by the HW.
**     Returns     :
**         ---             - Error code, possible codes:
**                           ERR_OK - OK
**                           ERR_DISABLED - This component is disabled
**                           by user.
**                           ERR_SPEED - This device does not work in
**                           the active clock configuration
**                           ERR_PARAM_MODE - Value of BlankMode
**                           parameter is out of range.
** ===================================================================
*/
LDD_TError SegLCD1_SetBlank(LDD_TDeviceData *DeviceDataPtr, LDD_SegLCD_TSetBlank BlankMode)
{
  SegLCD1_TDeviceData *DeviceDataPrv = (SegLCD1_TDeviceData *)DeviceDataPtr;

  /* Device state test - this test can be disabled by setting the "Ignore enable test"
     property to the "yes" value in the "Configuration inspector" */
  if(!DeviceDataPrv->EnUser) {         /* Is the device disabled by user? */
    return ERR_DISABLED;               /* If yes then error */
  }
  switch(BlankMode) {
    case LDD_SEGLCD_BLANK_STATE:
        LCD_PDD_EnableBlankDisplayMode(LCD_BASE_PTR,PDD_ENABLE); /* Enable blank display mode. */
      break;
    case LDD_SEGLCD_NORMAL_STATE:
        LCD_PDD_EnableBlankDisplayMode(LCD_BASE_PTR,PDD_DISABLE); /* Disable blank display mode. */
        LCD_PDD_EnableAlternateMode(LCD_BASE_PTR,PDD_DISABLE); /* Disable alternate display mode. */
      break;
    default:
      return ERR_PARAM_MODE;           /* If is other value of parameter "BlankMode" then error */
  }
  return ERR_OK;
}

/*
** ===================================================================
**     Method      :  HWEnDi (component SegLCD_LDD)
**
**     Description :
**         Enables or disables the peripheral(s) associated with the 
**         component. The method is called automatically as a part of the 
**         Enable and Disable methods and several internal methods.
**         This method is internal. It is used by Processor Expert only.
** ===================================================================
*/
static void HWEnDi(LDD_TDeviceData *DeviceDataPtr)
{
  SegLCD1_TDeviceData *DeviceDataPrv = (SegLCD1_TDeviceData *)DeviceDataPtr;

  if(DeviceDataPrv->EnUser) {          /* Enable device? */
    LCD_PDD_EnableDevice(LCD_BASE_PTR,PDD_ENABLE); /* Enable device */
  } else {
    LCD_PDD_EnableDevice(LCD_BASE_PTR,PDD_DISABLE); /* Disable device */
  }
}

/*lint -restore Enable MISRA rule () checking. */
/* END SegLCD1. */

/*
** ###################################################################
**
**     This file was created by Processor Expert 5.3 [05.01]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
