

#include <mqx.h>
#include <bsp.h> 
#include <fio.h>
#include <string.h>

#if ! BSPCFG_ENABLE_IO_SUBSYSTEM
#error This application requires BSPCFG_ENABLE_IO_SUBSYSTEM defined non-zero in user_config.h. Please recompile BSP with this option.
#endif


#ifndef BSP_DEFAULT_IO_CHANNEL_DEFINED
#error This application requires BSP_DEFAULT_IO_CHANNEL to be not NULL. Please set corresponding BSPCFG_ENABLE_TTYx to non-zero in user_config.h and recompile BSP with this option.
#endif


/* Task IDs */
#define TASK_I2C_SLAVE_RX 1000
#define TASK_I2C_SLAVE_TX 1001
#define IIC_ERR -1

void task_slave_rx(uint_32 initial_data);
void task_slave_tx(uint_32 initial_data);
const TASK_TEMPLATE_STRUCT  MQX_template_list[] =  
{ 
    /* Task Index,       Function,       Stack,  Priority,  Name,              Attributes,           Param, Time Slice */
    { TASK_I2C_SLAVE_RX, task_slave_rx,  4000,   10,        "i2c_slave_rx",    MQX_AUTO_START_TASK,  0,     0 },
    { TASK_I2C_SLAVE_TX, task_slave_tx,  4000,   10,        "i2c_slave_tx",    0,                    0,     0 },
    { 0 }
};



MQX_FILE_PTR file_iic0 = NULL;

//-------------------------------------------
// i2c slave demo
//-------------------------------------------
#define I2C0_SLAVE_ADDRESS 0x50
char buf_i2c_rx[256];
char buf_i2c_tx[256];

void task_slave_rx(uint_32 initial_data)
{
    uint_32 param;
    uint_32 len;
    int i;

    printf("I2C slave demo for FB. *******************\n");
    file_iic0 = fopen("ii2c0fb:", NULL);
    param = I2C0_SLAVE_ADDRESS;
    ioctl(file_iic0, IO_IOCTL_I2C_SET_SLAVE_MODE, &param);

    _task_create(0, TASK_I2C_SLAVE_TX, 0);

    while(1)
    {
        memset(buf_i2c_rx, 0, 256);
        len = fread(buf_i2c_rx, 1, 256, file_iic0);
//*
        if(len > 0)
        {
            printf("get i2c data, len: %d\n", len);
            for(i=0;i<len;i++)
                printf("%x\n", buf_i2c_rx[i]);
        }
        else
            printf("read failed.\n");
// */
    }
}

void task_slave_tx(uint_32 initial_data)
{
    int i;
    int len;
    for(i=0;i<256;i++)
        buf_i2c_tx[i] = i;

    while(1)
    {
        len = fwrite(buf_i2c_tx, 1, 4, file_iic0);
        if(len < 4)
            printf("send fail. len = %d \n", len);
        else
            printf("send OK. len = %d \n", len);
    }
}















