

#include <mqx.h>
#include <bsp.h> 
#include <fio.h>
#include <string.h>


#if ! BSPCFG_ENABLE_IO_SUBSYSTEM
#error This application requires BSPCFG_ENABLE_IO_SUBSYSTEM defined non-zero in user_config.h. Please recompile BSP with this option.
#endif


#ifndef BSP_DEFAULT_IO_CHANNEL_DEFINED
#error This application requires BSP_DEFAULT_IO_CHANNEL to be not NULL. Please set corresponding BSPCFG_ENABLE_TTYx to non-zero in user_config.h and recompile BSP with this option.
#endif


/* Task IDs */
#define HELLO_TASK 5
#define IIC_ERR -1

extern void hello_task(uint_32);

const TASK_TEMPLATE_STRUCT  MQX_template_list[] =  
{ 
    /* Task Index,   Function,      Stack,     Priority,  Name,              Attributes,                              Param, Time Slice */
    { HELLO_TASK,     hello_task,      4000,   10,         "hello",           MQX_AUTO_START_TASK,  0,     50 },
    { 0 }
};



MQX_FILE_PTR file_iic0 = NULL;


//-------------------------------------------
// i2c master demo
//-------------------------------------------
struct STRU_I2C_BUFFER
{
    char dst_addr;
    char reg_addr;
    char data[100];
};

struct STRU_I2C_BUFFER i2c_buf_rx;
struct STRU_I2C_BUFFER i2c_buf_tx;
int_32 i2c_fb_test_master(void)
{
    uint_32 param;
    int i;
    int len;

    file_iic0 = fopen("ii2c0fb:", NULL);
    if (file_iic0 == NULL)
    {
        printf("\nOpen the IIC0 driver failed!!!\n");
        return IIC_ERR;
    }

    param = 100000;
    ioctl(file_iic0, IO_IOCTL_I2C_SET_BAUD, &param);

    i2c_buf_tx.dst_addr = 0x50;
    i2c_buf_tx.reg_addr = 0;
    i2c_buf_rx.dst_addr = 0x50;
    i2c_buf_rx.reg_addr = 0;

    for(i=0;i<8;i++)
        i2c_buf_tx.data[i] = 0xb0+i;

    //i = 1;
    //i = 2;
    //i = 3;
    i = 4;
        
    while(1)
    {
        printf("---------------------\n");
//*
        len = fwrite(&i2c_buf_tx, 1, i, file_iic0);
        if( len < i )
        {
            printf("send failed, %x\n", len);
        }
        else
        {
            printf("send ok, %x\n", len);
        }
        _time_delay(1000);
// */

/*
        i = 4;
        memset(i2c_buf_rx.data, 0, i);
        len = fread(&i2c_buf_rx, 1, i, file_iic0);
        printf("get i2c data, len = %x\n", len);
        for(i=0; i<len; i++)
        {
            printf("%x \n", i2c_buf_rx.data[i]);
        }
        _time_delay(100); 
// */
    }
}


void hello_task
    (
        uint_32 initial_data
    )
{
    printf("I2C master for FB***********************\n");
    i2c_fb_test_master();
}











