/*
 * File:        k60_Camera.h
 * Purpose:     Camera demo header
 *
 * Notes:
 *
 */

// I2C definitions
#define OV7675_I2C_ADDRESS                         0x21

#define i2c_Start()            I2C0_C1 |= I2C_C1_TX_MASK;\
                               I2C0_C1 |= I2C_C1_MST_MASK

#define i2c_Stop()             I2C0_C1 &= ~I2C_C1_MST_MASK;\
                               I2C0_C1 &= ~I2C_C1_TX_MASK

#define i2c_Wait()               while((I2C0_S & I2C_S_IICIF_MASK)==0) {} \
                                  I2C0_S |= I2C_S_IICIF_MASK;

#define MWSR                   0x00  /* Master write  */
#define MRSW                   0x01  /* Master read */

// FTM clock definitions
#define FTM_24MHZ_PERIOD	(0x00000001UL)
#define FTM_24MHZ_DUTY		(0x00000001UL)

// General definitions
#define QQVGA_rows 120
#define QQVGA_columns 160
#define frame_count 2
#define DMA_SOURCE_ADDRESS 0x400FF110       // DMA source taken from first 8bits of PORT E    
#define DMA_FRAME_DESTINATION 0x1FFF8000  // DMA address destination

//ISRs definitions
#define VSYNC_NO  91     // IRQ number for VSYNC GPIO Port
#define VSYNC_VEC 107    // vector number of VSYNC GPIO Port ( = #IRQ + 16 )

#undef  VECTOR_107                   // install GPIO Port E service into ROM vector table
#define VECTOR_107  vsync_isr

#define HREF_NO  89     // IRQ number for HREF GPIO Port
#define HREF_VEC 105    // vector number of HREF GPIO Port ( = #IRQ + 16 )

#undef  VECTOR_105                   // install GPIO Port C service into ROM vector table
#define VECTOR_105  href_isr

extern uint32 __VECTOR_RAM[]; //Get vector table that was copied to RAM
