/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     tim.c
*
* @author   B06050
* 
* @version  1.0.6.0
* 
* @date     May-31-2012
* 
* @brief    Timer SW module source file.
*
*******************************************************************************/
#include "tim.h"

/*******************************************************************************
*
* Function: void TIM_Init(uint16_t u16tc1, uint16_t u16tc2)
*
* Description:  This function initializes the TIM module
*               - TIM counter frequency BUSclk/25
*               - TIM channel 0 input capture
*               - TIM channel 1 output compare (interrupts enabled)
*               - TIM channel 2 output compare
* 
* Param[in]:    u16tc1      TIM1 timeout period in ticks
*               u16tc2      TIM2 timeout period in ticks
*
*******************************************************************************/
void TIM_Init(uint16_t u16tc1, uint16_t u16tc2)
{
    TIOS = 0x06;    /* Channels 1 & 2 act as output compare */
    TSCR1 = 0x68;   /* Disable timer in wait and freeze modes, precision timer
                       enabled */
    TCTL1 = 0x00;   /* No output compare action on IOC[7..4] pins */
    TCTL2 = 0x00;   /* No output compare action on IOC[3..0] pins */
    TCTL3 = 0x00;   /* Capture disabled on IOC[7..4] pins */
    TCTL4 = 0x02;   /* Capture disabled on IOC[3..1], enabled on IOC0 (falling
                       edge) */
    TIE = 0x02;     /* Channel 1 output compare interrupt enabled */
    
    TC1 = u16tc1;   /* Channel 1 output compare counter value */
    TC2 = u16tc2;   /* Channel 2 output compare counter value */
    
    OCPD = 0xFF;     /* All output compare pins disconnected */
    
    PTPSR = 0x18;   /* Timer prescale factor 25. TIM running at 1MHz
                       @BUSclk=25MHz */
    
    TFLG1 = 0xFF;   /* Clear all channels OC/IC event flags */
    
    TSCR1_TEN = 1;  /* Enable TIM */
}