/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     pim.h
*
* @author   B06050
* 
* @version  1.0.4.0
* 
* @date     Mar-28-2012
* 
* @brief    Port Integration Module SW module header file.
*
*******************************************************************************/
#ifndef _PIM_H
#define _PIM_H

/* Variable types and common definitions */
#include "derivative.h"

/*******************************************************************************
* GPIO pin I/O data register definitions
*******************************************************************************/
/* Serial Peripheral Interface SPI0  */
#define SCLK0                       /* PS6/SCK0  */
#define MOSI0                       /* PS5/MOSI0 */
#define MISO0                       /* PS4/MISO0 */

/* SBC - MC33905S pin assignment */
#define MC33905_SCLK                /* PS6/SCK0  */
#define MC33905_MOSI                /* PS5/MOSI0 */
#define MC33905_MISO                /* PS4/MISO0 */
#define MC33905_CS      PORTC_PC3   /* PC3       */
#define MC33905_INT     PORTC_PC6   /* PC6       */
#define MC33905_RST                 /* RESET     */
#define MC33905_LIN_RX              /* PS2/RXD1  */
#define MC33905_LIN_TX              /* PS3/TXD1  */
#define MC33905_CAN_RX              /* PM0/RXCAN */
#define MC33905_CAN_TX              /* PM1/TXCAN */

/* MC33937 FET pre-driver pin assignment */
#define MC33937_SCLK                /* PS6/SCK0  */
#define MC33937_MOSI                /* PS5/MOSI0 */
#define MC33937_MISO                /* PS4/MISO0 */
#define MC33937_CS      PTS_PTS7    /* PS7/SS0   */
#define MC33937_INT     PORTC_PC5   /* PC5       */
#define MC33937_RST     PORTC_PC4   /* PC4       */
#define MC33937_EN      PORTA_PA4   /* PA4 - EN_OUT enable (AND gate input) */
#define MC33937_OC

/* UNI3 connector pin assignment */
#define UNI3_BRAKE      PORTA_PA5   /* PA5         */
#define HALL0_ZCA                   /* KWP2        */
#define HALL1_ZCA                   /* KWP4        */
#define HALL2_ZCA                   /* KWP6        */
#define BEMF_A                      /* see adc.h   */
#define BEMF_B                      /* see adc.h   */
#define BEMF_C                      /* see adc.h   */
#define DCBI                        /* see adc.h   */
#define DCBV                        /* AN6         */
#define TEMP                        /* AN7         */

/* PWM pin assignment */
#define PWMA_HS                     /* PWM1 */
#define PWMA_LS_CTRL    PORTA_PA0   /* PA0  */
#define PWMB_HS                     /* PWM3 */
#define PWMB_LS_CTRL    PORTA_PA1   /* PA1  */
#define PWMC_HS                     /* PWM5 */
#define PWMC_LS_CTRL    PORTA_PA2   /* PA2  */

/* Fault logic pin assignment */
#define FAULT                       /* IRQ      */
#define FAULT0          PTJ_PTJ4    /* PJ4/KWJ4 */
#define FAULT1          PTJ_PTJ5    /* PJ5/KWJ5 */
#define FLT_RST         PORTA_PA3   /* PA3      */

/* Rotary switch pin assignment */
#define ROT_SW          PORTC_PC7   /* PC7      */
#define ROT_A           PTJ_PTJ6    /* PJ6/KWJ6 */
#define ROT_B           PTJ_PTJ7    /* PJ7/KWJ7 */

/* User LED pin assignments */
#define LED0            PORTC_PC0   /* PC0 */
#define LED1            PORTC_PC1   /* PC1 */

/* User swith assignment */
#define SWITCH          PORTC_PC2   /* PC2 */

void PIM_Init(void);

#endif /* _PIM_H */