/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file      typedefs.h
*
* @version   1.0.1.0
* 
* @date      Jul-10-2012
* 
* @brief     Common types definitions.
*
*******************************************************************************/
typedef unsigned char           uint8_t;    /* unsigned 8 bit definition */
typedef unsigned short          uint16_t;   /* unsigned 16 bit definition */
typedef unsigned long           uint32_t;   /* unsigned 32 bit definition */
typedef signed char             int8_t;     /* signed 8 bit definition */
typedef short                   int16_t;    /* signed 16 bit definition */
typedef long                    int32_t;    /* signed 32 bit definition */

typedef volatile unsigned char  vuint8_t;   /* volatile unsigned 8 bit */
typedef volatile unsigned short vuint16_t;  /* volatile unsigned 16 bit */
typedef volatile unsigned long  vuint32_t;   /* volatile unsigned 32 bit */
typedef volatile signed char    vint8_t;    /* volatile signed 8 bit */
typedef volatile short          vint16_t;   /* volatile signed 16 bit */
typedef volatile long           vint32_t;   /* volatile signed 32 bit */

/* Common Bit masks */
#define ENABLE_INTERRUPTS()  {__asm CLI;}        /* Interrupts enabled */
#define DISABLE_INTERRUPTS() {__asm SEI;}        /* Interrupts disabled */
#define XIRQ_ENABLE()        {asm ANDCC #0xBF;}  /* XIRQ enabled */
#define WAIT()               {asm WAI;}          /* Enter wait mode */
#define ENABLE_STOP()        {asm ANDCC #0x7F;}  /* Stop mode enabled */
#define DISABLE_STOP()       {asm ORCC #0x80;}   /* Stop mode disabled */
#define STOP()               {asm STOP;}         /* Enter stop mode */
#define NOP()                {asm NOP;}          /* Enter NOP asm instruction */

/* Common Constants */
#define ON 1U        
#define OFF 0U
//#define TRUE 1U
//#define FALSE 0U
#define ENABLE 1U
#define DISABLED 0U
#define PASS 0U
#define FAIL 1U
#define SET 1U
#define CLEAR 0U

