/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     pwm.c
*
* @author   B06050
* 
* @version  1.0.1.0
* 
* @date     Jul-10-2012
* 
* @brief    Pulse-Width Modulator SW module source file.
*
*******************************************************************************/
#include "pwm.h"
#include "S12G128_appconfig.h"

/*******************************************************************************
*
* Function: void PWM_Init(void)
*
* Description:  This function initializes the PWM module
*               - PWM counter frequency equal to BUSclk
*
*******************************************************************************/
void PWM_Init(void)
{
    PWME = PWM_DISABLE; /* Disable all PWM channels */
    
    PWMPOL = 0x00;      /* All PWM channels starts low */
    PWMCLK = 0x00;      /* All channels are clocked from A or B clock source */
    PWMPRCLK = 0x00;    /* Clock A & B equals to BUS clock */
    PWMCAE = 0x00;      /* PWM1, PWM3, PWM5, PWM7 are left aligned */
    PWMCTL = 0xF4;      /* All channels are concatenated to form 16-bit PWMs,
                           counters stop in Freeze Mode */
    PWMCLKAB = 0x00;    /* Clock A is the source clock for all channels */
    
    PWMPER01 = PWM_MODULO;  /* Set PWM channel 01 period */
    PWMPER23 = PWM_MODULO;  /* Set PWM channel 23 period */
    PWMPER45 = PWM_MODULO;  /* Set PWM channel 45 period */
    PWMPER67 = PWM_MODULO;  /* Set PWM channel 67 period */
}