/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     pim.c
*
* @author   B06050
* 
* @version  1.0.1.0
* 
* @date     Jul-10-2012
* 
* @brief    Port Integration Module SW module source file.
*
*******************************************************************************/
#include "pim.h"

/*******************************************************************************
*
* Function: void PIM_Init(void)
*
* Description:  This function initializes the PIM module (GPIO configuration).
*
*******************************************************************************/
void PIM_Init(void)
{
    /* Pin I/O direction settings */
    DDRA  = 0x3F;   /* PA[5..0] configured as general purpose outputs */
    DDRC  = 0x1B;   /* PC[4..3],PC[1..0] configured as general purpose
                       outputs */
    DDRP  = 0xAA;   /* PP[7],PP[5],PP[3],PP[1] configured as general purpose
                       outputs */
    DDRS  = 0x80;   /* PS[7] configured as general purpose output */
    
    /* General purpose output pin level settings */
    PORTA = 0x00;   /* PA[7..0] outputs set to logic low */
    PORTC = 0x0B;   /* PC[3],PC[1],PC[0] outputs set to logic high */
    PTP   = 0xAA;   /* PP[7],PP[5],PP[3],PP[1] outputs set to logic high */
    PTS   = 0x80;   /* PS[7] output set to logic high */
    
    /* General purpose input pin pull device settings */
    PERJ  = 0x0F;   /* Disable pull device on PJ[7..4] */
}