/******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
***************************************************************************//*!
*
* @file      state_machine.h
*
* @author    b06050
*
* @version   1.0.4.0
*
* @date      Aug-3-2012
*
* @brief     Header file for StateMachineFrame "c" project
*
******************************************************************************/
#ifndef __STATE_MACHINE_H
#define __STATE_MACHINE_H

/******************************************************************************
* Includes
******************************************************************************/


/******************************************************************************
* Constants
******************************************************************************/
#define TURNED_ON   0x1
#define TURNED_OFF  0x0

#ifndef true
#define true  ((bool_t)1)
#endif

#ifndef false
#define false ((bool_t)0)
#endif

typedef void (*PFCN_VOID_VOID)(void); /* pointer to function */

typedef enum {
    reset           = 0,
    init            = 1,
    fault           = 2,
    ready           = 3,
    calib           = 4,
    align           = 5,
    start           = 6,
    run             = 7,
}AppStates;         /* Application state identification user type*/

typedef enum {
    e_reset             = 0,
    e_reset_done        = 1,
    e_fault             = 2,
    e_fault_clear       = 3,
    e_init_done         = 4,
    e_ready             = 5,
    e_app_on            = 6,
    e_calib             = 7,
    e_calib_done        = 8,
    e_align             = 9,
    e_align_done        = 10,
    e_run               = 11,
    e_app_off           = 12,
    e_start             = 13,
    e_start_done        = 14,
}AppEvents;         /* Application event identification user type*/

typedef union
{
    vuint32_t R;
    struct
    {
        vuint32_t reserved0              : 1;   /* RESERVED */
        vuint32_t ADC_Error              : 1;   /* Error in ADC hw initialization*/
        vuint32_t reserved1              : 5;   /* RESERVED */
        vuint32_t InitError              : 1;   /* Error during app initialization */
        vuint32_t CalibError             : 1;   /* Error during calibration */
        vuint32_t AlignError             : 1;   /* Error during alignment */
        vuint32_t reserved2              : 12;  /* RESERVED */
        vuint32_t OverPhaseCCurrent      : 1;   /* OverCurrent fault flag */
        vuint32_t OverPhaseBCurrent      : 1;   /* OverCurrent fault flag */
        vuint32_t OverPhaseACurrent      : 1;   /* OverCurrent fault flag */
        vuint32_t OverHeating            : 1;   /* Overheating fault flag */
        vuint32_t WrongHardware          : 1;   /* Wrong hardware fault flag */
        vuint32_t MainsFault             : 1;   /* Mains out of range */
        vuint32_t OverLoad               : 1;   /* Overload Flag */
        vuint32_t OverDCBusCurrent       : 1;   /* OverCurrent fault flag */
        vuint32_t UnderDCBusVoltage      : 1;   /* Undervoltage fault flag */
        vuint32_t OverDCBusVoltage       : 1;   /* Overvoltage fault flag */
    } B;
}AppFaultStatus;    /* Application fault status user type*/

#endif /* __STATE_MACHINE_H */