#
# Freescale Semiconductor Inc.
# (c) Copyright 2012 Freescale Semiconductor, Inc.
# ALL RIGHTS RESERVED.
#
#*******************************************************************************
#
# $File Name: startup.s$
#
# $Date: Aug-3-2012$
#
# $Version: 1.0.4.0$
#
# Description: MPC5606B Startup Code
#
#*******************************************************************************

#*******************************************************************************
# Reset control word initialization
#*******************************************************************************
    .section .rcw
    .long 0x005A005A               # Reset Configuration Half Word
    .long _start                   # Code starts at _start

    .section .vletext,va
    .vle
    .globl _start
    .align 2

_start:

#*******************************************************************************
# Initialize the base address for interrupt and trap vector tables
#*******************************************************************************
    e_lis   r3, __IV_ADDR@h
    e_or2i  r3, __IV_ADDR@l
    mtIVPR  r3

#*******************************************************************************
# Internal ram must be initialized for error correction
# NOTE: This code has to be commented if the application code resides in SRAM
#*******************************************************************************
    e_lis    r5, INT_SRAM_SIZE@h   # Number of 128 byte segments
    e_or2i   r5, INT_SRAM_SIZE@l   # Number of 128 byte segments
    se_mtctr r5                    # configure control register for use
                                   # with e_bdnz

# Start address of the internal SRAM
    e_lis    r5, INT_SRAM_START@h
    e_or2i   r5, INT_SRAM_START@l

# Repeat
sram_loop:
    e_stmw   r0, 0(r5)             # write all 32 registers into RAM
    e_addi   r5, r5,128            # increment the ram ptr
    e_bdnz   sram_loop             # loop for 40k of SRAM


#*******************************************************************************
# Erase ".sbss Section"
#*******************************************************************************
    e_li   r0, 0                   # Clear r0

    e_lis    r5, SBSS_SRAM_SIZE@h  # Number of words
    e_or2i   r5, SBSS_SRAM_SIZE@l  # Number of words
    or.      r5, r5, r5            # Number of words
    e_beq    sram_erase1
    se_mtctr r5                    # configure control register for use
                                   # with e_bdnz

# Start address of the sbss section
    e_lis    r5, SBSS_SRAM_START@h
    e_or2i   r5, SBSS_SRAM_START@l
    xor      r0, r0, r0
    e_subi   r5, r5, 4             # decrement by 4 to prepare for e_stwu
                                   # in loop

# Repeat
sram_loop1:
    e_stwu   r0,4(r5)              # write 0 to RAM and update r5 address
    e_bdnz   sram_loop1

sram_erase1:
#*******************************************************************************
# Erase ".bss Section"
#*******************************************************************************
    e_lis    r5, BSS_SRAM_SIZE@h   # Number of words
    e_or2i   r5, BSS_SRAM_SIZE@l   # Number of words
    or.      r5, r5, r5            # Number of words
    e_beq    sram_erase2
    se_mtctr r5                    # configure control register for use
                                   # with e_bdnz

# Start address of the bss section
    e_lis    r5, BSS_SRAM_START@h
    e_or2i   r5, BSS_SRAM_START@l
    e_subi   r5, r5, 4             # decrement by 4 to prepare for e_stwu
                                   # in loop

# Repeat
sram_loop2:
    e_stwu   r0, 4(r5)             # write 0 to RAM and update r5 address
    e_bdnz   sram_loop2

sram_erase2:

#*******************************************************************************
# Initialize stack pointer base address
#*******************************************************************************
    e_lis    r1, __SP_INIT@h
    e_or2i   r1, __SP_INIT@l

#*******************************************************************************
# Copy  initialized data from Flash to SRAM
#*******************************************************************************
#*******************************************************************************
# .PPC.EMB.sdata0
#*******************************************************************************
    e_lis    r5, RC_PPC_SDATA2_SIZE@h  # Number of words
    e_or2i   r5, RC_PPC_SDATA2_SIZE@l  # Number of words
    or.      r5, r5, r5                # Number of words
    e_beq    data_copy1
    se_mtctr r5                    # configure control register for use
                                   # with e_bdnz

# Source address of the section
    e_lis    r8, RC_PPC_SDATA2_SRC@h
    e_or2i   r8, RC_PPC_SDATA2_SRC@l
    e_subi   r8, r8, 4             # decrement by 4 to prepare for e_stwu
                                   # in loop

# Destination address of the section
    e_lis    r9, RC_PPC_SDATA2_DEST@h
    e_or2i   r9, RC_PPC_SDATA2_DEST@l
    e_subi   r9, r9, 4             # decrement by 4 to prepare for e_stwu
                                   # in loop

# Repeat
data_copy_loop1:
    e_lwzu   r10, 4(r8)
    e_stwu   r10, 4(r9)
    e_bdnz   data_copy_loop1

data_copy1:
#*******************************************************************************
# .sdata
#*******************************************************************************
    e_lis    r5, RC_SDATA_SIZE@h   # Number of words
    e_or2i   r5, RC_SDATA_SIZE@l   # Number of words
    or.      r5, r5, r5            # Number of words
    e_beq    data_copy2
    se_mtctr r5                    # configure control register for use
                                   # with e_bdnz

# Source address of the section
    e_lis    r8, RC_SDATA_SRC@h
    e_or2i   r8, RC_SDATA_SRC@l
    e_subi   r8, r8, 4             # decrement by 4 to prepare for e_stwu
                                   # in loop

# Destination address of the section
    e_lis    r9, RC_SDATA_DEST@h
    e_or2i   r9, RC_SDATA_DEST@l
    e_subi   r9, r9, 4             # decrement by 4 to prepare for e_stwu
                                   # in loop

# Repeat
data_copy_loop2:
    e_lwzu   r10,4(r8)
    e_stwu   r10,4(r9)
    e_bdnz   data_copy_loop2

data_copy2:
#*******************************************************************************
# .data
#*******************************************************************************
    e_lis    r5, RC_DATA_SIZE@h    # Number of words
    e_or2i   r5, RC_DATA_SIZE@l    # Number of words
    or.      r5, r5, r5            # Number of words
    e_beq    data_copy3
    se_mtctr r5                    # configure control register for use
                                   # with e_bdnz

# Source address of the section
    e_lis    r8, RC_DATA_SRC@h
    e_or2i   r8, RC_DATA_SRC@l
    e_subi   r8, r8, 4             # decrement by 4 to prepare for e_stwu
                                   # in loop

# Destination address of the section
    e_lis    r9, RC_DATA_DEST@h
    e_or2i   r9, RC_DATA_DEST@l
    e_subi   r9, r9, 4             # decrement by 4 to prepare for e_stwu
                                   # in loop

# Repeat
data_copy_loop3:
    e_lwzu  r10, 4(r8)
    e_stwu  r10, 4(r9)
    e_bdnz  data_copy_loop3

data_copy3:

#*******************************************************************************
# Set the small ro data pointer
#*******************************************************************************
    e_lis   r2, SDATA_RO_START@h
    e_or2i  r2, SDATA_RO_START@l

#*******************************************************************************
# Set the small rw data pointer
#*******************************************************************************
    e_lis   r13, SDATA_RW_START@h
    e_or2i  r13, SDATA_RW_START@l

#*******************************************************************************
# Prepare a terminating stack record
#*******************************************************************************
    e_li r0, -1
    e_stwu r1, -8(r1)              # Decrement stack by 8 bytes, (write word)
    e_stw  r0, 4(r1)               # Make an illegal return address
                                   # of 0xFFFFFFFF
    e_stw  r0, 0(r1)               # Make an illegal back chain address
                                   # of 0xFFFFFFFF

#*******************************************************************************
# Branch to main()
#*******************************************************************************
    e_bl   main

# Loop forever
    se_b .