#
# Freescale Semiconductor Inc.
# (c) Copyright 2012 Freescale Semiconductor, Inc.
# ALL RIGHTS RESERVED.
#
#*******************************************************************************
#
# $File Name: IVORn_Vector_Table.s$
#
# $Date: Aug-3-2012$
#
# $Version: 1.0.4.0$
#
# Description: MPC5606B IVOR Vector Table
#
#*******************************************************************************

    .globl   IVORnTable
    .globl   _start

    .section .xcptn,va         # The "v" indicates VLE code
    .vle

    # Position of IVPR
    IVORnTable:

    .offset 0x00
    e_b exc_critical

    .offset 0x10
    e_b exc_mach_check

    .offset 0x20
    e_b exc_data_storage

    .offset 0x30
    e_b exc_instruction_storage

    .offset 0x40
    e_b IVOR4Handler

    .offset 0x50
    e_b exc_alignment

    .offset 0x60
    e_b exc_program

    .offset 0x70
    e_b exc_float_point_unavailable

    .offset 0x80
    e_b exc_system_call

    .offset 0x90
    e_b AP_unavailable_int_handler

    .offset 0xA0
    e_b exc_decrementer

    .offset 0xB0
    e_b exc_fixed_interval_timer

    .offset 0xC0
    e_b exc_watchdog_timer

    .offset 0xD0
    e_b exc_data_TLB

    .offset 0xE0
    e_b exc_instruction_TLB

    .offset 0xF0
    e_b exc_debug


exc_critical:
    e_b exc_critical

exc_mach_check:
    e_b exc_mach_check

exc_data_storage:
    e_b exc_data_storage

exc_instruction_storage:
    e_b exc_instruction_storage

exc_alignment:
    e_b exc_alignment

exc_program:
    e_b exc_program

exc_float_point_unavailable:
    e_b exc_float_point_unavailable

exc_system_call:
    e_b exc_system_call

AP_unavailable_int_handler:
    e_b AP_unavailable_int_handler

exc_decrementer:
    e_b exc_decrementer

exc_fixed_interval_timer:
    e_b exc_fixed_interval_timer

exc_watchdog_timer:
    e_b exc_watchdog_timer

exc_data_TLB:
    e_b exc_data_TLB

exc_instruction_TLB:
    e_b exc_instruction_TLB

exc_debug:
    e_b exc_debug