/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     siu.c
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    SIU - System Integration Unit for MPC5606B
*
********************************************************************************
*
* This file includes initial setting function of MPC5606B SIU peripheral module.
* The port settings are valid for 144QFP package.
*
*******************************************************************************/
#include "MPC5606B.h"
#include "siu.h"
#include "MPC5606B_appconfig.h"

/*******************************************************************************
* SIU initialization function
*******************************************************************************/
void siu_init(void)
{
    static uint8_t  i;

    // initialization of peripheral base address
    pSIU=(struct SIU_tag *)&SIU;

    /*--------------------------------------------------------------------------
     * SIU reset
    --------------------------------------------------------------------------*/
    for (i=0;i<=31;i++)
    {
        pSIU->PCR[i].R = 0x0;
    }

    for (i=34;i<=120;i++)
    {
        pSIU->PCR[i].R = 0x0;
    }

    for (i=0;i<=63;i++)
    {
        pSIU->PSMI[i].R = 0x0;
    }

    for (i=0;i<=23;i++)
    {
        pSIU->IFMC[i].R = 0x0;
    }

    pSIU->IFCPR.R   = 0x0;
    pSIU->IFEER.R   = 0x0;
    pSIU->IFER.R    = 0x0;
    pSIU->IREER.R   = 0x0;
    pSIU->IRER.R    = 0x0;
    pSIU->ISR.R     = 0x0;

    for (i=0;i<=122;i++)
    {
        pSIU->GPDO[i].R    = 0x0;
    }

    for (i=0;i<=7;i++)
        pSIU->MPGPDO[i].R  = 0x0;

    for (i=0;i<=3;i++)
    {
        pSIU->PGPDO[i].R   = 0x0;
    }

    /*--------------------------------------------------------------------------
     * SIU PCR registers
    --------------------------------------------------------------------------*/
    #ifdef SIU_PCR0              /* SIU 0 */
       pSIU->PCR[0].R = SIU_PCR0;
    #endif
    #ifdef SIU_PCR1              /* SIU 1 */
       pSIU->PCR[1].R = SIU_PCR1;
    #endif
    #ifdef SIU_PCR2              /* SIU 2 */
       pSIU->PCR[2].R = SIU_PCR2;
    #endif
    #ifdef SIU_PCR3              /* SIU 3 */
       pSIU->PCR[3].R = SIU_PCR3;
    #endif
    #ifdef SIU_PCR4              /* SIU 4 */
       pSIU->PCR[4].R = SIU_PCR4;
    #endif
    #ifdef SIU_PCR5              /* SIU 5 */
       pSIU->PCR[5].R = SIU_PCR5;
    #endif
    #ifdef SIU_PCR6              /* SIU 6 */
       pSIU->PCR[6].R = SIU_PCR6;
    #endif
    #ifdef SIU_PCR7              /* SIU 7 */
       pSIU->PCR[7].R = SIU_PCR7;
    #endif
    #ifdef SIU_PCR8              /* SIU 8 */
       pSIU->PCR[8].R = SIU_PCR8;
    #endif
    #ifdef SIU_PCR9              /* SIU 9 */
       pSIU->PCR[9].R = SIU_PCR9;
    #endif
    #ifdef SIU_PCR10             /* SIU 10 */
       pSIU->PCR[10].R = SIU_PCR10;
    #endif
    #ifdef SIU_PCR11             /* SIU 11 */
       pSIU->PCR[11].R = SIU_PCR11;
    #endif
    #ifdef SIU_PCR12             /* SIU 12 */
       pSIU->PCR[12].R = SIU_PCR12;
    #endif
    #ifdef SIU_PCR13             /* SIU 13 */
       pSIU->PCR[13].R = SIU_PCR13;
    #endif
    #ifdef SIU_PCR14             /* SIU 14 */
       pSIU->PCR[14].R = SIU_PCR14;
    #endif
    #ifdef SIU_PCR15             /* SIU 15 */
       pSIU->PCR[15].R = SIU_PCR15;
    #endif
    #ifdef SIU_PCR16             /* SIU 16 */
       pSIU->PCR[16].R = SIU_PCR16;
    #endif
    #ifdef SIU_PCR17             /* SIU 17 */
       pSIU->PCR[17].R = SIU_PCR17;
    #endif
    #ifdef SIU_PCR18             /* SIU 18 */
       pSIU->PCR[18].R = SIU_PCR18;
    #endif
    #ifdef SIU_PCR19             /* SIU 19 */
       pSIU->PCR[19].R = SIU_PCR19;
    #endif
    #ifdef SIU_PCR20             /* SIU 20 */
       pSIU->PCR[20].R = SIU_PCR20;
    #endif
    #ifdef SIU_PCR21             /* SIU 21 */
       pSIU->PCR[21].R = SIU_PCR21;
    #endif
    #ifdef SIU_PCR22             /* SIU 22 */
       pSIU->PCR[22].R = SIU_PCR22;
    #endif
    #ifdef SIU_PCR23             /* SIU 23 */
       pSIU->PCR[23].R = SIU_PCR23;
    #endif
    #ifdef SIU_PCR24             /* SIU 24 */
       pSIU->PCR[24].R = SIU_PCR24;
    #endif
    #ifdef SIU_PCR25             /* SIU 25 */
       pSIU->PCR[25].R = SIU_PCR25;
    #endif
    #ifdef SIU_PCR26             /* SIU 26 */
       pSIU->PCR[26].R = SIU_PCR26;
    #endif
    #ifdef SIU_PCR27             /* SIU 27 */
       pSIU->PCR[27].R = SIU_PCR27;
    #endif
    #ifdef SIU_PCR28             /* SIU 28 */
       pSIU->PCR[28].R = SIU_PCR28;
    #endif
    #ifdef SIU_PCR29             /* SIU 29 */
       pSIU->PCR[29].R = SIU_PCR29;
    #endif
    #ifdef SIU_PCR30             /* SIU 30 */
       pSIU->PCR[30].R = SIU_PCR30;
    #endif
    #ifdef SIU_PCR31             /* SIU 31 */
       pSIU->PCR[31].R = SIU_PCR31;
    #endif
    #ifdef SIU_PCR32             /* SIU 32 */
       pSIU->PCR[32].R = SIU_PCR32;
    #endif
    #ifdef SIU_PCR33             /* SIU 33 */
       pSIU->PCR[33].R = SIU_PCR33;
    #endif
    #ifdef SIU_PCR34             /* SIU 34 */
       pSIU->PCR[34].R = SIU_PCR34;
    #endif
    #ifdef SIU_PCR35             /* SIU 35 */
       pSIU->PCR[35].R = SIU_PCR35;
    #endif
    #ifdef SIU_PCR36             /* SIU 36 */
       pSIU->PCR[36].R = SIU_PCR36;
    #endif
    #ifdef SIU_PCR37             /* SIU 37 */
       pSIU->PCR[37].R = SIU_PCR37;
    #endif
    #ifdef SIU_PCR38             /* SIU 38 */
       pSIU->PCR[38].R = SIU_PCR38;
    #endif
    #ifdef SIU_PCR39             /* SIU 39 */
       pSIU->PCR[39].R = SIU_PCR39;
    #endif
    #ifdef SIU_PCR40             /* SIU 40 */
       pSIU->PCR[40].R = SIU_PCR40;
    #endif
    #ifdef SIU_PCR41             /* SIU 41 */
       pSIU->PCR[41].R = SIU_PCR41;
    #endif
    #ifdef SIU_PCR42             /* SIU 42 */
       pSIU->PCR[42].R = SIU_PCR42;
    #endif
    #ifdef SIU_PCR43             /* SIU 43 */
       pSIU->PCR[43].R = SIU_PCR43;
    #endif
    #ifdef SIU_PCR44             /* SIU 44 */
       pSIU->PCR[44].R = SIU_PCR44;
    #endif
    #ifdef SIU_PCR45             /* SIU 45 */
       pSIU->PCR[45].R = SIU_PCR45;
    #endif
    #ifdef SIU_PCR46             /* SIU 46 */
       pSIU->PCR[46].R = SIU_PCR46;
    #endif
    #ifdef SIU_PCR47             /* SIU 47 */
       pSIU->PCR[47].R = SIU_PCR47;
    #endif
    #ifdef SIU_PCR48             /* SIU 48 */
       pSIU->PCR[48].R = SIU_PCR48;
    #endif
    #ifdef SIU_PCR49             /* SIU 49 */
       pSIU->PCR[49].R = SIU_PCR49;
    #endif
    #ifdef SIU_PCR50             /* SIU 50 */
       pSIU->PCR[50].R = SIU_PCR50;
    #endif
    #ifdef SIU_PCR51             /* SIU 51 */
       pSIU->PCR[51].R = SIU_PCR51;
    #endif
    #ifdef SIU_PCR52             /* SIU 52 */
       pSIU->PCR[52].R = SIU_PCR52;
    #endif
    #ifdef SIU_PCR53             /* SIU 53 */
       pSIU->PCR[53].R = SIU_PCR53;
    #endif
    #ifdef SIU_PCR54             /* SIU 54 */
       pSIU->PCR[54].R = SIU_PCR54;
    #endif
    #ifdef SIU_PCR55             /* SIU 55 */
       pSIU->PCR[55].R = SIU_PCR55;
    #endif
    #ifdef SIU_PCR56             /* SIU 56 */
       pSIU->PCR[56].R = SIU_PCR56;
    #endif
    #ifdef SIU_PCR57             /* SIU 57 */
       pSIU->PCR[57].R = SIU_PCR57;
    #endif
    #ifdef SIU_PCR58             /* SIU 58 */
       pSIU->PCR[58].R = SIU_PCR58;
    #endif
    #ifdef SIU_PCR59             /* SIU 59 */
       pSIU->PCR[59].R = SIU_PCR59;
    #endif
    #ifdef SIU_PCR60             /* SIU 60 */
       pSIU->PCR[60].R = SIU_PCR60;
    #endif
    #ifdef SIU_PCR61             /* SIU 61 */
       pSIU->PCR[61].R = SIU_PCR61;
    #endif
    #ifdef SIU_PCR62             /* SIU 62 */
       pSIU->PCR[62].R = SIU_PCR62;
    #endif
    #ifdef SIU_PCR63             /* SIU 63 */
       pSIU->PCR[63].R = SIU_PCR63;
    #endif
    #ifdef SIU_PCR64             /* SIU 64 */
       pSIU->PCR[64].R = SIU_PCR64;
    #endif
    #ifdef SIU_PCR65             /* SIU 65 */
       pSIU->PCR[65].R = SIU_PCR65;
    #endif
    #ifdef SIU_PCR66             /* SIU 66 */
       pSIU->PCR[66].R = SIU_PCR66;
    #endif
    #ifdef SIU_PCR67             /* SIU 67 */
       pSIU->PCR[67].R = SIU_PCR67;
    #endif
    #ifdef SIU_PCR68             /* SIU 68 */
       pSIU->PCR[68].R = SIU_PCR68;
    #endif
    #ifdef SIU_PCR69             /* SIU 69 */
       pSIU->PCR[69].R = SIU_PCR69;
    #endif
    #ifdef SIU_PCR70             /* SIU 70 */
       pSIU->PCR[70].R = SIU_PCR70;
    #endif
    #ifdef SIU_PCR71             /* SIU 71 */
       pSIU->PCR[71].R = SIU_PCR71;
    #endif
    #ifdef SIU_PCR72             /* SIU 72 */
       pSIU->PCR[72].R = SIU_PCR72;
    #endif
    #ifdef SIU_PCR73             /* SIU 73 */
       pSIU->PCR[73].R = SIU_PCR73;
    #endif
    #ifdef SIU_PCR74             /* SIU 74 */
       pSIU->PCR[74].R = SIU_PCR74;
    #endif
    #ifdef SIU_PCR75             /* SIU 75 */
       pSIU->PCR[75].R = SIU_PCR75;
    #endif
    #ifdef SIU_PCR76             /* SIU 76 */
       pSIU->PCR[76].R = SIU_PCR76;
    #endif
    #ifdef SIU_PCR77             /* SIU 77 */
       pSIU->PCR[77].R = SIU_PCR77;
    #endif
    #ifdef SIU_PCR78             /* SIU 78 */
       pSIU->PCR[78].R = SIU_PCR78;
    #endif
    #ifdef SIU_PCR79             /* SIU 79 */
       pSIU->PCR[79].R = SIU_PCR79;
    #endif
    #ifdef SIU_PCR80             /* SIU 80 */
       pSIU->PCR[80].R = SIU_PCR80;
    #endif
    #ifdef SIU_PCR81             /* SIU 81 */
       pSIU->PCR[81].R = SIU_PCR81;
    #endif
    #ifdef SIU_PCR82             /* SIU 82 */
       pSIU->PCR[82].R = SIU_PCR82;
    #endif
    #ifdef SIU_PCR83             /* SIU 83 */
       pSIU->PCR[83].R = SIU_PCR83;
    #endif
    #ifdef SIU_PCR84             /* SIU 84 */
       pSIU->PCR[84].R = SIU_PCR84;
    #endif
    #ifdef SIU_PCR85             /* SIU 85 */
       pSIU->PCR[85].R = SIU_PCR85;
    #endif
    #ifdef SIU_PCR86             /* SIU 86 */
       pSIU->PCR[86].R = SIU_PCR86;
    #endif
    #ifdef SIU_PCR87             /* SIU 87 */
       pSIU->PCR[87].R = SIU_PCR87;
    #endif
    #ifdef SIU_PCR88             /* SIU 88 */
       pSIU->PCR[88].R = SIU_PCR88;
    #endif
    #ifdef SIU_PCR89             /* SIU 89 */
       pSIU->PCR[89].R = SIU_PCR89;
    #endif
    #ifdef SIU_PCR90             /* SIU 90 */
       pSIU->PCR[90].R = SIU_PCR90;
    #endif
    #ifdef SIU_PCR91             /* SIU 91 */
       pSIU->PCR[91].R = SIU_PCR91;
    #endif
    #ifdef SIU_PCR92             /* SIU 92 */
       pSIU->PCR[92].R = SIU_PCR92;
    #endif
    #ifdef SIU_PCR93             /* SIU 93 */
       pSIU->PCR[93].R = SIU_PCR93;
    #endif
    #ifdef SIU_PCR94             /* SIU 94 */
       pSIU->PCR[94].R = SIU_PCR94;
    #endif
    #ifdef SIU_PCR95             /* SIU 95 */
       pSIU->PCR[95].R = SIU_PCR95;
    #endif
    #ifdef SIU_PCR96             /* SIU 96 */
       pSIU->PCR[96].R = SIU_PCR96;
    #endif
    #ifdef SIU_PCR97             /* SIU 97 */
       pSIU->PCR[97].R = SIU_PCR97;
    #endif
    #ifdef SIU_PCR98             /* SIU 98 */
       pSIU->PCR[98].R = SIU_PCR98;
    #endif
    #ifdef SIU_PCR99             /* SIU 99 */
       pSIU->PCR[99].R = SIU_PCR99;
    #endif
    #ifdef SIU_PCR100            /* SIU 100 */
       pSIU->PCR[100].R = SIU_PCR100;
    #endif
    #ifdef SIU_PCR101            /* SIU 101 */
       pSIU->PCR[101].R = SIU_PCR101;
    #endif
    #ifdef SIU_PCR102            /* SIU 102 */
       pSIU->PCR[102].R = SIU_PCR102;
    #endif
    #ifdef SIU_PCR103            /* SIU 103 */
       pSIU->PCR[103].R = SIU_PCR103;
    #endif
    #ifdef SIU_PCR104            /* SIU 104 */
       pSIU->PCR[104].R = SIU_PCR104;
    #endif
    #ifdef SIU_PCR105            /* SIU 105 */
       pSIU->PCR[105].R = SIU_PCR105;
    #endif
    #ifdef SIU_PCR106            /* SIU 106 */
       pSIU->PCR[106].R = SIU_PCR106;
    #endif
    #ifdef SIU_PCR107            /* SIU 107 */
       pSIU->PCR[107].R = SIU_PCR107;
    #endif
    #ifdef SIU_PCR108            /* SIU 108 */
       pSIU->PCR[108].R = SIU_PCR108;
    #endif
    #ifdef SIU_PCR109            /* SIU 109 */
       pSIU->PCR[109].R = SIU_PCR109;
    #endif
    #ifdef SIU_PCR110            /* SIU 110 */
       pSIU->PCR[110].R = SIU_PCR110;
    #endif
    #ifdef SIU_PCR111            /* SIU 111 */
       pSIU->PCR[111].R = SIU_PCR111;
    #endif
    #ifdef SIU_PCR112            /* SIU 112 */
       pSIU->PCR[112].R = SIU_PCR112;
    #endif
    #ifdef SIU_PCR113            /* SIU 113 */
       pSIU->PCR[113].R = SIU_PCR113;
    #endif
    #ifdef SIU_PCR114            /* SIU 114 */
       pSIU->PCR[114].R = SIU_PCR114;
    #endif
    #ifdef SIU_PCR115            /* SIU 115 */
       pSIU->PCR[115].R = SIU_PCR115;
    #endif
    #ifdef SIU_PCR116            /* SIU 116 */
       pSIU->PCR[116].R = SIU_PCR116;
    #endif
    #ifdef SIU_PCR117            /* SIU 117 */
       pSIU->PCR[117].R = SIU_PCR117;
    #endif
    #ifdef SIU_PCR118            /* SIU 118 */
       pSIU->PCR[118].R = SIU_PCR118;
    #endif
    #ifdef SIU_PCR119            /* SIU 119 */
       pSIU->PCR[119].R = SIU_PCR119;
    #endif
    #ifdef SIU_PCR120            /* SIU 120 */
       pSIU->PCR[120].R = SIU_PCR120;
    #endif
    #ifdef SIU_PCR121            /* SIU 121 */
       pSIU->PCR[121].R = SIU_PCR121;
    #endif
    #ifdef SIU_PCR122            /* SIU 122 */
       pSIU->PCR[122].R = SIU_PCR122;
    #endif

    /*--------------------------------------------------------------------------
     * SIU PSMI registers
    --------------------------------------------------------------------------*/
    #ifdef SIU_PSMI0            /* PSMI 0 */
       pSIU->PSMI[0].R = SIU_PSMI0;
    #endif
    #ifdef SIU_PSMI1            /* PSMI 1 */
       pSIU->PSMI[1].R = SIU_PSMI1;
    #endif
    #ifdef SIU_PSMI2            /* PSMI 2 */
       pSIU->PSMI[2].R = SIU_PSMI2;
    #endif
    #ifdef SIU_PSMI3            /* PSMI 3 */
       pSIU->PSMI[3].R = SIU_PSMI3;
    #endif
    #ifdef SIU_PSMI4            /* PSMI 4 */
       pSIU->PSMI[4].R = SIU_PSMI4;
    #endif
    #ifdef SIU_PSMI5            /* PSMI 5 */
       pSIU->PSMI[5].R = SIU_PSMI5;
    #endif
    #ifdef SIU_PSMI6            /* PSMI 6 */
       pSIU->PSMI[6].R = SIU_PSMI6;
    #endif
    #ifdef SIU_PSMI7            /* PSMI 7 */
       pSIU->PSMI[7].R = SIU_PSMI7;
    #endif
    #ifdef SIU_PSMI8            /* PSMI 8 */
       pSIU->PSMI[8].R = SIU_PSMI8;
    #endif
    #ifdef SIU_PSMI9            /* PSMI 9 */
       pSIU->PSMI[9].R = SIU_PSMI9;
    #endif
    #ifdef SIU_PSMI10           /* PSMI 10 */
       pSIU->PSMI[10].R = SIU_PSMI10;
    #endif
    #ifdef SIU_PSMI11           /* PSMI 11 */
       pSIU->PSMI[11].R = SIU_PSMI11;
    #endif
    #ifdef SIU_PSMI12           /* PSMI 12 */
       pSIU->PSMI[12].R = SIU_PSMI12;
    #endif
    #ifdef SIU_PSMI13           /* PSMI 13 */
       pSIU->PSMI[13].R = SIU_PSMI13;
    #endif
    #ifdef SIU_PSMI14           /* PSMI 14 */
       pSIU->PSMI[14].R = SIU_PSMI14;
    #endif
    #ifdef SIU_PSMI15           /* PSMI 15 */
       pSIU->PSMI[15].R = SIU_PSMI15;
    #endif
    #ifdef SIU_PSMI16           /* PSMI 16 */
       pSIU->PSMI[16].R = SIU_PSMI16;
    #endif
    #ifdef SIU_PSMI17           /* PSMI 17 */
       pSIU->PSMI[17].R = SIU_PSMI17;
    #endif
    #ifdef SIU_PSMI18           /* PSMI 18 */
       pSIU->PSMI[18].R = SIU_PSMI18;
    #endif
    #ifdef SIU_PSMI19           /* PSMI 19 */
       pSIU->PSMI[19].R = SIU_PSMI19;
    #endif
    #ifdef SIU_PSMI20           /* PSMI 20 */
       pSIU->PSMI[20].R = SIU_PSMI20;
    #endif
    #ifdef SIU_PSMI21           /* PSMI 21 */
       pSIU->PSMI[21].R = SIU_PSMI21;
    #endif
    #ifdef SIU_PSMI22           /* PSMI 22 */
       pSIU->PSMI[22].R = SIU_PSMI22;
    #endif
    #ifdef SIU_PSMI23           /* PSMI 23 */
       pSIU->PSMI[23].R = SIU_PSMI23;
    #endif
    #ifdef SIU_PSMI24           /* PSMI 24 */
       pSIU->PSMI[24].R = SIU_PSMI24;
    #endif
    #ifdef SIU_PSMI25           /* PSMI 25 */
       pSIU->PSMI[25].R = SIU_PSMI25;
    #endif
    #ifdef SIU_PSMI26           /* PSMI 26 */
       pSIU->PSMI[26].R = SIU_PSMI26;
    #endif
    #ifdef SIU_PSMI27           /* PSMI 27 */
       pSIU->PSMI[27].R = SIU_PSMI27;
    #endif
    #ifdef SIU_PSMI28           /* PSMI 28 */
       pSIU->PSMI[28].R = SIU_PSMI28;
    #endif
    #ifdef SIU_PSMI29           /* PSMI 29 */
       pSIU->PSMI[29].R = SIU_PSMI29;
    #endif
    #ifdef SIU_PSMI30           /* PSMI 30 */
       pSIU->PSMI[30].R = SIU_PSMI30;
    #endif
    #ifdef SIU_PSMI31           /* PSMI 31 */
       pSIU->PSMI[31].R = SIU_PSMI31;
    #endif
    #ifdef SIU_PSMI32           /* PSMI 32 */
       pSIU->PSMI[32].R = SIU_PSMI32;
    #endif
    #ifdef SIU_PSMI33           /* PSMI 33 */
       pSIU->PSMI[33].R = SIU_PSMI33;
    #endif
    #ifdef SIU_PSMI34           /* PSMI 34 */
       pSIU->PSMI[34].R = SIU_PSMI34;
    #endif
    #ifdef SIU_PSMI35           /* PSMI 35 */
       pSIU->PSMI[35].R = SIU_PSMI35;
    #endif
    #ifdef SIU_PSMI36           /* PSMI 36 */
       pSIU->PSMI[36].R = SIU_PSMI36;
    #endif
    #ifdef SIU_PSMI37           /* PSMI 37 */
       pSIU->PSMI[37].R = SIU_PSMI37;
    #endif
    #ifdef SIU_PSMI38           /* PSMI 38 */
       pSIU->PSMI[38].R = SIU_PSMI38;
    #endif
    #ifdef SIU_PSMI39           /* PSMI 39 */
       pSIU->PSMI[39].R = SIU_PSMI39;
    #endif
    #ifdef SIU_PSMI40           /* PSMI 40 */
       pSIU->PSMI[40].R = SIU_PSMI40;
    #endif
    #ifdef SIU_PSMI41           /* PSMI 41 */
       pSIU->PSMI[41].R = SIU_PSMI41;
    #endif
    #ifdef SIU_PSMI42           /* PSMI 42 */
       pSIU->PSMI[42].R = SIU_PSMI42;
    #endif
    #ifdef SIU_PSMI43           /* PSMI 43 */
       pSIU->PSMI[43].R = SIU_PSMI43;
    #endif
    #ifdef SIU_PSMI44           /* PSMI 44 */
       pSIU->PSMI[44].R = SIU_PSMI44;
    #endif
    #ifdef SIU_PSMI45           /* PSMI 45 */
       pSIU->PSMI[45].R = SIU_PSMI45;
    #endif
    #ifdef SIU_PSMI46           /* PSMI 46 */
       pSIU->PSMI[46].R = SIU_PSMI46;
    #endif
    #ifdef SIU_PSMI47           /* PSMI 47 */
       pSIU->PSMI[47].R = SIU_PSMI47;
    #endif
    #ifdef SIU_PSMI48           /* PSMI 48 */
       pSIU->PSMI[48].R = SIU_PSMI48;
    #endif
    #ifdef SIU_PSMI49           /* PSMI 49 */
       pSIU->PSMI[49].R = SIU_PSMI49;
    #endif
    #ifdef SIU_PSMI50           /* PSMI 50 */
       pSIU->PSMI[50].R = SIU_PSMI50;
    #endif
    #ifdef SIU_PSMI51           /* PSMI 51 */
       pSIU->PSMI[51].R = SIU_PSMI51;
    #endif
    #ifdef SIU_PSMI52           /* PSMI 52 */
       pSIU->PSMI[52].R = SIU_PSMI52;
    #endif
    #ifdef SIU_PSMI53           /* PSMI 53 */
       pSIU->PSMI[53].R = SIU_PSMI53;
    #endif
    #ifdef SIU_PSMI54           /* PSMI 54 */
       pSIU->PSMI[54].R = SIU_PSMI54;
    #endif
    #ifdef SIU_PSMI55           /* PSMI 55 */
       pSIU->PSMI[55].R = SIU_PSMI55;
    #endif
    #ifdef SIU_PSMI56           /* PSMI 56 */
       pSIU->PSMI[56].R = SIU_PSMI56;
    #endif
    #ifdef SIU_PSMI57           /* PSMI 57 */
       pSIU->PSMI[57].R = SIU_PSMI57;
    #endif
    #ifdef SIU_PSMI58           /* PSMI 58 */
       pSIU->PSMI[58].R = SIU_PSMI58;
    #endif
    #ifdef SIU_PSMI59           /* PSMI 59 */
       pSIU->PSMI[59].R = SIU_PSMI59;
    #endif
    #ifdef SIU_PSMI60           /* PSMI 60 */
       pSIU->PSMI[60].R = SIU_PSMI60;
    #endif
    #ifdef SIU_PSMI61           /* PSMI 61 */
       pSIU->PSMI[61].R = SIU_PSMI61;
    #endif
    #ifdef SIU_PSMI62           /* PSMI 62 */
       pSIU->PSMI[62].R = SIU_PSMI62;
    #endif
    #ifdef SIU_PSMI63           /* PSMI 32 */
       pSIU->PSMI[32].R = SIU_PSMI32;
    #endif

    /*--------------------------------------------------------------------------
     * SIU IFMC register
    --------------------------------------------------------------------------*/
    #ifdef SIU_IFMC0            /* IFMC 0 */
       pSIU->IFMC[0].R = SIU_IFMC0;
    #endif
    #ifdef SIU_IFMC1            /* IFMC 1 */
       pSIU->IFMC[1].R = SIU_IFMC1;
    #endif
    #ifdef SIU_IFMC2            /* IFMC 2 */
       pSIU->IFMC[2].R = SIU_IFMC2;
    #endif
    #ifdef SIU_IFMC3            /* IFMC 3 */
       pSIU->IFMC[3].R = SIU_IFMC3;
    #endif
    #ifdef SIU_IFMC4            /* IFMC 4 */
       pSIU->IFMC[4].R = SIU_IFMC4;
    #endif
    #ifdef SIU_IFMC5            /* IFMC 5 */
       pSIU->IFMC[5].R = SIU_IFMC5;
    #endif
    #ifdef SIU_IFMC6            /* IFMC 6 */
       pSIU->IFMC[6].R = SIU_IFMC6;
    #endif
    #ifdef SIU_IFMC7            /* IFMC 7 */
       pSIU->IFMC[7].R = SIU_IFMC7;
    #endif
    #ifdef SIU_IFMC8            /* IFMC 8 */
       pSIU->IFMC[8].R = SIU_IFMC8;
    #endif
    #ifdef SIU_IFMC9            /* IFMC 9 */
       pSIU->IFMC[9].R = SIU_IFMC9;
    #endif
    #ifdef SIU_IFMC10           /* IFMC 10 */
       pSIU->IFMC[10].R = SIU_IFMC10;
    #endif
    #ifdef SIU_IFMC11           /* IFMC 11 */
       pSIU->IFMC[11].R = SIU_IFMC11;
    #endif
    #ifdef SIU_IFMC12           /* IFMC 12 */
       pSIU->IFMC[12].R = SIU_IFMC12;
    #endif
    #ifdef SIU_IFMC13           /* IFMC 13 */
       pSIU->IFMC[13].R = SIU_IFMC13;
    #endif
    #ifdef SIU_IFMC14           /* IFMC 14 */
       pSIU->IFMC[14].R = SIU_IFMC14;
    #endif
    #ifdef SIU_IFMC15           /* IFMC 15 */
       pSIU->IFMC[15].R = SIU_IFMC15;
    #endif
    #ifdef SIU_IFMC16           /* IFMC 16 */
       pSIU->IFMC[16].R = SIU_IFMC16;
    #endif
    #ifdef SIU_IFMC17           /* IFMC 17 */
       pSIU->IFMC[17].R = SIU_IFMC17;
    #endif
    #ifdef SIU_IFMC18           /* IFMC 18 */
       pSIU->IFMC[18].R = SIU_IFMC18;
    #endif
    #ifdef SIU_IFMC19           /* IFMC 19 */
       pSIU->IFMC[19].R = SIU_IFMC19;
    #endif
    #ifdef SIU_IFMC20           /* IFMC 20 */
       pSIU->IFMC[20].R = SIU_IFMC20;
    #endif
    #ifdef SIU_IFMC21           /* IFMC 21 */
       pSIU->IFMC[21].R = SIU_IFMC21;
    #endif
    #ifdef SIU_IFMC22           /* IFMC 22 */
       pSIU->IFMC[22].R = SIU_IFMC22;
    #endif
    #ifdef SIU_IFMC23           /* IFMC 23 */
       pSIU->IFMC[23].R = SIU_IFMC23;
    #endif

    /*--------------------------------------------------------------------------
     * SIU IRER register
    --------------------------------------------------------------------------*/
    #ifdef SIU_IRER             /* IRER */
       pSIU->IRER.R = SIU_IRER;
    #endif

    /*--------------------------------------------------------------------------
     * SIU IREER register
    --------------------------------------------------------------------------*/
    #ifdef SIU_IREER             /* IREER */
       pSIU->IREER.R = SIU_IREER;
    #endif

    /*--------------------------------------------------------------------------
     * SIU IFEER register
    --------------------------------------------------------------------------*/
    #ifdef SIU_IFEER             /* IFEER */
       pSIU->IFEER.R = SIU_IREER;
    #endif

    /*--------------------------------------------------------------------------
     * SIU IFCPR register
    --------------------------------------------------------------------------*/
    #ifdef SIU_IFCPR             /* IFCPR */
       pSIU->IFCPR.R = SIU_IFCPR;
    #endif

    /*--------------------------------------------------------------------------
     * SIU IFER register
    --------------------------------------------------------------------------*/
    #ifdef SIU_IFER             /* IFER */
       pSIU->IFER.R = SIU_IFER;
    #endif
}