/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     adc.c
*
* @author   b06050
*
* @version  1.0.2.0
*
* @date     Aug-3-2012
*
* @brief    ADC - Analog to Digital Converter for MPC5606B
*
********************************************************************************
*
* This file includes initial setting function of MPC5606B ADC peripheral module.
*
*******************************************************************************/
#include "MPC5606B.h"
#include "adc.h"
#include "MPC5606B_appconfig.h"

/*******************************************************************************
* ADC functions
******************************************************************************/

/****************************************************************************//*!
@brief          ADC0 initialization function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes ADC0 module.
*******************************************************************************/
void adc0_init(void)
{
    // initialization of peripheral base address
    pADC_0=(struct ADC_tag_cut2 *)&ADC_0;

    pADC_0->MCR.R       = 0x1;
    pADC_0->IMR.R       = 0x0;
    pADC_0->CIMR0.R     = 0x0;
    pADC_0->CIMR1.R     = 0x0;
    pADC_0->CIMR2.R     = 0x0;
    pADC_0->WTIMR.R     = 0x0;
    pADC_0->DMAE.R      = 0x0;
    pADC_0->DMAR0.R     = 0x0;
    pADC_0->DMAR1.R     = 0x0;
    pADC_0->DMAR2.R     = 0x0;
    pADC_0->THRHLR[0].R   = 0x0FFF0000;
    pADC_0->THRHLR[1].R   = 0x0FFF0000;
    pADC_0->THRHLR[2].R   = 0x0FFF0000;
    pADC_0->THRHLR[3].R   = 0x0FFF0000;
    pADC_0->PSCR.R      = 0x0;
    pADC_0->PSR0.R      = 0x0;
    pADC_0->PSR1.R      = 0x0;
    pADC_0->PSR2.R      = 0x0;
    pADC_0->CTR0.R      = 0x0203;
    pADC_0->CTR1.R      = 0x0203;
    pADC_0->CTR2.R      = 0x0203;
    pADC_0->NCMR0.R     = 0x0;
    pADC_0->NCMR1.R     = 0x0;
    pADC_0->NCMR2.R     = 0x0;
    pADC_0->JCMR0.R     = 0x0;
    pADC_0->JCMR1.R     = 0x0;
    pADC_0->JCMR2.R     = 0x0;
    pADC_0->DSDR.R      = 0x0;
    pADC_0->PDEDR.R     = 0x0;

    #ifdef ADC0_MCR                                 /* MCR register */
        pADC_0->MCR.R       = ADC0_MCR;
    #endif

    #ifdef ADC0_IMR                                 /* IMR register */
        pADC_0->IMR.R       = ADC0_IMR;
    #endif

    #ifdef ADC0_CIMR0                               /* CIMR0 register */
        pADC_0->CIMR0.R     = ADC0_CIMR0;
    #endif

    #ifdef ADC0_CIMR1                               /* CIMR1 register */
        pADC_0->CIMR1.R     = ADC0_CIMR1;
    #endif

    #ifdef ADC0_CIMR2                               /* CIMR2 register */
        pADC_0->CIMR2.R     = ADC0_CIMR2;
    #endif

    #ifdef ADC0_WTIMR                               /* WTIMR register */
        pADC_0->WTIMR.R     = ADC0_WTIMR;
    #endif

    #ifdef ADC0_DMAE                                /* DMAE register */
        pADC_0->DMAE.R      = ADC0_DMAE;
    #endif

    #ifdef ADC0_DMAR0                               /* DMAR0 register */
        pADC_0->DMAR0.R     = ADC0_DMAR0;
    #endif

    #ifdef ADC0_DMAR1                               /* DMAR1 register */
        pADC_0->DMAR1.R     = ADC0_DMAR1;
    #endif

    #ifdef ADC0_DMAR2                               /* DMAR2 register */
        pADC_0->DMAR2.R     = ADC0_DMAR2;
    #endif

    #ifdef ADC0_TRC0                                /* TRC0 register */
        pADC_0->TRC0.R      = ADC0_TRC0;
    #endif

    #ifdef ADC0_TRC1                                /* TRC1 register */
        pADC_0->TRC1.R      = ADC0_TRC1;
    #endif

    #ifdef ADC0_TRC2                                /* TRC2 register */
        pADC_0->TRC2.R      = ADC0_TRC2;
    #endif

    #ifdef ADC0_TRC3                                /* TRC3 register */
        pADC_0->TRC3.R      = ADC0_TRC3;
    #endif

    #ifdef ADC0_THRHLR0                             /* THRHLR0 register */
        pADC_0->THRHLR0.R   = ADC0_THRHLR0;
    #endif

    #ifdef ADC0_THRHLR1                             /* THRHLR1 register */
        pADC_0->THRHLR1.R   = ADC0_THRHLR1;
    #endif

    #ifdef ADC0_THRHLR2                             /* THRHLR2 register */
        pADC_0->THRHLR2.R   = ADC0_THRHLR2;
    #endif

    #ifdef ADC0_THRHLR3                             /* THRHLR3 register */
        pADC_0->THRHLR3.R   = ADC0_THRHLR3;
    #endif

    #ifdef ADC0_THRALT0                             /* THRALT0 register */
        pADC_0->THRALT0.R   = ADC0_THRALT0;
    #endif

    #ifdef ADC0_THRALT1                             /* THRALT1 register */
        pADC_0->THRALT1.R   = ADC0_THRALT1;
    #endif

    #ifdef ADC0_THRALT2                             /* THRALT2 register */
        pADC_0->THRALT2.R   = ADC0_THRALT2;
    #endif

    #ifdef ADC0_THRALT3                             /* THRALT3 register */
        pADC_0->THRALT3.R   = ADC0_THRALT3;
    #endif

    #ifdef ADC0_PSCR                                /* PSCR register */
        pADC_0->PSCR.R      = ADC0_PSCR;
    #endif

    #ifdef ADC0_PSR0                                /* PSR0 register */
        pADC_0->PSR0.R      = ADC0_PSR0;
    #endif

    #ifdef ADC0_PSR1                                /* PSR1 register */
        pADC_0->PSR1.R      = ADC0_PSR1;
    #endif

    #ifdef ADC0_PSR2                                /* PSR2 register */
        pADC_0->PSR2.R      = ADC0_PSR2;
    #endif

    #ifdef ADC0_CTR0                                /* CTR0 register */
        pADC_0->CTR0.R      = ADC0_CTR0;
    #endif

    #ifdef ADC0_CTR1                                /* CTR1 register */
        pADC_0->CTR1.R      = ADC0_CTR1;
    #endif

    #ifdef ADC0_CTR2                                /* CTR2 register */
        pADC_0->CTR2.R      = ADC0_CTR2;
    #endif

    #ifdef ADC0_NCMR0                               /* NCMR0 register */
        pADC_0->NCMR0.R     = ADC0_NCMR0;
    #endif

    #ifdef ADC0_NCMR1                               /* NCMR1 register */
        pADC_0->NCMR1.R     = ADC0_NCMR1;
    #endif

    #ifdef ADC0_NCMR2                               /* NCMR2 register */
        pADC_0->NCMR2.R     = ADC0_NCMR2;
    #endif

    #ifdef ADC0_JCMR0                               /* JCMR0 register */
        pADC_0->JCMR0.R     = ADC0_JCMR0;
    #endif

    #ifdef ADC0_JCMR1                               /* JCMR1 register */
        pADC_0->JCMR1.R     = ADC0_JCMR1;
    #endif

    #ifdef ADC0_JCMR2                               /* JCMR2 register */
        pADC_0->JCMR2.R     = ADC0_JCMR2;
    #endif

    #ifdef ADC0_OFFWR                               /* OFFWR register */
        pADC_0->OFFWR.R     = ADC0_OFFWR;
    #endif

    #ifdef ADC0_DSDR                                /* DSDR register */
        pADC_0->DSDR.R      = ADC0_DSDR;
    #endif

    #ifdef ADC0_PDEDR                               /* PDEDR register */
        pADC_0->PDEDR.R     = ADC0_PDEDR;
    #endif
}

/***************************************************************************//*!
@brief          ADC1 initialization function

@param[in,out]  void
@param[in]      void

@return         void

@details        This function initializes ADC1 module.
*******************************************************************************/
void adc1_init(void)
{
    // initialization of peripheral base address
    pADC_1=(struct ADC_tag_cut2 *)&ADC_1;

    pADC_1->MCR.R       = 0x0;
    pADC_1->IMR.R       = 0x0;
    pADC_1->CIMR0.R     = 0x0;
    pADC_1->CIMR1.R     = 0x0;
    pADC_1->CIMR2.R     = 0x0;
    pADC_1->WTIMR.R     = 0x0;
    pADC_1->DMAE.R      = 0x0;
    pADC_1->DMAR0.R     = 0x0;
    pADC_1->DMAR1.R     = 0x0;
    pADC_1->DMAR2.R     = 0x0;
    pADC_1->THRHLR[0].R   = 0x0000FFF0;
    pADC_1->THRHLR[1].R   = 0x0000FFF0;
    pADC_1->THRHLR[2].R   = 0x0000FFF0;
    pADC_1->THRHLR[3].R   = 0x0000FFF0;
    pADC_1->PSCR.R      = 0x0;
    pADC_1->PSR0.R      = 0x0;
    pADC_1->PSR1.R      = 0x0;
    pADC_1->PSR2.R      = 0x0;
    pADC_1->CTR0.R      = 0x0;
    pADC_1->CTR1.R      = 0x0;
    pADC_1->CTR2.R      = 0x0;
    pADC_1->NCMR0.R     = 0x0;
    pADC_1->NCMR1.R     = 0x0;
    pADC_1->NCMR2.R     = 0x0;
    pADC_1->JCMR0.R     = 0x0;
    pADC_1->JCMR1.R     = 0x0;
    pADC_1->JCMR2.R     = 0x0;
    pADC_1->DSDR.R      = 0x0;
    pADC_1->PDEDR.R     = 0x0;

    #ifdef ADC1_MCR                                 /* MCR register */
        pADC_1->MCR.R       = ADC1_MCR;
    #endif

    #ifdef ADC1_IMR                                 /* IMR register */
        pADC_1->IMR.R       = ADC1_IMR;
    #endif

    #ifdef ADC1_CIMR0                               /* CIMR0 register */
        pADC_1->CIMR0.R     = ADC1_CIMR0;
    #endif

    #ifdef ADC1_CIMR1                               /* CIMR1 register */
        pADC_1->CIMR1.R     = ADC1_CIMR1;
    #endif

    #ifdef ADC1_CIMR2                               /* CIMR2 register */
        pADC_1->CIMR2.R     = ADC1_CIMR2;
    #endif

    #ifdef ADC1_WTIMR                               /* WTIMR register */
        pADC_1->WTIMR.R     = ADC1_WTIMR;
    #endif

    #ifdef ADC1_DMAE                                /* DMAE register */
        pADC_1->DMAE.R      = ADC1_DMAE;
    #endif

    #ifdef ADC1_DMAR0                               /* DMAR0 register */
        pADC_1->DMAR0.R     = ADC1_DMAR0;
    #endif

    #ifdef ADC1_DMAR1                               /* DMAR1 register */
        pADC_1->DMAR1.R     = ADC1_DMAR1;
    #endif

    #ifdef ADC1_DMAR2                               /* DMAR2 register */
        pADC_1->DMAR2.R     = ADC1_DMAR2;
    #endif

    #ifdef ADC1_TRC0                                /* TRC0 register */
        pADC_1->TRC0.R      = ADC1_TRC0;
    #endif

    #ifdef ADC1_TRC1                                /* TRC1 register */
        pADC_1->TRC1.R      = ADC1_TRC1;
    #endif

    #ifdef ADC1_TRC2                                /* TRC2 register */
        pADC_1->TRC2.R      = ADC1_TRC2;
    #endif

    #ifdef ADC1_TRC3                                /* TRC3 register */
        pADC_1->TRC3.R      = ADC1_TRC3;
    #endif

    #ifdef ADC1_THRHLR0                             /* THRHLR0 register */
        pADC_1->THRHLR0.R   = ADC1_THRHLR0;
    #endif

    #ifdef ADC1_THRHLR1                             /* THRHLR1 register */
        pADC_1->THRHLR1.R   = ADC1_THRHLR1;
    #endif

    #ifdef ADC1_THRHLR2                             /* THRHLR2 register */
        pADC_1->THRHLR2.R   = ADC1_THRHLR2;
    #endif

    #ifdef ADC1_THRHLR3                             /* THRHLR3 register */
        pADC_1->THRHLR3.R   = ADC1_THRHLR3;
    #endif

    #ifdef ADC1_THRALT0                             /* THRALT0 register */
        pADC_1->THRALT0.R   = ADC1_THRALT0;
    #endif

    #ifdef ADC1_THRALT1                             /* THRALT1 register */
        pADC_1->THRALT1.R   = ADC1_THRALT1;
    #endif

    #ifdef ADC1_THRALT2                             /* THRALT2 register */
        pADC_1->THRALT2.R   = ADC1_THRALT2;
    #endif

    #ifdef ADC1_THRALT3                             /* THRALT3 register */
        pADC_1->THRALT3.R   = ADC1_THRALT3;
    #endif

    #ifdef ADC1_PSCR                                /* PSCR register */
        pADC_1->PSCR.R      = ADC1_PSCR;
    #endif

    #ifdef ADC1_PSR0                                /* PSR0 register */
        pADC_1->PSR0.R      = ADC1_PSR0;
    #endif

    #ifdef ADC1_PSR1                                /* PSR1 register */
        pADC_1->PSR1.R      = ADC1_PSR1;
    #endif

    #ifdef ADC1_PSR2                                /* PSR2 register */
        pADC_1->PSR2.R      = ADC1_PSR2;
    #endif

    #ifdef ADC1_CTR0                                /* CTR0 register */
        pADC_1->CTR0.R      = ADC1_CTR0;
    #endif

    #ifdef ADC1_CTR1                                /* CTR1 register */
        pADC_1->CTR1.R      = ADC1_CTR1;
    #endif

    #ifdef ADC1_CTR2                                /* CTR2 register */
        pADC_1->CTR2.R      = ADC1_CTR2;
    #endif

    #ifdef ADC1_NCMR0                               /* NCMR0 register */
        pADC_1->NCMR0.R     = ADC1_NCMR0;
    #endif

    #ifdef ADC1_NCMR1                               /* NCMR1 register */
        pADC_1->NCMR1.R     = ADC1_NCMR1;
    #endif

    #ifdef ADC1_NCMR2                               /* NCMR2 register */
        pADC_1->NCMR2.R     = ADC1_NCMR2;
    #endif

    #ifdef ADC1_JCMR0                               /* JCMR0 register */
        pADC_1->JCMR0.R     = ADC1_JCMR0;
    #endif

    #ifdef ADC1_JCMR1                               /* JCMR1 register */
        pADC_1->JCMR1.R     = ADC1_JCMR1;
    #endif

    #ifdef ADC1_JCMR2                               /* JCMR2 register */
        pADC_1->JCMR2.R     = ADC1_JCMR2;
    #endif

    #ifdef ADC1_OFFWR                               /* OFFWR register */
        pADC_1->OFFWR.R     = ADC1_OFFWR;
    #endif

    #ifdef ADC1_DSDR                                /* DSDR register */
        pADC_1->DSDR.R      = ADC1_DSDR;
    #endif

    #ifdef ADC1_PDEDR                               /* PDEDR register */
        pADC_1->PDEDR.R     = ADC1_PDEDR;
    #endif
        // CTU Control Mode enable

        pADC_1->MCR.B.CTUEN = 1;
}