/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file       MPC5606B_SIUL_LLD.h
*
* @author     b06050
*
* @version    1.0.2.0
*
* @date       Aug-3-2012
*
* @brief      SIUL low level driver module for MPC5606B.
*
********************************************************************************
*
* This file includes initial setting and MACRO definitions of MPC5606B SIUL
* peripheral module.
*
*******************************************************************************/
#ifndef __MPC5606B_SIUL_LLD_H
#define __MPC5606B_SIUL_LLD_H

#ifdef __cplusplus
extern "C" {
#endif

#define SIUL_BASE                                       0xC3F90000

/*******************************************************************************
* SIUL ioctl commands definitions
*******************************************************************************/
/***************************************************************************//*!
*
* @brief                Clear external interrupt flag .
*
* @param                SIUL_EXT_INT_0
* @param                SIUL_EXT_INT_1
* @param                SIUL_EXT_INT_2
* @param                SIUL_EXT_INT_3
* @param                SIUL_EXT_INT_4
* @param                SIUL_EXT_INT_5
* @param                SIUL_EXT_INT_6
* @param                SIUL_EXT_INT_7
* @param                SIUL_EXT_INT_8
* @param                SIUL_EXT_INT_9
* @param                SIUL_EXT_INT_10
* @param                SIUL_EXT_INT_11
* @param                SIUL_EXT_INT_12
* @param                SIUL_EXT_INT_13
* @param                SIUL_EXT_INT_14
* @param                SIUL_EXT_INT_15
* @param                SIUL_EXT_INT_16
* @param                SIUL_EXT_INT_17
* @param                SIUL_EXT_INT_18
* @param                SIUL_EXT_INT_19
* @param                SIUL_EXT_INT_20
* @param                SIUL_EXT_INT_21
* @param                SIUL_EXT_INT_22
* @param                SIUL_EXT_INT_23
*
* @return               NULL
*
* @details              The #SIUL_CLEAR_INT_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CLEAR_INT_FLAG, SIUL_EXT_INT_0);
* \endcode
*
*******************************************************************************/
#define SIUL_CLEAR_INT_FLAG

/***************************************************************************//*!
*
* @brief                Read External Interrupt status register.
*
* @param                NULL
*
* @return               external interrupt register value
*
* @details              The #SIUL_READ_VALUE_REG_EIF ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_EIF, NULL);
* \endcode
*
******************************************************************************/
#define SIUL_READ_VALUE_REG_EIF

/***************************************************************************//*!
*
* @brief                Read Interrupt request enable register.
*
* @param                NULL
*
* @return               interrupt request enable register value
*
* @details              The #SIUL_READ_VALUE_REG_IRER ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IRER, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IRER

/***************************************************************************//*!
*
* @brief                Enable external interrupt request.
*
* @param                SIUL_REQ_0
* @param                SIUL_REQ_1
* @param                SIUL_REQ_2
* @param                SIUL_REQ_3
* @param                SIUL_REQ_4
* @param                SIUL_REQ_5
* @param                SIUL_REQ_6
* @param                SIUL_REQ_7
* @param                SIUL_REQ_8
* @param                SIUL_REQ_9
* @param                SIUL_REQ_10
* @param                SIUL_REQ_11
* @param                SIUL_REQ_12
* @param                SIUL_REQ_13
* @param                SIUL_REQ_14
* @param                SIUL_REQ_15
* @param                SIUL_REQ_16
* @param                SIUL_REQ_17
* @param                SIUL_REQ_18
* @param                SIUL_REQ_19
* @param                SIUL_REQ_20
* @param                SIUL_REQ_21
* @param                SIUL_REQ_22
* @param                SIUL_REQ_23
*
* @return               NULL
*
* @details              The #SIUL_ENABLE_INT_REQ ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_ENABLE_INT_REQ, SIUL_REQ_0);
* \endcode
*
*******************************************************************************/
#define SIUL_ENABLE_INT_REQ

/***************************************************************************//*!
*
* @brief                Disable external interrupt request.
*
* @param                SIUL_REQ_0
* @param                SIUL_REQ_1
* @param                SIUL_REQ_2
* @param                SIUL_REQ_3
* @param                SIUL_REQ_4
* @param                SIUL_REQ_5
* @param                SIUL_REQ_6
* @param                SIUL_REQ_7
* @param                SIUL_REQ_8
* @param                SIUL_REQ_9
* @param                SIUL_REQ_10
* @param                SIUL_REQ_11
* @param                SIUL_REQ_12
* @param                SIUL_REQ_13
* @param                SIUL_REQ_14
* @param                SIUL_REQ_15
* @param                SIUL_REQ_16
* @param                SIUL_REQ_17
* @param                SIUL_REQ_18
* @param                SIUL_REQ_19
* @param                SIUL_REQ_20
* @param                SIUL_REQ_21
* @param                SIUL_REQ_22
* @param                SIUL_REQ_23
*
* @return               NULL
*
* @details              The #SIUL_ENABLE_INT_REQ ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_ENABLE_INT_REQ, SIUL_REQ_0);
* \endcode
*
*******************************************************************************/
#define SIUL_DISABLE_INT_REQ

/***************************************************************************//*!
*
* @brief                Enable rising edge triggered event.
*
* @param                SIUL_REQ_0
* @param                SIUL_REQ_1
* @param                SIUL_REQ_2
* @param                SIUL_REQ_3
* @param                SIUL_REQ_4
* @param                SIUL_REQ_5
* @param                SIUL_REQ_6
* @param                SIUL_REQ_7
* @param                SIUL_REQ_8
* @param                SIUL_REQ_9
* @param                SIUL_REQ_10
* @param                SIUL_REQ_11
* @param                SIUL_REQ_12
* @param                SIUL_REQ_13
* @param                SIUL_REQ_14
* @param                SIUL_REQ_15
* @param                SIUL_REQ_16
* @param                SIUL_REQ_17
* @param                SIUL_REQ_18
* @param                SIUL_REQ_19
* @param                SIUL_REQ_20
* @param                SIUL_REQ_21
* @param                SIUL_REQ_22
* @param                SIUL_REQ_23
*
* @return               NULL
*
* @details              The #SIUL_ENABLE_RIS_EDGE_EVNT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_ENABLE_RIS_EDGE_EVNT, SIUL_REQ_0);
* \endcode
*
*******************************************************************************/
#define SIUL_ENABLE_RIS_EDGE_EVNT

/***************************************************************************//*!
*
* @brief                Disable rising edge triggered event.
*
* @param                SIUL_REQ_0
* @param                SIUL_REQ_1
* @param                SIUL_REQ_2
* @param                SIUL_REQ_3
* @param                SIUL_REQ_4
* @param                SIUL_REQ_5
* @param                SIUL_REQ_6
* @param                SIUL_REQ_7
* @param                SIUL_REQ_8
* @param                SIUL_REQ_9
* @param                SIUL_REQ_10
* @param                SIUL_REQ_11
* @param                SIUL_REQ_12
* @param                SIUL_REQ_13
* @param                SIUL_REQ_14
* @param                SIUL_REQ_15
* @param                SIUL_REQ_16
* @param                SIUL_REQ_17
* @param                SIUL_REQ_18
* @param                SIUL_REQ_19
* @param                SIUL_REQ_20
* @param                SIUL_REQ_21
* @param                SIUL_REQ_22
* @param                SIUL_REQ_23
*
* @return               NULL
*
* @details              The #SIUL_DISABLE_RIS_EDGE_EVNT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_DISABLE_RIS_EDGE_EVNT, SIUL_REQ_0);
* \endcode
*
*******************************************************************************/
#define SIUL_DISABLE_RIS_EDGE_EVNT

/***************************************************************************//*!
*
* @brief                Read Interrupt rising edge event enable register.
*
* @param                NULL
*
* @return               interrupt rising edge event enable register value
*
* @details              The #SIUL_READ_VALUE_REG_IREER ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IREER, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IREER

/***************************************************************************//*!
*
* @brief                Enable falling edge triggered event.
*
* @param                SIUL_REQ_0
* @param                SIUL_REQ_1
* @param                SIUL_REQ_2
* @param                SIUL_REQ_3
* @param                SIUL_REQ_4
* @param                SIUL_REQ_5
* @param                SIUL_REQ_6
* @param                SIUL_REQ_7
* @param                SIUL_REQ_8
* @param                SIUL_REQ_9
* @param                SIUL_REQ_10
* @param                SIUL_REQ_11
* @param                SIUL_REQ_12
* @param                SIUL_REQ_13
* @param                SIUL_REQ_14
* @param                SIUL_REQ_15
* @param                SIUL_REQ_16
* @param                SIUL_REQ_17
* @param                SIUL_REQ_18
* @param                SIUL_REQ_19
* @param                SIUL_REQ_20
* @param                SIUL_REQ_21
* @param                SIUL_REQ_22
* @param                SIUL_REQ_23
*
* @return               NULL
*
* @details              The #SIUL_ENABLE_FALL_EDGE_EVNT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_ENABLE_FALL_EDGE_EVNT, SIUL_REQ_0);
* \endcode
*
*******************************************************************************/
#define SIUL_ENABLE_FALL_EDGE_EVNT

/***************************************************************************//*!
*
* @brief                Disable falling edge triggered event.
*
* @param                SIUL_REQ_0
* @param                SIUL_REQ_1
* @param                SIUL_REQ_2
* @param                SIUL_REQ_3
* @param                SIUL_REQ_4
* @param                SIUL_REQ_5
* @param                SIUL_REQ_6
* @param                SIUL_REQ_7
* @param                SIUL_REQ_8
* @param                SIUL_REQ_9
* @param                SIUL_REQ_10
* @param                SIUL_REQ_11
* @param                SIUL_REQ_12
* @param                SIUL_REQ_13
* @param                SIUL_REQ_14
* @param                SIUL_REQ_15
* @param                SIUL_REQ_16
* @param                SIUL_REQ_17
* @param                SIUL_REQ_18
* @param                SIUL_REQ_19
* @param                SIUL_REQ_20
* @param                SIUL_REQ_21
* @param                SIUL_REQ_22
* @param                SIUL_REQ_23
*
* @return               NULL
*
* @details              The #SIUL_DISABLE_FALL_EDGE_EVNT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_DISABLE_FALL_EDGE_EVNT, SIUL_REQ_0);
* \endcode
*
*******************************************************************************/
#define SIUL_DISABLE_FALL_EDGE_EVNT

/***************************************************************************//*!
*
* @brief                Read Interrupt falling edge event enable register.
*
* @param                NULL
*
* @return               interrupt falling edge event enable register value
*
* @details              The #SIUL_READ_VALUE_REG_IFEER ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFEER, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFEER

/***************************************************************************//*!
*
* @brief                Enable interrupt filtering.
*
* @param                SIUL_REQ_0
* @param                SIUL_REQ_1
* @param                SIUL_REQ_2
* @param                SIUL_REQ_3
* @param                SIUL_REQ_4
* @param                SIUL_REQ_5
* @param                SIUL_REQ_6
* @param                SIUL_REQ_7
* @param                SIUL_REQ_8
* @param                SIUL_REQ_9
* @param                SIUL_REQ_10
* @param                SIUL_REQ_11
* @param                SIUL_REQ_12
* @param                SIUL_REQ_13
* @param                SIUL_REQ_14
* @param                SIUL_REQ_15
* @param                SIUL_REQ_16
* @param                SIUL_REQ_17
* @param                SIUL_REQ_18
* @param                SIUL_REQ_19
* @param                SIUL_REQ_20
* @param                SIUL_REQ_21
* @param                SIUL_REQ_22
* @param                SIUL_REQ_23
*
* @return               NULL
*
* @details              The #SIUL_ENABLE_INT_FILT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_ENABLE_INT_FILT, SIUL_REQ_0);
* \endcode
*
*******************************************************************************/
#define SIUL_ENABLE_INT_FILT

/***************************************************************************//*!
*
* @brief                Disable interrupt filtering.
*
* @param                SIUL_REQ_0
* @param                SIUL_REQ_1
* @param                SIUL_REQ_2
* @param                SIUL_REQ_3
* @param                SIUL_REQ_4
* @param                SIUL_REQ_5
* @param                SIUL_REQ_6
* @param                SIUL_REQ_7
* @param                SIUL_REQ_8
* @param                SIUL_REQ_9
* @param                SIUL_REQ_10
* @param                SIUL_REQ_11
* @param                SIUL_REQ_12
* @param                SIUL_REQ_13
* @param                SIUL_REQ_14
* @param                SIUL_REQ_15
* @param                SIUL_REQ_16
* @param                SIUL_REQ_17
* @param                SIUL_REQ_18
* @param                SIUL_REQ_19
* @param                SIUL_REQ_20
* @param                SIUL_REQ_21
* @param                SIUL_REQ_22
* @param                SIUL_REQ_23
*
* @return               NULL
*
* @details              The #SIUL_DISABLE_INT_FILT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_DISABLE_INT_FILT, SIUL_REQ_0);
* \endcode
*
*******************************************************************************/
#define SIUL_DISABLE_INT_FILT

/***************************************************************************//*!
*
* @brief                Read Interrupt filter enable register.
*
* @param                NULL
*
* @return               interrupt filter enable register value
*
* @details              The #SIUL_READ_VALUE_REG_IFER ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFER, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFER

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_0, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_0

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_1, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_1

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_2, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_2

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_3, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_3

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_4, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_4

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_5, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_5

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_6 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_6, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_6

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_7 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_7, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_7

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_8 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_8, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_8

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_9 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_9, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_9

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_10 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_10, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_10

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_11 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_11, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_11

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_12 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_12, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_12

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_13 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_13, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_13

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_14 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_14, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_14

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_15 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_15, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_15

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_16 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_16, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_16

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_17 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_17, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_17

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_18 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_18, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_18

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_19 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_19, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_19

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_20 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_20, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_20

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_21 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_21, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_21

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_22 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_22, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_22

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_23 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_23, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_23

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_24 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_24, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_24

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_25 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_25, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_25

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_26 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_26, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_26

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_27 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_27, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_27

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_28 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_28, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_28

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_29 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_29, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_29

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_30 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_30, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_30

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_31 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_31, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_31

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_32 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_32, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_32

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_33 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_33, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_33

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_34 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_34, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_34

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_35 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_35, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_35

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_36 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_36, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_36

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_37 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_37, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_37

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_38 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_38, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_38

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_39 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_39, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_39

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_40 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_40, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_40

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_41 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_41, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_41

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_42 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_42, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_42

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_43 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_43, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_43

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_44 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_44, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_44

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_45 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_45, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_45

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_46 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_46, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_46

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_47 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_47, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_47

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_48 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_48, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_48

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_49 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_49, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_49

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_50 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_50, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_50

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_51 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_51, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_51

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_52 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_52, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_52

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_53 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_53, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_53

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_54 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_54, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_54

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_55 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_55, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_55

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_56 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_56, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_56

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_57 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_57, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_57

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_58 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_58, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_58

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_59 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_59, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_59

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_60 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_60, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_60

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_61 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_61, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_61

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_62 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_62, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_62

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_63 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_63, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_63

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_64 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_64, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_64

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_65 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_65, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_65

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_66 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_66, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_66

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_67 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_67, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_67

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_68 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_68, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_68

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_69 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_69, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_69

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_70 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_70, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_70

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_71 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_71, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_71

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_72 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_72, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_72

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_73 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_73, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_73

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_74 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_74, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_74

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_75 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_75, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_75

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_76 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_76, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_76

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_77 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_77, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_77

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_78 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_78, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_78

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_79 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_79, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_79

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_80 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_80, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_80

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_81 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_81, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_81

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_82 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_82, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_82

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_83 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_83, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_83

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_84 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_84, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_84

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_85 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_85, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_85

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_86 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_86, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_86

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_87 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_87, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_87

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_88 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_88, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_88

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_89 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_89, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_89

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_90 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_90, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_90

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_91 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_91, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_91

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_92 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_92, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_92

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_93 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_93, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_93

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_94 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_94, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_94

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_95 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_95, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_95

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_96 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_96, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_96

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_97 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_97, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_97

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_98 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_98, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_98

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_99 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_99, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_99

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_100 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_100, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_100

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_101 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_101, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_101

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_102 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_102, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_102

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_103 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_103, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_103

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_104 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_104, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_104

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_105 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_105, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_105

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_106 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_106, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_106

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_107 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_107, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_107

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_108 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_108, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_108

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_109 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_109, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_109

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_110 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_110, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_110

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_107 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_111, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_111

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_112 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_112, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_112

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_113 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_113, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_113

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_114 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_114, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_114

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_115 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_115, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_115

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_116 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_116, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_116

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_117 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_117, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_117

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_118 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_118, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_118

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_119 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_119, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_119

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_120 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_120, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_120

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_121 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_121, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_121

/***************************************************************************//*!
*
* @brief                I/O pad configuration.
*
* @param                SIUL_SEL_PULL_UP
* @param                SIUL_PULL_UP_DOWN_ENBL
* @param                SIUL_FAST_SR
* @param                SIUL_OPEN_DRAIN_ENBL
* @param                SIUL_INPUT_ENBL
* @param                SIUL_OUTPUT_ENBL
* @param                SIUL_SET_GPIO
* @param                SIUL_SET_ATL_MODE1
* @param                SIUL_SET_ATL_MODE2
* @param                SIUL_SET_ATL_MODE3
* @param                SIUL_ANALOG
* @param                SIUL_SAFE_MODE
* @param                SIUL_GPIO_IN
* @param                SIUL_GPIO_OUT
* @param                SIUL_ALT1_OUT
* @param                SIUL_ALT2_OUT
* @param                SIUL_ALT3_OUT
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_122 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_122, SIUL_SEL_PULL_UP);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_122

/***************************************************************************//*!
*
* @brief                Configure pad as GPIO
*
* @param                SIUL_PAD_x
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_GPIO ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_GPIO, SIUL_PAD_0);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_GPIO

/***************************************************************************//*!
*
* @brief                Configure pad to ALT1 mode
*
* @param                SIUL_PAD_x
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_ALT1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_ALT1, SIUL_PAD_0);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_ALT1

/***************************************************************************//*!
*
* @brief                Configure pad to ALT2 mode
*
* @param                SIUL_PAD_x
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_ALT2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_ALT2, SIUL_PAD_0);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_ALT2

/***************************************************************************//*!
*
* @brief                Configure pad to ALT3 mode
*
* @param                SIUL_PAD_x
*
* @return               NULL
*
* @details              The #SIUL_CONFIGURE_PAD_ALT3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CONFIGURE_PAD_ALT3, SIUL_PAD_0);
* \endcode
*
*******************************************************************************/
#define SIUL_CONFIGURE_PAD_ALT3

/***************************************************************************//*!
*
* @brief                Set output value on dedicated pad.
*
* @param                SIUL_PAD_0
* @param                SIUL_PAD_1
* @param                SIUL_PAD_2
* @param                SIUL_PAD_3
* @param                SIUL_PAD_4
* @param                SIUL_PAD_5
* @param                SIUL_PAD_6
* @param                SIUL_PAD_7
* @param                SIUL_PAD_8
* @param                SIUL_PAD_9
* @param                SIUL_PAD_10
* @param                SIUL_PAD_11
* @param                SIUL_PAD_12
* @param                SIUL_PAD_13
* @param                SIUL_PAD_14
* @param                SIUL_PAD_15
* @param                SIUL_PAD_16
* @param                SIUL_PAD_17
* @param                SIUL_PAD_18
* @param                SIUL_PAD_19
* @param                SIUL_PAD_20
* @param                SIUL_PAD_21
* @param                SIUL_PAD_22
* @param                SIUL_PAD_23
* @param                SIUL_PAD_24
* @param                SIUL_PAD_25
* @param                SIUL_PAD_26
* @param                SIUL_PAD_27
* @param                SIUL_PAD_28
* @param                SIUL_PAD_29
* @param                SIUL_PAD_30
* @param                SIUL_PAD_31
* @param                SIUL_PAD_32
* @param                SIUL_PAD_33
* @param                SIUL_PAD_34
* @param                SIUL_PAD_35
* @param                SIUL_PAD_36
* @param                SIUL_PAD_37
* @param                SIUL_PAD_38
* @param                SIUL_PAD_39
* @param                SIUL_PAD_40
* @param                SIUL_PAD_41
* @param                SIUL_PAD_42
* @param                SIUL_PAD_43
* @param                SIUL_PAD_44
* @param                SIUL_PAD_45
* @param                SIUL_PAD_46
* @param                SIUL_PAD_47
* @param                SIUL_PAD_48
* @param                SIUL_PAD_49
* @param                SIUL_PAD_50
* @param                SIUL_PAD_51
* @param                SIUL_PAD_52
* @param                SIUL_PAD_53
* @param                SIUL_PAD_54
* @param                SIUL_PAD_55
* @param                SIUL_PAD_56
* @param                SIUL_PAD_57
* @param                SIUL_PAD_58
* @param                SIUL_PAD_59
* @param                SIUL_PAD_60
* @param                SIUL_PAD_61
* @param                SIUL_PAD_62
* @param                SIUL_PAD_63
* @param                SIUL_PAD_64
* @param                SIUL_PAD_65
* @param                SIUL_PAD_66
* @param                SIUL_PAD_67
* @param                SIUL_PAD_68
* @param                SIUL_PAD_69
* @param                SIUL_PAD_70
* @param                SIUL_PAD_71
* @param                SIUL_PAD_72
* @param                SIUL_PAD_73
* @param                SIUL_PAD_74
* @param                SIUL_PAD_75
* @param                SIUL_PAD_76
* @param                SIUL_PAD_77
* @param                SIUL_PAD_78
* @param                SIUL_PAD_79
* @param                SIUL_PAD_80
* @param                SIUL_PAD_81
* @param                SIUL_PAD_82
* @param                SIUL_PAD_83
* @param                SIUL_PAD_84
* @param                SIUL_PAD_85
* @param                SIUL_PAD_86
* @param                SIUL_PAD_87
* @param                SIUL_PAD_88
* @param                SIUL_PAD_89
* @param                SIUL_PAD_90
* @param                SIUL_PAD_91
* @param                SIUL_PAD_92
* @param                SIUL_PAD_93
* @param                SIUL_PAD_94
* @param                SIUL_PAD_95
* @param                SIUL_PAD_96
* @param                SIUL_PAD_97
* @param                SIUL_PAD_98
* @param                SIUL_PAD_99
* @param                SIUL_PAD_100
* @param                SIUL_PAD_101
* @param                SIUL_PAD_102
* @param                SIUL_PAD_103
* @param                SIUL_PAD_104
* @param                SIUL_PAD_105
* @param                SIUL_PAD_106
* @param                SIUL_PAD_107
* @param                SIUL_PAD_108
* @param                SIUL_PAD_109
* @param                SIUL_PAD_110
* @param                SIUL_PAD_111
* @param                SIUL_PAD_112
* @param                SIUL_PAD_113
* @param                SIUL_PAD_114
* @param                SIUL_PAD_115
* @param                SIUL_PAD_116
* @param                SIUL_PAD_117
* @param                SIUL_PAD_118
* @param                SIUL_PAD_119
* @param                SIUL_PAD_120
* @param                SIUL_PAD_121
* @param                SIUL_PAD_122
*
* @return               NULL
*
* @details              The #SIUL_SET_PAD ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_SET_PAD, SIUL_PAD_0);
* \endcode
*
*******************************************************************************/
#define SIUL_SET_PAD

/***************************************************************************//*!
*
* @brief                Clear output value on dedicated pad.
*
* @param                SIUL_PAD_0
* @param                SIUL_PAD_1
* @param                SIUL_PAD_2
* @param                SIUL_PAD_3
* @param                SIUL_PAD_4
* @param                SIUL_PAD_5
* @param                SIUL_PAD_6
* @param                SIUL_PAD_7
* @param                SIUL_PAD_8
* @param                SIUL_PAD_9
* @param                SIUL_PAD_10
* @param                SIUL_PAD_11
* @param                SIUL_PAD_12
* @param                SIUL_PAD_13
* @param                SIUL_PAD_14
* @param                SIUL_PAD_15
* @param                SIUL_PAD_16
* @param                SIUL_PAD_17
* @param                SIUL_PAD_18
* @param                SIUL_PAD_19
* @param                SIUL_PAD_20
* @param                SIUL_PAD_21
* @param                SIUL_PAD_22
* @param                SIUL_PAD_23
* @param                SIUL_PAD_24
* @param                SIUL_PAD_25
* @param                SIUL_PAD_26
* @param                SIUL_PAD_27
* @param                SIUL_PAD_28
* @param                SIUL_PAD_29
* @param                SIUL_PAD_30
* @param                SIUL_PAD_31
* @param                SIUL_PAD_32
* @param                SIUL_PAD_33
* @param                SIUL_PAD_34
* @param                SIUL_PAD_35
* @param                SIUL_PAD_36
* @param                SIUL_PAD_37
* @param                SIUL_PAD_38
* @param                SIUL_PAD_39
* @param                SIUL_PAD_40
* @param                SIUL_PAD_41
* @param                SIUL_PAD_42
* @param                SIUL_PAD_43
* @param                SIUL_PAD_44
* @param                SIUL_PAD_45
* @param                SIUL_PAD_46
* @param                SIUL_PAD_47
* @param                SIUL_PAD_48
* @param                SIUL_PAD_49
* @param                SIUL_PAD_50
* @param                SIUL_PAD_51
* @param                SIUL_PAD_52
* @param                SIUL_PAD_53
* @param                SIUL_PAD_54
* @param                SIUL_PAD_55
* @param                SIUL_PAD_56
* @param                SIUL_PAD_57
* @param                SIUL_PAD_58
* @param                SIUL_PAD_59
* @param                SIUL_PAD_60
* @param                SIUL_PAD_61
* @param                SIUL_PAD_62
* @param                SIUL_PAD_63
* @param                SIUL_PAD_64
* @param                SIUL_PAD_65
* @param                SIUL_PAD_66
* @param                SIUL_PAD_67
* @param                SIUL_PAD_68
* @param                SIUL_PAD_69
* @param                SIUL_PAD_70
* @param                SIUL_PAD_71
* @param                SIUL_PAD_72
* @param                SIUL_PAD_73
* @param                SIUL_PAD_74
* @param                SIUL_PAD_75
* @param                SIUL_PAD_76
* @param                SIUL_PAD_77
* @param                SIUL_PAD_78
* @param                SIUL_PAD_79
* @param                SIUL_PAD_80
* @param                SIUL_PAD_81
* @param                SIUL_PAD_82
* @param                SIUL_PAD_83
* @param                SIUL_PAD_84
* @param                SIUL_PAD_85
* @param                SIUL_PAD_86
* @param                SIUL_PAD_87
* @param                SIUL_PAD_88
* @param                SIUL_PAD_89
* @param                SIUL_PAD_90
* @param                SIUL_PAD_91
* @param                SIUL_PAD_92
* @param                SIUL_PAD_93
* @param                SIUL_PAD_94
* @param                SIUL_PAD_95
* @param                SIUL_PAD_96
* @param                SIUL_PAD_97
* @param                SIUL_PAD_98
* @param                SIUL_PAD_99
* @param                SIUL_PAD_100
* @param                SIUL_PAD_101
* @param                SIUL_PAD_102
* @param                SIUL_PAD_103
* @param                SIUL_PAD_104
* @param                SIUL_PAD_105
* @param                SIUL_PAD_106
* @param                SIUL_PAD_107
* @param                SIUL_PAD_108
* @param                SIUL_PAD_109
* @param                SIUL_PAD_110
* @param                SIUL_PAD_111
* @param                SIUL_PAD_112
* @param                SIUL_PAD_113
* @param                SIUL_PAD_114
* @param                SIUL_PAD_115
* @param                SIUL_PAD_116
* @param                SIUL_PAD_117
* @param                SIUL_PAD_118
* @param                SIUL_PAD_119
* @param                SIUL_PAD_120
* @param                SIUL_PAD_121
* @param                SIUL_PAD_122
*
* @return               NULL
*
* @details              The #SIUL_CLEAR_PAD ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_CLEAR_PAD, SIUL_PAD_0);
* \endcode
*
*******************************************************************************/
#define SIUL_CLEAR_PAD

/***************************************************************************//*!
*
* @brief                Toggle output value on dedicated pad.
*
* @param                SIUL_PAD_0
* @param                SIUL_PAD_1
* @param                SIUL_PAD_2
* @param                SIUL_PAD_3
* @param                SIUL_PAD_4
* @param                SIUL_PAD_5
* @param                SIUL_PAD_6
* @param                SIUL_PAD_7
* @param                SIUL_PAD_8
* @param                SIUL_PAD_9
* @param                SIUL_PAD_10
* @param                SIUL_PAD_11
* @param                SIUL_PAD_12
* @param                SIUL_PAD_13
* @param                SIUL_PAD_14
* @param                SIUL_PAD_15
* @param                SIUL_PAD_16
* @param                SIUL_PAD_17
* @param                SIUL_PAD_18
* @param                SIUL_PAD_19
* @param                SIUL_PAD_20
* @param                SIUL_PAD_21
* @param                SIUL_PAD_22
* @param                SIUL_PAD_23
* @param                SIUL_PAD_24
* @param                SIUL_PAD_25
* @param                SIUL_PAD_26
* @param                SIUL_PAD_27
* @param                SIUL_PAD_28
* @param                SIUL_PAD_29
* @param                SIUL_PAD_30
* @param                SIUL_PAD_31
* @param                SIUL_PAD_32
* @param                SIUL_PAD_33
* @param                SIUL_PAD_34
* @param                SIUL_PAD_35
* @param                SIUL_PAD_36
* @param                SIUL_PAD_37
* @param                SIUL_PAD_38
* @param                SIUL_PAD_39
* @param                SIUL_PAD_40
* @param                SIUL_PAD_41
* @param                SIUL_PAD_42
* @param                SIUL_PAD_43
* @param                SIUL_PAD_44
* @param                SIUL_PAD_45
* @param                SIUL_PAD_46
* @param                SIUL_PAD_47
* @param                SIUL_PAD_48
* @param                SIUL_PAD_49
* @param                SIUL_PAD_50
* @param                SIUL_PAD_51
* @param                SIUL_PAD_52
* @param                SIUL_PAD_53
* @param                SIUL_PAD_54
* @param                SIUL_PAD_55
* @param                SIUL_PAD_56
* @param                SIUL_PAD_57
* @param                SIUL_PAD_58
* @param                SIUL_PAD_59
* @param                SIUL_PAD_60
* @param                SIUL_PAD_61
* @param                SIUL_PAD_62
* @param                SIUL_PAD_63
* @param                SIUL_PAD_64
* @param                SIUL_PAD_65
* @param                SIUL_PAD_66
* @param                SIUL_PAD_67
* @param                SIUL_PAD_68
* @param                SIUL_PAD_69
* @param                SIUL_PAD_70
* @param                SIUL_PAD_71
* @param                SIUL_PAD_72
* @param                SIUL_PAD_73
* @param                SIUL_PAD_74
* @param                SIUL_PAD_75
* @param                SIUL_PAD_76
* @param                SIUL_PAD_77
* @param                SIUL_PAD_78
* @param                SIUL_PAD_79
* @param                SIUL_PAD_80
* @param                SIUL_PAD_81
* @param                SIUL_PAD_82
* @param                SIUL_PAD_83
* @param                SIUL_PAD_84
* @param                SIUL_PAD_85
* @param                SIUL_PAD_86
* @param                SIUL_PAD_87
* @param                SIUL_PAD_88
* @param                SIUL_PAD_89
* @param                SIUL_PAD_90
* @param                SIUL_PAD_91
* @param                SIUL_PAD_92
* @param                SIUL_PAD_93
* @param                SIUL_PAD_94
* @param                SIUL_PAD_95
* @param                SIUL_PAD_96
* @param                SIUL_PAD_97
* @param                SIUL_PAD_98
* @param                SIUL_PAD_99
* @param                SIUL_PAD_100
* @param                SIUL_PAD_101
* @param                SIUL_PAD_102
* @param                SIUL_PAD_103
* @param                SIUL_PAD_104
* @param                SIUL_PAD_105
* @param                SIUL_PAD_106
* @param                SIUL_PAD_107
* @param                SIUL_PAD_108
* @param                SIUL_PAD_109
* @param                SIUL_PAD_110
* @param                SIUL_PAD_111
* @param                SIUL_PAD_112
* @param                SIUL_PAD_113
* @param                SIUL_PAD_114
* @param                SIUL_PAD_115
* @param                SIUL_PAD_116
* @param                SIUL_PAD_117
* @param                SIUL_PAD_118
* @param                SIUL_PAD_119
* @param                SIUL_PAD_120
* @param                SIUL_PAD_121
* @param                SIUL_PAD_122
*
* @return               NULL
*
* @details              The #SIUL_TOGGLE_PAD ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_TOGGLE_PAD, SIUL_PAD_0);
* \endcode
*
*******************************************************************************/
#define SIUL_TOGGLE_PAD

/***************************************************************************//*!
*
* @brief                Read GPIO input value on dedicated pad.
*
* @param                SIUL_PAD_0
* @param                SIUL_PAD_1
* @param                SIUL_PAD_2
* @param                SIUL_PAD_3
* @param                SIUL_PAD_4
* @param                SIUL_PAD_5
* @param                SIUL_PAD_6
* @param                SIUL_PAD_7
* @param                SIUL_PAD_8
* @param                SIUL_PAD_9
* @param                SIUL_PAD_10
* @param                SIUL_PAD_11
* @param                SIUL_PAD_12
* @param                SIUL_PAD_13
* @param                SIUL_PAD_14
* @param                SIUL_PAD_15
* @param                SIUL_PAD_16
* @param                SIUL_PAD_17
* @param                SIUL_PAD_18
* @param                SIUL_PAD_19
* @param                SIUL_PAD_20
* @param                SIUL_PAD_21
* @param                SIUL_PAD_22
* @param                SIUL_PAD_23
* @param                SIUL_PAD_24
* @param                SIUL_PAD_25
* @param                SIUL_PAD_26
* @param                SIUL_PAD_27
* @param                SIUL_PAD_28
* @param                SIUL_PAD_29
* @param                SIUL_PAD_30
* @param                SIUL_PAD_31
* @param                SIUL_PAD_32
* @param                SIUL_PAD_33
* @param                SIUL_PAD_34
* @param                SIUL_PAD_35
* @param                SIUL_PAD_36
* @param                SIUL_PAD_37
* @param                SIUL_PAD_38
* @param                SIUL_PAD_39
* @param                SIUL_PAD_40
* @param                SIUL_PAD_41
* @param                SIUL_PAD_42
* @param                SIUL_PAD_43
* @param                SIUL_PAD_44
* @param                SIUL_PAD_45
* @param                SIUL_PAD_46
* @param                SIUL_PAD_47
* @param                SIUL_PAD_48
* @param                SIUL_PAD_49
* @param                SIUL_PAD_50
* @param                SIUL_PAD_51
* @param                SIUL_PAD_52
* @param                SIUL_PAD_53
* @param                SIUL_PAD_54
* @param                SIUL_PAD_55
* @param                SIUL_PAD_56
* @param                SIUL_PAD_57
* @param                SIUL_PAD_58
* @param                SIUL_PAD_59
* @param                SIUL_PAD_60
* @param                SIUL_PAD_61
* @param                SIUL_PAD_62
* @param                SIUL_PAD_63
* @param                SIUL_PAD_64
* @param                SIUL_PAD_65
* @param                SIUL_PAD_66
* @param                SIUL_PAD_67
* @param                SIUL_PAD_68
* @param                SIUL_PAD_69
* @param                SIUL_PAD_70
* @param                SIUL_PAD_71
* @param                SIUL_PAD_72
* @param                SIUL_PAD_73
* @param                SIUL_PAD_74
* @param                SIUL_PAD_75
* @param                SIUL_PAD_76
* @param                SIUL_PAD_77
* @param                SIUL_PAD_78
* @param                SIUL_PAD_79
* @param                SIUL_PAD_80
* @param                SIUL_PAD_81
* @param                SIUL_PAD_82
* @param                SIUL_PAD_83
* @param                SIUL_PAD_84
* @param                SIUL_PAD_85
* @param                SIUL_PAD_86
* @param                SIUL_PAD_87
* @param                SIUL_PAD_88
* @param                SIUL_PAD_89
* @param                SIUL_PAD_90
* @param                SIUL_PAD_91
* @param                SIUL_PAD_92
* @param                SIUL_PAD_93
* @param                SIUL_PAD_94
* @param                SIUL_PAD_95
* @param                SIUL_PAD_96
* @param                SIUL_PAD_97
* @param                SIUL_PAD_98
* @param                SIUL_PAD_99
* @param                SIUL_PAD_100
* @param                SIUL_PAD_101
* @param                SIUL_PAD_102
* @param                SIUL_PAD_103
* @param                SIUL_PAD_104
* @param                SIUL_PAD_105
* @param                SIUL_PAD_106
* @param                SIUL_PAD_107
* @param                SIUL_PAD_108
* @param                SIUL_PAD_109
* @param                SIUL_PAD_110
* @param                SIUL_PAD_111
* @param                SIUL_PAD_112
* @param                SIUL_PAD_113
* @param                SIUL_PAD_114
* @param                SIUL_PAD_115
* @param                SIUL_PAD_116
* @param                SIUL_PAD_117
* @param                SIUL_PAD_118
* @param                SIUL_PAD_119
* @param                SIUL_PAD_120
* @param                SIUL_PAD_121
* @param                SIUL_PAD_122
*
* @return               8bit value
*
* @details              The #SIUL_READ_INP_VALUE_PAD ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint8_t u8RetVal;
* u8RetVal = ioctl(SIUL_BASE,SIUL_READ_INP_VALUE_PAD, SIUL_PAD_0);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_INP_VALUE_PAD

/***************************************************************************//*!
*
* @brief                Read parallel GPIO pad data Out register value.
*
* @param                NULL
*
* @return               32bit PGPDO0 register value
*
* @details              The #SIUL_READ_VALUE_REG_PGPDO0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_PGPDO0, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_PGPDO0

/***************************************************************************//*!
*
* @brief                Read parallel GPIO pad data Out register value.
*
* @param                NULL
*
* @return               32bit PGPDO0 register value
*
* @details              The #SIUL_READ_VALUE_REG_PGPDO1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_PGPDO1, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_PGPDO1

/***************************************************************************//*!
*
* @brief                Read parallel GPIO pad data Out register value.
*
* @param                NULL
*
* @return               32bit PGPDO0 register value
*
* @details              The #SIUL_READ_VALUE_REG_PGPDO2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_PGPDO2, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_PGPDO2

/***************************************************************************//*!
*
* @brief                Read parallel GPIO pad data Out register value.
*
* @param                NULL
*
* @return               32bit PGPDO0 register value
*
* @details              The #SIUL_READ_VALUE_REG_PGPDO3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_PGPDO3, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_PGPDO3

/***************************************************************************//*!
*
* @brief                Read parallel GPIO pad data Out register value.
*
* @param                NULL
*
* @return               32bit PGPDO0 register value
*
* @details              The #SIUL_READ_VALUE_REG_PGPDO4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_PGPDO4, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_PGPDO4

/***************************************************************************//*!
*
* @brief                Write value to parallel GPIO register to set pad value.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VLAUE_REG_PGPDO0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VLAUE_REG_PGPDO0, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VLAUE_REG_PGPDO0

/***************************************************************************//*!
*
* @brief                Write value to parallel GPIO register to set pad value.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VLAUE_REG_PGPDO1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VLAUE_REG_PGPDO1, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VLAUE_REG_PGPDO1

/***************************************************************************//*!
*
* @brief                Write value to parallel GPIO register to set pad value.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VLAUE_REG_PGPDO2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VLAUE_REG_PGPDO2, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VLAUE_REG_PGPDO2

/***************************************************************************//*!
*
* @brief                Write value to parallel GPIO register to set pad value.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VLAUE_REG_PGPDO3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VLAUE_REG_PGPDO3, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VLAUE_REG_PGPDO3

/***************************************************************************//*!
*
* @brief                Write value to parallel GPIO register to set pad value.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VLAUE_REG_PGPDO4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VLAUE_REG_PGPDO4, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VLAUE_REG_PGPDO4

/***************************************************************************//*!
*
* @brief                Read parallel GPIO pad data IN register value.
*
* @param                NULL
*
* @return               32bit PGPDI0 register value
*
* @details              The #SIUL_READ_VALUE_REG_PGPDI0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_PGPDI0, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_PGPDI0

/***************************************************************************//*!
*
* @brief                Read parallel GPIO pad data IN register value.
*
* @param                NULL
*
* @return               32bit PGPDI1 register value
*
* @details              The #SIUL_READ_VALUE_REG_PGPDI1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_PGPDI1, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_PGPDI1

/***************************************************************************//*!
*
* @brief                Read parallel GPIO pad data IN register value.
*
* @param                NULL
*
* @return               32bit PGPDI2 register value
*
* @details              The #SIUL_READ_VALUE_REG_PGPDI2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_PGPDI2, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_PGPDI2

/***************************************************************************//*!
*
* @brief                Read parallel GPIO pad data IN register value.
*
* @param                NULL
*
* @return               32bit PGPDI3 register value
*
* @details              The #SIUL_READ_VALUE_REG_PGPDI3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_PGPDI3, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_PGPDI3

/***************************************************************************//*!
*
* @brief                Read parallel GPIO pad data IN register value.
*
* @param                NULL
*
* @return               32bit PGPDI3 register value
*
* @details              The #SIUL_READ_VALUE_REG_PGPDI4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_PGPDI4, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_PGPDI4

/***************************************************************************//*!
*
* @brief                Write value to masked parallel GPIO register.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VALUE_REG_MPGPDO0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VALUE_REG_MPGPDO0, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VALUE_REG_MPGPDO0

/***************************************************************************//*!
*
* @brief                Write value to masked parallel GPIO register.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VALUE_REG_MPGPDO1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VALUE_REG_MPGPDO1, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VALUE_REG_MPGPDO1

/***************************************************************************//*!
*
* @brief                Write value to masked parallel GPIO register.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VALUE_REG_MPGPDO2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VALUE_REG_MPGPDO2, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VALUE_REG_MPGPDO2

/***************************************************************************//*!
*
* @brief                Write value to masked parallel GPIO register.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VALUE_REG_MPGPDO3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VALUE_REG_MPGPDO3, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VALUE_REG_MPGPDO3

/***************************************************************************//*!
*
* @brief                Write value to masked parallel GPIO register.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VALUE_REG_MPGPDO4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VALUE_REG_MPGPDO4, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VALUE_REG_MPGPDO4

/***************************************************************************//*!
*
* @brief                Write value to masked parallel GPIO register.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VALUE_REG_MPGPDO5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VALUE_REG_MPGPDO5, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VALUE_REG_MPGPDO5

/***************************************************************************//*!
*
* @brief                Write value to masked parallel GPIO register.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VALUE_REG_MPGPDO6 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VALUE_REG_MPGPDO6, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VALUE_REG_MPGPDO6

/***************************************************************************//*!
*
* @brief                Write value to masked parallel GPIO register.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VALUE_REG_MPGPDO7 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VALUE_REG_MPGPDO7, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VALUE_REG_MPGPDO7

/***************************************************************************//*!
*
* @brief                Write value to masked parallel GPIO register.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VALUE_REG_MPGPDO8 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VALUE_REG_MPGPDO8, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VALUE_REG_MPGPDO8

/***************************************************************************//*!
*
* @brief                Write value to masked parallel GPIO register.
*
* @param                32bit value
*
* @return               NULL
*
* @details              The #SIUL_WRITE_VALUE_REG_MPGPDO9 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_VALUE_REG_MPGPDO9, 32bit value);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_VALUE_REG_MPGPDO9

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_0, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_0

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_0, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_0

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_1, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_1

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_1, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_1

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_2, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_2

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_2, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_2

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_3, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_3

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_3, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_3

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_4, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_4

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_4, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_4

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_5, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_5

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_5, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_5

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_6 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_6, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_6

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_6 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_6, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_6

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_7 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_7, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_7

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_7 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_7, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_7

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_8 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_8, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_8

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_8 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_8, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_8

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_9 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_9, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_9

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_9 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_9, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_9

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_10 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_10, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_10

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_10 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_10, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_10

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_11 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_11, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_11

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_11 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_11, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_11

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_12 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_12, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_12

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_12 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_12, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_12

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_13 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_13, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_13

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_13 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_13, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_13

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_14 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_14, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_14

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_14 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_14, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_14

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_15 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_15, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_15

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_15 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_15, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_15

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_16 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_16, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_16

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_16 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_16, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_16

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_17 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_17, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_17

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_17 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_17, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_17

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_18 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_18, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_18

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_18 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_18, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_18

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_19 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_19, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_19

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_19 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_19, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_19

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_20 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_20, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_20

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_20 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_20, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_20

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_21 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_21, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_21

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_21 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_21, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_21

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_22 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_22, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_22

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_22 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_22, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_22

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter counter value.
*
* @param                SIUL_MAXCNT0
* @param                SIUL_MAXCNT1
* @param                SIUL_MAXCNT2
* @param                SIUL_MAXCNT3
* @param                SIUL_MAXCNT4
* @param                SIUL_MAXCNT5
* @param                SIUL_MAXCNT6
* @param                SIUL_MAXCNT7
* @param                SIUL_MAXCNT8
* @param                SIUL_MAXCNT9
* @param                SIUL_MAXCNT10
* @param                SIUL_MAXCNT11
* @param                SIUL_MAXCNT12
* @param                SIUL_MAXCNT13
* @param                SIUL_MAXCNT14
* @param                SIUL_MAXCNT15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CNT_23 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CNT_23, SIUL_MAXCNT0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CNT_23

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_23 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_23, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_23

/***************************************************************************//*!
*
* @brief                Read maximum interrupt filter counter value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFMC_31 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFMC_31, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFMC_31

/***************************************************************************//*!
*
* @brief                Configure digital glitch filter clock prescaler value.
*
* @param                SIUL_IFCP0
* @param                SIUL_IFCP1
* @param                SIUL_IFCP2
* @param                SIUL_IFCP3
* @param                SIUL_IFCP4
* @param                SIUL_IFCP5
* @param                SIUL_IFCP6
* @param                SIUL_IFCP7
* @param                SIUL_IFCP8
* @param                SIUL_IFCP9
* @param                SIUL_IFCP10
* @param                SIUL_IFCP11
* @param                SIUL_IFCP12
* @param                SIUL_IFCP13
* @param                SIUL_IFCP14
* @param                SIUL_IFCP15
*
* @return               NULL
*
* @details              The #SIUL_WRITE_INT_FILT_CLK_PRESC ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(SIUL_BASE,SIUL_WRITE_INT_FILT_CLK_PRESC, SIUL_IFCP0);
* \endcode
*
*******************************************************************************/
#define SIUL_WRITE_INT_FILT_CLK_PRESC

/***************************************************************************//*!
*
* @brief                Read interrupt filter clock prescaler value .
*
* @param                NULL
*
* @return               32bit register value
*
* @details              The #SIUL_READ_VALUE_REG_IFCPR ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(SIUL_BASE,SIUL_READ_VALUE_REG_IFCPR, NULL);
* \endcode
*
*******************************************************************************/
#define SIUL_READ_VALUE_REG_IFCPR


/******************************************************************************
* SIUL bitfield masks definition
*******************************************************************************/
#define SIUL_PA_MASK                                    0x0C00


/******************************************************************************
* SIUL register offset definition
*******************************************************************************/

#define SIUL_ISR_OFFSET                                 0x14
#define SIUL_IRER_OFFSET                                0x18
#define SIUL_IREER_OFFSET                               0x28
#define SIUL_IFEER_OFFSET                               0x2C
#define SIUL_IFER_OFFSET                                0x30
#define SIUL_PCR0_OFFSET                                0x40
#define SIUL_PCR1_OFFSET                                0x42
#define SIUL_PCR2_OFFSET                                0x44
#define SIUL_PCR3_OFFSET                                0x46
#define SIUL_PCR4_OFFSET                                0x48
#define SIUL_PCR5_OFFSET                                0x4A
#define SIUL_PCR6_OFFSET                                0x4C
#define SIUL_PCR7_OFFSET                                0x4E
#define SIUL_PCR8_OFFSET                                0x50
#define SIUL_PCR9_OFFSET                                0x52
#define SIUL_PCR10_OFFSET                               0x54
#define SIUL_PCR11_OFFSET                               0x56
#define SIUL_PCR12_OFFSET                               0x58
#define SIUL_PCR13_OFFSET                               0x5A
#define SIUL_PCR14_OFFSET                               0x5C
#define SIUL_PCR15_OFFSET                               0x5E
#define SIUL_PCR16_OFFSET                               0x60
#define SIUL_PCR17_OFFSET                               0x62
#define SIUL_PCR18_OFFSET                               0x64
#define SIUL_PCR19_OFFSET                               0x66
#define SIUL_PCR20_OFFSET                               0x68
#define SIUL_PCR21_OFFSET                               0x6A
#define SIUL_PCR22_OFFSET                               0x6C
#define SIUL_PCR23_OFFSET                               0x6E
#define SIUL_PCR24_OFFSET                               0x70
#define SIUL_PCR25_OFFSET                               0x72
#define SIUL_PCR26_OFFSET                               0x74
#define SIUL_PCR27_OFFSET                               0x76
#define SIUL_PCR28_OFFSET                               0x78
#define SIUL_PCR29_OFFSET                               0x7A
#define SIUL_PCR30_OFFSET                               0x7C
#define SIUL_PCR31_OFFSET                               0x7E
#define SIUL_PCR32_OFFSET                               0x80
#define SIUL_PCR33_OFFSET                               0x82
#define SIUL_PCR34_OFFSET                               0x84
#define SIUL_PCR35_OFFSET                               0x86
#define SIUL_PCR36_OFFSET                               0x88
#define SIUL_PCR37_OFFSET                               0x8A
#define SIUL_PCR38_OFFSET                               0x8C
#define SIUL_PCR39_OFFSET                               0x8E
#define SIUL_PCR40_OFFSET                               0x90
#define SIUL_PCR41_OFFSET                               0x92
#define SIUL_PCR42_OFFSET                               0x94
#define SIUL_PCR43_OFFSET                               0x96
#define SIUL_PCR44_OFFSET                               0x98
#define SIUL_PCR45_OFFSET                               0x9A
#define SIUL_PCR46_OFFSET                               0x9C
#define SIUL_PCR47_OFFSET                               0x9E
#define SIUL_PCR48_OFFSET                               0xA0
#define SIUL_PCR49_OFFSET                               0xA2
#define SIUL_PCR50_OFFSET                               0xA4
#define SIUL_PCR51_OFFSET                               0xA6
#define SIUL_PCR52_OFFSET                               0xA8
#define SIUL_PCR53_OFFSET                               0xAA
#define SIUL_PCR54_OFFSET                               0xAC
#define SIUL_PCR55_OFFSET                               0xAE
#define SIUL_PCR56_OFFSET                               0xB0
#define SIUL_PCR57_OFFSET                               0xB2
#define SIUL_PCR58_OFFSET                               0xB4
#define SIUL_PCR59_OFFSET                               0xB6
#define SIUL_PCR60_OFFSET                               0xB8
#define SIUL_PCR61_OFFSET                               0xBA
#define SIUL_PCR62_OFFSET                               0xBC
#define SIUL_PCR63_OFFSET                               0xBE
#define SIUL_PCR64_OFFSET                               0xC0
#define SIUL_PCR65_OFFSET                               0xC2
#define SIUL_PCR66_OFFSET                               0xC4
#define SIUL_PCR67_OFFSET                               0xC6
#define SIUL_PCR68_OFFSET                               0xC8
#define SIUL_PCR69_OFFSET                               0xCA
#define SIUL_PCR70_OFFSET                               0xCC
#define SIUL_PCR71_OFFSET                               0xCE
#define SIUL_PCR72_OFFSET                               0xD0
#define SIUL_PCR73_OFFSET                               0xD2
#define SIUL_PCR74_OFFSET                               0xD4
#define SIUL_PCR75_OFFSET                               0xD6
#define SIUL_PCR76_OFFSET                               0xD8
#define SIUL_PCR77_OFFSET                               0xDA
#define SIUL_PCR78_OFFSET                               0xDC
#define SIUL_PCR79_OFFSET                               0xDE
#define SIUL_PCR80_OFFSET                               0xE0
#define SIUL_PCR81_OFFSET                               0xE2
#define SIUL_PCR82_OFFSET                               0xE4
#define SIUL_PCR83_OFFSET                               0xE6
#define SIUL_PCR84_OFFSET                               0xE8
#define SIUL_PCR85_OFFSET                               0xEA
#define SIUL_PCR86_OFFSET                               0xEC
#define SIUL_PCR87_OFFSET                               0xEE
#define SIUL_PCR88_OFFSET                               0xF0
#define SIUL_PCR89_OFFSET                               0xF2
#define SIUL_PCR90_OFFSET                               0xF4
#define SIUL_PCR91_OFFSET                               0xF6
#define SIUL_PCR92_OFFSET                               0xF8
#define SIUL_PCR93_OFFSET                               0xFA
#define SIUL_PCR94_OFFSET                               0xFC
#define SIUL_PCR95_OFFSET                               0xFE
#define SIUL_PCR96_OFFSET                               0x100
#define SIUL_PCR97_OFFSET                               0x102
#define SIUL_PCR98_OFFSET                               0x104
#define SIUL_PCR99_OFFSET                               0x106
#define SIUL_PCR100_OFFSET                              0x108
#define SIUL_PCR101_OFFSET                              0x10A
#define SIUL_PCR102_OFFSET                              0x10C
#define SIUL_PCR103_OFFSET                              0x10E
#define SIUL_PCR104_OFFSET                              0x110
#define SIUL_PCR105_OFFSET                              0x112
#define SIUL_PCR106_OFFSET                              0x114
#define SIUL_PCR107_OFFSET                              0x116
#define SIUL_PCR108_OFFSET                              0x118
#define SIUL_PCR109_OFFSET                              0x11A
#define SIUL_PCR110_OFFSET                              0x11C
#define SIUL_PCR111_OFFSET                              0x11E
#define SIUL_PCR112_OFFSET                              0x120
#define SIUL_PCR113_OFFSET                              0x122
#define SIUL_PCR114_OFFSET                              0x124
#define SIUL_PCR115_OFFSET                              0x126
#define SIUL_PCR116_OFFSET                              0x128
#define SIUL_PCR117_OFFSET                              0x12A
#define SIUL_PCR118_OFFSET                              0x12C
#define SIUL_PCR119_OFFSET                              0x12E
#define SIUL_PCR120_OFFSET                              0x130
#define SIUL_PCR121_OFFSET                              0x132
#define SIUL_PCR122_OFFSET                              0x134
#define SIUL_GPDOX_OFFSET                               0x0600
#define SIUL_GPDIX_OFFSET                               0x800
#define SIUL_PGPDO_0_OFFSET                             0xC00
#define SIUL_PGPDO_1_OFFSET                             0xC04
#define SIUL_PGPDO_2_OFFSET                             0xC08
#define SIUL_PGPDO_3_OFFSET                             0xC0C
#define SIUL_PGPDO_4_OFFSET                             0xC10
#define SIUL_PGPDI_0_OFFSET                             0xC40
#define SIUL_PGPDI_1_OFFSET                             0xC44
#define SIUL_PGPDI_2_OFFSET                             0xC48
#define SIUL_PGPDI_3_OFFSET                             0xC4C
#define SIUL_PGPDI_4_OFFSET                             0xC50
#define SIUL_MPGPDO_0_OFFSET                            0xC80
#define SIUL_MPGPDO_1_OFFSET                            0xC84
#define SIUL_MPGPDO_2_OFFSET                            0xC88
#define SIUL_MPGPDO_3_OFFSET                            0xC8C
#define SIUL_MPGPDO_4_OFFSET                            0xC90
#define SIUL_MPGPDO_5_OFFSET                            0xC94
#define SIUL_MPGPDO_6_OFFSET                            0xC98
#define SIUL_MPGPDO_7_OFFSET                            0xC9C
#define SIUL_MPGPDO_8_OFFSET                            0xCA0
#define SIUL_MPGPDO_9_OFFSET                            0xCA4
#define SIUL_IFMC0_OFFSET                               0x1000
#define SIUL_IFMC1_OFFSET                               0x1004
#define SIUL_IFMC2_OFFSET                               0x1008
#define SIUL_IFMC3_OFFSET                               0x100C
#define SIUL_IFMC4_OFFSET                               0x1010
#define SIUL_IFMC5_OFFSET                               0x1014
#define SIUL_IFMC6_OFFSET                               0x1018
#define SIUL_IFMC7_OFFSET                               0x101C
#define SIUL_IFMC8_OFFSET                               0x1020
#define SIUL_IFMC9_OFFSET                               0x1024
#define SIUL_IFMC10_OFFSET                              0x1028
#define SIUL_IFMC11_OFFSET                              0x102C
#define SIUL_IFMC12_OFFSET                              0x1030
#define SIUL_IFMC13_OFFSET                              0x1034
#define SIUL_IFMC14_OFFSET                              0x1038
#define SIUL_IFMC15_OFFSET                              0x103C
#define SIUL_IFMC16_OFFSET                              0x1040
#define SIUL_IFMC17_OFFSET                              0x1044
#define SIUL_IFMC18_OFFSET                              0x1048
#define SIUL_IFMC19_OFFSET                              0x104C
#define SIUL_IFMC20_OFFSET                              0x1050
#define SIUL_IFMC21_OFFSET                              0x1054
#define SIUL_IFMC22_OFFSET                              0x1058
#define SIUL_IFMC23_OFFSET                              0x105C
#define SIUL_IFCPR_OFFSET                               0x1080

/******************************************************************************
* SIUL MACRO and ioctl parameters definition
*******************************************************************************/

#define SIUL_EXT_INT_0                                  0x00000001
#define SIUL_EXT_INT_1                                  0x00000002
#define SIUL_EXT_INT_2                                  0x00000004
#define SIUL_EXT_INT_3                                  0x00000008
#define SIUL_EXT_INT_4                                  0x00000010
#define SIUL_EXT_INT_5                                  0x00000020
#define SIUL_EXT_INT_6                                  0x00000040
#define SIUL_EXT_INT_7                                  0x00000080
#define SIUL_EXT_INT_8                                  0x00000100
#define SIUL_EXT_INT_9                                  0x00000200
#define SIUL_EXT_INT_10                                 0x00000400
#define SIUL_EXT_INT_11                                 0x00000800
#define SIUL_EXT_INT_12                                 0x00001000
#define SIUL_EXT_INT_13                                 0x00002000
#define SIUL_EXT_INT_14                                 0x00004000
#define SIUL_EXT_INT_15                                 0x00008000
#define SIUL_EXT_INT_16                                 0x00010000
#define SIUL_EXT_INT_17                                 0x00020000
#define SIUL_EXT_INT_18                                 0x00040000
#define SIUL_EXT_INT_19                                 0x00080000
#define SIUL_EXT_INT_20                                 0x00100000
#define SIUL_EXT_INT_21                                 0x00200000
#define SIUL_EXT_INT_22                                 0x00400000
#define SIUL_EXT_INT_23                                 0x00800000
#define SIUL_REQ_0                                      0x00000001
#define SIUL_REQ_1                                      0x00000002
#define SIUL_REQ_2                                      0x00000004
#define SIUL_REQ_3                                      0x00000008
#define SIUL_REQ_4                                      0x00000010
#define SIUL_REQ_5                                      0x00000020
#define SIUL_REQ_6                                      0x00000040
#define SIUL_REQ_7                                      0x00000080
#define SIUL_REQ_8                                      0x00000100
#define SIUL_REQ_9                                      0x00000200
#define SIUL_REQ_10                                     0x00000400
#define SIUL_REQ_11                                     0x00000800
#define SIUL_REQ_12                                     0x00001000
#define SIUL_REQ_13                                     0x00002000
#define SIUL_REQ_14                                     0x00004000
#define SIUL_REQ_15                                     0x00008000
#define SIUL_REQ_16                                     0x00010000
#define SIUL_REQ_17                                     0x00020000
#define SIUL_REQ_18                                     0x00040000
#define SIUL_REQ_19                                     0x00080000
#define SIUL_REQ_20                                     0x00100000
#define SIUL_REQ_21                                     0x00200000
#define SIUL_REQ_22                                     0x00400000
#define SIUL_REQ_23                                     0x00800000
#define SIUL_SEL_PULL_UP                                0x0001
#define SIUL_PULL_UP_DOWN_ENBL                          0x0002
#define SIUL_FAST_SR                                    0x0004
#define SIUL_OPEN_DRAIN_ENBL                            0x0020
#define SIUL_INPUT_ENBL                                 0x0100
#define SIUL_OUTPUT_ENBL                                0x0200
#define SIUL_SET_GPIO                                   0x0000
#define SIUL_SET_ATL_MODE1                              0x0400
#define SIUL_SET_ATL_MODE2                              0x0800
#define SIUL_SET_ATL_MODE3                              0x0C00
#define SIUL_ANALOG                                     0x2000
#define SIUL_SAFE_MODE                                  0x4000
#define SIUL_GPIO_IN                                    SIUL_INPUT_ENBL | SIUL_SET_GPIO
#define SIUL_GPIO_OUT                                   SIUL_OUTPUT_ENBL | SIUL_SET_GPIO
#define SIUL_ALT1_OUT                                   SIUL_OUTPUT_ENBL | SIUL_SET_ATL_MODE1
#define SIUL_ALT2_OUT                                   SIUL_OUTPUT_ENBL | SIUL_SET_ATL_MODE2
#define SIUL_ALT3_OUT                                   SIUL_OUTPUT_ENBL | SIUL_SET_ATL_MODE3
#define SIUL_PAD_0                                      0x0
#define SIUL_PAD_1                                      0x1
#define SIUL_PAD_2                                      0x2
#define SIUL_PAD_3                                      0x3
#define SIUL_PAD_4                                      0x4
#define SIUL_PAD_5                                      0x5
#define SIUL_PAD_6                                      0x6
#define SIUL_PAD_7                                      0x7
#define SIUL_PAD_8                                      0x8
#define SIUL_PAD_9                                      0x9
#define SIUL_PAD_10                                     0xA
#define SIUL_PAD_11                                     0xB
#define SIUL_PAD_12                                     0xC
#define SIUL_PAD_13                                     0xD
#define SIUL_PAD_14                                     0xE
#define SIUL_PAD_15                                     0xF
#define SIUL_PAD_16                                     0x10
#define SIUL_PAD_17                                     0x11
#define SIUL_PAD_18                                     0x12
#define SIUL_PAD_19                                     0x13
#define SIUL_PAD_20                                     0x14
#define SIUL_PAD_21                                     0x15
#define SIUL_PAD_22                                     0x16
#define SIUL_PAD_23                                     0x17
#define SIUL_PAD_24                                     0x18
#define SIUL_PAD_25                                     0x19
#define SIUL_PAD_26                                     0x1A
#define SIUL_PAD_27                                     0x1B
#define SIUL_PAD_28                                     0x1C
#define SIUL_PAD_29                                     0x1D
#define SIUL_PAD_30                                     0x1E
#define SIUL_PAD_31                                     0x1F
#define SIUL_PAD_32                                     0x20
#define SIUL_PAD_33                                     0x21
#define SIUL_PAD_34                                     0x22
#define SIUL_PAD_35                                     0x23
#define SIUL_PAD_36                                     0x24
#define SIUL_PAD_37                                     0x25
#define SIUL_PAD_38                                     0x26
#define SIUL_PAD_39                                     0x27
#define SIUL_PAD_40                                     0x28
#define SIUL_PAD_41                                     0x29
#define SIUL_PAD_42                                     0x2A
#define SIUL_PAD_43                                     0x2B
#define SIUL_PAD_44                                     0x2C
#define SIUL_PAD_45                                     0x2D
#define SIUL_PAD_46                                     0x2E
#define SIUL_PAD_47                                     0x2F
#define SIUL_PAD_48                                     0x30
#define SIUL_PAD_49                                     0x31
#define SIUL_PAD_50                                     0x32
#define SIUL_PAD_51                                     0x33
#define SIUL_PAD_52                                     0x34
#define SIUL_PAD_53                                     0x35
#define SIUL_PAD_54                                     0x36
#define SIUL_PAD_55                                     0x37
#define SIUL_PAD_56                                     0x38
#define SIUL_PAD_57                                     0x39
#define SIUL_PAD_58                                     0x3A
#define SIUL_PAD_59                                     0x3B
#define SIUL_PAD_60                                     0x3C
#define SIUL_PAD_61                                     0x3D
#define SIUL_PAD_62                                     0x3E
#define SIUL_PAD_63                                     0x3F
#define SIUL_PAD_64                                     0x40
#define SIUL_PAD_65                                     0x41
#define SIUL_PAD_66                                     0x42
#define SIUL_PAD_67                                     0x43
#define SIUL_PAD_68                                     0x44
#define SIUL_PAD_69                                     0x45
#define SIUL_PAD_70                                     0x46
#define SIUL_PAD_71                                     0x47
#define SIUL_PAD_72                                     0x48
#define SIUL_PAD_73                                     0x49
#define SIUL_PAD_74                                     0x4A
#define SIUL_PAD_75                                     0x4B
#define SIUL_PAD_76                                     0x4C
#define SIUL_PAD_77                                     0x4D
#define SIUL_PAD_78                                     0x4E
#define SIUL_PAD_79                                     0x4F
#define SIUL_PAD_80                                     0x50
#define SIUL_PAD_81                                     0x51
#define SIUL_PAD_82                                     0x52
#define SIUL_PAD_83                                     0x53
#define SIUL_PAD_84                                     0x54
#define SIUL_PAD_85                                     0x55
#define SIUL_PAD_86                                     0x56
#define SIUL_PAD_87                                     0x57
#define SIUL_PAD_88                                     0x58
#define SIUL_PAD_89                                     0x59
#define SIUL_PAD_90                                     0x5A
#define SIUL_PAD_91                                     0x5B
#define SIUL_PAD_92                                     0x5C
#define SIUL_PAD_93                                     0x5D
#define SIUL_PAD_94                                     0x5E
#define SIUL_PAD_95                                     0x5F
#define SIUL_PAD_96                                     0x60
#define SIUL_PAD_97                                     0x61
#define SIUL_PAD_98                                     0x62
#define SIUL_PAD_99                                     0x63
#define SIUL_PAD_100                                    0x64
#define SIUL_PAD_101                                    0x65
#define SIUL_PAD_102                                    0x66
#define SIUL_PAD_103                                    0x67
#define SIUL_PAD_104                                    0x68
#define SIUL_PAD_105                                    0x69
#define SIUL_PAD_106                                    0x6A
#define SIUL_PAD_107                                    0x6B
#define SIUL_PAD_108                                    0x6C
#define SIUL_PAD_109                                    0x6D
#define SIUL_PAD_110                                    0x6E
#define SIUL_PAD_111                                    0x6F
#define SIUL_PAD_112                                    0x70
#define SIUL_PAD_113                                    0x71
#define SIUL_PAD_114                                    0x72
#define SIUL_PAD_115                                    0x73
#define SIUL_PAD_116                                    0x74
#define SIUL_PAD_117                                    0x75
#define SIUL_PAD_118                                    0x76
#define SIUL_PAD_119                                    0x77
#define SIUL_PAD_120                                    0x78
#define SIUL_PAD_121                                    0x79
#define SIUL_PAD_122                                    0x7A
#define SIUL_MAXCNT0                                    0x0
#define SIUL_MAXCNT1                                    0x1
#define SIUL_MAXCNT2                                    0x2
#define SIUL_MAXCNT3                                    0x3
#define SIUL_MAXCNT4                                    0x4
#define SIUL_MAXCNT5                                    0x5
#define SIUL_MAXCNT6                                    0x6
#define SIUL_MAXCNT7                                    0x7
#define SIUL_MAXCNT8                                    0x8
#define SIUL_MAXCNT9                                    0x9
#define SIUL_MAXCNT10                                   0xA
#define SIUL_MAXCNT11                                   0xB
#define SIUL_MAXCNT12                                   0xC
#define SIUL_MAXCNT13                                   0xD
#define SIUL_MAXCNT14                                   0xE
#define SIUL_MAXCNT15                                   0xF
#define SIUL_IFCP0                                      0x0
#define SIUL_IFCP1                                      0x1
#define SIUL_IFCP2                                      0x2
#define SIUL_IFCP3                                      0x3
#define SIUL_IFCP4                                      0x4
#define SIUL_IFCP5                                      0x5
#define SIUL_IFCP6                                      0x6
#define SIUL_IFCP7                                      0x7
#define SIUL_IFCP8                                      0x8
#define SIUL_IFCP9                                      0x9
#define SIUL_IFCP10                                     0xA
#define SIUL_IFCP11                                     0xB
#define SIUL_IFCP12                                     0xC
#define SIUL_IFCP13                                     0xD
#define SIUL_IFCP14                                     0xE
#define SIUL_IFCP15                                     0xF

/*******************************************************************************
* SIUL ioctl commands implementation
*******************************************************************************/

#define ioctlSIUL_CLEAR_INT_FLAG(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_ISR_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_ISR(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_ISR_OFFSET))

#define ioctlSIUL_READ_VALUE_REG_IRER(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IRER_OFFSET))

#define ioctlSIUL_ENABLE_INT_REQ(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IRER_OFFSET)) = (param)

#define ioctlSIUL_DISABLE_INT_REQ(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IRER_OFFSET)) = (~param)

#define ioctlSIUL_ENABLE_RIS_EDGE_EVNT(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IREER_OFFSET)) = (param)

#define ioctlSIUL_DISABLE_RIS_EDGE_EVNT(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IREER_OFFSET)) = (~param)

#define ioctlSIUL_READ_VALUE_REG_IREER(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IREER_OFFSET))

#define ioctlSIUL_ENABLE_FALL_EDGE_EVNT(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFEER_OFFSET)) = (param)

#define ioctlSIUL_DISABLE_FALL_EDGE_EVNT(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFEER_OFFSET)) = (~param)

#define ioctlSIUL_READ_VALUE_REG_IFEER(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFEER_OFFSET))

#define ioctlSIUL_ENABLE_INT_FILT(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFER_OFFSET)) = (param)

#define ioctlSIUL_DISABLE_INT_FILT(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFER_OFFSET)) = (~param)

#define ioctlSIUL_READ_VALUE_REG_IFER(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFER_OFFSET))

#define ioctlSIUL_CONFIGURE_PAD_0(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR0_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_1(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR1_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_2(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR2_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_3(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR3_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_4(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR4_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_5(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR5_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_6(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR6_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_7(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR7_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_8(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR8_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_9(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR9_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_10(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR10_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_11(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR11_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_12(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR12_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_13(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR13_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_14(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR14_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_15(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR15_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_16(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR16_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_17(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR17_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_18(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR18_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_19(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR19_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_20(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR20_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_21(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR21_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_22(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR22_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_23(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR23_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_24(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR24_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_25(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR25_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_26(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR26_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_27(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR27_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_28(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR28_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_29(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR29_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_30(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR30_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_31(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR31_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_32(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR32_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_33(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR33_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_34(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR34_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_35(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR35_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_36(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR36_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_37(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR37_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_38(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR38_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_39(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR39_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_40(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR40_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_41(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR41_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_42(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR42_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_43(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR43_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_44(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR44_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_45(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR45_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_46(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR46_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_47(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR47_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_48(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR48_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_49(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR49_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_50(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR50_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_51(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR51_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_52(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR52_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_53(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR53_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_54(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR54_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_55(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR55_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_56(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR56_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_57(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR57_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_58(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR58_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_59(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR59_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_60(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR60_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_61(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR61_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_62(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR62_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_63(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR63_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_64(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR64_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_65(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR65_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_66(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR66_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_67(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR67_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_68(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR68_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_69(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR69_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_70(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR70_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_71(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR71_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_72(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR72_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_73(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR73_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_74(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR74_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_75(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR75_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_76(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR76_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_77(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR77_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_78(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR78_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_79(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR79_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_80(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR80_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_81(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR81_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_82(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR82_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_83(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR83_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_84(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR84_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_85(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR85_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_86(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR86_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_87(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR87_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_88(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR88_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_89(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR89_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_90(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR90_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_91(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR91_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_92(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR92_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_93(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR93_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_94(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR94_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_95(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR95_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_96(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR96_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_97(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR97_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_98(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR98_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_99(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR99_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_100(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR100_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_101(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR101_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_102(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR102_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_103(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR103_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_104(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR104_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_105(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR105_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_106(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR106_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_107(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR107_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_108(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR108_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_109(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR109_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_110(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR110_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_111(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR111_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_112(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR112_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_113(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR113_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_114(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR114_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_115(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR115_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_116(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR116_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_117(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR117_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_118(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR118_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_119(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR119_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_120(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR120_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_121(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR121_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_122(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR122_OFFSET)) = (param)

#define ioctlSIUL_CONFIGURE_PAD_GPIO(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR0_OFFSET +(2*param))) = (*((vuint16_t *)(siulAddr + SIUL_PCR0_OFFSET +(2*param))) & (~SIUL_PA_MASK)) | (SIUL_SET_GPIO)

#define ioctlSIUL_CONFIGURE_PAD_ALT1(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR0_OFFSET +(2*param))) = (*((vuint16_t *)(siulAddr + SIUL_PCR0_OFFSET +(2*param))) & (~SIUL_PA_MASK)) | (SIUL_SET_ATL_MODE1)

#define ioctlSIUL_CONFIGURE_PAD_ALT2(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR0_OFFSET +(2*param))) = (*((vuint16_t *)(siulAddr + SIUL_PCR0_OFFSET +(2*param))) & (~SIUL_PA_MASK)) | (SIUL_SET_ATL_MODE2)

#define ioctlSIUL_CONFIGURE_PAD_ALT3(siulAddr,param) \
        *((vuint16_t *)(siulAddr + SIUL_PCR0_OFFSET +(2*param))) = (*((vuint16_t *)(siulAddr + SIUL_PCR0_OFFSET +(2*param))) & (~SIUL_PA_MASK)) | (SIUL_SET_ATL_MODE3)

#define ioctlSIUL_SET_PAD(siulAddr,param) \
        *((vuint8_t *)(siulAddr + SIUL_GPDOX_OFFSET +(param))) = 1

#define ioctlSIUL_CLEAR_PAD(siulAddr,param) \
        *((vuint8_t *)(siulAddr + SIUL_GPDOX_OFFSET + (param))) = 0

#define ioctlSIUL_TOGGLE_PAD(siulAddr,param) \
        *((vuint8_t *)(siulAddr + SIUL_GPDOX_OFFSET+ (param))) = *((vuint8_t *)(siulAddr + SIUL_GPDOX_OFFSET+ (param))) ^ 1

#define ioctlSIUL_READ_INP_VALUE_PAD(siulAddr,param) \
        *((vuint8_t *)(siulAddr + SIUL_GPDIX_OFFSET + (param)))

#define ioctlSIUL_READ_VALUE_REG_PGPDO0(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDO_0_OFFSET))

#define ioctlSIUL_READ_VALUE_REG_PGPDO1(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDO_1_OFFSET))

#define ioctlSIUL_READ_VALUE_REG_PGPDO2(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDO_2_OFFSET))

#define ioctlSIUL_READ_VALUE_REG_PGPDO3(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDO_3_OFFSET))

#define ioctlSIUL_READ_VALUE_REG_PGPDO4(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDO_4_OFFSET))

#define ioctlSIUL_WRITE_VLAUE_REG_PGPDO0(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDO_0_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VLAUE_REG_PGPDO1(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDO_1_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VLAUE_REG_PGPDO2(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDO_2_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VLAUE_REG_PGPDO3(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDO_3_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VLAUE_REG_PGPDO4(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDO_4_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_PGPDI0(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDI_0_OFFSET))

#define ioctlSIUL_READ_VALUE_REG_PGPDI1(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDI_1_OFFSET))

#define ioctlSIUL_READ_VALUE_REG_PGPDI2(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDI_2_OFFSET))

#define ioctlSIUL_READ_VALUE_REG_PGPDI3(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDI_3_OFFSET))

#define ioctlSIUL_READ_VALUE_REG_PGPDI4(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_PGPDI_4_OFFSET))

#define ioctlSIUL_WRITE_VALUE_REG_MPGPDO0(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_MPGPDO_0_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VALUE_REG_MPGPDO1(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_MPGPDO_1_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VALUE_REG_MPGPDO2(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_MPGPDO_2_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VALUE_REG_MPGPDO3(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_MPGPDO_3_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VALUE_REG_MPGPDO4(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_MPGPDO_4_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VALUE_REG_MPGPDO5(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_MPGPDO_5_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VALUE_REG_MPGPDO6(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_MPGPDO_6_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VALUE_REG_MPGPDO7(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_MPGPDO_7_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VALUE_REG_MPGPDO8(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_MPGPDO_8_OFFSET)) = (param)

#define ioctlSIUL_WRITE_VALUE_REG_MPGPDO9(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_MPGPDO_9_OFFSET)) = (param)

#define ioctlSIUL_WRITE_INT_FILT_CNT_0(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC0_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_0(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC0_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_1(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC1_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_1(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC1_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_2(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC2_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_2(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC2_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_3(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC3_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_3(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC3_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_4(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC4_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_4(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC4_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_5(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC5_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_5(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC5_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_6(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC6_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_6(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC6_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_7(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC7_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_7(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC7_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_8(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC8_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_8(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC8_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_9(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC9_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_9(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC9_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_10(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC10_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_10(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC10_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_11(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC11_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_11(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC11_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_12(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC12_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_12(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC12_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_13(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC13_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_13(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC13_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_14(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC14_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_14(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC14_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_15(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC15_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_15(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC15_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_16(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC16_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_16(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC16_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_17(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC17_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_17(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC17_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_18(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC18_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_18(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC18_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_19(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC19_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_19(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC19_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_20(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC20_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_20(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC20_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_21(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC21_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_21(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC21_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_22(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC22_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_22(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC22_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CNT_23(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC23_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFMC_23(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFMC23_OFFSET))

#define ioctlSIUL_WRITE_INT_FILT_CLK_PRESC(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFCPR_OFFSET)) = (param)

#define ioctlSIUL_READ_VALUE_REG_IFCPR(siulAddr,param) \
        *((vuint32_t *)(siulAddr + SIUL_IFCPR_OFFSET))

#ifdef __cplusplus
}
#endif

#endif /* __MPC5606B_SIUL_LLD_H */