/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file       MPC5606B_ADC_LLD.h
*
* @author     b06050
*
* @version    1.0.2.0
*
* @date       Aug-3-2012
*
* @brief      ADC low level driver module for MPC5606B.
*
********************************************************************************
*
* This file includes initial setting and MACRO definitions of MPC5606B ADC
* peripheral module.
*
*******************************************************************************/
#ifndef __MPC5606B_ADC_LLD_H
#define __MPC5606B_ADC_LLD_H

#ifdef __cplusplus
extern "C" {
#endif

#define ADC0_BASE                                       0xFFE00000
#define ADC1_BASE                                       0xFFE04000

/*******************************************************************************
* ADC ioctl commands definitions
*******************************************************************************/
/***************************************************************************//*!
*
* @brief                Set the ADC power down mode.
*
* @param                ADC_ENABLE
* @param                ADC_DISABLE
*
* @return               NULL
*
* @details              The #ADC_POWERDOWN ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_POWERDOWN, ADC_ENABLE);
* \endcode
*
*******************************************************************************/
#define ADC_POWERDOWN

/***************************************************************************//*!
*
* @brief                Enable Auto clock off feature.
*
* @param                ADC_ENABLE
* @param                ADC_DISABLE
*
* @return               NULL
*
* @details              The #ADC_AUTO_CLOCK_OFF ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_AUTO_CLOCK_OFF, ADC_ENABLE);
* \endcode
*
*******************************************************************************/
#define ADC_AUTO_CLOCK_OFF

/***************************************************************************//*!
*
* @brief                Abort ADC Conversion.
*
* @param                ADC_ABORT
*
* @return               NULL
*
* @details              The #ADC_ABORT_CONVERSION ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_ABORT_CONVERSION, ADC_ABORT);
* \endcode
*
*******************************************************************************/
#define ADC_ABORT_CONVERSION

/***************************************************************************//*!
*
* @brief                Abort ongoing chain conversion.
*
* @param                ADC_ABORT_CHAIN
*
* @return               NULL
*
* @details              The #ADC_ABORT_CHAIN_CONVERSION ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_ABORT_CHAIN_CONVERSION, ADC_ABORT_CHAIN);
* \endcode
*
*******************************************************************************/
#define ADC_ABORT_CHAIN_CONVERSION

/***************************************************************************//*!
*
* @brief                Select ADC clock frequency.
*
* @param                ADC_SYS_CLK
* @param                ADC_HALF_SYS_CLK
*
* @return               NULL
*
* @details              The #ANALOG_CLOCK_FREQ_SEL ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ANALOG_CLOCK_FREQ_SEL, ADC_SYS_CLK);
* \endcode
*
*******************************************************************************/
#define ANALOG_CLOCK_FREQ_SEL

/***************************************************************************//*!
*
* @brief                Select ADC control mode.
*
* @param                ADC_CTU_DRIVEN
* @param                ADC_CPU_DRIVEN
*
* @return               NULL
*
* @details              The #ADC_CONTROL_MODE ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CONTROL_MODE, ADC_CTU_DRIVEN);
* \endcode
*
*******************************************************************************/
#define ADC_CONTROL_MODE

/***************************************************************************//*!
*
* @brief                Start injected conversion
*
* @param                ADC_INJ_START
*
* @return               NULL
*
* @details              The #ADC_INJECTION_START ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_INJECTION_START, ADC_INJ_START);
* \endcode
*
*******************************************************************************/
#define ADC_INJECTION_START

/***************************************************************************//*!
*
* @brief                Injection trigger edge selection.
*
* @param                ADC_INJ_TRG_FALLING_EDGE
* @param                ADC_INJ_TRG_RISING_EDGE
*
* @return               NULL
*
* @details              The #ADC_INJ_TRG_EDGE_SEL ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_INJ_TRG_EDGE_SEL, ADC_INJ_TRG_FALLING_EDGE);
* \endcode
*
*******************************************************************************/
#define ADC_INJ_TRG_EDGE_SEL

/***************************************************************************//*!
*
* @brief                Injection external trigger enable.
*
* @param                ADC_EXT_TRG_ENABLE
* @param                ADC_EXT_TRG_DISABLE
*
* @return               NULL
*
* @details              The #ADC_INJECTION_EXT_TRG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_INJECTION_EXT_TRG, ADC_EXT_TRG_ENABLE);
* \endcode
*
*******************************************************************************/
#define ADC_INJECTION_EXT_TRG

/***************************************************************************//*!
*
* @brief                Start chain or scan conversion.
*
* @param                ADC_CNV_START
* @param                ADC_CNV_STOP
*
* @return               NULL
*
* @details              The #ADC_NORMAL_START_CONVERSION ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_NORMAL_START_CONVERSION, ADC_CNV_START);
* \endcode
*
*******************************************************************************/
#define ADC_NORMAL_START_CONVERSION

/***************************************************************************//*!
*
* @brief                Select normal conversion mode.
1 - Scan ModeConfigures continuous chain conversion mode; when the programmed
chain conversion is finished it restarts immediately.
*
* @param                ADC_ONE_SHOT
* @param                ADC_SCAN
*
* @return               NULL
*
* @details              The #ADC_MODE_SELECTION ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_MODE_SELECTION, ADC_ONE_SHOT);
* \endcode
*
*******************************************************************************/
#define ADC_MODE_SELECTION

/***************************************************************************//*!
*
* @brief                Select left/right alignment.
*
* @param                ADC_RIGHT_ALIGNED
* @param                ADC_LEFT_ALIGNED
*
* @return               NULL
*
* @details              The #ADC_WRITE_ALIGNMENT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_WRITE_ALIGNMENT, ADC_RIGHT_ALIGNED);
* \endcode
*
*******************************************************************************/
#define ADC_WRITE_ALIGNMENT

/***************************************************************************//*!
*
* @brief                Enables or disables the functionality to overwrite unread converted data.
*
* @param                ADC_PREVENT_OVERWRITE
* @param                ADC_ENABLE_OVERWRITE
*
* @return               NULL
*
* @details              The #ADC_OVERWRITE_ENABLE ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_OVERWRITE_ENABLE, ADC_PREVENT_OVERWRITE);
* \endcode
*
*******************************************************************************/
#define ADC_OVERWRITE_ENABLE

/***************************************************************************//*!
*
* @brief                read MCR register value
*
* @param                NULL
*
* @return               MSR register value
*
* @details              The #ADC_READ_VALUE_REG_MCR ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_MCR, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_MCR

/***************************************************************************//*!
*
* @brief                Read ADC status value
*
* @param                NULL
*
* @return               ADC status
*
* @details              The #ADC_GET_STATUS ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_STATUS, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_STATUS

/***************************************************************************//*!
*
* @brief                Get number of channel under conversion
*
* @param                NULL
*
* @return               number of channel under measure
*
* @details              The #ADC_GET_CHANNEL_ADDRESS ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_CHANNEL_ADDRESS, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_CHANNEL_ADDRESS

/***************************************************************************//*!
*
* @brief                check ongoing CTU conversion.
*
* @param                NULL
*
* @return               CTU conversion is ongoing.
*
* @details              The #ADC_GET_CTU_START_STATUS ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_CTU_START_STATUS, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_CTU_START_STATUS

/***************************************************************************//*!
*
* @brief                Get End of Chain Conversion interrupt flag.
*
* @param                NULL
*
* @return               end of chain conversion interrupt flag
*
* @details              The #ADC_GET_ECH_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_ECH_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_ECH_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear End of Chain interrupt flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_ECH_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_ECH_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
******************************************************************************/
#define ADC_CLEAR_ECH_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Get End of Channel Conversion interrupt flag.
*
* @param                NULL
*
* @return               EOC
*
* @details              The #ADC_GET_EOC_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_EOC_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_EOC_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear EOC interrupt flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_EOC_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_EOC_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_EOC_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Get End of Injected Chain Conversion interrupt flag.
*
* @param                NULL
*
* @return               JECH
*
* @details              The #ADC_GET_JECH_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_JECH_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_JECH_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear JECH interrupt flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_JECH_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_JECH_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_JECH_ISR_FLAG

/***************************************************************************//*!
*
* @brief                End of Injected Channel Conversion interrupt flag.
*
* @param                NULL
*
* @return               JEOC
*
* @details              The #ADC_GET_JEOC_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_JEOC_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_JEOC_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear JEOC interrupt flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_JEOC_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_JEOC_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_JEOC_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Get End of CTU Conversion interrupt flag.
*
* @param                NULL
*
* @return               EOCTU
*
* @details              The #ADC_GET_EOCTU_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_EOCTU_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_EOCTU_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear EOCTU ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_EOCTU_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_EOCTU_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_EOCTU_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Mask ECH interrupt
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_ECH_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_ECH_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_ECH_INT

/***************************************************************************//*!
*
* @brief                Mask EOC interrupt
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_EOC_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_EOC_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_EOC_INT

/***************************************************************************//*!
*
* @brief                Mask JECH interrupt
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_JECH_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_JECH_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_JECH_INT

/***************************************************************************//*!
*
* @brief                Mask JEOC interrupt
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_JEOC_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_JEOC_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_JEOC_INT

/***************************************************************************//*!
*
* @brief                Mask EOCTU interrupt
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_EOCTU_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_EOCTU_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_EOCTU_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 0
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL0_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL0_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL0_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 1
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL1_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL1_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL1_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 2
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL2_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL2_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL2_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 3
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL3_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL3_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL3_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 4
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL4_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL4_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL4_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 5
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL5_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL5_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL5_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 6
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL6_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL6_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL6_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 7
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL7_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL7_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL7_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 8
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL8_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL8_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL8_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 9
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL9_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL9_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL9_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 10
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL10_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL10_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL10_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 11
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL11_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL11_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL11_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 12
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL12_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL12_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL12_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 13
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL13_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL13_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL13_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 14
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL14_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL14_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL14_INT

/***************************************************************************//*!
*
* @brief                Enables interrupt for channel 15
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_CHNL15_INT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CHNL15_INT, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_CHNL15_INT

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG0L_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG0L_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG0L_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG0H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG0H_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG0H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG1L_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG1L_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG1L_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG1H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG1H_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG1H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG2L_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG2L_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG2L_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG2H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG2H_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG2H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG3L_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG3L_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG3L_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG3H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG3H_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG3H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG4L_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG4L_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG4L_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG4H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG4H_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG4H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG5L_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG5L_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG5L_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Clear Watchdog Threshold ISR flag.
*
* @param                ADC_CLEAR_FLAG
*
* @return               NULL
*
* @details              The #ADC_CLEAR_WDG5H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_WDG5H_ISR_FLAG, ADC_CLEAR_FLAG);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_WDG5H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR flag.
*
* @param                NULL
*
* @return               WDG0H_FLAG
*
* @details              The #ADC_GET_WDG0H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WDG0H_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WDG0H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR flag.
*
* @param                NULL
*
* @return               WDG1L_FLAG
*
* @details              The #ADC_GET_WDG1L_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WDG1L_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WDG1L_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR flag.
*
* @param                NULL
*
* @return               WDG1H_FLAG
*
* @details              The #ADC_GET_WDG1H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WDG1H_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WDG1H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR flag.
*
* @param                NULL
*
* @return               WDG2L_FLAG
*
* @details              The #ADC_GET_WDG2L_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WDG2L_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WDG2L_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR flag.
*
* @param                NULL
*
* @return               WDG2H_FLAG
*
* @details              The #ADC_GET_WDG2H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WDG2H_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WDG2H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR flag.
*
* @param                NULL
*
* @return               WDG3L_FLAG
*
* @details              The #ADC_GET_WDG3L_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WDG3L_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WDG3L_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR flag.
*
* @param                NULL
*
* @return               WDG3H_FLAG
*
* @details              The #ADC_GET_WDG3H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WDG3H_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WDG3H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR flag.
*
* @param                NULL
*
* @return               WDG4L_FLAG
*
* @details              The #ADC_GET_WDG4L_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WDG4L_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WDG4L_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR flag.
*
* @param                NULL
*
* @return               WDG4H_FLAG
*
* @details              The #ADC_GET_WDG4H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WDG4H_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WDG4H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR flag.
*
* @param                NULL
*
* @return               WDG5L_FLAG
*
* @details              The #ADC_GET_WDG5L_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WDG5L_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WDG5L_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR flag.
*
* @param                NULL
*
* @return               WDG5H_FLAG
*
* @details              The #ADC_GET_WDG5H_ISR_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WDG5H_ISR_FLAG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WDG5H_ISR_FLAG

/***************************************************************************//*!
*
* @brief                Read Watchdog Threshold ISR register.
*
* @param                NULL
*
* @return               WTISR
*
* @details              The #ADC_GET_WTISR_REG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_GET_WTISR_REG, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_GET_WTISR_REG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG0L_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG0L_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG0L_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG0H_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG0H_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG0H_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG1L_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG1L_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG1L_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG1H_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG1H_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG1H_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG2L_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG2L_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG2L_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG2H_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG2H_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG2H_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG3L_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG3L_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG3L_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG3H_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG3H_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG3H_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG4L_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG4L_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG4L_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG4H_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG4H_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG4H_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG5L_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG5L_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG5L_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Enables interrupt from Watchdog Threshold.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_WDG5H_MASK_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_WDG5H_MASK_FLAG, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_WDG5H_MASK_FLAG

/***************************************************************************//*!
*
* @brief                Set high threshold value for channel 0
*
* @param                ADC_HIGH_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_HIGH_CHNL0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_HIGH_CHNL0, ADC_HIGH_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_HIGH_CHNL0

/***************************************************************************//*!
*
* @brief                Set low threshold value for channel 0
*
* @param                ADC_LOW_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_LOW_CHNL0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_LOW_CHNL0, ADC_LOW_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_LOW_CHNL0

/***************************************************************************//*!
*
* @brief                Set high threshold value for channel 1
*
* @param                ADC_HIGH_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_HIGH_CHNL1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_HIGH_CHNL1, ADC_HIGH_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_HIGH_CHNL1

/***************************************************************************//*!
*
* @brief                Set low threshold value for channel 1
*
* @param                ADC_LOW_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_LOW_CHNL1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_LOW_CHNL1, ADC_LOW_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_LOW_CHNL1

/***************************************************************************//*!
*
* @brief                Set high threshold value for channel 2
*
* @param                ADC_HIGH_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_HIGH_CHNL2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_HIGH_CHNL2, ADC_HIGH_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_HIGH_CHNL2

/***************************************************************************//*!
*
* @brief                Set low threshold value for channel 2
*
* @param                ADC_LOW_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_LOW_CHNL2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_LOW_CHNL2, ADC_LOW_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_LOW_CHNL2

/***************************************************************************//*!
*
* @brief                Set high threshold value for channel 3
*
* @param                ADC_HIGH_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_HIGH_CHNL3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_HIGH_CHNL3, ADC_HIGH_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_HIGH_CHNL3

/***************************************************************************//*!
*
* @brief                Set low threshold value for channel 3
*
* @param                ADC_LOW_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_LOW_CHNL3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_LOW_CHNL3, ADC_LOW_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_LOW_CHNL3

/***************************************************************************//*!
*
* @brief                Set high threshold value for channel 4
*
* @param                ADC_HIGH_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_HIGH_CHNL4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_HIGH_CHNL4, ADC_HIGH_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_HIGH_CHNL4

/***************************************************************************//*!
*
* @brief                Set low threshold value for channel 4
*
* @param                ADC_LOW_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_LOW_CHNL4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_LOW_CHNL4, ADC_LOW_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_LOW_CHNL4

/***************************************************************************//*!
*
* @brief                Set high threshold value for channel 5
*
* @param                ADC_HIGH_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_HIGH_CHNL5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_HIGH_CHNL5, ADC_HIGH_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_HIGH_CHNL5

/***************************************************************************//*!
*
* @brief                Set low threshold value for channel 5
*
* @param                ADC_LOW_THR_VALUE
*
* @return               NULL
*
* @details              The #ADC_SET_THR_LOW_CHNL5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_THR_LOW_CHNL5, ADC_LOW_THR_VALUE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_THR_LOW_CHNL5

/***************************************************************************//*!
*
* @brief                Set internal voltage for presampling.
*
* @param                ADC_SEL_V0_INT_VOLTAGE
* @param                ADC_SEL_V1_INT_VOLTAGE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_INTERNAL_VOLTAGE0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_INTERNAL_VOLTAGE0, ADC_SEL_V0_INT_VOLTAGE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_INTERNAL_VOLTAGE0

/***************************************************************************//*!
*
* @brief                Set internal voltage for presampling.
*
* @param                ADC_SEL_V0_INT_VOLTAGE
* @param                ADC_SEL_V1_INT_VOLTAGE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_INTERNAL_VOLTAGE1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_INTERNAL_VOLTAGE1, ADC_SEL_V0_INT_VOLTAGE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_INTERNAL_VOLTAGE1

/***************************************************************************//*!
*
* @brief                Set internal voltage for presampling.
*
* @param                ADC_SEL_V0_INT_VOLTAGE
* @param                ADC_SEL_V1_INT_VOLTAGE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_INTERNAL_VOLTAGE2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_INTERNAL_VOLTAGE2, ADC_SEL_V0_INT_VOLTAGE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_INTERNAL_VOLTAGE2

/***************************************************************************//*!
*
* @brief                Set .
*
* @param                ADC_CONV_AND_SAMPLE
* @param                ADC_CONV_AND_PRESAMPLE
*
* @return               NULL
*
* @details              The #ADC_CONVERT_PRESAMPLED_VALUE ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CONVERT_PRESAMPLED_VALUE, ADC_CONV_AND_SAMPLE);
* \endcode
*
*******************************************************************************/
#define ADC_CONVERT_PRESAMPLED_VALUE

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL0, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL0

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL1, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL1

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL2, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL2

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL3, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL3

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL4, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL4

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL5, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL5

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL6 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL6, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL6

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL7 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL7, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL7

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL8 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL8, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL8

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL9 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL9, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL9

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL10 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL10, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL10

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL11 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL11, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL11

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL12 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL12, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL12

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL13 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL13, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL13

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL14 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL14, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL14

/***************************************************************************//*!
*
* @brief                Enable or disable presampling for dedicated channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_PRESAMPLING_CHNL15 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_PRESAMPLING_CHNL15, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_PRESAMPLING_CHNL15

/***************************************************************************//*!
*
* @brief                Set INPLATCH configuration in the conversion timing register for channels 0-14
*
* @param                ADC_ZERO
* @param                ADC_ONE
*
* @return               NULL
*
* @details              The #ADC_SET_INPLATCH_BITFIELD ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_INPLATCH_BITFIELD, ADC_ZERO);
* \endcode
*
*******************************************************************************/
#define ADC_SET_INPLATCH_BITFIELD

/***************************************************************************//*!
*
* @brief                Set  offset  shift characteristic  for channels 0-14
*
* @param                ADC_NO_SHIFT
* @param                ADC_HALF_LSB
* @param                ADC_ZERO_LSB
*
* @return               NULL
*
* @details              The #ADC_SET_OFFSET_SHIFT ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_OFFSET_SHIFT, ADC_NO_SHIFT);
* \endcode
*
*******************************************************************************/
#define ADC_SET_OFFSET_SHIFT

/***************************************************************************//*!
*
* @brief                Set INPCMP bits in the conversion timing register for channels 0-14
*
* @param                ADC_ZERO
* @param                ADC_ONE
* @param                ADC_TWO
* @param                ADC_THREE
*
* @return               NULL
*
* @details              The #ADC_SET_INPCMP_BITFIELD ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_INPCMP_BITFIELD, ADC_ZERO);
* \endcode
*
*******************************************************************************/
#define ADC_SET_INPCMP_BITFIELD

/***************************************************************************//*!
*
* @brief                Set sampling phase duration value for channels 0-14
*
* @param                ADC_SAMPLING_DURATION
*
* @return               NULL
*
* @details              The #ADC_SET_INPSAMP ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_INPSAMP, ADC_SAMPLING_DURATION);
* \endcode
*
*******************************************************************************/
#define ADC_SET_INPSAMP

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH0_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH0_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH0_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH1_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH1_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH1_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH2_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH2_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH2_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH3_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH3_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH3_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH4_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH4_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH4_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH5_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH5_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH5_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH6_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH6_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH6_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH7_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH7_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH7_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH8_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH8_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH8_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH9_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH9_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH9_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH10_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH10_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH10_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH11_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH11_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH11_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH12_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH12_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH12_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH13_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH13_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH13_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH14_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH14_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH14_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable conversion during normal conversion.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH15_NORMAL_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH15_NORMAL_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH15_NORMAL_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH0_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH0_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH0_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH1_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH1_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH1_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH2_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH2_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH2_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH3_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH3_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH3_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH4_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH4_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH4_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH5_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH5_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH5_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH6_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH6_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH6_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH7_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH7_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH7_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH8_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH8_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH8_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH9_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH9_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH9_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH10_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH10_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH10_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH11_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH11_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH11_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH12_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH12_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH12_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH13_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH13_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH13_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH14_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH14_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH14_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Enable or disable injected conversion for dedicated ADC channel.
*
* @param                ADC_DISABLE
* @param                ADC_ENABLE
*
* @return               NULL
*
* @details              The #ADC_SET_CH15_INJECTED_CONV_MASK ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_CH15_INJECTED_CONV_MASK, ADC_DISABLE);
* \endcode
*
*******************************************************************************/
#define ADC_SET_CH15_INJECTED_CONV_MASK

/***************************************************************************//*!
*
* @brief                Set delay between the power-down reset and the start of conversion.
*
* @param                ADC_PDED
*
* @return               NULL
*
* @details              The #ADC_SET_POWER_DOWN_DELAY ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SET_POWER_DOWN_DELAY, ADC_PDED);
* \endcode
*
*******************************************************************************/
#define ADC_SET_POWER_DOWN_DELAY

/***************************************************************************//*!
*
* @brief                The function return channel  0 converted value.
*
* @param                CHNLx
*
* ADC_CDR0_OFFSET
* ADC_CDR1_OFFSET
* ADC_CDR2_OFFSET
* ADC_CDR3_OFFSET
* ADC_CDR4_OFFSET
* ADC_CDR5_OFFSET
* ADC_CDR6_OFFSET
* ADC_CDR7_OFFSET
* ADC_CDR8_OFFSET
* ADC_CDR9_OFFSET
* ADC_CDR10_OFFSET
* ADC_CDR11_OFFSET
* ADC_CDR12_OFFSET
* ADC_CDR13_OFFSET
* ADC_CDR14_OFFSET
* ADC_CDR15_OFFSET
*
* @return               Returns channel 0 converted value.
*
* @details              The #ADC_READ_VALUE ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE, CHNLx);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE

/***************************************************************************//*!
*
* @brief                The function return channel  0 converted value.
*
* @param                NULL
*
* @return               Returns channel 0 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL0, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL0


/***************************************************************************//*!
*
* @brief                The function return channel 0 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 0 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR0, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR0

/***************************************************************************//*!
*
* @brief                The function return converted value from channel  1.
*
* @param                NULL
*
* @return               Returns  channel 1 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL1, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL1

/***************************************************************************//*!
*
* @brief                The function return channel 1 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 1 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR1, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR1

/***************************************************************************//*!
*
* @brief                The function return channel  2 converted value.
*
* @param                NULL
*
* @return               Returns channel 2 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL2, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL2

/***************************************************************************//*!
*
* @brief                The function return channel 2 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 2 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR2, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR2

/***************************************************************************//*!
*
* @brief                The function return channel 3 converted value.
*
* @param                NULL
*
* @return               Returns channel 3 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL3, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL3

/***************************************************************************//*!
*
* @brief                The function return channel 3 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 3 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR3, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR3

/***************************************************************************//*!
*
* @brief                The function return channel  4 converted value.
*
* @param                NULL
*
* @return               Returns channel 4 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL4, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL4

/***************************************************************************//*!
*
* @brief                The function return channel 4 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 4 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR4, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR4

/***************************************************************************//*!
*
* @brief                The function return channel  5 converted value.
*
* @param                NULL
*
* @return               Returns channel 5 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL5, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL5

/***************************************************************************//*!
*
* @brief                The function return channel 5 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 5 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR5, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR5

/***************************************************************************//*!
*
* @brief                The function return channel  6 converted value.
*
* @param                NULL
*
* @return               Returns channel 6 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL6 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL6, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL6

/***************************************************************************//*!
*
* @brief                The function return channel 6 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 6 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR6 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR6, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR6

/***************************************************************************//*!
*
* @brief                The function return channel  7 converted value.
*
* @param                NULL
*
* @return               Returns channel 7 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL7 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL7, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL7

/***************************************************************************//*!
*
* @brief                The function return channel 7 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 7 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR7 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR7, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR7

/***************************************************************************//*!
*
* @brief                The function return channel  8 converted value.
*
* @param                NULL
*
* @return               Returns channel 8 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL8 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL8, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL8

/***************************************************************************//*!
*
* @brief                The function return channel 8 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 8 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR8 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR8, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR8

/***************************************************************************//*!
*
* @brief                The function return channel  9 converted value.
*
* @param                NULL
*
* @return               Returns converted value from channel 9.
*
* @details              The #ADC_READ_VALUE_CHNL9 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL9, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL9

/***************************************************************************//*!
*
* @brief                The function return channel 9 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 9 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR9 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR9, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR9

/***************************************************************************//*!
*
* @brief                The function return channel  10 converted value.
*
* @param                NULL
*
* @return               Returns channel 10 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL10 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL10, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL10

/***************************************************************************//*!
*
* @brief                The function return channel 10 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 10 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR10 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR10, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR10

/***************************************************************************//*!
*
* @brief                The function return channel  11 converted value.
*
* @param                NULL
*
* @return               Returns channel 11 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL11 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL11, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL11

/***************************************************************************//*!
*
* @brief                The function return channel 11 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 11 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR11 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR11, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR11

/***************************************************************************//*!
*
* @brief                The function return channel  12 converted value.
*
* @param                NULL
*
* @return               Returns channel 12 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL12 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL12, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL12

/***************************************************************************//*!
*
* @brief                The function return channel 12 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 12 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR12 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR12, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR12

/***************************************************************************//*!
*
* @brief                The function return channel  13 converted value.
*
* @param                NULL
*
* @return               Returns channel 13 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL13 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL13, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL13

/***************************************************************************//*!
*
* @brief                The function return channel 13 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 13 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR13 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR13, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR13

/***************************************************************************//*!
*
* @brief                The function return channel  14 converted value.
*
* @param                NULL
*
* @return               Returns channel 14 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL14 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL14, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL14

/***************************************************************************//*!
*
* @brief                The function return channel 14 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 14 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR14 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR14, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR14

/***************************************************************************//*!
*
* @brief                The function return channel  15 converted value.
*
* @param                NULL
*
* @return               Returns channel 15 converted value.
*
* @details              The #ADC_READ_VALUE_CHNL15 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_CHNL15, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_CHNL15

/***************************************************************************//*!
*
* @brief                The function return channel 15 converted data register value.
*
* @param                NULL
*
* @return               Returns channel 15 converted data register value.
*
* @details              The #ADC_READ_VALUE_REG_CDR15 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_VALUE_REG_CDR15, NULL);
* \endcode
*
*******************************************************************************/
#define ADC_READ_VALUE_REG_CDR15

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 0.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL0 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL0, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL0

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 1.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL1 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL1, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL1

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 2.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL2 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL2, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL2

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 3.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL3 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL3, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL3

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 4.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL4 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL4, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL4

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 5.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL5 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL5, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL5

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 6.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL6 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL6, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL6

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 7.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL7 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL7, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL7

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 8.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL8 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL8, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL8

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 9.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL9 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL9, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL9

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 10.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL10 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL10, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL10

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 11.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL11 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL11, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL11

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 12.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL12 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL12, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL12

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 13.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL13 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL13, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL13

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 14.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL14 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL14, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL14

/***************************************************************************//*!
*
* @brief                Select the threshold register that define limit value for channel 15.
*
* @param                ADC_THRHLR0
* @param                ADC_THRHLR1
* @param                ADC_THRHLR2
* @param                ADC_THRHLR3
* @param                ADC_THRHLR4
* @param                ADC_THRHLR5
* @param                ADC_THRHLR6
* @param                ADC_THRHLR7
* @param                ADC_THRHLR8
* @param                ADC_THRHLR9
* @param                ADC_THRHLR10
* @param                ADC_THRHLR11
* @param                ADC_THRHLR12
* @param                ADC_THRHLR13
* @param                ADC_THRHLR14
* @param                ADC_THRHLR15
*
* @return               NULL
*
* @details              The #ADC_SEL_THRESHOLD_REG_CHNL15 ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_SEL_THRESHOLD_REG_CHNL15, ADC_THRHLR0);
* \endcode
*
*******************************************************************************/
#define ADC_SEL_THRESHOLD_REG_CHNL15

/***************************************************************************//*!
*
* @brief                Enable watchdog features for dedicated channel.
*
* @param                ADC_CHANNEL_0
* @param                ADC_CHANNEL_1
* @param                ADC_CHANNEL_2
* @param                ADC_CHANNEL_3
* @param                ADC_CHANNEL_4
* @param                ADC_CHANNEL_5
* @param                ADC_CHANNEL_6
* @param                ADC_CHANNEL_7
* @param                ADC_CHANNEL_8
* @param                ADC_CHANNEL_9
* @param                ADC_CHANNEL_10
* @param                ADC_CHANNEL_11
* @param                ADC_CHANNEL_12
* @param                ADC_CHANNEL_13
* @param                ADC_CHANNEL_14
* @param                ADC_CHANNEL_15
*
* @return               NULL
*
* @details              The #ADC_ENABLE_WATCHDOG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_ENABLE_WATCHDOG, ADC_CHANNEL_0);
* \endcode
*
*******************************************************************************/
#define ADC_ENABLE_WATCHDOG

/***************************************************************************//*!
*
* @brief                Disable watchdog features for dedicated channel.
*
* @param                ADC_CHANNEL_0
* @param                ADC_CHANNEL_1
* @param                ADC_CHANNEL_2
* @param                ADC_CHANNEL_3
* @param                ADC_CHANNEL_4
* @param                ADC_CHANNEL_5
* @param                ADC_CHANNEL_6
* @param                ADC_CHANNEL_7
* @param                ADC_CHANNEL_8
* @param                ADC_CHANNEL_9
* @param                ADC_CHANNEL_10
* @param                ADC_CHANNEL_11
* @param                ADC_CHANNEL_12
* @param                ADC_CHANNEL_13
* @param                ADC_CHANNEL_14
* @param                ADC_CHANNEL_15
*
* @return               NULL
*
* @details              The #ADC_DISABLE_WATCHDOG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_DISABLE_WATCHDOG, ADC_CHANNEL_0);
* \endcode
*
*******************************************************************************/
#define ADC_DISABLE_WATCHDOG

/***************************************************************************//*!
*
* @brief                Read OUT OF RANGE flag for dedicated channel number.
*
* @param                ADC_CHANNEL_0
* @param                ADC_CHANNEL_1
* @param                ADC_CHANNEL_2
* @param                ADC_CHANNEL_3
* @param                ADC_CHANNEL_4
* @param                ADC_CHANNEL_5
* @param                ADC_CHANNEL_6
* @param                ADC_CHANNEL_7
* @param                ADC_CHANNEL_8
* @param                ADC_CHANNEL_9
* @param                ADC_CHANNEL_10
* @param                ADC_CHANNEL_11
* @param                ADC_CHANNEL_12
* @param                ADC_CHANNEL_13
* @param                ADC_CHANNEL_14
* @param                ADC_CHANNEL_15
*
* @return               The OUT OF RANGE value for dedicated channel or channels.
*
* @details              The #ADC_READ_OUT_OF_RANGE_REGISTER ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* vuint32_t u32RetVal;
* u32RetVal = ioctl(ADC0_BASE,ADC_READ_OUT_OF_RANGE_REGISTER, ADC_CHANNEL_0);
* \endcode
*
*******************************************************************************/
#define ADC_READ_OUT_OF_RANGE_REGISTER

/***************************************************************************//*!
*
* @brief                Clear OUT OF RANGE indicator for dedicated channel.
*
* @param                ADC_CHANNEL_0
* @param                ADC_CHANNEL_1
* @param                ADC_CHANNEL_2
* @param                ADC_CHANNEL_3
* @param                ADC_CHANNEL_4
* @param                ADC_CHANNEL_5
* @param                ADC_CHANNEL_6
* @param                ADC_CHANNEL_7
* @param                ADC_CHANNEL_8
* @param                ADC_CHANNEL_9
* @param                ADC_CHANNEL_10
* @param                ADC_CHANNEL_11
* @param                ADC_CHANNEL_12
* @param                ADC_CHANNEL_13
* @param                ADC_CHANNEL_14
* @param                ADC_CHANNEL_15
*
* @return               NULL
*
* @details              The #ADC_CLEAR_OUT_OF_RANGE_FLAG ioctl command TBD
*
* @par Code Example:
*
* \code
* //
* ioctl(ADC0_BASE,ADC_CLEAR_OUT_OF_RANGE_FLAG, ADC_CHANNEL_0);
* \endcode
*
*******************************************************************************/
#define ADC_CLEAR_OUT_OF_RANGE_FLAG


/*******************************************************************************
* ADC bitfield masks definition
*******************************************************************************/

#define ADC_PWDN_MASK                                   0x00000001
#define ADC_ACKO_MASK                                   0x00000020
#define ADC_ABORT_MASK                                  0x00000040
#define ADC_ABORTCHAIN_MASK                             0x00000080
#define ADC_ADCLKSEL_MASK                               0x00000100
#define ADC_CTUEN_MASK                                  0x00020000
#define ADC_JSTART_MASK                                 0x00100000
#define ADC_JEDGE_MASK                                  0x00200000
#define ADC_JTRGEN_MASK                                 0x00400000
#define ADC_NSTART_MASK                                 0x01000000
#define ADC_MODE_MASK                                   0x20000000
#define ADC_WLSIDE_MASK                                 0x40000000
#define ADC_OWREN_MASK                                  0x80000000
#define ADC_ADCSTATUS_MASK                              0x00000007
#define ADC_CHADDR_MASK                                 0x0000FE00
#define ADC_CTUSTART_MASK                               0x00010000
#define ADC_ECH_MASK                                    0x00000001
#define ADC_EOC_MASK                                    0x00000002
#define ADC_JECH_MASK                                   0x00000004
#define ADC_JEOC_MASK                                   0x00000008
#define ADC_EOCTU_MASK                                  0x00000010
#define ADC_MSKECH_MASK                                 0x00000001
#define ADC_MSKEOC_MASK                                 0x00000002
#define ADC_MSKJECH_MASK                                0x00000004
#define ADC_MSKJEOC_MASK                                0x00000008
#define ADC_MSKEOCTU_MASK                               0x00000010
#define ADC_CIM0_MASK                                   0x00000001
#define ADC_CIM1_MASK                                   0x00000002
#define ADC_CIM2_MASK                                   0x00000004
#define ADC_CIM3_MASK                                   0x00000008
#define ADC_CIM4_MASK                                   0x00000010
#define ADC_CIM5_MASK                                   0x00000020
#define ADC_CIM6_MASK                                   0x00000040
#define ADC_CIM7_MASK                                   0x00000080
#define ADC_CIM8_MASK                                   0x00000100
#define ADC_CIM9_MASK                                   0x00000200
#define ADC_CIM10_MASK                                  0x00000400
#define ADC_CIM11_MASK                                  0x00000800
#define ADC_CIM12_MASK                                  0x00001000
#define ADC_CIM13_MASK                                  0x00002000
#define ADC_CIM14_MASK                                  0x00004000
#define ADC_CIM15_MASK                                  0x00008000
#define ADC_WDG0L_MASK                                  0x00000001
#define ADC_WDG0H_MASK                                  0x00000002
#define ADC_WDG1L_MASK                                  0x00000004
#define ADC_WDG1H_MASK                                  0x00000008
#define ADC_WDG2L_MASK                                  0x00000010
#define ADC_WDG2H_MASK                                  0x00000020
#define ADC_WDG3L_MASK                                  0x00000040
#define ADC_WDG3H_MASK                                  0x00000080
#define ADC_WDG4L_MASK                                  0x00000100
#define ADC_WDG4H_MASK                                  0x00000200
#define ADC_WDG5L_MASK                                  0x00000400
#define ADC_WDG5H_MASK                                  0x00000800
#define ADC_MSKWDG0L_MASK                               0x00000001
#define ADC_MSKWDG0H_MASK                               0x00000002
#define ADC_MSKWDG1L_MASK                               0x00000004
#define ADC_MSKWDG1H_MASK                               0x00000008
#define ADC_MSKWDG2L_MASK                               0x00000010
#define ADC_MSKWDG2H_MASK                               0x00000020
#define ADC_MSKWDG3L_MASK                               0x00000040
#define ADC_MSKWDG3H_MASK                               0x00000080
#define ADC_MSKWDG4L_MASK                               0x00000100
#define ADC_MSKWDG4H_MASK                               0x00000200
#define ADC_MSKWDG5L_MASK                               0x00000400
#define ADC_MSKWDG5H_MASK                               0x00000800
#define ADC_THRH_MASK                                   0x00000FFF
#define ADC_THRL_MASK                                   0x0FFF0000
#define ADC_PREVAL0_MASK                                0x00000006
#define ADC_PREVAL1_MASK                                0x00000018
#define ADC_PREVAL2_MASK                                0x00000060
#define ADC_PRECONV_MASK                                0x00000001
#define ADC_PRES0_MASK                                  0x00000001
#define ADC_PRES1_MASK                                  0x00000002
#define ADC_PRES2_MASK                                  0x00000004
#define ADC_PRES3_MASK                                  0x00000008
#define ADC_PRES4_MASK                                  0x00000010
#define ADC_PRES5_MASK                                  0x00000020
#define ADC_PRES6_MASK                                  0x00000040
#define ADC_PRES7_MASK                                  0x00000080
#define ADC_PRES8_MASK                                  0x00000100
#define ADC_PRES9_MASK                                  0x00000200
#define ADC_PRES10_MASK                                 0x00000400
#define ADC_PRES11_MASK                                 0x00000800
#define ADC_PRES12_MASK                                 0x00001000
#define ADC_PRES13_MASK                                 0x00002000
#define ADC_PRES14_MASK                                 0x00004000
#define ADC_PRES15_MASK                                 0x00008000
#define ADC_INPLATCH_MASK                               0x00008000
#define ADC_OFFSHIFT_MASK                               0x00003000
#define ADC_INPCMP_MASK                                 0x00000600
#define ADC_CTR0_INPSAMP_MASK                           0x000000FF
#define ADC_CTR1_INPSAMP_MASK                           0x000000FE
#define ADC_CH0_MASK                                    0x00000001
#define ADC_CH1_MASK                                    0x00000002
#define ADC_CH2_MASK                                    0x00000004
#define ADC_CH3_MASK                                    0x00000008
#define ADC_CH4_MASK                                    0x00000010
#define ADC_CH5_MASK                                    0x00000020
#define ADC_CH6_MASK                                    0x00000040
#define ADC_CH7_MASK                                    0x00000080
#define ADC_CH8_MASK                                    0x00000100
#define ADC_CH9_MASK                                    0x00000200
#define ADC_CH10_MASK                                   0x00000400
#define ADC_CH11_MASK                                   0x00000800
#define ADC_CH12_MASK                                   0x00001000
#define ADC_CH13_MASK                                   0x00002000
#define ADC_CH14_MASK                                   0x00004000
#define ADC_CH15_MASK                                   0x00008000
#define ADC_CDATA_MASK                                  0x00000FFF
#define ADC_WSEL_CH0_MASK                               0x0000000F
#define ADC_WSEL_CH1_MASK                               0x000000F0
#define ADC_WSEL_CH2_MASK                               0x00000F00
#define ADC_WSEL_CH3_MASK                               0x0000F000
#define ADC_WSEL_CH4_MASK                               0x000F0000
#define ADC_WSEL_CH5_MASK                               0x00F00000
#define ADC_CWEN0_MASK                                  0x0000FFFF
#define ADC_AWOR_MASK                                   0x0000FFFF

/*******************************************************************************
* ADC register offset definition
*******************************************************************************/

#define ADC_MCR_OFFSET                                  0x0
#define ADC_MSR_OFFSET                                  0x4
#define ADC_ISR_OFFSET                                  0x10
#define ADC_IMR_OFFSET                                  0x20
#define ADC_CIMR0_OFFSET                                0x24
#define ADC_WTISR_OFFSET                                0x30
#define ADC_WTIMR_OFFSET                                0x34
#define ADC_THRHLR0_OFFSET                              0x60
#define ADC_THRHLR1_OFFSET                              0x64
#define ADC_THRHLR2_OFFSET                              0x68
#define ADC_THRHLR3_OFFSET                              0x6C
#define ADC_THRHLR4_OFFSET                              0x280
#define ADC_THRHLR5_OFFSET                              0x284
#define ADC_PSCR_OFFSET                                 0x80
#define ADC_PSR0_OFFSET                                 0x84
#define ADC_CTR0_OFFSET                                 0x94
#define ADC_NCMR0_OFFSET                                0xA4
#define ADC_JCMR0_OFFSET                                0xB4
#define ADC_PDEDR_OFFSET                                0xC8
#define ADC_CDR0_OFFSET                                 0x100
#define ADC_CDR1_OFFSET                                 0x104
#define ADC_CDR2_OFFSET                                 0x108
#define ADC_CDR3_OFFSET                                 0x10C
#define ADC_CDR4_OFFSET                                 0x110
#define ADC_CDR5_OFFSET                                 0x114
#define ADC_CDR6_OFFSET                                 0x118
#define ADC_CDR7_OFFSET                                 0x11C
#define ADC_CDR8_OFFSET                                 0x120
#define ADC_CDR9_OFFSET                                 0x124
#define ADC_CDR10_OFFSET                                0x128
#define ADC_CDR11_OFFSET                                0x12C
#define ADC_CDR12_OFFSET                                0x130
#define ADC_CDR13_OFFSET                                0x134
#define ADC_CDR14_OFFSET                                0x138
#define ADC_CDR15_OFFSET                                0x13C
#define ADC_CWSEL0_OFFSET                               0x2B0
#define ADC_CWSEL1_OFFSET                               0x2B4
#define ADC_CWENR0_OFFSET                               0x2E0
#define ADC_AWORR0_OFFSET                               0x2F0

/*******************************************************************************
* ADC MACRO and ioctl parameters definition
*******************************************************************************/

#define ADC_ENABLE                                      0x1
#define ADC_DISABLE                                     0x0
#define ADC_ABORT                                       0x1
#define ADC_ABORT_CHAIN                                 0x1
#define ADC_SYS_CLK                                     0x1
#define ADC_HALF_SYS_CLK                                0x0
#define ADC_CTU_DRIVEN                                  0x1
#define ADC_CPU_DRIVEN                                  0x0
#define ADC_INJ_START                                   0x1
#define ADC_INJ_TRG_FALLING_EDGE                        0x0
#define ADC_INJ_TRG_RISING_EDGE                         0x1
#define ADC_EXT_TRG_ENABLE                              0x1
#define ADC_EXT_TRG_DISABLE                             0x0
#define ADC_CNV_START                                   0x1
#define ADC_CNV_STOP                                    0x0
#define ADC_ONE_SHOT                                    0x0
#define ADC_SCAN                                        0x1
#define ADC_RIGHT_ALIGNED                               0x0
#define ADC_LEFT_ALIGNED                                0x1
#define ADC_PREVENT_OVERWRITE                           0x0
#define ADC_ENABLE_OVERWRITE                            0x1
#define ADC_CLEAR_FLAG                                  0x1
#define ADC_HIGH_THR_VALUE                              0xFFF
#define ADC_LOW_THR_VALUE                               0x000
#define ADC_SEL_V0_INT_VOLTAGE                          0x0
#define ADC_SEL_V1_INT_VOLTAGE                          0x1
#define ADC_CONV_AND_SAMPLE                             0x0
#define ADC_CONV_AND_PRESAMPLE                          0x1
#define ADC_ZERO                                        0x0
#define ADC_ONE                                         0x1
#define ADC_NO_SHIFT                                    0x0
#define ADC_HALF_LSB                                    0x1
#define ADC_ZERO_LSB                                    0x2
#define ADC_TWO                                         0x2
#define ADC_THREE                                       0x3
#define ADC_SAMPLING_DURATION                           0x0
#define ADC_PTAT_MODE                                   0x0
#define ADC_CTAT_MODE                                   0x1
#define ADC_PDED                                        0xFF
#define ADC_THRHLR0                                     0x0
#define ADC_THRHLR1                                     0x1
#define ADC_THRHLR2                                     0x2
#define ADC_THRHLR3                                     0x3
#define ADC_THRHLR4                                     0x4
#define ADC_THRHLR5                                     0x5
#define ADC_CHANNEL_0                                   0x0001
#define ADC_CHANNEL_1                                   0x0002
#define ADC_CHANNEL_2                                   0x0004
#define ADC_CHANNEL_3                                   0x0008
#define ADC_CHANNEL_4                                   0x0010
#define ADC_CHANNEL_5                                   0x0020
#define ADC_CHANNEL_6                                   0x0040
#define ADC_CHANNEL_7                                   0x0080
#define ADC_CHANNEL_8                                   0x0100
#define ADC_CHANNEL_9                                   0x0200
#define ADC_CHANNEL_10                                  0x0400
#define ADC_CHANNEL_11                                  0x0800
#define ADC_CHANNEL_12                                  0x1000
#define ADC_CHANNEL_13                                  0x2000
#define ADC_CHANNEL_14                                  0x4000
#define ADC_CHANNEL_15                                  0x8000

/*******************************************************************************
* ADC ioctl commands implementation
*******************************************************************************/

#define ioctlADC_POWERDOWN(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_PWDN_MASK)) | (param)

#define ioctlADC_AUTO_CLOCK_OFF(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_ACKO_MASK)) | (param<<5)

#define ioctlADC_ABORT_CONVERSION(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_ABORT_MASK)) | (param<<6)

#define ioctlADC_ABORT_CHAIN_CONVERSION(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_ABORTCHAIN_MASK)) | (param<<7)

#define ioctlANALOG_CLOCK_FREQ_SEL(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_ADCLKSEL_MASK)) | (param<<8)

#define ioctlADC_CONTROL_MODE(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_CTUEN_MASK)) | (param<<17)

#define ioctlADC_INJECTION_START(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_JSTART_MASK)) | (param<<20)

#define ioctlADC_INJ_TRG_EDGE_SEL(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_JEDGE_MASK)) | (param<<21)

#define ioctlADC_INJECTION_EXT_TRG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_JTRGEN_MASK)) | (param<<22)

#define ioctlADC_NORMAL_START_CONVERSION(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_NSTART_MASK)) | (param<<24)

#define ioctlADC_MODE_SELECTION(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_MODE_MASK)) | (param<<29)

#define ioctlADC_WRITE_ALIGNMENT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_WLSIDE_MASK)) | (param<<30)

#define ioctlADC_OVERWRITE_ENABLE(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_MCR_OFFSET)) & (~ADC_OWREN_MASK)) | (param<<31)

#define ioctlADC_READ_VALUE_REG_MCR(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MCR_OFFSET))

#define ioctlADC_GET_STATUS(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_MSR_OFFSET)) & (ADC_ADCSTATUS_MASK)

#define ioctlADC_GET_CHANNEL_ADDRESS(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_MSR_OFFSET)) & (ADC_CHADDR_MASK)) >>9

#define ioctlADC_GET_CTU_START_STATUS(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_MSR_OFFSET)) & (ADC_CTUSTART_MASK)) >>16

#define ioctlADC_GET_ECH_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) & (ADC_ECH_MASK)

#define ioctlADC_CLEAR_ECH_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) & (~ADC_ECH_MASK)) | (param)

#define ioctlADC_GET_EOC_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) & (ADC_EOC_MASK)) >>1

#define ioctlADC_CLEAR_EOC_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) & (~ADC_EOC_MASK)) | (param<<1)

#define ioctlADC_GET_JECH_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) & (ADC_JECH_MASK)) >>2

#define ioctlADC_CLEAR_JECH_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) & (~ADC_JECH_MASK)) | (param<<2)

#define ioctlADC_GET_JEOC_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) & (ADC_JEOC_MASK)) >>3

#define ioctlADC_CLEAR_JEOC_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) & (~ADC_JEOC_MASK)) | (param<<3)

#define ioctlADC_GET_EOCTU_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) & (ADC_EOCTU_MASK)) >>4

#define ioctlADC_CLEAR_EOCTU_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_ISR_OFFSET)) & (~ADC_EOCTU_MASK)) | (param<<4)

#define ioctlADC_ECH_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_IMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_IMR_OFFSET)) & (~ADC_MSKECH_MASK)) | (param)

#define ioctlADC_EOC_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_IMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_IMR_OFFSET)) & (~ADC_MSKEOC_MASK)) | (param<<1)

#define ioctlADC_JECH_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_IMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_IMR_OFFSET)) & (~ADC_MSKJECH_MASK)) | (param<<2)

#define ioctlADC_JEOC_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_IMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_IMR_OFFSET)) & (~ADC_MSKJEOC_MASK)) | (param<<3)

#define ioctlADC_EOCTU_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_IMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_IMR_OFFSET)) & (~ADC_MSKEOCTU_MASK)) | (param<<4)

#define ioctlADC_CHNL0_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM0_MASK)) | (param)

#define ioctlADC_CHNL1_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM1_MASK)) | (param<<1)

#define ioctlADC_CHNL2_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM2_MASK)) | (param<<2)

#define ioctlADC_CHNL3_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM3_MASK)) | (param<<3)

#define ioctlADC_CHNL4_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM4_MASK)) | (param<<4)

#define ioctlADC_CHNL5_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM5_MASK)) | (param<<5)

#define ioctlADC_CHNL6_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM6_MASK)) | (param<<6)

#define ioctlADC_CHNL7_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM7_MASK)) | (param<<7)

#define ioctlADC_CHNL8_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM8_MASK)) | (param<<8)

#define ioctlADC_CHNL9_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM9_MASK)) | (param<<9)

#define ioctlADC_CHNL10_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM10_MASK)) | (param<<10)

#define ioctlADC_CHNL11_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM11_MASK)) | (param<<11)

#define ioctlADC_CHNL12_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM12_MASK)) | (param<<12)

#define ioctlADC_CHNL13_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM13_MASK)) | (param<<13)

#define ioctlADC_CHNL14_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM14_MASK)) | (param<<14)

#define ioctlADC_CHNL15_INT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CIMR0_OFFSET)) & (~ADC_CIM15_MASK)) | (param<<15)

#define ioctlADC_CLEAR_WDG0L_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG0L_MASK)) | (param)

#define ioctlADC_CLEAR_WDG0H_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG0H_MASK)) | (param<<1)

#define ioctlADC_CLEAR_WDG1L_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG1L_MASK)) | (param<<2)

#define ioctlADC_CLEAR_WDG1H_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG1H_MASK)) | (param<<3)

#define ioctlADC_CLEAR_WDG2L_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG2L_MASK)) | (param<<4)

#define ioctlADC_CLEAR_WDG2H_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG2H_MASK)) | (param<<5)

#define ioctlADC_CLEAR_WDG3L_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG3L_MASK)) | (param<<6)

#define ioctlADC_CLEAR_WDG3H_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG3H_MASK)) | (param<<7)

#define ioctlADC_CLEAR_WDG4L_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG4L_MASK)) | (param<<8)

#define ioctlADC_CLEAR_WDG4H_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG4H_MASK)) | (param<<9)

#define ioctlADC_CLEAR_WDG5L_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG5L_MASK)) | (param<<10)

#define ioctlADC_CLEAR_WDG5H_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (~ADC_WDG5H_MASK)) | (param<<11)

#define ioctlADC_GET_WDG0L_ISR_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG0L_MASK)

#define ioctlADC_GET_WDG0H_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG0H_MASK)) >>1

#define ioctlADC_GET_WDG1L_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG1L_MASK)) >>2

#define ioctlADC_GET_WDG1H_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG1H_MASK)) >>3

#define ioctlADC_GET_WDG2L_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG2L_MASK)) >>4

#define ioctlADC_GET_WDG2H_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG2H_MASK)) >>5

#define ioctlADC_GET_WDG3L_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG3L_MASK)) >>6

#define ioctlADC_GET_WDG3H_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG3H_MASK)) >>7

#define ioctlADC_GET_WDG4L_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG4L_MASK)) >>8

#define ioctlADC_GET_WDG4H_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG4H_MASK)) >>9

#define ioctlADC_GET_WDG5L_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG5L_MASK)) >>10

#define ioctlADC_GET_WDG5H_ISR_FLAG(adcAddr,param) \
        (*((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET)) & (ADC_WDG5H_MASK)) >>11

#define ioctlADC_GET_WTISR_REG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTISR_OFFSET))

#define ioctlADC_SET_WDG0L_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG0L_MASK)) | (param)

#define ioctlADC_SET_WDG0H_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG0H_MASK)) | (param<<1)

#define ioctlADC_SET_WDG1L_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG1L_MASK)) | (param<<2)

#define ioctlADC_SET_WDG1H_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG1H_MASK)) | (param<<3)

#define ioctlADC_SET_WDG2L_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG2L_MASK)) | (param<<4)

#define ioctlADC_SET_WDG2H_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG2H_MASK)) | (param<<5)

#define ioctlADC_SET_WDG3L_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG3L_MASK)) | (param<<6)

#define ioctlADC_SET_WDG3H_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG3H_MASK)) | (param<<7)

#define ioctlADC_SET_WDG4L_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG4L_MASK)) | (param<<8)

#define ioctlADC_SET_WDG4H_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG4H_MASK)) | (param<<9)

#define ioctlADC_SET_WDG5L_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG5L_MASK)) | (param<<10)

#define ioctlADC_SET_WDG5H_MASK_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_WTIMR_OFFSET)) & (~ADC_MSKWDG5H_MASK)) | (param<<11)

#define ioctlADC_SET_THR_HIGH_CHNL0(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR0_OFFSET)) & (~ADC_THRH_MASK)) | (param)

#define ioctlADC_SET_THR_LOW_CHNL0(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR0_OFFSET)) & (~ADC_THRL_MASK)) | (param<<16)

#define ioctlADC_SET_THR_HIGH_CHNL1(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR1_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR1_OFFSET)) & (~ADC_THRH_MASK)) | (param)

#define ioctlADC_SET_THR_LOW_CHNL1(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR1_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR1_OFFSET)) & (~ADC_THRL_MASK)) | (param<<16)

#define ioctlADC_SET_THR_HIGH_CHNL2(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR2_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR2_OFFSET)) & (~ADC_THRH_MASK)) | (param)

#define ioctlADC_SET_THR_LOW_CHNL2(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR2_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR2_OFFSET)) & (~ADC_THRL_MASK)) | (param<<16)

#define ioctlADC_SET_THR_HIGH_CHNL3(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR3_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR3_OFFSET)) & (~ADC_THRH_MASK)) | (param)

#define ioctlADC_SET_THR_LOW_CHNL3(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR3_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR3_OFFSET)) & (~ADC_THRL_MASK)) | (param<<16)

#define ioctlADC_SET_THR_HIGH_CHNL4(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR4_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR4_OFFSET)) & (~ADC_THRH_MASK)) | (param)

#define ioctlADC_SET_THR_LOW_CHNL4(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR4_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR4_OFFSET)) & (~ADC_THRL_MASK)) | (param<<16)

#define ioctlADC_SET_THR_HIGH_CHNL5(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR5_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR5_OFFSET)) & (~ADC_THRH_MASK)) | (param)

#define ioctlADC_SET_THR_LOW_CHNL5(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_THRHLR5_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_THRHLR5_OFFSET)) & (~ADC_THRL_MASK)) | (param<<16)

#define ioctlADC_SET_PRESAMPLING_INTERNAL_VOLTAGE0(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSCR_OFFSET)) & (~ADC_PREVAL0_MASK)) | (param<<1)

#define ioctlADC_SET_PRESAMPLING_INTERNAL_VOLTAGE1(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSCR_OFFSET)) & (~ADC_PREVAL1_MASK)) | (param<<3)

#define ioctlADC_SET_PRESAMPLING_INTERNAL_VOLTAGE2(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSCR_OFFSET)) & (~ADC_PREVAL2_MASK)) | (param<<5)

#define ioctlADC_CONVERT_PRESAMPLED_VALUE(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSCR_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSCR_OFFSET)) & (~ADC_PRECONV_MASK)) | (param)

#define ioctlADC_SET_PRESAMPLING_CHNL0(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES0_MASK)) | (param)

#define ioctlADC_SET_PRESAMPLING_CHNL1(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES1_MASK)) | (param<<1)

#define ioctlADC_SET_PRESAMPLING_CHNL2(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES2_MASK)) | (param<<2)

#define ioctlADC_SET_PRESAMPLING_CHNL3(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES3_MASK)) | (param<<3)

#define ioctlADC_SET_PRESAMPLING_CHNL4(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES4_MASK)) | (param<<4)

#define ioctlADC_SET_PRESAMPLING_CHNL5(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES5_MASK)) | (param<<5)

#define ioctlADC_SET_PRESAMPLING_CHNL6(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES6_MASK)) | (param<<6)

#define ioctlADC_SET_PRESAMPLING_CHNL7(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES7_MASK)) | (param<<7)

#define ioctlADC_SET_PRESAMPLING_CHNL8(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES8_MASK)) | (param<<8)

#define ioctlADC_SET_PRESAMPLING_CHNL9(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES9_MASK)) | (param<<9)

#define ioctlADC_SET_PRESAMPLING_CHNL10(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES10_MASK)) | (param<<10)

#define ioctlADC_SET_PRESAMPLING_CHNL11(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES11_MASK)) | (param<<11)

#define ioctlADC_SET_PRESAMPLING_CHNL12(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES12_MASK)) | (param<<12)

#define ioctlADC_SET_PRESAMPLING_CHNL13(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES13_MASK)) | (param<<13)

#define ioctlADC_SET_PRESAMPLING_CHNL14(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES14_MASK)) | (param<<14)

#define ioctlADC_SET_PRESAMPLING_CHNL15(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_PSR0_OFFSET)) & (~ADC_PRES15_MASK)) | (param<<15)

#define ioctlADC_SET_INPLATCH_BITFIELD(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CTR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CTR0_OFFSET)) & (~ADC_INPLATCH_MASK)) | (param<<15)

#define ioctlADC_SET_OFFSET_SHIFT(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CTR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CTR0_OFFSET)) & (~ADC_OFFSHIFT_MASK)) | (param<<12)

#define ioctlADC_SET_INPCMP_BITFIELD(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CTR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CTR0_OFFSET)) & (~ADC_INPCMP_MASK)) | (param<<9)

#define ioctlADC_SET_INPSAMP(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CTR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CTR0_OFFSET)) & (~ADC_CTR0_INPSAMP_MASK)) | (param)

#define ioctlADC_SET_CH0_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH0_MASK)) | (param)

#define ioctlADC_SET_CH1_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH1_MASK)) | (param<<1)

#define ioctlADC_SET_CH2_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH2_MASK)) | (param<<2)

#define ioctlADC_SET_CH3_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH3_MASK)) | (param<<3)

#define ioctlADC_SET_CH4_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH4_MASK)) | (param<<4)

#define ioctlADC_SET_CH5_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH5_MASK)) | (param<<5)

#define ioctlADC_SET_CH6_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH6_MASK)) | (param<<6)

#define ioctlADC_SET_CH7_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH7_MASK)) | (param<<7)

#define ioctlADC_SET_CH8_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH8_MASK)) | (param<<8)

#define ioctlADC_SET_CH9_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH9_MASK)) | (param<<9)

#define ioctlADC_SET_CH10_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH10_MASK)) | (param<<10)

#define ioctlADC_SET_CH11_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH11_MASK)) | (param<<11)

#define ioctlADC_SET_CH12_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH12_MASK)) | (param<<12)

#define ioctlADC_SET_CH13_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH13_MASK)) | (param<<13)

#define ioctlADC_SET_CH14_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH14_MASK)) | (param<<14)

#define ioctlADC_SET_CH15_NORMAL_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_NCMR0_OFFSET)) & (~ADC_CH15_MASK)) | (param<<15)

#define ioctlADC_SET_CH0_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH0_MASK)) | (param)

#define ioctlADC_SET_CH1_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH1_MASK)) | (param<<1)

#define ioctlADC_SET_CH2_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH2_MASK)) | (param<<2)

#define ioctlADC_SET_CH3_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH3_MASK)) | (param<<3)

#define ioctlADC_SET_CH4_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH4_MASK)) | (param<<4)

#define ioctlADC_SET_CH5_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH5_MASK)) | (param<<5)

#define ioctlADC_SET_CH6_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH6_MASK)) | (param<<6)

#define ioctlADC_SET_CH7_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH7_MASK)) | (param<<7)

#define ioctlADC_SET_CH8_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH8_MASK)) | (param<<8)

#define ioctlADC_SET_CH9_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH9_MASK)) | (param<<9)

#define ioctlADC_SET_CH10_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH10_MASK)) | (param<<10)

#define ioctlADC_SET_CH11_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH11_MASK)) | (param<<11)

#define ioctlADC_SET_CH12_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH12_MASK)) | (param<<12)

#define ioctlADC_SET_CH13_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH13_MASK)) | (param<<13)

#define ioctlADC_SET_CH14_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH14_MASK)) | (param<<14)

#define ioctlADC_SET_CH15_INJECTED_CONV_MASK(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_JCMR0_OFFSET)) & (~ADC_CH15_MASK)) | (param<<15)

#define ioctlADC_SET_POWER_DOWN_DELAY(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_PDEDR_OFFSET)) = (param)

#define ioctlADC_READ_VALUE(adcAddr,param) \
        *((vuint32_t *)(adcAddr + param)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_CHNL0(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR0_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR0(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR0_OFFSET))

#define ioctlADC_READ_VALUE_CHNL1(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR1_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR1(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR1_OFFSET))

#define ioctlADC_READ_VALUE_CHNL2(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR2_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR2(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR2_OFFSET))

#define ioctlADC_READ_VALUE_CHNL3(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR3_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR3(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR3_OFFSET))

#define ioctlADC_READ_VALUE_CHNL4(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR4_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR4(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR4_OFFSET))

#define ioctlADC_READ_VALUE_CHNL5(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR5_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR5(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR5_OFFSET))

#define ioctlADC_READ_VALUE_CHNL6(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR6_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR6(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR6_OFFSET))

#define ioctlADC_READ_VALUE_CHNL7(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR7_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR7(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR7_OFFSET))

#define ioctlADC_READ_VALUE_CHNL8(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR8_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR8(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR8_OFFSET))

#define ioctlADC_READ_VALUE_CHNL9(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR9_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR9(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR9_OFFSET))

#define ioctlADC_READ_VALUE_CHNL10(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR10_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR10(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR10_OFFSET))

#define ioctlADC_READ_VALUE_CHNL11(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR11_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR11(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR11_OFFSET))

#define ioctlADC_READ_VALUE_CHNL12(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR12_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR12(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR12_OFFSET))

#define ioctlADC_READ_VALUE_CHNL13(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR13_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR13(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR13_OFFSET))

#define ioctlADC_READ_VALUE_CHNL14(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR14_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR14(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR14_OFFSET))

#define ioctlADC_READ_VALUE_CHNL15(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR15_OFFSET)) & (ADC_CDATA_MASK)

#define ioctlADC_READ_VALUE_REG_CDR15(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CDR15_OFFSET))

#define ioctlADC_SEL_THRESHOLD_REG_CHNL0(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) & (~ADC_WSEL_CH0_MASK)) | (param)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL1(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) & (~ADC_WSEL_CH1_MASK)) | (param<<4)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL2(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) & (~ADC_WSEL_CH2_MASK)) | (param<<8)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL3(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) & (~ADC_WSEL_CH3_MASK)) | (param<<12)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL4(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) & (~ADC_WSEL_CH4_MASK)) | (param<<16)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL5(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) & (~ADC_WSEL_CH5_MASK)) | (param<<20)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL6(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) & (~ADC_WSEL_CH6_MASK)) | (param<<24)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL7(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL0_OFFSET)) & (~ADC_WSEL_CH7_MASK)) | (param<<28)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL8(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) & (~ADC_WSEL_CH8_MASK)) | (param)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL9(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) & (~ADC_WSEL_CH9_MASK)) | (param<<4)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL10(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) & (~ADC_WSEL_CH10_MASK)) | (param<<8)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL11(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) & (~ADC_WSEL_CH11_MASK)) | (param<<12)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL12(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) & (~ADC_WSEL_CH12_MASK)) | (param<<16)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL13(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) & (~ADC_WSEL_CH13_MASK)) | (param<<20)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL14(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) & (~ADC_WSEL_CH14_MASK)) | (param<<24)

#define ioctlADC_SEL_THRESHOLD_REG_CHNL15(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWSEL1_OFFSET)) & (~ADC_WSEL_CH15_MASK)) | (param<<28)

#define ioctlADC_ENABLE_WATCHDOG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWENR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWENR0_OFFSET)) & (~ADC_CWEN0_MASK)) | (param)

#define ioctlADC_DISABLE_WATCHDOG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_CWENR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_CWENR0_OFFSET)) & (~ADC_CWEN0_MASK)) | (~param)

#define ioctlADC_READ_OUT_OF_RANGE_REGISTER(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_AWORR0_OFFSET)) & (ADC_AWOR_MASK) & (param)

#define ioctlADC_CLEAR_OUT_OF_RANGE_FLAG(adcAddr,param) \
        *((vuint32_t *)(adcAddr + ADC_AWORR0_OFFSET)) = (*((vuint32_t *)(adcAddr + ADC_AWORR0_OFFSET)) & (~ADC_AWOR_MASK)) | (param)

#ifdef __cplusplus
}
#endif

#endif /* __MPC5606B_ADC_LLD_H */