/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     MPC5606B_CB_BSP.h
*
* @author   b06050
*
* @version  1.0.4.0
*
* @date     Aug-3-2012
*
* @brief    Header file for Board Support Package for MPC5606B Controller Board
*
********************************************************************************
*
* This file includes MACRO definitions of Board Support Package for
* MPC5606B Controller Board
*
*******************************************************************************/
#ifndef __MPC5606B_CB_BSP_H
#define __MPC5606B_CB_BSP_H

/*******************************************************************************
* General definitions
*******************************************************************************/
#define FAULT_0_PIN             36  // PC[4]
#define FAULT_1_PIN             37  // PC[5]
#define FAULT_RESET_PIN         96  // PF[10]
#define FAULT_EN_PIN            15  // PA[15]

#define MC33937_EN_PIN          14  // PA[14]
#define MC33937_RST_PIN         90  // PF[10]
#define MC33937_INT_PIN         93  // PF[13]

#define DSPI4_CS0_PIN           107 // PG[11]

#define ON_OFF_SW_PIN           65  // PE[1]
#define UP_SW_PIN               74  // PE[10]
#define DOWN_SW_PIN             73  // PE[9]

#define LED_RUN_PIN             16  // PB[0]

#define UNI3_BRAKE_PIN          4   // PA[4]

/* eMIOS0 unified channel definition */
#define EMIOS0_UC_MC        0   /* Modulus counter @ 64MHz */
#define EMIOS0_UC_PWMA_HS   1   /* PWM_A HS */
#define EMIOS0_UC_PWMB_HS   3   /* PWM_B HS */
#define EMIOS0_UC_PWMC_HS   5   /* PWM_C HS */
#define EMIOS0_UC_PWMA_LS   2   /* PWM_A LS */
#define EMIOS0_UC_PWMB_LS   4   /* PWM_B LS */
#define EMIOS0_UC_PWMC_LS   6   /* PWM_C LS */
#define EMIOS0_UC_OC        7   /* Output compare */

/* eMIOS1 unified channel definition */
#define EMIOS1_UC_OC        24  /* Output capture @ 1MHz */
#define EMIOS1_UC_IC        25  /* Input capture @ 1MHz  */

/*-------------------------------------------
 * Fault PIN assignment
--------------------------------------------*/
#define FAULT_DCBV_PIN          FAULT_0_PIN  /*!< Assignment of DCBus undervoltage fault */
#define FAULT_DCBI_PIN          FAULT_1_PIN  /*!< Assignment of DCBus overcurrent fault */

#endif /* __MPC5606B_CB_BSP_H */