/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2012 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
****************************************************************************//*!
*
* @file     MPC5606B_appconfig.h
*
* @author   b06050
*
* @version  1.0.3.0
*
* @date     Aug-3-2012
*
* @brief    File for static configuration of the MPC5606B device
*
*
*******************************************************************************/
#ifndef __MPC5606B_APPCONFIG_H
#define __MPC5606B_APPCONFIG_H

/*
Interrupts
--------------------------------------
*/
#define IRQ_217_FCN         FMSTR_Isr
#define IRQ_217_PRIORITY    0x1
#define IRQ_216_FCN         FMSTR_Isr
#define IRQ_216_PRIORITY    0x1
#define IRQ_169_FCN         EMIOS1_CH24_ISR
#define IRQ_169_PRIORITY    0xE
#define IRQ_62_FCN          BLDC_Fast_ISR
#define IRQ_62_PRIORITY     0xD

/*
SIUL registers configuration
--------------------------------------
*/
#define SIU_PCR0            0x0A00 // CLKOUT
#define SIU_PCR1            0x0600 // eMIOS0_CH1 OUT
#define SIU_PCR2            0x0600 // eMIOS0_CH2 OUT
#define SIU_PCR3            0x0600 // eMIOS0_CH3 OUT
#define SIU_PCR4            0x0200 // GPO
#define SIU_PCR13           0x0200 // GPO
#define SIU_PCR14           0x0200 // GPO
#define SIU_PCR15           0x0200 // GPO
#define SIU_PCR16           0x0200 // GPO
#define SIU_PCR28           0x0600 // eMIOS0_CH4 OUT
#define SIU_PCR29           0x0600 // eMIOS0_CH5 OUT
#define SIU_PCR30           0x0600 // eMIOS0_CH6 OUT
#define SIU_PCR36           0x0100 // GPI
#define SIU_PCR37           0x0100 // GPI
#define SIU_PCR39           0x0100 // GPI
#define SIU_PCR41           0x0A00 // eMIOS0_CH7 OUT
#define SIU_PCR44           0x0102 // GPI PULL-UP
#define SIU_PCR46           0x0102 // GPI PULL-UP
#define SIU_PCR47           0x0102 // GPI PULL-UP
#define SIU_PCR48           0x2000 // ANALOG IN
#define SIU_PCR49           0x2000 // ANALOG IN
#define SIU_PCR50           0x2000 // ANALOG IN
#define SIU_PCR51           0x2000 // ANALOG IN
#define SIU_PCR52           0x2000 // ANALOG IN
#define SIU_PCR53           0x2000 // ANALOG IN
#define SIU_PCR54           0x2000 // ANALOG IN
#define SIU_PCR65           0x0100 // GPI
#define SIU_PCR66           0x0100 // SIN_1
#define SIU_PCR67           0x0A00 // SOUT_1
#define SIU_PCR68           0x0A00 // SCK_1
#define SIU_PCR69           0x0A00 // CS0_1
#define SIU_PCR73           0x0100 // GPI
#define SIU_PCR74           0x0100 // GPI
#define SIU_PCR76           0x0100 // GPI
#define SIU_PCR77           0x0200 // GPO
#define SIU_PCR78           0x0200 // GPO
#define SIU_PCR90           0x0200 // GPO
#define SIU_PCR91           0x0100 // GPI
#define SIU_PCR92           0x0500 // eMIOS1_CH25 IN
#define SIU_PCR93           0x0100 // GPI
#define SIU_PCR96           0x0200 // GPO
#define SIU_PCR102          0x0A00 // LIN6TX
#define SIU_PCR103          0x0100 // LIN6RX

#define SIU_PCR104          0x0200 // GPO (for TEST purpose)
#define SIU_PCR105          0x0200 // GPO (for TEST purpose)


#define SIU_PCR106          0x0100 // SIN_4
#define SIU_PCR107          0x0A00 // CS0_4
#define SIU_PCR108          0x0A00 // SOUT_4
#define SIU_PCR109          0x0A00 // SCK_4

#define SIU_PSMI7           0x01
#define SIU_PSMI8           0x01
#define SIU_PSMI9           0x02
#define SIU_PSMI35          0x00
#define SIU_PSMI36          0x00
#define SIU_PSMI37          0x00
#define SIU_PSMI51          0x00

/*
eMIOS0 registers configuration
--------------------------------------
*/
#define EMIOS0_MCR          0x14000000

#define EMIOS0_UC0_CCR      0x02000600
#define EMIOS0_UC1_CCR      0x43020226
#define EMIOS0_UC2_CCR      0x02000201
#define EMIOS0_UC3_CCR      0x42000226
#define EMIOS0_UC4_CCR      0x02000201
#define EMIOS0_UC5_CCR      0x42000226
#define EMIOS0_UC6_CCR      0x02000201
#define EMIOS0_UC7_CCR      0x02000303

#define EMIOS0_UC0_CADR     PERIOD
#define EMIOS0_UC1_CADR     0x0000
#define EMIOS0_UC2_CADR     0x0000
#define EMIOS0_UC3_CADR     0x0000
#define EMIOS0_UC4_CADR     0x0000
#define EMIOS0_UC5_CADR     0x0000
#define EMIOS0_UC6_CADR     0x0000
#define EMIOS0_UC7_CADR     ((PERIOD >> 1) + DELAY)

#define EMIOS0_UC0_CBDR     0x0000
#define EMIOS0_UC1_CBDR     0x0000
#define EMIOS0_UC2_CBDR     0x0000
#define EMIOS0_UC3_CBDR     0x0000
#define EMIOS0_UC4_CBDR     0x0000
#define EMIOS0_UC5_CBDR     0x0000
#define EMIOS0_UC6_CBDR     0x0000
#define EMIOS0_UC7_CBDR     0x0000

#define EMIOS0_UC1_ALTCADR  ((PERIOD >> 1) + DELAY)

/*
eMIOS1 registers configuration
--------------------------------------
*/
#define EMIOS1_MCR          0x14000F00

#define EMIOS1_UC24_CCR     0x0E020701
#define EMIOS1_UC25_CCR     0x00000302

/*
CTU registers configuration
--------------------------------------
*/
#define CTU_EVTCFGR1         0x00008104


/*
ADC0 registers configuration
--------------------------------------
*/
#define ADC0_MCR             0x80600000
#define ADC0_IMR             0x00000004
#define ADC0_JCMR0           0x00000180
#define ADC0_CTR0            0x00008411


/*
ADC1 registers configuration
--------------------------------------
*/
#define ADC1_MCR             0x80020000
#define ADC1_CTR0            0x00008011

/*
DSPI1 registers configuration
--------------------------------------
*/
#define DSPI1_MCR            0x803F0C00
#define DSPI1_CTAR0          0x3A002255
#define DSPI1_CTAR1          0x7A004454

/*
DSPI4 registers configuration
--------------------------------------
*/
#define DSPI4_MCR            0x813F3C00
#define DSPI4_CTAR0          0x3A015554
#define DSPI4_CTAR1          0x39010004

/*
PIT registers configuration
--------------------------------------
*/
#define PIT_PITMCR           0x00000000
#define PIT_CH2_LDVAL        ((PERIOD >> 1) + DELAY)

#endif /* __MPC5606B_APPCONFIG_H */