/***************************************************************************************************
**	Ver			Date			Author				Description
----------------------------------------------------------------------------------------------------
**	0.1			18/Jun/2010		Shanaka				SCI Initial version

***************************************************************************************************/
#include "mpc5675k_0201.h"
#include "sci.h"
 
/************************************************************************/
/*							LINFLEX_0									*/
/*envirnment:	473BGA EVB												*/
/************************************************************************/
void PCR_Config4LINFLEX0_init(void)
{
		SIU.PCR[18].R = 0x0600;	//PA=1, OBE=1 for LINFLEX0 Tx PB[2] 
		SIU.PCR[19].R = 0x0200;	//IBE = 1 for LinFlex0 Rx PB[3]	
}


/************************************************************************/
/* Linflex_0 Initialization for 9600bps @90MHz periclk					*/
/* Baudrate = f_periph_set_1_clk/16*LFDIV								*/
/* where, LFDIV = LNIBRR + LNIFBRR/LNIBRR 								*/
/************************************************************************/
void LINFLEX_0_UART_init(void)
{
	PCR_Config4LINFLEX0_init();								// Pad configuration for LINFLEX0 to PB[2] PB[3]
	LINFLEX_0.LINCR1.B.SLEEP = 0;
	LINFLEX_0.LINCR1.B.INIT = LIN_INIT_Mode;				// For initialization INIT should be set to 1
	//LINFLEX_0.LINIBRR.R = 585;								// 90MHz => 9600bps
	LINFLEX_0.LINIBRR.R = 48;								// 90MHz => 9600bps
	//LINFLEX_0.LINFBRR.R = 15;								// 90M/(16x(585+15/16))=9600.0 bps
	LINFLEX_0.LINFBRR.R = 13;								// 90M/(16x(146+8/16))=4x9600.0 bps
	LINFLEX_0.LINCR1.B.AWUM = 1;							// Auto matic wake up from sleep
	
	LINFLEX_0.UARTCR.B.UART = UART_Mode;						//UART=1 for UART mode 0 for LIN
	LINFLEX_0.UARTCR.B.TDFLTFC = Transmit_DATA_Length_1Byte;	//Transmitter data field length : 0-1 buffer 3-4 buffer
	LINFLEX_0.UARTCR.B.RDFLRFC = Receive_DATA_Length_1Byte; 	//Receiver data field length : 0-1 buffer 3-4 buffer
	LINFLEX_0.UARTCR.B.WL0 	 = 1;							// Set word length to 8-bit data (9-bit for PCE=1)
	
	//interrupts enabling
	LINFLEX_0.LINSR.R = 0xFFFF;								// Clear status register for pending interrupt
	//LINFLEX_0.LINIER.R = 0x2020;							// BEIE,WUIE,DRIE,DTIE are enabled
	LINFLEX_0.LINCR1.B.INIT = LIN_NORMAL_Mode;				// return for Normal mode
	
	//INTC priority settings
	//INTC.PSR[79].R  = 0x02;								// LINFLEX0 Rx
	//INTC.PSR[80].R  = 0x02;								// LINFLEX0 Tx
	//INTC.PSR[81].R  = 0x02;								// LINFLEX0 Err
}

void sci_a_putchar (char ch)
{
 	LINFLEX_0.BDRL.B.DATA0 = ch;		// Shoud be write as 32bit wise
 	while(LINFLEX_0.UARTSR.B.DTFTFF != 1){};	// wait till Data is tranfered
 	LINFLEX_0.UARTSR.B.DTFTFF = 1;			// clear Data Transfered flag		
}

void LINFLEX_0_TX_Enable(void)
{
  LINFLEX_0.UARTCR.B.TXEN = 1;	//Tx enble
}

void LINFLEX_0_TX_Disable(void)
{
  LINFLEX_0.UARTCR.B.TXEN = 0;	//Tx enble
}

void Uart_init(void)
{
	PCR_Config4LINFLEX0_init();								// Pad configuration for LINFLEX0 to PB[2] PB[3]
	LINFLEX_0.LINCR1.R = 0x00000001;
	LINFLEX_0.GCR.R = 0x00000007;							//not working because of SR=1 so user have to clear it before LinFlex Mode=Normal
	//LINFLEX_0.GCR.R = 0x00000006;
	LINFLEX_0.UARTCR.R = 0x00000001;
	LINFLEX_0.LINIBRR.R = 585;								// 90MHz => 9600bps
	LINFLEX_0.LINFBRR.R = 15;								// 90M/(16x(585+15/16))=9600.0 bps
	//LINFLEX_0.LINCR1.B.AWUM = 1;							// Auto matic wake up from sleep
	//LINFLEX_0.LINSR.R = 0xFFFF;
	//LINFLEX_0.UARTCR.R = 0x00000007;
	//LINFLEX_0.UARTCR.R = 0x00000737;
	LINFLEX_0.UARTCR.R = 0x00000637;
	//LINFLEX_0.UARTCR.R = 0x00000337;
	//LINFLEX_0.UARTSR.R = 0xffff;
	//LINFLEX_0.GCR.R = 0x00000007;
	LINFLEX_0.GCR.R = 0x00000006;
	LINFLEX_0.LINCR1.R = 0x00000000;
	//LINFLEX_0.GCR.R = 0x00000001;	//ok have to ask design....
}