 /********************************************************************************************************
 **  Version: 	Date: 		Author:		Description: 
 **  -----------------------------------------------------------------------------------------------------
 **	 V0.1 		24/04/2010 	Shanaka 	Initial version
 **  V0.2 		14/05/2010 	Shanaka 	Add eTimer2 ch5
 ********************************************************************************************************/
/**************************************************************************/
#include "mpc5675k-2.02.h"
#include "eTimer.h"

/**************************************************************************/
#define CTU_OVERHEAD		0
#define TIMER_PULSE_2_CTU 	60
#define TIMER_PERIOD_2_CTU 	180 + CTU_OVERHEAD
#define TIMER_INITIAL_VAL   1

/**************************************************************************/
/* FUNCTION     : setup_eTimer1                                           */
/* MOCLK		: 120MHz												  */
/**************************************************************************/
void eTimer_1_init(void)
{
  eTimer1_ch2_setup(); // Output on Port B[0]  ALT2 Ch2 eTimer1 ETC[2]

  ETIMER_1.ENBL.R = V_DIBLALL; 		// disable etimer1 all channels
  
  /****************************************************************************
  ** eTimer1 ch4 settings for CTU_1
  ****************************************************************************/
  ETIMER_1.CHANNEL[4].COMP1.R 	= TIMER_PULSE_2_CTU;   	// initial low period 0x21-0x1=0x20
  ETIMER_1.CHANNEL[4].COMP2.R 	= TIMER_PERIOD_2_CTU;   	// PWM period 0x101-0x1=0x100
  ETIMER_1.CHANNEL[4].LOAD.R 	= TIMER_INITIAL_VAL;	// initial count =0x0
  //ETIMER_1.CHANNEL[4].CMPLD2.R = 0x0001;	// initial count =0x1
  ETIMER_1.CHANNEL[4].CTRL.R 	= 0x3844;      // Ip clock / 1        
  ETIMER_1.CHANNEL[4].CTRL2.R 	= 0x8004;   
  ETIMER_1.CHANNEL[4].CTRL3.R 	= 0x6F00;      
//  ETIMER_1.CHANNEL[4].CCCTRL.R = 0xeC61; 	//CLC2=0x7: Load CNTR with CMPLD2 upon successful comparison of COMP2
   							//CLC1=0x3: Load COMP1 with CMPLD1 upon successful comparison of COMP2

  /****************************************************************************
  ** eTimer1 ch2 settings for CTU_0
  ****************************************************************************/
  ETIMER_1.CHANNEL[2].INTDMA.R 	= V_DIBLALL; 	// disable all interrupt and DMA requests
  ETIMER_1.CHANNEL[2].COMP1.R 	= TIMER_PULSE_2_CTU;   	// initial low period 200-0=200
  ETIMER_1.CHANNEL[2].COMP2.R 	= TIMER_PERIOD_2_CTU;   	// PWM period 100-0=100
  ETIMER_1.CHANNEL[2].LOAD.R 	= TIMER_INITIAL_VAL;	// initial count =0x0
//  ETIMER_1.CHANNEL[2].CMPLD2.R = 0x0001;	// initial count =0x1
  ETIMER_1.CHANNEL[2].CTRL.R 	= 0x3844;    // IPCLK/1    
  ETIMER_1.CHANNEL[2].CTRL2.R 	= 0x8004;   
  ETIMER_1.CHANNEL[2].CTRL3.R 	= 0x6F00;      

  ETIMER_1.CHANNEL[2].STS.R = V_CLAER_STS; 		// Clear all flags

  ETIMER_1.ENBL.R = V_ENBL4 | V_ENBL2; // enable timer1 ch4&2 and start PWM output
}

/**************************************************************************/
/* FUNCTION     : setup_eTimer2                                           */
/**************************************************************************/
void eTimer_2_init(void)
{
  ETIMER_2.ENBL.R = V_DIBLALL; 		// disable etimer1 all channels
  /****************************************************************************
  ** eTimer1 ch5 settings
  ****************************************************************************/
  ETIMER_2.CHANNEL[5].COMP1.R 	= 0x002;   	// initial low period 0x20-0x0=0x20
  ETIMER_2.CHANNEL[5].COMP2.R 	= 0x002;   	// PWM period 0x100-0x0=0x100
  ETIMER_2.CHANNEL[5].CTRL.R 	= 0xD849;   // Edge of second source triggers primary count till compare =110,Ip clock / 1 =11000, count once=1, upcount=0, Sec source=Aux1      
  ETIMER_2.CHANNEL[5].CTRL2.R 	= 0x8005;   // Output mode 0101
}
