 /********************************************************************************************************
 **  Version: 	Date: 		Author:		Description: 
 **  -----------------------------------------------------------------------------------------------------
 **	 V0.1 		25/04/2010 	Shanaka 	Initial version ADC0->CTU0 & ADC1->Injection by eTimer1 ch5 edge
 **  V0.2 		14/05/2010 	Shanaka 	Add the ADC2->CTU1 & ADC3->Injection by eTimer2 ch5 edje
 **	 V0.3 	   	14/06/2010  Shanaka		Change all channels to CTU trigger mode
 ********************************************************************************************************/
 #include "mpc5675k_0201.h"
 #include "adc.h"
 #include "dma.h"
 /*************************************************************************************
 ** Function : ADC_INIT
 ** Purpose  : initialize the ADC modules and ADC sampling input pins
 ** Originator : Shanaka Pradeep(b10849)
 ** Date : 25/04/2010
 ** ADC_CLK = 60MHz ( MOTC_CLK/2 = 120MHz/2 )
 ** Tconversion = 1us = (Tsamp + Teval + 1) x Tadc_clk = ((24-1) + 12x3 + 1 ) 1/60 us
 **             = 60 x 1/06 us = 1us
 *************************************************************************************/
 
 void ADC_INIT(void)
 {
  //SIU.PCR[70].R = 0x2000;     // adc_0 ch4
  //SIU.PCR[66].R = 0x2000;     // adc_0 ch5
  SIU.PCR[24].R = 0x2000;     // adc_0 ch1
  SIU.PCR[33].R = 0x2000;     // adc_0 ch2

  //SIU.PCR[75].R = 0x2000;     // adc_1 ch4
  //SIU.PCR[64].R = 0x2000;     // adc_1 ch5
  SIU.PCR[31].R = 0x2000;     // adc_1 ch2
  
  //SIU.PCR[221].R = 0x2000;     // adc_2 ch0
  //SIU.PCR[222].R = 0x2000;     // adc_2 ch1
  SIU.PCR[223].R = 0x2000;     // adc_2 ch2
  
  SIU.PCR[229].R = 0x2000;     // adc_3 ch0
  //SIU.PCR[230].R = 0x2000;     // adc_3 ch1
  SIU.PCR[231].R = 0x2000;     // adc_3 ch2
  
  
  
  ADC_0.MCR.B.PWDN 			= 1;		// power down the ADC module
  ADC_0.CTR[0].B.INPSAMP 	= 0x15;//INPSAMP_24;		// set the sampling duration
  ADC_0.CTR[0].B.INPCMP 	= 0x3;		// set the comparision duration
  ADC_0.CTR[0].B.INPLATCH 	= 0x1;		// set for optimal value
  ADC_0.MCR.B. PWDN 		= 0;		// exit from power down state (offset cancellation is performed)
  ADC_0.CTR[0].B.OFFSHIFT 	= 0x3;		// offset shift not used
  ADC_0.MCR.B.ADCLKSEL 		= 0;		// ADC 0 clock prescaler = 2 (ADC clock = ipg_clk/2)

  ADC_1.MCR.B.PWDN 			= 1;
  ADC_1.CTR[0].B.INPSAMP 	= 0x15;//INPSAMP_24;		// set the sampling duration
  ADC_1.CTR[0].B.INPCMP 	= 0x3;		// set the comparision duration
  ADC_1.CTR[0].B.INPLATCH 	= 0x1;
  ADC_1.MCR.B. PWDN 		= 0;		// exit from power down state (offset cancellation is performed)
  ADC_1.CTR[0].B.OFFSHIFT 	= 0x3;		// offset shift not used
  ADC_1.MCR.B.ADCLKSEL 		= 0;		// ADC 0 clock prescaler = 2 (ADC clock = ipg_clk/2)

  
//********************  for Komodo use only ************************
#ifdef KOMODO
  ADC_2.MCR.B.PWDN 			= POWERDOWN;		// power down the ADC module
  ADC_2.CTR[0].B.INPSAMP 	= 0x15;//INPSAMP_24;		// set the sampling duration
  ADC_2.CTR[0].B.INPCMP 	= INPCOMP_3;		// set the comparision duration
  ADC_2.CTR[0].B.INPLATCH 	= INPLATCH_1;		// set for optimal value
  ADC_2.MCR.B. PWDN 		= POWERUP;			// exit from power down state (offset cancellation is performed)
  ADC_2.CTR[0].B.OFFSHIFT 	= NOOFFSET;			// offset shift not used
  ADC_2.MCR.B.ADCLKSEL 		= ADCCLKDIVBY2;		// ADC 0 clock prescaler = 2 (ADC clock = ipg_clk/2)

  ADC_3.MCR.B.PWDN 			= POWERDOWN;
  ADC_3.CTR[0].B.INPSAMP 	= 0x15;//INPSAMP_24;		// set the sampling duration
  ADC_3.CTR[0].B.INPCMP 	= INPCOMP_3;		// set the comparision duration
  ADC_3.CTR[0].B.INPLATCH 	= INPLATCH_1;
  ADC_3.MCR.B. PWDN 		= POWERUP;			// exit from power down state (offset cancellation is performed)
  ADC_3.CTR[0].B.OFFSHIFT 	= NOOFFSET;			// offset shift not used
  ADC_3.MCR.B.ADCLKSEL 		= ADCCLKDIVBY2;		// ADC 0 clock prescaler = 2 (ADC clock = ipg_clk/2)

  ADC_2.MCR.B. CTUEN 		= CTUENABLE;		// CTU Control Mode enable
  ADC_3.MCR.B. CTUEN 		= CTUENABLE;		// CTU Control Mode enable
  #endif

  ADC_0.MCR.B. CTUEN 		= CTUENABLE;		// CTU Control Mode enable
  ADC_1.MCR.B. CTUEN 		= CTUENABLE;		// CTU Control Mode enable
  }
