#***************************************************************************/
#* FILE NAME:                               COPYRIGHT (c) Freescale 2008   */
#* SSI0_HW_Handler_NewVLE_Best.s                  All Rights Reserved      */
#* DESCRIPTION:                                                            */
#*        This file creates prolog, epilog for C ISR and enables nested    */
#*        interrupts. This file starts in memory at the beginning of the   */
#*        ".xcptn" section designated by the label "IVOR4Handler".         */
#* WARNING:  This stack frame does not save the SPEs Accumulator, which    */
#*           is required if SPE instructions are used in ISRs.   If SPE    */
#*           instructions are used, the stack frame must include the       */
#*           accumulator, and prologue and epilogue must be modified.      */
#========================================================================= */
#*                                                                         */
#* REV      AUTHOR       DATE       DESCRIPTION OF CHANGE                  */
#* ---   -----------   ----------   ---------------------                  */
#* 1.0:  S. Mihalik    23/Apr/04     Initial version                       */
#* 1.1:  B. Terry      29/Jul/04    Modified read of IACKR using           */
#*                                  pointer to determine vector  address.  */
#* 1.2   G. Jackson    30/Jul/04    Added ".xcptn" section designation     */
#*                                   for placement into mpc5500cfg.        */
#* 1.3   G. Jackson    12/Oct/04    Green Hills now does not require       */
#*                                    quotation marks around the section   */
#*                                  Added syntax to generate symbols for   */
#*                                    debug.                               */
#* 1.4   G. Jackson    18/Oct/04    Epilogue move of restoration for r3,   */
#*                                    and r4 until after INTC_EOIR.        */
#* 1.5   C. Baker      19/Jul/06    Added comments                         */
#* 1.6   R. Moran      23/Feb/07    Modified instructions to VLE           */
#* 1.7   R. Moran      10/Dec/08    Added new Save and Restore instructions*/
#***************************************************************************/

 # Indent one space to prevent GCC warning
 # STACK FRAME DESIGN: Depth: 20 words (0x50, or 80 bytes)
 #            ************* 
 #   0x30-50  *  GPR4-12  *
 #   0x28     *  GPR3     * 
 #   0x24     *  GPR0     * 
 #   0x20     *  XER      * 
 #   0x1C     *  CTR      * 
 #   0x18     *  LR       *  
 #   0x14     *  CR       * 
 #   0x10     *  SRR1     *  
 #   0x0C     *  SRR0     * 
 #   0x08     *  padding  * 
 #   0x04     *  padding  * 
 #   0x00     *  SP       * 
 #            ************* 
 
    .globl   SSI0_Handler

    .section  .xptn_vectors, vax
    .vle

    # On Dual Core these registers are treated as Processor 0
    .equ  INTC_EOIR,  0xfff48018  # End Of Interrupt Register address
      
    .align 4
    
SSI0_Handler:
prolog:                            # PROLOGUE 
                                   
    e_stwu   r1, -0x50(r1)         # Create stack frame and store back chain 
                                   
    e_stw    r3, 0x28(r1)          # Save working registers R3
                                   
    .long 0x18211114               # e_stmvsprw  0x14 (r1) 
                                   # Store vol. SPRs on stack (CR,LR,CTR,XER)
                                   
    .long 0x18011124               # e_stmvgprw  0x24 (r1) 
                                   # Store vol. GPRs on stack (R0, R3-R12)                                                                 
                                   
    e_lwz    r0, 0(r3)             # Read ISR address from ISR Vector Table address
    mtLR     r0                    
                                   
    e_bl SSI0_ISR                  # Branch to ISR, but return here

    
    
epilog:                            # EPILOGUE

    .long 0x18011024               # e_lmvgprw  0x24 (r1) 
                                   # Restore vol. GPRs from stack (R0, R3-R12)                                   
                                   
    .long 0x18211014               # e_lmvsprw   0x14 (r1)
                                   # Rest. vol. SPRs from stack(CR,LR,CTR,XER)

    e_lis    r3, INTC_EOIR@ha      # Load upper half of EIOR address to r3
                                                                                                                                                 
    mbar 0                         # Ensure interrupt flag has finished clearing
                                   # before writing to INTC_EIOR
    e_stw    r3, INTC_EOIR@l(r3)   # Load lower half of EIOR address to r3 and
                                   # write contents of r3 to INTC_EOIR, address 0xFFF4 8018
    
    e_lwz    r3,  0x28(r1)         # Restore r3 after INTC_EOIR uses this register
    
    e_lwz    r3,  0x28 (r1)        # Restore working register
    e_add16i r1, r1, 0x50          # Restore space on stack

    se_rfi                         # End of Interrupt - re-enables interrupts.
