/** ###################################################################
**     Filename  : Example_Project_for_eFlexPWM.C
**     Project   : Example_Project_for_eFlexPWM
**     Processor : MC56F8257
**     Version   : Driver 01.14
**     Compiler  : Metrowerks DSP C Compiler
**     Date/Time : 3/3/2011, 6:20 PM
**     Abstract  :
**         Main module.
**         This module contains user's application code.
**     Settings  :
**     Contents  :
**         No public methods
**
** ###################################################################*/
/* MODULE ePWM_test */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

#define MODE_SEL 0		/* Edge-aligned PWM */
//#define MODE_SEL 1		/* Center-aligned PWM */
//#define MODE_SEL 2		/* Complementary PWM */
//#define MODE_SEL 3		/* Push-pull PWM */
//#define MODE_SEL 4		/* Multi-phase PWM */
//#define MODE_SEL 5		/* Phase-shifted PWM */
//#define MODE_SEL 6		/* Current-limit PWM */
//#define MODE_SEL 7		/* Current-reset PWM */
//#define MODE_SEL 8		/* High-resolution PWM with fractional delay logic */
//#define MODE_SEL 9		/* Enhanced capture */

UInt16 frequency,dutycycle1,dutycycle2,phaseshift,currentlimit,turnon,risingedge,risingedgeold,fallingedge,counter;

void main(void)
{
  /* Write your local variable definition here */
  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/

  /* Write your code here */
  switch(MODE_SEL)		/* Switch operation mode of eFlexPWM module */
  {
  	case 0:
  	{
  		/* Configure PWM output pins */
  		setReg16Bits(GPIO_E_PEREN, 0x03U);	 		/* Set GPIOE0/1 as PWM0A,PWM0B output */
  		/* Configure sub-module0 as edge-aligned PWM mode with 100kHz frequency */
  		setReg16(PWM_SM0_INIT, 0xFED4U);     		/* Set Initial count register as -300, 60MHz/100kHz/2 = 300 */ 
  		setReg16(PWM_SM0_CTRL2, 0x2000U);    		/* Set Control 2 register: independent PWM mode with IP bus clock */
  		setReg16(PWM_SM0_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM0_VAL0, 0x00U);       		/* Set Value 0 register as 0, middle point of PWM period */ 
  		setReg16(PWM_SM0_VAL1, 0x012BU);     		/* Set Value 1 register as 299, 60MHz/100kHz/2-1 = 299 */ 
  		setReg16(PWM_SM0_VAL2, 0xFED4U);     		/* Set Value 2 register as INIT for rising edge-aligned */ 
  		setReg16(PWM_SM0_VAL3, 0xFED4U);     		/* Set Value 3 register as INIT to output low level for PWM0A */ 
  		setReg16(PWM_SM0_VAL4, 0xFED4U);     		/* Set Value 4 register as INIT for rising edge-aligned */ 
  		setReg16(PWM_SM0_VAL5, 0xFED4U);     		/* Set Value 5 register as INIT to output low level for PWM0B */ 
  		setReg16(PWM_SM0_DISMAP, 0x0F00U);   		/* Set Fault disable mapping register */
  		setReg16(PWM_OUTEN, 0x0110U);        		/* Set Output enable register to enable PWM0A/PWM0B output */
  		setReg16(PWM_DTSRCSEL, 0x00U);       		/* Set Deadtime source select register as generated PWM for sub-module0 */
  		clrSetReg16Bits(PWM_MCTRL, 0x0110U, 0x01U); /* Set master control register to set LDOK for sub-module0 */ 
  		setReg16Bits(PWM_MCTRL, 0x0100U);    		/* Enable counter's clock of sub-module0 */
  		break;
  	}
  	case 1:
  	{
  		/* Configure PWM output pins */
  		setReg16Bits(GPIO_E_PEREN, 0x03U);	 		/* Set GPIOE0/1 as PWM0A,PWM0B output */
  		/* Configure sub-module0 as center-aligned PWM mode with 100kHz frequency */
  		setReg16(PWM_SM0_INIT, 0xFED4U);     		/* Set Initial count register as -300, 60MHz/100kHz/2 = 300 */ 
  		setReg16(PWM_SM0_CTRL2, 0x2000U);    		/* Set Control 2 register: independent PWM mode with IP bus clock */
  		setReg16(PWM_SM0_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM0_VAL0, 0x00U);       		/* Set Value 0 register as 0, middle point of PWM period */ 
  		setReg16(PWM_SM0_VAL1, 0x012BU);     		/* Set Value 1 register as 299, 60MHz/100kHz/2-1 = 299 */ 
  		setReg16(PWM_SM0_VAL2, 0x00U);     			/* Set Value 2 register as 0 */ 
  		setReg16(PWM_SM0_VAL3, 0x00U);     			/* Set Value 3 register as 0 to generate low level for PWM0A */ 
  		setReg16(PWM_SM0_VAL4, 0x00U);     			/* Set Value 4 register as 0 */ 
  		setReg16(PWM_SM0_VAL5, 0x00U);     			/* Set Value 5 register as 0 to generate low level for PWM0B */ 
  		setReg16(PWM_SM0_DISMAP, 0x0F00U);   		/* Set Fault disable mapping register */
  		setReg16(PWM_OUTEN, 0x0110U);        		/* Set Output enable register to enable PWM0A/PWM0B output */
  		setReg16(PWM_DTSRCSEL, 0x00U);       		/* Set Deadtime source select register as generated PWM for sub-module0 */
  		clrSetReg16Bits(PWM_MCTRL, 0x0110U, 0x01U); /* Set master control register to set LDOK for sub-module0 */ 
  		setReg16Bits(PWM_MCTRL, 0x0100U);    		/* Enable counter's clock of sub-module0 */
  		break;
  	}
  	case 2:
  	{
  		/* Configure PWM output pins */
  		setReg16Bits(GPIO_E_PEREN, 0x03U);	 		/* Set GPIOE0/1 as PWM0A,PWM0B output */
  		/* Configure sub-module0 as complementary PWM mode with 100kHz frequency and 0.2us dead time */
  		setReg16(PWM_SM0_INIT, 0xFED4U);     		/* Set Initial count register as -300, 60MHz/100kHz/2 = 300 */ 
  		setReg16(PWM_SM0_CTRL2, 0x0000U);    		/* Set Control 2 register: complementary PWM mode with IP bus clock */
  		setReg16(PWM_SM0_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM0_VAL0, 0x00U);       		/* Set Value 0 register as 0, middle point of PWM period */ 
  		setReg16(PWM_SM0_VAL1, 0x012BU);     		/* Set Value 1 register as 299, 60MHz/100kHz/2-1 = 299 */ 
  		setReg16(PWM_SM0_VAL2, 0x00U);     			/* Set Value 2 register as 0 */ 
  		setReg16(PWM_SM0_VAL3, 0x00U);     			/* Set Value 3 register as 0 to generate low level for PWM0A, and high level for PWM0B */ 
  		setReg16(PWM_SM0_DISMAP, 0x0F00U);   		/* Set Fault disable mapping register */
  		setReg16(PWM_SM0_DTCNT0, 0x0CU);     		/* Set Deadtime count 0 register for 0.2us */
  		setReg16(PWM_SM0_DTCNT1, 0x0CU);     		/* Set Deadtime count 1 register for 0.2us */
  		setReg16(PWM_OUTEN, 0x00U);        			/* Set Output enable register to disable PWM0A/PWM0B output as tri-state avoiding PWM0B output with high level */
  		setReg16(PWM_DTSRCSEL, 0x00U);       		/* Set Deadtime source select register as generated PWM for sub-module0 */
  		clrSetReg16Bits(PWM_MCTRL, 0x1110U, 0x01U); /* Set master control register to set LDOK for sub-module0,and use PWM23 to generate complementary PWM pair */ 
  		setReg16Bits(PWM_MCTRL, 0x0100U);    		/* Enable counter's clock of sub-module0 */
  		break;
  	}
  	case 3:
  	{
  		/* Configure PWM output pins */
  		setReg16Bits(GPIO_E_PEREN, 0x03U);	 		/* Set GPIOE0/1 as PWM0A,PWM0B output */
  		/* Configure sub-module0 as push-pull PWM mode with 100kHz frequency */
  		setReg16(PWM_SM0_INIT, 0xFED4U);     		/* Set Initial count register as -300, 60MHz/100kHz/2 = 300 */ 
  		setReg16(PWM_SM0_CTRL2, 0x2000U);    		/* Set Control 2 register: independent PWM mode with IP bus clock */
  		setReg16(PWM_SM0_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM0_VAL0, 0x00U);       		/* Set Value 0 register as 0, middle point of PWM period */ 
  		setReg16(PWM_SM0_VAL1, 0x012BU);     		/* Set Value 1 register as 299, 60MHz/100kHz/2-1 = 299 */ 
  		setReg16(PWM_SM0_VAL2, 0x00U);     			/* Set Value 2 register as 0 */ 
  		setReg16(PWM_SM0_VAL3, 0x00U);     			/* Set Value 3 register as 0 to generate low level for PWM0A */ 
  		setReg16(PWM_SM0_VAL4, 0x00U);     			/* Set Value 4 register as 0 */ 
  		setReg16(PWM_SM0_VAL5, 0x00U);     			/* Set Value 5 register as 0 to generate low level for PWM0B */ 
  		setReg16(PWM_SM0_DISMAP, 0x0F00U);   		/* Set Fault disable mapping register */
  		setReg16(PWM_OUTEN, 0x0110U);        		/* Set Output enable register to enable PWM0A/PWM0B output */
  		setReg16(PWM_DTSRCSEL, 0x00U);       		/* Set Deadtime source select register as generated PWM for sub-module0 */
  		clrSetReg16Bits(PWM_MCTRL, 0x0110U, 0x01U); /* Set master control register to set LDOK for sub-module0 */ 
  		setReg16Bits(PWM_MCTRL, 0x0100U);    		/* Enable counter's clock of sub-module0 */
  		break;
  	}
  	case 4:
  	{
  		/* Configure PWM output pins */
  		setReg16Bits(GPIO_E_PEREN, 0x03FU);	 		/* Set GPIOE0-5 as PWM0A/0B,1A/1B,2A/2B output */
  		clrReg16Bits(SIM_GPS3, 0x50U);				/* Set GPIOE4/5 as PWM2A/2B output */
  		/* Configure eFlexPWM as multi-phase PWM mode with 100kHz frequency */
  		/* Configure sub-module0 as complementary PWM mode with 0.2us dead time */
  		setReg16(PWM_SM0_INIT, 0xFED4U);     		/* Set Initial count register as -300, 60MHz/100kHz/2 = 300 */ 
  		setReg16(PWM_SM0_CTRL2, 0x0000U);    		/* Set Control 2 register: complementary PWM mode with IP bus clock,local sync to initialize counter */
  		setReg16(PWM_SM0_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM0_VAL0, 0x00U);       		/* Set Value 0 register as 0, middle point of PWM period */ 
  		setReg16(PWM_SM0_VAL1, 0x012BU);     		/* Set Value 1 register as 299, 60MHz/100kHz/2-1 = 299 */ 
  		setReg16(PWM_SM0_VAL2, 0x00U);     			/* Set Value 2 register as 0 */ 
  		setReg16(PWM_SM0_VAL3, 0x00U);     			/* Set Value 3 register as 0 to generate low level for PWM0A, and high level for PWM0B */ 
  		setReg16(PWM_SM0_DISMAP, 0x0F00U);   		/* Set Fault disable mapping register */
  		setReg16(PWM_SM0_DTCNT0, 0x0CU);     		/* Set Deadtime count 0 register for 0.2us */
  		setReg16(PWM_SM0_DTCNT1, 0x0CU);     		/* Set Deadtime count 1 register for 0.2us */
  		/* Configure sub-module1 as complementary PWM mode with 0.2us dead time */
  		setReg16(PWM_SM1_INIT, 0xFED4U);     		/* Set Initial count register as -300, 60MHz/100kHz/2 = 300 */ 
  		setReg16(PWM_SM1_CTRL2, 0x0202U);    		/* Set Control 2 register: complementary PWM mode with sub-module0's clock,master sync to initialize counter to sync with PWM0 */
  		setReg16(PWM_SM1_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM1_VAL0, 0x00U);       		/* Set Value 0 register as 0, middle point of PWM period */ 
  		setReg16(PWM_SM1_VAL1, 0x012BU);     		/* Set Value 1 register as 299, 60MHz/100kHz/2-1 = 299 */ 
  		setReg16(PWM_SM1_VAL2, 0x00U);     			/* Set Value 2 register as 0 */ 
  		setReg16(PWM_SM1_VAL3, 0x00U);     			/* Set Value 3 register as 0 to generate low level for PWM1A, and high level for PWM1B */ 
  		setReg16(PWM_SM1_DISMAP, 0x0F00U);   		/* Set Fault disable mapping register */
  		setReg16(PWM_SM1_DTCNT0, 0x0CU);     		/* Set Deadtime count 0 register for 0.2us */
  		setReg16(PWM_SM1_DTCNT1, 0x0CU);     		/* Set Deadtime count 1 register for 0.2us */
  		/* Configure sub-module2 as complementary PWM mode with 0.2us dead time */
  		setReg16(PWM_SM2_INIT, 0xFED4U);     		/* Set Initial count register as -300, 60MHz/100kHz/2 = 300 */ 
  		setReg16(PWM_SM2_CTRL2, 0x0202U);    		/* Set Control 2 register: complementary PWM mode with sub-module0's clock,master sync to initialize counter to sync with PWM0 */
  		setReg16(PWM_SM2_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM2_VAL0, 0x00U);       		/* Set Value 0 register as 0, middle point of PWM period */ 
  		setReg16(PWM_SM2_VAL1, 0x012BU);     		/* Set Value 1 register as 299, 60MHz/100kHz/2-1 = 299 */ 
  		setReg16(PWM_SM2_VAL2, 0x00U);     			/* Set Value 2 register as 0 */ 
  		setReg16(PWM_SM2_VAL3, 0x00U);     			/* Set Value 3 register as 0 to generate low level for PWM2A, and high level for PWM2B */ 
  		setReg16(PWM_SM2_DISMAP, 0x0F00U);   		/* Set Fault disable mapping register */
  		setReg16(PWM_SM2_DTCNT0, 0x0CU);     		/* Set Deadtime count 0 register for 0.2us */
  		setReg16(PWM_SM2_DTCNT1, 0x0CU);     		/* Set Deadtime count 1 register for 0.2us */
  		
  		setReg16(PWM_OUTEN, 0x00U);        			/* Set Output enable register to disable PWM0A/0B,1A/1B,2A/2B output as tri-state avoiding PWM0B/1B/2B output with high level */
  		setReg16(PWM_DTSRCSEL, 0x00U);       		/* Set Deadtime source select register as generated PWM for sub-module0/1/2 */
  		clrSetReg16Bits(PWM_MCTRL, 0x7770U, 0x07U); /* Set master control register to set LDOK for sub-module0/1/2,and use PWM23 to generate complementary PWM pair */ 
  		setReg16Bits(PWM_MCTRL, 0x0700U);    		/* Enable counter's clock of sub-module0/1/2 */
  		break;
  	}
  	case 5:
  	{
  		/* Configure PWM output pins */
  		setReg16Bits(GPIO_E_PEREN, 0x0FU);	 		/* Set GPIOE0-3 as PWM0A/0B,1A/1B output */
  		/* Configure eFlexPWM as phase-shifted PWM mode with 100kHz frequency */
  		/* Configure sub-module0 as complementary PWM mode with 0.2us dead time */
  		setReg16(PWM_SM0_INIT, 0xFED4U);     		/* Set Initial count register as -300, 60MHz/100kHz/2 = 300 */ 
  		setReg16(PWM_SM0_CTRL2, 0x0000U);    		/* Set Control 2 register: complementary PWM mode with IP bus clock,local sync to initialize counter */
  		setReg16(PWM_SM0_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM0_VAL0, 0x00U);       		/* Set Value 0 register as 0, middle point of PWM period */ 
  		setReg16(PWM_SM0_VAL1, 0x012BU);     		/* Set Value 1 register as 299, 60MHz/100kHz/2-1 = 299 */ 
  		setReg16(PWM_SM0_VAL2, 0x00U);     			/* Set Value 2 register as 0 */ 
  		setReg16(PWM_SM0_VAL3, 0x00U);     			/* Set Value 3 register as 0 to generate low level for PWM0A, and high level for PWM0B */ 
  		setReg16(PWM_SM0_DISMAP, 0x0F00U);   		/* Set Fault disable mapping register */
  		setReg16(PWM_SM0_DTCNT0, 0x0CU);     		/* Set Deadtime count 0 register for 0.2us */
  		setReg16(PWM_SM0_DTCNT1, 0x0CU);     		/* Set Deadtime count 1 register for 0.2us */
  		/* Configure sub-module1 as complementary PWM mode with 0.2us dead time */
  		setReg16(PWM_SM1_INIT, 0xFED4U);     		/* Set Initial count register as -300, 60MHz/100kHz/2 = 300 */ 
  		setReg16(PWM_SM1_CTRL2, 0x0202U);    		/* Set Control 2 register: complementary PWM mode with sub-module0's clock,master sync to initialize counter to sync with PWM0 */
  		setReg16(PWM_SM1_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM1_VAL0, 0x00U);       		/* Set Value 0 register as 0, middle point of PWM period */ 
  		setReg16(PWM_SM1_VAL1, 0x012BU);     		/* Set Value 1 register as 299, 60MHz/100kHz/2-1 = 299 */ 
  		setReg16(PWM_SM1_VAL2, 0x00U);     			/* Set Value 2 register as 0 */ 
  		setReg16(PWM_SM1_VAL3, 0x00U);     			/* Set Value 3 register as 0 to generate low level for PWM1A, and high level for PWM1B */ 
  		setReg16(PWM_SM1_DISMAP, 0x0F00U);   		/* Set Fault disable mapping register */
  		setReg16(PWM_SM1_DTCNT0, 0x0CU);     		/* Set Deadtime count 0 register for 0.2us */
  		setReg16(PWM_SM1_DTCNT1, 0x0CU);     		/* Set Deadtime count 1 register for 0.2us */
  		
  		setReg16(PWM_OUTEN, 0x00U);        			/* Set Output enable register to disable PWM0A/0B,1A/1B output as tri-state avoiding PWM0B/1B/2B output with high level */
  		setReg16(PWM_DTSRCSEL, 0x00U);       		/* Set Deadtime source select register as generated PWM for sub-module0/1 */
  		clrSetReg16Bits(PWM_MCTRL, 0x3330U, 0x03U); /* Set master control register to set LDOK for sub-module0/1,and use PWM23 to generate complementary PWM pair */ 
  		setReg16Bits(PWM_MCTRL, 0x0300U);    		/* Enable counter's clock of sub-module0/1 */
  		break;
  	}
  	case 6:
  	{
  		/* Configure PWM output pins */
  		setReg16Bits(GPIO_E_PEREN, 0x02U);	 		/* Set GPIOE1 as PWM0A output */
  		/* Configure CMPA intput pin */
  		setReg16Bits(GPIO_A_PEREN, 0x02U);	 		/* Set GPIOA1 as CMPA_M0 input from current sensing */
  		/* Configure internal 12-bit DAC as reference positive input for comparatorA */
  		setReg16(DAC_CTRL, 0x01U);					/* Set Control register: power down with right justified data format */	
  		setReg16(DAC_DATA, 0x00U);					/* Oupt zero */        
  		clrReg16Bits(DAC_CTRL, 0x01U);				/* Power on DAC */
  		/* Configure internal comparator0 as fault input for sub-module0 */
  		setReg16(CMPA_CR0, 0x04U);           		/* Set Control 0 register: output filter disable, P1 input with 12-bit DAC output and M0 input with GPIOA1  */
  		setReg16(CMPA_CR1, 0x14U);           		/* Set Control 1 register: high speed mode */ 
  		setReg16(CMPA_FPR, 0x00U);           		/* Filter period register as 0 */
  		setReg16Bits(CMPA_CR1, 0x01U);       		/* Enable device */ 
  		/* Delay to wait for stability of comparator */
  		Cpu_Delay100US(1);
  		setReg16(CMPA_SCR, 0x06U);           		/* Status and control register: disable internal hysteresis */
  		/* Configure crossbar for Fault0 of eFlexPWM sub-module0 from CMPA_OUT */
  		clrSetReg16Bits(XB_XBC10, 0x1600U, 0x0900U);/* Set CMPA_OUT as Fault0 of eFlexPWM sub-module0 by crossbar */
  		/* Configure sub-module0 as current-limit PWM mode with 100kHz frequency */
  		setReg16(PWM_SM0_INIT, 0xFED4U);     		/* Set Initial count register as -300, 60MHz/100kHz/2 = 300 */ 
  		setReg16(PWM_SM0_CTRL2, 0x2000U);    		/* Set Control 2 register: independent PWM mode with IP bus clock */
  		setReg16(PWM_SM0_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM0_VAL0, 0x00U);       		/* Set Value 0 register as 0, middle point of PWM period */ 
  		setReg16(PWM_SM0_VAL1, 0x012BU);     		/* Set Value 1 register as 299, 60MHz/100kHz/2-1 = 300 */ 
  		setReg16(PWM_SM0_VAL2, 0xFED4U);     		/* Set Value 2 register as INIT for rising edge-aligned */ 
  		setReg16(PWM_SM0_VAL3, 0xB3U);     			/* Set Value 3 register as 179 to output programmed 80% duty cycle for PWM0A */
  		setReg16(PWM_SM0_DISMAP, 0x0FF1U);   		/* Set Fault disable mapping register with Fault0 disable PWM0A */
  		setReg16(PWM_FFILT, 0x00U);					/* Disable fault filter*/
  		setReg16(PWM_FCTRL, 0x0100U);				/* Set logic 1 as fault level and automatic clearing mode for fault0 */
  		setReg16(PWM_FSTS, 0x0010U);				/* Set only full cycle fault clearing timing for fault0 */
  		setReg16(PWM_OUTEN, 0x0100U);        		/* Set Output enable register to enable PWM0A output */
  		setReg16(PWM_DTSRCSEL, 0x00U);       		/* Set Deadtime source select register as generated PWM for sub-module0 */
  		clrSetReg16Bits(PWM_MCTRL, 0x0110U, 0x01U); /* Set master control register to set LDOK for sub-module0 */ 
  		setReg16Bits(PWM_MCTRL, 0x0100U);    		/* Enable counter's clock of sub-module0 */
  		break;
  	}
  	case 7:
  	{
  		/* Configure PWM output pins */
  		setReg16Bits(GPIO_E_PEREN, 0x02U);	 		/* Set GPIOE1 as PWM0A output */
  		/* Configure CMPA intput pin */
  		setReg16Bits(GPIO_A_PEREN, 0x02U);	 		/* Set GPIOA1 as CMPA_M0 input from current sensing */
  		/* Configure internal REFA (5-bit DAC) as reference positive input for comparatorA */
  		setReg16(REFA_DACCTRL, 0x82U);				/* Set minimal current value from REFA: 0.3V */	
  		/* Configure internal comparator0 as fault input for sub-module0 */
  		setReg16(CMPA_CR0, 0x00U);           		/* Set Control 0 register: output filter disable, P0 input with REFA (5-bit DAC) output and M0 input with GPIOA1  */
  		setReg16(CMPA_CR1, 0x14U);           		/* Set Control 1 register: high speed mode */ 
  		setReg16(CMPA_FPR, 0x00U);           		/* Filter period register as 0 */
  		setReg16Bits(CMPA_CR1, 0x01U);       		/* Enable device */ 
  		/* Delay to wait for stability of comparator */
  		Cpu_Delay100US(1);
  		setReg16(CMPA_SCR, 0x06U);           		/* Status and control register: disable internal hysteresis */
  		/* Configure crossbar for EXT_SYNC of eFlexPWM sub-module0 from CMPA_OUT */
  		clrSetReg16Bits(XB_XBC8, 0x16U, 0x09U);		/* Set CMPA_OUT as EXT_SYNC of eFlexPWM sub-module0 by crossbar */
  		/* Configure sub-module0 as current-reset PWM mode wiht initial 1kHz frequency */
  		setReg16(PWM_SM0_INIT, 0x8AD0U);     		/* Set Initial count register as -30000: 60000/1/2 */ 
  		setReg16(PWM_SM0_CTRL2, 0x2300U);    		/* Set Control 2 register: independent PWM mode with IP bus clock,external sync to initialize counter */
  		setReg16(PWM_SM0_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM0_VAL0, 0x00U);       		/* Set Value 0 register as 0 */ 
  		setReg16(PWM_SM0_VAL1, 0x752FU);     		/* Set Value 1 register as 29999: 60000/1/2-1 */ 
  		setReg16(PWM_SM0_VAL2, 0x8AD0U);     		/* Set Value 2 register as -30000 for rising edge-aligned */ 
  		setReg16(PWM_SM0_VAL3, 0x8AD0U);     		/* Set Value 3 register as -30000 to output low level for PWM0A */
  		setReg16(PWM_SM0_DISMAP, 0x0FF0U);   		/* Set Fault disable mapping register with Fault0 disable PWM0A */
  		setReg16(PWM_OUTEN, 0x0100U);        		/* Set Output enable register to enable PWM0A output */
  		setReg16(PWM_DTSRCSEL, 0x00U);       		/* Set Deadtime source select register as generated PWM for sub-module0 */
  		clrSetReg16Bits(PWM_MCTRL, 0x0110U, 0x01U); /* Set master control register to set LDOK for sub-module0 */ 
  		setReg16Bits(PWM_MCTRL, 0x0100U);    		/* Enable counter's clock of sub-module0 */
  		break;
  	}
  	case 8:
  	{
  		/* Configure PWM output pins */
  		setReg16Bits(GPIO_E_PEREN, 0x03U);	 		/* Set GPIOE0/1 as PWM0A,PWM0B output */
  		/* Configure sub-module0 as complementary PWM mode with 450kHz frequency and 0.05us dead time */
  		setReg16(PWM_SM0_INIT, 0x00U);     			/* Set Initial count register as 0, because only VAL1 supports high-resolution for period */ 
  		setReg16(PWM_SM0_CTRL2, 0x0000U);    		/* Set Control 2 register: complementary PWM mode with IP bus clock */
  		setReg16(PWM_SM0_CTRL, 0x0400U);     		/* Set Control register: every PWM full cycle reload */ 
  		setReg16(PWM_SM0_VAL0, 0x00U);       		/* Set Value 0 register as 0 */ 
  		setReg16(PWM_SM0_VAL1, 0x00U);     			/* Set Value 1 register as 0 for 0s period */ 
  		setReg16(PWM_SM0_VAL2, 0x00U);     			/* Set Value 2 register as 0 */ 
  		setReg16(PWM_SM0_VAL3, 0x00U);     			/* Set Value 3 register as 0 to generate low level for PWM0A, and high level for PWM0B */ 
  		setReg16(PWM_SM0_FRACVAL1, 0x00U);   		/* Set Fractional value 1 register as 0 */ 
  		setReg16(PWM_SM0_FRACVAL2, 0x00U); 			/* Set Fractional value 2 register as 0 */ 
  		setReg16(PWM_SM0_FRACVAL3, 0x00U); 			/* Set Fractional value 3 register as 0 */ 
  		setReg16(PWM_SM0_FRACVAL4, 0x00U); 			/* Set Fractional value 4 register as 0 */ 
  		setReg16(PWM_SM0_FRACVAL5, 0x00U); 			/* Set Fractional value 5 register as 0 */
  		setReg16(PWM_SM0_FRCTRL, 0x0116U);     		/* Set Fractional control register: enable fractional delay logic for all registers */
  		setReg16(PWM_SM0_DISMAP, 0x0F00U);   		/* Set Fault disable mapping register */
  		setReg16(PWM_SM0_DTCNT0, 0x03U);     		/* Set Deadtime count 0 register for 0.2us */
  		setReg16(PWM_SM0_DTCNT1, 0x03U);     		/* Set Deadtime count 1 register for 0.2us */
  		setReg16(PWM_OUTEN, 0x00U);        			/* Set Output enable register to disable PWM0A/PWM0B output as tri-state avoiding PWM0B output with high level */
  		setReg16(PWM_DTSRCSEL, 0x00U);       		/* Set Deadtime source select register as generated PWM for sub-module0 */
  		clrSetReg16Bits(PWM_MCTRL, 0x0110U, 0x01U); /* Set master control register to set LDOK for sub-module0,and use PWM23 to generate complementary PWM pair */ 
  		setReg16Bits(PWM_MCTRL, 0x0100U);    		/* Enable counter's clock of sub-module0 */
  		break;
  	}
  	case 9:
  	{
  		/* Configure capture input pin */
  		setReg16Bits(GPIO_F_PEREN, 0x40U);
  		setReg16Bits(SIM_GPS2, 0x1000U);	 		/* Set GPIOF6 as PWM3X input */
  		/* Configure sub-module3 as enhanced capture mode with 7.15Hz frequency, which means above 7.15Hz input signal can be measured using this routine */
  		setReg16(PWM_SM3_INIT, 0x8000U);     		/* Set Initial count register as -32768, 60MHz/128/7.15Hz/2 = 32768 */ 
  		setReg16(PWM_SM3_CTRL2, 0x00U);    			/* Set Control 2 register */
  		setReg16(PWM_SM3_CTRL, 0x0470U);     		/* Set Control register: every PWM full cycle reload with IP bus clock/128 */ 
  		setReg16(PWM_SM3_VAL0, 0x00U);       		/* Set Value 0 register as 0, middle point of timer period */ 
  		setReg16(PWM_SM3_VAL1, 0x7FFFU);     		/* Set Value 1 register as 32767, 60MHz/128/7.15Hz/2-1 = 32767 */
  		setReg16(PWM_SM3_DISMAP, 0x00FFU);   		/* Set Fault disable mapping register */
  		setReg16(PWM_SM3_CAPTCOMPX, 0x00U);  		/* Set Capture compare X register as 0 */
  		setReg16(PWM_SM3_CAPTCTRLX, 0x19U);  		/* Set Capture control X register: PWM3X pin as input source, rising edge for capture0, falling edge for capture1 */
  		setReg16(PWM_OUTEN, 0x00U);        			/* Set Output enable register to disable PWM3X output when it is used for capture input */
  		clrSetReg16Bits(PWM_MCTRL, 0x0880U, 0x08U); /* Set master control register to set LDOK for sub-module3 */ 
  		setReg16Bits(PWM_MCTRL, 0x0800U);    		/* Enable counter's clock of sub-module3 */
  		setReg16(PWM_SM3_STS, 0xC0U);      			/* Clear interrupt flags: clear interrupt flags of capture X0/X1 */
  		break;
  	}
  	default:
  	{
  		break;
  	}
  }

  for(;;) 
  {
  	switch(MODE_SEL)		/* Switch operation mode of eFlexPWM module */
  	{
  		case 0:
  		{
  			dutycycle1 = (600 * 20)/100;					/* 20% duty cycle */
  			dutycycle2 = (600 * 40)/100;					/* 40% duty cycle */ 
  			setReg16(PWM_SM0_VAL3, (-300 + dutycycle1));   	/* Set Value 3 register to generate 20% duty cycle for PWM0A */ 
  			setReg16(PWM_SM0_VAL5, (-300 + dutycycle2));    /* Set Value 5 register to generate 40% duty cycle for PWM0B */
  			setReg16Bit(PWM_MCTRL, LDOK0);					/* Reload duty cycle */
  			break;
  		}
  		case 1:
  		{
  			dutycycle1 = (600 * 40)/100;					/* 40% duty cycle */
  			dutycycle2 = (600 * 20)/100;					/* 20% duty cycle */ 
  			setReg16(PWM_SM0_VAL2, -(dutycycle1/2));     	/* Set Value 2 register to generate 40% duty cycle for PWM0A */
  			setReg16(PWM_SM0_VAL3, (dutycycle1/2-1));     	/* Set Value 3 register to generate 40% duty cycle for PWM0A */ 
  			setReg16(PWM_SM0_VAL4, -(dutycycle2/2));     	/* Set Value 4 register to generate 20% duty cycle for PWM0B */
  			setReg16(PWM_SM0_VAL5, (dutycycle2/2-1));     	/* Set Value 5 register to generate 20% duty cycle for PWM0B */
  			setReg16Bit(PWM_MCTRL, LDOK0);					/* Reload duty cycle */
  			break;
  		}
  		case 2:
  		{
  			dutycycle1 = (600 * 40)/100;					/* 40% duty cycle */ 
  			setReg16(PWM_SM0_VAL2, -(dutycycle1/2));     	/* Set Value 2 register to generate 40% duty cycle for PWM0A */ 
  			setReg16(PWM_SM0_VAL3, (dutycycle1/2-1));     	/* Set Value 3 register to generate 40% duty cycle for PWM0A */
  			setReg16Bit(PWM_MCTRL, LDOK0);					/* Reload duty cycle */
  			setReg16(PWM_OUTEN, 0x0110U);					/* Enable PWM0A/PWM0B output */
  			break;
  		}
  		case 3:
  		{
  			dutycycle1 = (600 * 40)/100;					/* 40% duty cycle */ 
  			setReg16(PWM_SM0_VAL2, -150-(dutycycle1/2));    /* Set Value 2 register to generate 40% duty cycle for PWM0A */ 
  			setReg16(PWM_SM0_VAL3, -150+(dutycycle1/2-1));  /* Set Value 3 register to generate 40% duty cycle for PWM0A with middle point of -150 */
  			setReg16(PWM_SM0_VAL4, 150-(dutycycle1/2));     /* Set Value 4 register to generate 20% duty cycle for PWM0B */
  			setReg16(PWM_SM0_VAL5, 150+(dutycycle1/2-1));   /* Set Value 5 register to generate 20% duty cycle for PWM0B with middle point of 150 */
  			setReg16Bit(PWM_MCTRL, LDOK0);					/* Reload duty cycle */
  			break;
  		}
  		case 4:
  		{
  			dutycycle1 = (600 * 20)/100;					/* 20% duty cycle */ 
  			setReg16(PWM_SM0_VAL2, -200-(dutycycle1/2));    /* Set Value 2 register to generate 20% duty cycle for PWM0A */ 
  			setReg16(PWM_SM0_VAL3, -200+(dutycycle1/2-1));  /* Set Value 3 register to generate 20% duty cycle for PWM0A with middle point of -200 */
  			setReg16(PWM_SM1_VAL2, -(dutycycle1/2));     	/* Set Value 2 register to generate 20% duty cycle for PWM1A */ 
  			setReg16(PWM_SM1_VAL3, (dutycycle1/2-1));     	/* Set Value 3 register to generate 20% duty cycle for PWM1A with middle point of 0 */
  			setReg16(PWM_SM2_VAL2, 200-(dutycycle1/2));     /* Set Value 2 register to generate 20% duty cycle for PWM2A */ 
  			setReg16(PWM_SM2_VAL3, 200+(dutycycle1/2-1));   /* Set Value 3 register to generate 20% duty cycle for PWM2A with middle point of 200 */
  			setReg16Bits(PWM_MCTRL, 0x07);					/* Reload duty cycle */
  			setReg16(PWM_OUTEN, 0x0770U);					/* Enable PWM0A/0B,1A/1B,2A/2B output */
  			break;
  		}
  		case 5:
  		{
  			phaseshift = (600 * 30)/360;					/* 30 degree shift */ 
  			setReg16(PWM_SM0_VAL2, -150-(150));     		/* Set Value 2 register to generate 50% duty cycle for PWM0A */ 
  			setReg16(PWM_SM0_VAL3, -150+(149));     		/* Set Value 3 register to generate 50% duty cycle for PWM0A with middle point of -150 */
  			setReg16(PWM_SM1_VAL2, -150-(150)+phaseshift);  /* Set Value 2 register to generate 50% duty cycle for PWM1A */ 
  			setReg16(PWM_SM1_VAL3, -150+(149)+phaseshift);  /* Set Value 3 register to generate 50% duty cycle for PWM1A with middle point of -150 plus phaseshift */
  			setReg16Bits(PWM_MCTRL, 0x03);					/* Reload duty cycle */
  			setReg16(PWM_OUTEN, 0x0330U);					/* Enable PWM0A/0B,1A/1B output */
  			break;
  		}
  		case 6:
  		{
  			currentlimit = 2048; 							/* Set desired maximum current value */
  			setReg16(DAC_DATA, currentlimit);				/* Output current value */
  			break;
  		}
  		case 7:
  		{
  			turnon = 300;									/* 5us: 300/60=5 */
  			setReg16(PWM_SM0_VAL3, -30000+turnon-1);    	/* Set Value 3 register to output programmed 20us high level for PWM0A: VAL2=0x8AD0U=-30000 */
  			setReg16Bit(PWM_MCTRL, LDOK0);					/* Reload duty cycle */
  			break;
  		}
  		case 8:
  		{
  			frequency = 1920000/450;									/* 450kHz based on 1.92GHz clock when enabling fractional delay logic */
  			dutycycle1 = ((UInt32)frequency * 40)/100;					/* 40% duty cycle */
  			setReg16(PWM_SM0_VAL1, frequency>>5);     					/* Set Value 1 register */
  			setReg16(PWM_SM0_FRACVAL1, frequency<<11);   				/* Set Fractional value 1 */
  			setReg16(PWM_SM0_VAL2, ((frequency-dutycycle1)>>1)>>5);     /* Set Value 2 register for desired duty cycle by center of period */ 
  			setReg16(PWM_SM0_FRACVAL2, ((frequency-dutycycle1)>>1)<<11);/* Set Fractional value 2 register for desired duty cycle by center of period */
  			setReg16(PWM_SM0_VAL3, ((frequency+dutycycle1)>>1)>>5);     /* Set Value 3 register for desired duty cycle by center of period */  
  			setReg16(PWM_SM0_FRACVAL3, ((frequency+dutycycle1)>>1)<<11);/* Set Fractional value 3 register for desired duty cycle by center of period */ 
  			setReg16(PWM_SM0_FRACVAL4, ((frequency+dutycycle1)>>1)<<11);/* Set Fractional value 4 register to equal to Fractional value 3 for stable PWM0B generation */ 
  			setReg16(PWM_SM0_FRACVAL5, ((frequency-dutycycle1)>>1)<<11);/* Set Fractional value 5 register to equal to Fractional value 2 for stable PWM0B generation */
  			setReg16Bit(PWM_MCTRL, LDOK0);								/* Reload duty cycle */
  			setReg16(PWM_OUTEN, 0x0110U);								/* Enable PWM0A/PWM0B output */
  			break;
  		}
  		case 9:
  		{
  			if(testReg16Bit(PWM_SM3_STS, CFX0))							/* If rising edge occurs in capture0 */
  			{
  				if(counter < 2)
  				{
  					counter++;
  				}
  				setReg16Bit(PWM_SM3_STS, CFX0);							/* Clear edge flag in capture0 */
  				risingedge = PWM_SM3_CVAL0;								/* Read rising edge timing */
  				frequency = risingedge - risingedgeold;					/* Calculate period of input signal */
  				risingedgeold = risingedge;								/* Store last time rising edge timing for next period calculation */
  				if(counter == 2)										/* If the second rising edge, in order to assure complete period coming */
  				{
  					dutycycle1 = ((UInt32)turnon*100)/frequency;		/* Calculate duty cycle */
  				}
  			}
  			if(testReg16Bit(PWM_SM3_STS, CFX1))							/* If falling edge occurs in capture1 */
  			{
  				setReg16Bit(PWM_SM3_STS, CFX1);							/* Clear edge flag in capture1 */
  				fallingedge = PWM_SM3_CVAL1;							/* Read falling edge timing */
  				turnon = fallingedge - risingedge;						/* Calculate turn-on duration */
  			}
  			break;
  		}
  		default:
  		{
  			break;	
  		}
  	}
  }
}

/* END ePWM_test */
/*
** ###################################################################
**
**     This file was created by Processor Expert 3.00 [04.35]
**     for the Freescale 56800 series of microcontrollers.
**
** ###################################################################
*/
