/************************************************************************
 *    This file was generated by eTPU Graphical Configuration Tool        
 *                                                                        
 *    DO NOT EDIT !!! DO NOT EDIT !!! DO NOT EDIT !!! DO NOT EDIT !!!     
 *                                                                        
 *  DESCRIPTION:
 *  This file contains my_system_etpu_init and my_system_etpu_start
 *  functions and related items. The function initialize the eTPU 
 *  global and channel settings, based on the user settings 
 *  in the eTPU GCT, and runs the eTPU.               
 *  A header file of the same name .h is also generated.                   
 *
 *  Creation Date:  29.4.2005 9:04:22 
 *
 **************************************************************************/

#include "MPC5554.h"
#include "MPC5554_vars.h"

/* general routines */
#include "etpu_util.h"             /* Utility routines for working eTPU */

/* eTPU function set used */
#include "etpu_set4/etpu_set4.h"       

/* eTPU functions APIs */
#include "pwmmac/etpu_pwmmac.h" /* PWMMAC - PWM Master for AC Motors */
#include "pmsmvc/etpu_pmsmvc.h" /* PMSMVC - PMSM Vector Control */
#include "asac/etpu_asac.h" /* ASAC - Analog Sensing for AC Motors */
#include "pmsmrsvc/etpu_app_pmsmrsvc.h" /* PMSM with Resolver, Speed Vector Control */

/* our private header file (generated by eTPU GCT) */
#include "pmsmrsvc_etpu_gct.h"

/* External object declarations */
extern pmsmrsvc_instance_t pmsmrsvc_instance;
extern uint32_t * p_ASAC_result_queue;


/**************************************************************************
 * 
 * Global Variables
 *
 **************************************************************************/

uint32_t *fs_free_param;

/**************************************************************************
 *
 * CPU and clock configuration:
 *
 *   CPU = MPC5554
 *   SYSCLK = 128 MHz
 *   Input_TCRCLK_A = OFF
 *   Input_TCRCLK_B = OFF
 *   
 **************************************************************************/

uint32_t etpu_a_tcr1_freq = 64000000;
uint32_t etpu_a_tcr2_freq = 8000000;
uint32_t etpu_b_tcr1_freq = 64000000;
uint32_t etpu_b_tcr2_freq = 8000000;


/**************************************************************************
 * 
 * etpu_config structure filled accodring to the user settings
 *
 **************************************************************************/

struct etpu_config_t my_etpu_config =
{
  /* etpu_config.mcr */
  FS_ETPU_VIS_OFF	/* SCM not visible (VIS=0) */
  | FS_ETPU_MISC_DISABLE	/* SCM operation disabled (SCMMISEN=0) */,

  /* etpu_config.misc */
  FS_ETPU_MISC,

  /* etpu_config.ecr_a */
  FS_ETPU_ENTRY_TABLE_ADDR	/* entry table base address = shifted FS_ETPU_ENTRY_TABLE */
  | FS_ETPU_CHAN_FILTER_3SAMPLE	/* channel filter mode = three-sample mode (CDFC=2) */
  | FS_ETPU_ENGINE_ENABLE	/* engine is enabled (MDIS=0) */
  | FS_ETPU_FILTER_CLOCK_DIV64	/* channel filter clock = etpuclk div 64 (FPSCK=3) */,

  /* etpu_config.tbcr_a */
  FS_ETPU_ANGLE_MODE_DISABLE	/* TCR2 angle mode is disabled (AM=0) */
  | FS_ETPU_TCR2_PRESCALER(2)	/* TCR2 prescaler = 2 (TCR2P='2-1') */
  | FS_ETPU_TCR1_PRESCALER(1)	/* TCR1 prescaler = 1 (TCR1P='1-1') */
  | FS_ETPU_TCRCLK_MODE_INTEGRATION	/* TCRCLK signal is filtered using integration mode (TCRCF=1x) */
  | FS_ETPU_TCR2CTL_DIV8	/* TCR2 source = etpuclk div 8 (TCR2CTL=4) */
  | FS_ETPU_TCRCLK_INPUT_CHANCLOCK	/* TCRCLK signal is filtered with filter clock = channel filter clock (TCRCF=x1) */
  | FS_ETPU_TCR1CTL_DIV2	/* TCR1 source = etpuclk div 2 (TCR1CTL=2) */,

  /* etpu_config.stacr_a */
  FS_ETPU_TCR1_STAC_SERVER	/* TCR1 resource operates as server (RSC1=1) */
  | FS_ETPU_TCR2_STAC_SERVER	/* TCR2 resource operates as server (RSC2=1) */
  | FS_ETPU_TCR1_STAC_DISABLE	/* TCR1 operation on STAC bus disabled (REN1=0) */
  | FS_ETPU_TCR2_STAC_DISABLE	/* TCR2 operation on STAC bus disabled (REN2=0) */
  | FS_ETPU_TCR1_STAC_SRVSLOT(0)	/* TCR1 resource server slot = 0 (SRV1=0) */
  | FS_ETPU_TCR2_STAC_SRVSLOT(0)	/* TCR2 resource server slot = 0 (SRV2=0) */,

  /* etpu_config.ecr_b */
  FS_ETPU_ENTRY_TABLE_ADDR	/* entry table base address = shifted FS_ETPU_ENTRY_TABLE */
  | FS_ETPU_CHAN_FILTER_3SAMPLE	/* channel filter mode = three-sample mode (CDFC=2) */
  | FS_ETPU_ENGINE_ENABLE	/* engine is enabled (MDIS=0) */
  | FS_ETPU_FILTER_CLOCK_DIV64	/* channel filter clock = etpuclk div 64 (FPSCK=3) */,

  /* etpu_config.tbcr_b */
  FS_ETPU_ANGLE_MODE_DISABLE	/* TCR2 angle mode is disabled (AM=0) */
  | FS_ETPU_TCR2_PRESCALER(2)	/* TCR2 prescaler = 2 (TCR2P='2-1') */
  | FS_ETPU_TCR1_PRESCALER(1)	/* TCR1 prescaler = 1 (TCR1P='1-1') */
  | FS_ETPU_TCRCLK_MODE_INTEGRATION	/* TCRCLK signal is filtered using integration mode (TCRCF=1x) */
  | FS_ETPU_TCR2CTL_DIV8	/* TCR2 source = etpuclk div 8 (TCR2CTL=4) */
  | FS_ETPU_TCRCLK_INPUT_CHANCLOCK	/* TCRCLK signal is filtered with filter clock = channel filter clock (TCRCF=x1) */
  | FS_ETPU_TCR1CTL_DIV2	/* TCR1 source = etpuclk div 2 (TCR1CTL=2) */,

  /* etpu_config.stacr_b */
  FS_ETPU_TCR1_STAC_SERVER	/* TCR1 resource operates as server (RSC1=1) */
  | FS_ETPU_TCR2_STAC_SERVER	/* TCR2 resource operates as server (RSC2=1) */
  | FS_ETPU_TCR1_STAC_DISABLE	/* TCR1 operation on STAC bus disabled (REN1=0) */
  | FS_ETPU_TCR2_STAC_DISABLE	/* TCR2 operation on STAC bus disabled (REN2=0) */
  | FS_ETPU_TCR1_STAC_SRVSLOT(0)	/* TCR1 resource server slot = 0 (SRV1=0) */
  | FS_ETPU_TCR2_STAC_SRVSLOT(0)	/* TCR2 resource server slot = 0 (SRV2=0) */
};


/**************************************************************************
 * 
 *  FUNCTION : my_system_etpu_init
 * 
 *  PURPOSE  : Initializes the eTPU settings and channel settings, based
 *             on the user settings in the eTPU GCT:
 *
 *             1. Initialize global setting using fs_etpu_init function
 *                and the my_etpu_config structure.
 *             2. Initialize channel setting using channel function APIs 
 *                or standard eTPU routines.
 *
 *  RETURNS  : If the initialization of all channel functions passed OK, 
 *             the return value is 0. If the initialization of a channel 
 *             failed, the returned value is a number of the channel that
 *             failed to initialized increased by 1.
 *
 **************************************************************************/

int32_t my_system_etpu_init()
{
  int32_t err_code;

  /* Clear eTPU DATA RAM to make debugging easier */
  fs_memset32((uint32_t*)fs_etpu_data_ram_start, 0, fs_etpu_data_ram_end - fs_etpu_data_ram_start);
  
  /* Initialization of eTPU global settings */
  err_code = fs_etpu_init(
    my_etpu_config,
    (uint32_t *)etpu_code, sizeof(etpu_code),
    (uint32_t *)etpu_globals, sizeof(etpu_globals));
  if(err_code != 0) return(err_code);

#ifdef FS_ETPU_ARCHITECTURE
  #if FS_ETPU_ARCHITECTURE == ETPU2
  /* Initialization of additional eTPU2-only global settings */
  err_code = fs_etpu2_init(
    my_etpu_config,
    (uint32_t *)etpu_engine_globals, sizeof(etpu_engine_globals),
    (uint32_t *)etpu_engine_globals, sizeof(etpu_engine_globals));
  if(err_code != 0) return(err_code);
  #endif
#endif

  /* Allocate 20 bytes in eTPU DATA RAM which are used for ASAC result queue */
  p_ASAC_result_queue = fs_etpu_malloc(20);



  /* Initialization of eTPU channel settings */

  /* 
   *  eTPU API Function initialization: 'PMSM with Quadrature Encoder, Speed Vector Control'
   */
  err_code = fs_etpu_app_pmsmrsvc_init(&pmsmrsvc_instance,	/* pmsmrsvc_instance: &pmsmrsvc_instance */
                                       APP_PMSMRSVC0_PWM_MASTER,	/* engine: B; channel: 7 */
                                       APP_PMSMRSVC0_PWM_PHASEA_BASE_CHANNEL,	/* engine: B; channel: 8 */
                                       APP_PMSMRSVC0_PWM_PHASEB_BASE_CHANNEL,	/* engine: B; channel: 10 */
                                       APP_PMSMRSVC0_PWM_PHASEC_BASE_CHANNEL,	/* engine: B; channel: 12 */
                                       APP_PMSMRSVC0_RSLV, /* engine: A; channel: 0 */
                                       APP_PMSMRSVC0_SC,	/* engine: A; channel: 5 */
                                       APP_PMSMRSVC0_BC,	/* engine: A; channel: 15 */
                                       APP_PMSMRSVC0_PMSMVC,	/* engine: A; channel: 6 */
                                       APP_PMSMRSVC0_ASAC,	/* engine: A; channel: 29 */
                                       FS_ETPU_APP_PMSMRSVC_COMPL_PAIRS,	/* PWM_phases_type */
                                       20000,	/* PWM_freq_hz */
                                       500,	/* PWM_dead_time_ns */
                                       10000,	/* speed_range_rpm */
                                       5,	/* speed_min_rpm */
                                       53000,	/* dc_bus_voltage_range_mv */
                                       3,	/* motor_pole_pairs */
                                       1,	/* rslv_pole_pairs */
                                       5000,	/* SC_freq_hz */
                                       3193,	/* SC_PID_gain_permil */
                                       20000,	/* SC_I_time_const_us */
                                       1000,	/* SC_ramp_time_ms */
                                       93,	/* PMSMVC_D_PID_gain_permil */
                                       500,	/* PMSMVC_D_I_time_const_us */
                                       93,	/* PMSMVC_Q_PID_gain_permil */
                                       500,	/* PMSMVC_Q_I_time_const_us */
                                       3910, /* PMSM_Ke_mv_per_krpm */
                                       430, /* PMSM_L_uH */
                                       10000,	/* phase_current_range_ma */
                                       FS_ETPU_APP_PMSMRSVC_BC_MODE_PWM,	/* BC_mode */
                                       FS_ETPU_APP_PMSMRSVC_BC_ON_HIGH,	/* BC_polarity */
                                       130,	/* BC_u_dc_bus_ON_perc */
                                       110,	/* BC_u_dc_bus_OFF_perc */
                                       FS_ETPU_APP_PMSMRSVC_ASAC_PULSE_HIGH,	/* ASAC_polarity */
                                       8,	/* ASAC_measure_time_us */
                                       p_ASAC_result_queue,	/* ASAC_result_queue */
                                       FS_ETPU_APP_PMSMRSVC_ASAC_SHIFT_LEFT_BY_10,	/* ASAC_bit_shift */
                                       200,	/* ASAC_filter_time_constant_i_us */
                                       1000);	/* ASAC_filter_time_constant_u_us */
  if (err_code != 0)
  	return ((APP_PMSMRSVC0_PWM_MASTER) + 1);
  
  return(0);
}

/**************************************************************************
 *
 *  FUNCTION : my_system_etpu_start
 *
 *  PURPOSE  : Initializes the eTPU settings and channel settings, based
 *             on the user settings in the eTPU GCT:
 *
 *             1. Initialize
 *                - Interrupt Enable
 *                - DMA Enable
 *                - Output Disable
 *                options of each channel.
 *             2. Run eTPU using Global Timebase Enable (GTBE) bit.
 *
 **************************************************************************/

void my_system_etpu_start()
{
  /* Initialization of Interrupt Enable, DMA Enable
     and Output Disable channel options */
  fs_etpu_set_interrupt_mask_a(ETPU_CIE_A);
  fs_etpu_set_interrupt_mask_b(ETPU_CIE_B);
  fs_etpu_set_dma_mask_a(ETPU_DTRE_A);
  fs_etpu_set_dma_mask_b(ETPU_DTRE_B);
  fs_etpu_set_output_disable_mask_a(ETPU_ODIS_A, ETPU_OPOL_A);
  fs_etpu_set_output_disable_mask_b(ETPU_ODIS_B, ETPU_OPOL_B);

  /* Synchronous start of all TCR time bases */
  fs_timer_start();
}


