#include <hidef.h>        /* common defines and macros */
#include "derivative.h"   /* derivative-specific definitions */

/******************************************************************************
Function Name  : TIM0ISR
Engineer       : r59709	
Date           : 06/26/2009
Notes          : Interrupt service routine for Timer channel 0.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void interrupt VectorNumber_Vtimch0 TIM0ISR(void) 
{
  
  PTT_PTT4 ^= 1;         //Toggle Port A0 to show output compare occured.
  TFLG1 = TFLG1_C0F_MASK; //Clear channel 0 flag.
  
}
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : TIM1ISR
Engineer       : r59709
Date           : 06/26/2009
Notes          : Interrupt service routine for Timer channel 1.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void interrupt VectorNumber_Vtimch1 TIM1ISR(void) 
{
  
  PTT_PTT5 ^= 1;         //Toggle Port A1 to show output compare occured.
  TFLG1 = TFLG1_C1F_MASK; //Clear channel 1 flag.
  
}
#pragma CODE_SEG DEFAULT


/******************************************************************************
Function Name  : TIM3ISR
Engineer       : r59709
Date           : 06/26/2009
Notes          : Interrupt service routine for Timer channel 3.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void interrupt VectorNumber_Vtimch3 TIM3ISR(void) 
{
  
  PTT_PTT6 ^= 1;         //Toggle Port A3 to show input capture occured.
  TFLG1 = TFLG1_C3F_MASK; //Clear channel 3 flag.
  
}
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : Perform_Output_Compare
Engineer       : r59709
Date           : 06/26/2009
Notes          : Function to setup Timer module for output compare.
******************************************************************************/
void Perform_Output_Compare(void)
{
  PTT_PTT4 = 0;
  PTT_PTT5 = 0;
  DDRT_DDRT4 = 1;
  DDRT_DDRT5 = 1;
      
  TSCR1_TEN = 0;  //Disable Timer module before adjusting registers.
  TIOS_IOS0 = 1;  //Set Channel 0 as output compare.
  TCTL2_OM0 = 0;  //Set channel 0 to toggle when a Timer match occurs.
  TCTL2_OL0 = 1;  //Set channel 0 to toggle when a Timer match occurs.
  TC0 = 0x8000;   //Set a value for channel 0 timer compare.
  TIE_C0I = 1;    //Enable channel 0 interrupt, handled by function TIM0ISR.
  
  TIOS_IOS1 = 1;  //Set Channel 1 as output compare.
  TCTL2_OM1 = 0;  //Set channel 1 to toggle when a Timer match occurs.
  TCTL2_OL1 = 1;  //Set channel 1 to toggle when a Timer match occurs.
  TC1 = 0xFFFF;   //Set channel 1 timer compare.
  TIE_C1I = 1;    //Enable channel 1 interrupt, handled by function TIM1ISR.
  
  TSCR1_TSWAI = 1;//Disables the timer module while in wait mode.
  TSCR1_TSFRZ = 1;//Disables the timer counter while in freeze mode.
  TSCR2_PR = 0x6; //Set prescaler to divide by 64.
  TSCR1_TEN = 1;  //Timer Enable.
}

/******************************************************************************
Function Name  : Perform_Input_Capture
Engineer       : r59709
Date           : 06/26/2009
Notes          : Timer channel 3 is set as an any-edge input capture.
******************************************************************************/
void Allow_Input_Capture(void)
{
  PTT_PTT6 = 0;
  DDRT_DDRT6 = 1;
  
  PPST_PPST3 = 1;//Set Port T3 pull device polarity as low
  PERT_PERT3 = 1;//Enable Port T3 pull device.

  TSCR1_TEN = 0;  //Disable timer module before adjusting registers.
  TIOS_IOS3 = 0;  //Set Channel 3 as input capture.
  TCTL4_EDG3A = 1;//Set channel 3 to capture any edge transition.
  TCTL4_EDG3B = 1;//Set channel 3 to capture any edge transition.
  TIE_C3I = 1;    //Enable channel 3 interrupt, handled by function TIM1ISR.
  TSCR1_TSWAI = 1;//Disables the timer module while in wait mode.
  TSCR1_TSFRZ = 1;//Disables the timer counter while in freeze mode.
  TSCR2_PR = 0x6; //Set prescaler to divide by 64.
  TSCR1_TEN = 1;  //Timer Enable.
}

/******************************************************************************
Function Name  : IdentifyS12GDevice
Engineer       : b34618
Date           : 05/16/2011
Notes          : Returns S12G device ID
******************************************************************************/
unsigned int IdentifyS12GDevice(void) 
{
  return(PARTID);
}


void main(void) {
  /* put your own code here */
   
  Perform_Output_Compare();
  Allow_Input_Capture();

	EnableInterrupts;


  for(;;) {
    _FEED_COP(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
