/*******************************************************************************
                                                    Copyright (c) Freescale 2011
File Name:  main.c

Current Revision:   Revision: 1.0

PURPOSE: Main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
              function Delay() - simple software delay
              function Wait1ms() - 1mS software delay
              function WaitNms() - N ms software delay
              function ConfigurePorts() - provides I/O set up
              
              Software configures CPMU for PEI, PBE and PEE modes
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  ra9229    01/28/11    - initial coding

     *******************************************************************
     * File created by: Freescale Austin, TX MSG Applications Group *
     *******************************************************************

                                                                          
*******************************************************************************/
/*============================================================================*/
/* Freescale reserves the right to make changes without further notice to any */
/* product herein to improve reliability, function, or design. Freescale does */
/* not assume any  liability arising  out  of the  application or use of any  */
/* product,  circuit, or software described herein;  neither  does it convey  */
/* any license under its patent rights  nor the  rights of others.  Freescale */
/* products are not designed, intended,  or authorized for use as components  */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other  */
/* applications intended to support life, or  for any  other application  in  */
/* which the failure of the Freescale product  could create a situation where */
/* personal injury or death may occur. Should Buyer purchase or use Freescale */
/* products for any such intended  or unauthorized  application, Buyer shall  */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries, */
/* affiliates,  and distributors harmless against all claims costs, damages,  */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or  */
/* indirectly,  any claim of personal injury  or death  associated with such  */
/* unintended or unauthorized use, even if such claim alleges that  Freescale */
/* was negligent regarding the  design  or manufacture of the part. Freescale */
/* and the Freescale logo* are registered trademarks of Freescale Ltd.        */
/******************************************************************************/

/************************* Include Files **************************************/
#include <hidef.h>          /* also includes boolean definitions in stdtypes.h */
#include <MC9S12G128.h>     /* derivative information */

/************************* typedefs *******************************************/

/************************* #defines *******************************************/
/************************* Constants ******************************************/
#pragma CONST_SEG DEFAULT

/************************* Global Variables ***********************************/
#pragma DATA_SEG DEFAULT

/************************* function prototypes ********************************/
#pragma CODE_SEG DEFAULT
/************************* Functions ******************************************/
#pragma CODE_SEG DEFAULT

/*******************************************************************************
Function Name  : main
Engineer       : ra9229	
Date           : 01/28/11
Parameters     : NONE
Returns        : NONE
Notes          : main routine called by Startup.c. 
*******************************************************************************/

void main(void)
{
    unsigned int x, toggle;             /* outer loop counter */
    char y;                             /* inner loop counter */
          
    PTT = 0xF0;                         /* Initialise PORT T all high; turn off LEDs */
    DDRT = 0xF0;                        /* PORTT 7:4 outputs */

	PER1AD = 0xF0;						/* Enable Port PAD Pulls */
	PPS1AD = 0x00;						/* Eanble as Pull-Ups */
	ATDDIEN = 0x00F0;					/* Enable PAD[7:4] as Inputs */
	
    /* Wait for pull ups to come into effect */
    for (x=0; x<1000; x++)
    {	
        for (y=0; y<100; y++)
        {} 
    }

    /* Select clock mode via Push Button switches */
    /*                                            */
    /* PEI (6.25 MHz)   Default Mode              */
    /* PEI (12.5MHz)    Push Button 2             */
    /* PEE (32 MHz)     Push Button 3             */
    /* PBE (4 MHz)      Push Button 4             */


    ECLKCTL_NECLK = 0;  /* Enable ECLK = Bus Clock */                   

    toggle = 0x10;
    
    while (1)
    {
            
        switch (PT1AD)
        {

            case 0x7F:

                /* initialise the system clock PBE - 8 MHz Crystal, 4MHz Bus CLK (32MHz VCO, 4MHz PLL)  */

                CPMUSYNR = 0x01;                /* SYNDIV = 1, VCO frequency 32 - 48 MHz */       

                CPMUREFDIV = 0x80;              /* REFDIV = 0, REFCLK frequency 6 - 12 MHz */       

                CPMUPOSTDIV = 0x07;             /* POSTDIV = 7 */

                CPMUCLKS_PLLSEL = 1;            /* PLLSEL = 1 */

                while (!CPMUCLKS_PLLSEL);       /* Verify CPMUCLKS configuration */

                CPMUOSC_OSCE = 1;               /* Enable Oscillator OSCE = 1 */

                while(!CPMUFLG_UPOSC);          /* wait for OSC to stabilise */

                CPMUCLKS_PLLSEL = 0;            /* PLLSEL = 0 */

                while (CPMUCLKS_PLLSEL);        /* Verify CPMUCLKS configuration */

                PTT = 0xF0;                     /* Clear any set LEDs */
                
                toggle = 0x80;                  /* Set LED toggle pattern */
                
                break;

            case 0xBF:

                /* initialise the system clock PEE - 64MHz VCO, 32MHz Bus CLK, from 8MHz Crystal */

                CPMUSYNR = 0x47;                /* SYNDIV = 7, VCO frequency 48 - 64 MHz */

                CPMUREFDIV = 0x80;              /* REFDIV = 0 REFCLK frequency 6 - 12 MHz */     

                CPMUPOSTDIV = 0x01;             /* POSTDIV = 1 */

                CPMUCLKS_PLLSEL = 1;            /* PLLSEL = 1 */

                while (!CPMUCLKS_PLLSEL);       /* Verify CPMUCLKS configuration */

                CPMUOSC_OSCE = 1;               /* Enable Oscillator OSCE = 1 */

                while(!CPMUFLG_UPOSC);          /* wait for OSC to stabilise */

                while(!CPMUFLG_LOCK);           /* wait for PLL to lock */
                
                PTT = 0xF0;                     /* Clear any set LEDs */
                
                toggle = 0x40;                  /* Set LED toggle pattern */

                break;

            case 0xDF:

                /* initialise the system clock PEI - 50MHz VCO, 12.5MHz Bus CLK, from 1MHz Internal Clock */

                CPMUSYNR = 0x58;                /* SYNDIV = 24, VCO frequency 48 - 64 MHz */

                CPMUPOSTDIV = 0x01;             /* POSTDIV = 1 */

                CPMUCLKS_PLLSEL = 1;            /* PLLSEL = 1 */

                while (!CPMUCLKS_PLLSEL);       /* Verify CPMUCLKS configuration */

                while(!CPMUFLG_LOCK);	        /* wait for PLL to lock */

                PTT = 0xF0;                     /* Clear any set LEDs */
                
                toggle = 0x20;                  /* Set LED toggle pattern */
                
                break;

            default: 
                
                /* Toggel LED's */
                        
                PTT ^= toggle;
                
                break;

        }

        /* Delay */
        for (x=0; x<2000; x++)
        {	
            for (y=0; y<100; y++)
            {} 
        }
                
    }
}

