/******************************************************************************************
main file for DAC_8B5V module.
Requirements to migrate:
ADC channel input: 
built for IP ADC12B16CV2
SCI channel to transmit aquired data
built for IP S12SPIV5.
CPMU for IP S12CPMU.
If you are using this file you should check:
BUS SPEED - This application considers a bus clock of 25MHz reconfigure BUS_CLOCK macro in
UART.c file and DEVICE_FAMILY in devices.h, create a new family and add code in CLK_Confi
gure function.
******************************************************************************************/
/******************************************************************************************
TEST DETAILS:

TEST1: DACU1 Unbuffered output Voltage Range
Configure DAC in mode 4 "100"
DAC module will generate requested voltages in both modes: Reduced voltage Range
and Full voltage Range, DAC output will be conected to a ADC channel that will measure
if the channel output returns the expected output. If the output exceeds or is inferior
to the expected value (stored in _analogValues array) +- configured error, an error message
will be sent via SCI0. (USE hyperterminal 8 bit, no parity).

TEST2: DACU1  Buffered output Voltage Range. Change your probe to the AMP output.
Configure DAC in mode 7 "111"
DAC module will generate requested voltages in both modes: Reduced voltage Range
and Full voltage Range, DAC output will be conected to a ADC channel that will measure
if the channel output returns the expected output. If the output exceeds or is inferior
to the expected value (stored in _analogValues array) +- configured error, an error message
will be sent via SCI0. (USE hyperterminal 8 bit, no parity).


******************************************************************************************/



#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */
#include "clock.h"
#include "ADC.h"
#include "DAC.h"
#include "UART.h"


/*Selected ADC channel to measure DACU output*/
#define ADC_CHANNEL1     1
#define ADC_CHANNEL5     2

/******************************************************************************************
Definition of Constants
******************************************************************************************/

unsigned char interrupt_Flag;

/* Values to compare ADC read, consider that ADC is configured to 12 bit resolution*/
/* VHR 5V VLR 0V*/
const unsigned int _analogValues[2][256] = {
/*Reduced Voltage Range*/
 {
  410, 422, 435, 448, 461, 474, 486, 499, 512, 525, 538, 550, 563, 576, 589, 
  602, 614, 627, 640, 653, 666, 678, 691, 704, 717, 730, 742, 755, 768, 781,
  794, 806, 819, 832, 845, 858, 870, 883, 896, 909, 922, 934, 947, 960, 973,
  986, 998, 1011, 1024, 1037, 1050, 1062, 1075, 1088, 1101, 1114, 1126, 1139, 1152, 1165,
  1178, 1190, 1203, 1216, 1229, 1242, 1254, 1267, 1280, 1293, 1306, 1318, 1331, 1344, 1357, 
  1370, 1382, 1395, 1408, 1421, 1434, 1446, 1459, 1472, 1485, 1498, 1510, 1523, 1536, 1549, 
  1562, 1574, 1587, 1600, 1613, 1626, 1638, 1651, 1664, 1677, 1690, 1702, 1715, 1728, 1741, 
  1754, 1766, 1779, 1792, 1805, 1818, 1830, 1843, 1856, 1869, 1882, 1894, 1907, 1920, 1933, 
  1946, 1958, 1971, 1984, 1997, 2010, 2022, 2035, 2048, 2061, 2074, 2086, 2099, 2112, 2125, 
  2138, 2150, 2163, 2176, 2189, 2202, 2214, 2227, 2240, 2253, 2266, 2278, 2291, 2304, 2317, 
  2330, 2342, 2355, 2368, 2381, 2394, 2406, 2419, 2432, 2445, 2458, 2470, 2483, 2496, 2509, 
  2522, 2534, 2547, 2560, 2573, 2586, 2598, 2611, 2624, 2637, 2650, 2662, 2675, 2688, 2701, 
  2714, 2726, 2739, 2752, 2765, 2778, 2790, 2803, 2816, 2829, 2842, 2854, 2867, 2880, 2893, 
  2906, 2918, 2931, 2944, 2957, 2970, 2982, 2995, 3008, 3021, 3034, 3046, 3059, 3072, 3085, 
  3098, 3110, 3123, 3136, 3149, 3162, 3174, 3187, 3200, 3213, 3226, 3238, 3251, 3264, 3277, 
  3290, 3302, 3315, 3328, 3341, 3354, 3366, 3379, 3392, 3405, 3418, 3430, 3443, 3456, 3469, 
  3482, 3494, 3507, 3520, 3533, 3546, 3558, 3571, 3584, 3597, 3610, 3622, 3635, 3648, 3661, 3674
 },
/*Full Voltage Range*/
 {
  0, 16, 32, 48, 64, 80, 96, 112, 128, 144, 160, 176, 192, 208, 224,
  240, 256, 272, 288, 304, 320, 336, 352, 368, 384, 400, 416, 432, 448, 464, 
  480, 496, 512, 528, 544, 560, 576, 592, 608, 624, 640, 656, 672, 688, 704,
  720, 736, 752, 768, 784, 800, 816, 832, 848, 864, 880, 896, 912, 928, 944,
  960, 976, 992, 1008, 1024, 1040, 1056, 1072, 1088, 1104, 1120, 1136, 1152, 1168,1184,
  1200, 1216, 1232, 1248, 1264, 1280, 1296, 1312, 1328, 1344, 1360, 1376, 1392, 1408, 1424,
  1440, 1456, 1472, 1488, 1504, 1520, 1536, 1552, 1568, 1584, 1600, 1616, 1632, 1648, 1664,
  1680, 1696, 1712, 1728, 1744, 1760, 1776, 1792, 1808, 1824, 1840, 1856, 1872, 1888, 1904,
  1920, 1936, 1952, 1968, 1984, 2000, 2016, 2032, 2048, 2064, 2080, 2096, 2112, 2128, 2144,
  2160, 2176, 2192, 2208, 2224, 2240, 2256, 2272, 2288, 2304, 2320, 2336, 2352, 2368, 2384, 
  2400, 2416, 2432, 2448, 2464, 2480, 2496, 2512, 2528, 2544, 2560, 2576, 2592, 2608, 2624,
  2640, 2656, 2672, 2688, 2704, 2720, 2736, 2752, 2768, 2784, 2800, 2816, 2832, 2848, 2864, 
  2880, 2896, 2912, 2928, 2944, 2960, 2976, 2992, 3008, 3024, 3040, 3056, 3072, 3088, 3104, 
  3120, 3136, 3152, 3168, 3184, 3200, 3216, 3232, 3248, 3264, 3280, 3296, 3312, 3328, 3344, 
  3360, 3376, 3392, 3408, 3424, 3440, 3456, 3472, 3488, 3504, 3520, 3536, 3552, 3568, 3584, 
  3600, 3616, 3632, 3648, 3664, 3680, 3696, 3712, 3728, 3744, 3760, 3776, 3792, 3808, 3824, 
  3840, 3856, 3872, 3888, 3904, 3920, 3936, 3952, 3968, 3984, 4000, 4016, 4032, 4048, 4064, 4080
 }
};

static unsigned int readValues[2][256] = {0};

/******************************************************************************************
Local Function Definitions with File Level Scope
******************************************************************************************/

void Delay(unsigned long outer_cycle);
void PrintMem( unsigned long _addr, unsigned long _size );

/******************************************************************************************
main
******************************************************************************************/
void main(void)
{

    int error;
    unsigned int _dacChannel = 0, i=0;
    unsigned char _referenceVoltage = 0;
    signed char dataBuffer[ 3 ];
    unsigned long _arrayAddress;
        
    CLK_Configure();            /* Configures Clock to run at MAX bus speed for S12G Family -25MHz- */
    ADC_Configure();            /* Configures ADC to single conversion with 12 bit resolution */
       
    UartConfigure(9600);        /* Configure serial interface. */ 
    
    PTT  = 0x60;                /* Initialise PORT T 5 & 6 High; turn off LED4 (D4) and LED5 (D5) */
    DDRT = 0x60;                /* PORTT 5 & 6 = output */

    PER1AD =  0xF0;             /* Enable pullups on Switches 1-4 */
    ATDDIEN = 0xF0;
    
    PER0AD = 0x80;              /* Enable PU on PAD15 to enable RS-232	 */
    
    EnableInterrupts;

    UartWriteStr("\r\nTWR-S12G240 Board\r\n");
    
    while(1)
    {            
        switch (PT1AD&0xF0)
        {
        
            case (0xD0): /* SW4 - Test 2: DACU1 Buffered output Voltage Range. */

                DAC_Configure(DAC_DACM_BUFFERED_MODE, DAC_FVR_REDUCED_RANGE_MODE, DAC_DRIVE_HI_OUTPUT);                
                
                UartWriteStr("\r\nDAC-Buffered Output Voltage Range\r\n");

                PTT_PTT5 = 0;                       /* Turn on LED4 */
                                
                _arrayAddress = (unsigned long) &readValues;

                do 
                {
                    Delay(100000);
                    for(_dacChannel=0, i=0; _dacChannel<256; _dacChannel++, i++)  
                    {
                        DAC_Modify_Output(_dacChannel);

                        Delay(30000);

                        readValues[_referenceVoltage][_dacChannel] = ADC_Read_Channel(ADC_CHANNEL1);

                        UartWriteStr("\n\r");
                        ByteToStrHex((unsigned char)_dacChannel, dataBuffer);
                        UartWriteStr(dataBuffer);
                        UartWriteStr(": ");        
                        PrintMem(_arrayAddress+(i*2)+(_referenceVoltage*(sizeof(readValues)/2)), 2);
                        error = readValues[_referenceVoltage][_dacChannel] - _analogValues[_referenceVoltage][_dacChannel];

                        if(error > 50 || error < -50)
                        {
                            UartWriteStr(": ERROR");
                        }
                        else
                        {
                            UartWriteStr(": OK!");  
                        }
                      
                        _FEED_COP();
                         
                    }  
                  
                    DAC_Configure(DAC_DACM_BUFFERED_MODE, DAC_FVR_FULL_RANGE_MODE, DAC_DRIVE_HI_OUTPUT);
                   
                }while(++_referenceVoltage<=1);

                UartWriteStr("\r\n\nTest Complete.\n");
                
                DAC_Modify_Output(0);
                _referenceVoltage = 0;
                DAC_Configure(DAC_DACM_BUFFERED_MODE, DAC_FVR_REDUCED_RANGE_MODE, DAC_DRIVE_HI_OUTPUT);
                                
                break;

            case (0xE0): /* SW5 -  Test 1: DACU1 Unbuffered output Voltage Range */

                DAC_Configure(DAC_DACM_UNBUFFERED_MODE, DAC_FVR_REDUCED_RANGE_MODE, DAC_DRIVE_HI_OUTPUT);
                                                                     
                UartWriteStr("\r\nDAC - Unbuffered output Voltage Range\r\n");

                PTT_PTT6 = 0;                       /* Turn on LED5 */                          

                _arrayAddress = (unsigned long) &readValues;

                do 
                {
                    Delay(100000);
                    for(_dacChannel=0, i=0; _dacChannel<256; _dacChannel++, i++)  
                        {
                        DAC_Modify_Output(_dacChannel);

                        Delay(30000);

                        readValues[_referenceVoltage][_dacChannel] = ADC_Read_Channel(ADC_CHANNEL5);

                        UartWriteStr("\n\r");
                        ByteToStrHex((unsigned char)_dacChannel, dataBuffer);
                        UartWriteStr(dataBuffer);
                        UartWriteStr(": ");        
                        PrintMem(_arrayAddress+(i*2)+(_referenceVoltage*(sizeof(readValues)/2)), 2);
                        error = readValues[_referenceVoltage][_dacChannel] - _analogValues[_referenceVoltage][_dacChannel];

                        if(error > 50 || error < -50)
                        {
                            UartWriteStr(": ERROR");
                        }
                        else
                        {
                            UartWriteStr(": OK!");  
                        }

                        _FEED_COP(); 
                    }  

                    DAC_Configure(DAC_DACM_UNBUFFERED_MODE, DAC_FVR_FULL_RANGE_MODE, DAC_DRIVE_HI_OUTPUT);

                }while(++_referenceVoltage<=1);

                UartWriteStr("\r\n\nTest Complete.\n");
                
                DAC_Modify_Output(0);
                _referenceVoltage = 0;
                DAC_Configure(DAC_DACM_UNBUFFERED_MODE, DAC_FVR_REDUCED_RANGE_MODE, DAC_DRIVE_HI_OUTPUT);
                
                break;

            default:
               PTT_PTT5 = 1;                       /* Turn off LED4 (D4) */
               PTT_PTT6 = 1;                       /* Turn off LED5 (D5) */            
        }

    }
    /* Loop Forever. Code should never reach here */
}

void PrintMem( unsigned long _addr, unsigned long _size )
{
   signed char _dataBuffer[ 3 ];
   unsigned int _strSize = 2;
   unsigned long _lastAddr = _addr + _size;
   while( _addr < _lastAddr ) 
   {
      ByteToStrHex( *( unsigned char *)_addr, _dataBuffer );
      ++_addr;
      UartWriteStr( _dataBuffer );
      __RESET_WATCHDOG();
   }
}


void Delay(unsigned long outer_cycle) 
{
  unsigned long x;
  for(x=0; x<outer_cycle; x++) 
  {
  }
}
