/*
*/

#include "UART.h"

#define BUS_CLOCK 25000000UL

void UartConfigure(unsigned long _baudRate) 
{
  unsigned int _regBRate;
  unsigned char _roundDiv = 100;
  // BR = BusClk/(16*p_bRate)
  _regBRate = ( unsigned int )( ( BUS_CLOCK*_roundDiv/( 16*_baudRate ) + (_roundDiv/2) )/_roundDiv );
  SCI0CR1 = 0x00; /*IREN Disabled, Narrow Pulse Width 3/16, BR12:BR8 = 0 */
  SCI0BDH = (unsigned char)(_regBRate>>8);
  SCI0BDL = (unsigned char)_regBRate;
  /*Enable Transmitter*/
  SCI0CR2_RE = 1;
  SCI0CR2_TE = 1;
}

   
void UartWriteByte( unsigned char _byte)
{
   while (!SCI0SR1_TDRE) /*Wait until transmitter buffer is empty*/
   {
     __RESET_WATCHDOG();  
   }
   SCI0DRL = _byte;       
}

void UartWriteStr( const char *_string )
{
   while (*_string) /*Check for /0 at string's end*/
   {
      while (!SCI0SR1_TDRE) 
      {
        __RESET_WATCHDOG(); 
      }
      SCI0DRL = *_string++;
   }
}

char const TAB_CHAR_HEX[] = "0123456789ABCDEF";

void ByteToStrHex( unsigned char p_value, char *p_data ) 
{
    p_data[0] = (char)(TAB_CHAR_HEX[ ( (p_value>>4) & 0x0F ) ]);
    p_data[1] = (char)(TAB_CHAR_HEX[ ( p_value & 0x0F ) ]);
    p_data[2] = 0;
}

void UartWriteDataHex( const unsigned char *p_dataDebug, unsigned int p_dataSize )
{
   char dataBuffer[ 3 ];
   unsigned int strSize = 2;
   
   __RESET_WATCHDOG();
   while ( p_dataSize-- > 0 )
   {
      ByteToStrHex( *p_dataDebug++, dataBuffer );
      UartWriteStr( dataBuffer );
   }
   __RESET_WATCHDOG();
}


   

