/*
*/

#include "ADC.h"

void ADC_Configure(void) 
{
  /*12 bit resolution for ADC*/
  ATDCTL1 = 0x40;
  
  /*External trigger disabled, Interrupts disabled*/
  ATDCTL2 = 0x00;
  
  /*Right justified data in conversion registers
    16 convertions per sequence*/
  ATDCTL3 = 0x80;
  
  /*Configure ADC's sample time to be of 4 ADC clock cycles*/
  ATDCTL4_SMP = 0x00;
  
  /*Configure ADC clock to run at 6.25Mhz
    FADC = FBUS/(2*(DIV+1)) = 25MHz/(2*(2))*/
  ATDCTL4_PRS = 0x01;  
                              
}

unsigned int ADC_Read_Channel(unsigned char channel) 
{
  ATDCTL5 = channel&0x0F;
  while(!ATDSTAT0_SCF) 
  {
    
  }
  return(ATDDR0);
}