#include <hidef.h>        /* common defines and macros */
#include "derivative.h"   /* derivative-specific definitions */


/******************************************************************************
Function Name  : TIM0ISR
Engineer       : r59709	
Date           : 06/26/2009
Notes          : Interrupt service routine for Timer channel 0.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void interrupt VectorNumber_Vtimch0 TIM0ISR(void) 
{
  
  PTP_PTP0 ^= 1;          /* Toggle Port T4 to show output compare occured.*/
  TFLG1 = TFLG1_C0F_MASK; /* Clear channel 0 flag.                         */
  
}
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : TIM1ISR
Engineer       : r59709
Date           : 06/26/2009
Notes          : Interrupt service routine for Timer channel 1.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void interrupt VectorNumber_Vtimch1 TIM1ISR(void) 
{
  
  PTP_PTP1 ^= 1;          /* Toggle Port T5 to show output compare occured.*/
  TFLG1 = TFLG1_C1F_MASK; /* Clear channel 1 flag.                         */
  
}
#pragma CODE_SEG DEFAULT


/******************************************************************************
Function Name  : TIM3ISR
Engineer       : r59709
Date           : 06/26/2009
Notes          : Interrupt service routine for Timer channel 3.
******************************************************************************/
#pragma CODE_SEG NON_BANKED
#pragma TRAP_PROC
void interrupt VectorNumber_Vtimch3 TIM3ISR(void) 
{
  
  PTP_PTP3 ^= 1;          /* Toggle Port P3 to show input capture occured.*/
  TFLG1 = TFLG1_C3F_MASK; /* Clear channel 3 flag.                        */
  
}
#pragma CODE_SEG DEFAULT

/******************************************************************************
Function Name  : Perform_Output_Compare
Engineer       : r59709
Date           : 06/26/2009
Notes          : Function to setup Timer module for output compare.
******************************************************************************/
void Perform_Output_Compare(void)
{
  PTP_PTP0 = 1;
  PTP_PTP1 = 1;
  
  DDRP_DDRP0 = 1;
  DDRP_DDRP1 = 1;
      
  TSCR1_TEN = 0;  /* Disable Timer module before adjusting registers.    */
  TIOS_IOS0 = 1;  /* Set Channel 0 as output compare.                    */
  TCTL2_OM0 = 0;  /* Set channel 0 to toggle when a Timer match occurs.  */
  TCTL2_OL0 = 1;  /* Set channel 0 to toggle when a Timer match occurs.  */
  TC0       = 0x8000;   /* Set a value for channel 0 timer compare.            */
  TIE_C0I   = 1;    /* Enable channel 0 interrupt, handled by function TIM0ISR. */
  
  TIOS_IOS1 = 1;  /* Set Channel 1 as output compare.                   */
  TCTL2_OM1 = 0;  /* Set channel 1 to toggle when a Timer match occurs. */
  TCTL2_OL1 = 1;  /* Set channel 1 to toggle when a Timer match occurs. */
  TC1       = 0xFFFF; /* Set channel 1 timer compare.                             */
  TIE_C1I   = 1;      /* Enable channel 1 interrupt, handled by function TIM1ISR. */
                                                                    
  TSCR1_TSWAI = 1;/* Disables the timer module while in wait mode.    */
  TSCR1_TSFRZ = 1;/* Disables the timer counter while in freeze mode. */
  TSCR2_PR    = 0x6; /* Set prescaler to divide by 64                    */
  TSCR1_TEN   = 1;  /* Timer Enable.                                    */
}

/******************************************************************************
Function Name  : Perform_Input_Capture
Engineer       : r59709
Date           : 06/26/2009
Notes          : Timer channel 3 is set as an any-edge input capture.
******************************************************************************/
void Allow_Input_Capture(void)
{
  PTP_PTP3    = 1;   /* To be used to indicate Input capture status on LED4          */
  DDRP_DDRP3  = 1;   /* Set P3 as output, the state of P3 will be toggled in TIM3ISR */
  
  PPST_PPST3  = 1;   /* Set Port T3 pull device polarity as low */
  PERT_PERT3  = 1;   /* Enable Port T3 pull device.             */

  TSCR1_TEN   = 0;   /* Disable timer module before adjusting registers. */
  TIOS_IOS3   = 0;   /* Set Channel 3 as input capture.                  */
  TCTL4_EDG3A = 1;   /* Set channel 3 to capture any edge transition.    */
  TCTL4_EDG3B = 1;   /* Set channel 3 to capture any edge transition.    */
  TIE_C3I     = 1;       /* Enable channel 3 interrupt, handled by function TIM3ISR.*/
  TSCR1_TSWAI = 1;   /* Disables the timer module while in wait mode.           */
  TSCR1_TSFRZ = 1;   /* Disables the timer counter while in freeze mode.        */
  TSCR2_PR    = 0x6; /* Set prescaler to divide by 64.                          */
  TSCR1_TEN   = 1;   /* Timer Enable.                                           */
}



/******************************************************************************
Function Name  : main
Engineer       : b30269
Date           : 09/19/2011
Notes          : Main procedure that calls initialization routines to:
                 1.- Configure OC0 and OC1 to toggle at a .7Hz, (output is 
                     shown at P0 and P1 for LED1 and LED2)
                 2.- Configure IC3 to generate an interrupt when any transition
                     is detected at T3 (IOC3), output is shown at P3 for LED4.
.
******************************************************************************/
void main(void) 
{
  Perform_Output_Compare();
  Allow_Input_Capture();

	EnableInterrupts;


  for(;;) 
  {
    _FEED_COP(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
