/******************************************************************************
													            Copyright (c) Freescale 2009
File Name    : $RCSfile: main.c,v $

Current Revision :	$Revision: 1.0 $

PURPOSE: main program entry.                       
                                                                          
                                                                       
DESCRIPTION:  function main() providing initial program entry.
                                                         
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR    DATE        DESCRIPTION OF CHANGE                          
---  ------    --------    ---------------------                          
1.0  r59709    26/06/09    - initial coding
2.0  b30269    22/06/11    - S12G64 migration

     ******************************************************
     * File created by: Freescale  MSG Applications Group *
     ******************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

/************************* Include Files *************************************/
/* general includes */
#include <hidef.h>       /* also includes boolean definitions in stdtypes.h  */
#include "derivative.h"  /* derivative information */

/************************* typedefs ******************************************/

/************************* #defines ******************************************/

/************************* Constants *****************************************/

/************************* Global Variables **********************************/

/************************* function prototypes *******************************/
 void CPMU_Init(void);
/************************* Functions *****************************************/

/******************************************************************************
Function Name  : main
Engineer       : r59709
Date           : 06/26/2009
Parameters     : NONE
Returns        : NONE
Notes          : 
                 1.- Sets up the PWM channels 0 - 3 to with different alignment
                 and polarity settings and 50% duty cycle. The user can observe
                 this by probing on the channel pins PP0-PP3 
                 (TWR-S12G64 JP12 pin 17-20, if LED1-4 will be toggling at
                 a 100 KHz frequency y if correspondent jumpers are installed
                 in JP1).
                 2.- PWM frequency is derived from an external 8MHz oscillator, 
                 this freq is the base frequency and using internal PLL the bus 
                 frequency is multiplied to have a 25MHz.
                 3.- Since PWM0 and 1 are left align, and PWM2 and 3 are center 
                 alligned, so PWM2 and 3 have the double of the period than PWM0
                 and 1.
         
******************************************************************************/
void main(void)
{
	
	CPMU_Init();

  /*************************/
  PWMCAE = 0x0C; /* Set center alignment for channels 0 - 3 */
  PWMPOL = 0x0A; /* Set polarity for channels 0 - 3         */
  /**************************
    The above register setting should match the following truth table.
    PWM0: Left   Aligned=0, Polarity=0
    PWM1: Left   Aligned=0, Polarity=1
    PWM2: Center Aligned=1, Polarity=0
    PWM3: Center Aligned=1, Polarity=1
  ***************************/  
  
  /* PWM0 clk selection */
  PWMCLK_PCLK0     = 0;      /* selecet A as source clk */
  PWMCLKAB_PCLKAB0 = 0;  
  /* PWM1 clk selection */
  PWMCLK_PCLK1     = 0;      /* selecet A as source clk */
  PWMCLKAB_PCLKAB1 = 0;  
  /* PWM2 clk selection */
  PWMCLK_PCLK2     = 0;      /* selecet A as source clk */
  PWMCLKAB_PCLKAB2 = 1;  
  /* PWM3 clk selection */
  PWMCLK_PCLK3     = 0;      /* selecet A as source clk */
  PWMCLKAB_PCLKAB3 = 1;
  
  
  PWMPER0 = 0xFF; /* Set chan 0 period length to the maximum.        */
  PWMPER1 = 0xFF; /* Set chan 1 period length to the maximum.        */
  PWMPER2 = 0xFF; /* Set chan 2 period length to the maximum.        */
  PWMPER3 = 0xFF; /* Set chan 3 period length to the maximum.        */

  PWMDTY0 = 0x80; /* Set chan 0 duty cycle to half the maximum, 50%. */
  PWMDTY1 = 0x80; /* Set chan 1 duty cycle to half the maximum, 50%. */
  PWMDTY2 = 0x80; /* Set chan 2 duty cycle to half the maximum, 50%. */
  PWMDTY3 = 0x80; /* Set chan 3 duty cycle to half the maximum, 50%. */

  PWME = 0x0F;    /* Enable PWM channels 0 - 3 (PP0-PP3)             */
  
  for(;;)
  {
     ;
  }
  
  /* PLEASE MAKE SURE THAT YOU NEVER EXIT main(void) */
}


/******************************************************************************
Function Name  : CPMU_Init
Engineer       : b30269	
Date           : 02/07/11
Parameters     : NONE
Returns        : NONE
Notes          : CPMU configuration to run at 25MHz bus clk.                               
******************************************************************************/
void CPMU_Init(void)
{
   /* 
      Initialise the system clock for Normal mode: 
      - 50MHz VCO, 50MHz PLL, 25MHz Bus CLK, from 8MHz Crystal 
   */
	
   CPMUSYNR    = 0x58;     /* VCOFRQ -> 48MHz < fVCO<= 50MHz SYNDIV = 24  */

   CPMUREFDIV  = 0x07;     /* REFDIV =  7                                 */     

   CPMUPOSTDIV = 0x00;     /* POSTDIV = 0, FBus 0 FPLL/2                  */

   while(!CPMUFLG_LOCK)
   {
      ;                /* 
                          Wait for VCO to stabilize, if failure occurs 
                          WD will be triggered
                       */
   }			 
 
   CPMUCLKS_PLLSEL = 1;  /* Switch clk to use PLL */
}