/*****************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2005 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* File Name: uccp.h
*
* Description: uCCP public header file
*
* $Version: 2.0.10.0$
*
*****************************************************************************/

#ifndef __UCCP_H
#define __UCCP_H

#ifndef __TYPES_H
#error types.h must be included before uccp.h
#endif

/***********************************
*  public data types
***********************************/

// return codes
typedef enum
{
	UCCP_OK = 0,
	UCCP_ERR_SERVID = 1,	// bad service id
	
} UCCPRESULT;

// CCP service callback return data
typedef struct
{
	UWord32 mta;
	UWord16 ext;
	UWord16 len;
	UWord16 type;
} UCCP_SERVICE_DATA;

/***********************************
*  public callbacks definition
***********************************/

typedef UWord16 (*UCCP_SERVICE_CALLBACK)(UWord16 serviceId, UWord16* rxParams, UCCP_SERVICE_DATA* pReturnData);

/***********************************
*  public functions
***********************************/

// driver functions
UCCPRESULT UCCP_Init();

// activation/deactivation
UCCPRESULT UCCP_Start();
UCCPRESULT UCCP_Stop();

// dynamic CCP configuration (only if enabled in uccpcfg.h)
UCCPRESULT UCCP_SelectMB(UWord16 rxMB, UWord16 txMB);
UCCPRESULT UCCP_SelectCRO(UWord16 croId);
UCCPRESULT UCCP_SelectDTO(UWord16 dtoId);
UCCPRESULT UCCP_SelectECU(UWord16 ecu);

// action and diag services
UCCPRESULT UCCP_SetActionService(UWord16 serviceId, UCCP_SERVICE_CALLBACK pCallback);
UCCPRESULT UCCP_SetDiagService(UWord16 serviceId, UCCP_SERVICE_CALLBACK pCallback);

#endif /* __UCCP_H */
