/*****************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2005 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
******************************************************************************
*
* File Name: pcmccp_priv.h
*
* Description: FreeMaster (PC Master) services for CCP driver private header file
*
* $Version: 2.0.9.0$
*
*****************************************************************************/

#ifndef __PCMCCP_PRIV_H
#define __PCMCCP_PRIV_H

#ifndef __PCMCCP_CFG_H
#error PCMaster-CCP: pcmccp_cfg.h must be included before pcmccp_priv.h
#endif

/***********************************
*  sanity checks
***********************************/

#if PCMCCP_REC_MAXVARS > 8
#error PCMaster-CCP: eight recorder variables max is available in PC Master
#endif

#if !PCMCCP_REC_MAXVARS
#error PCMaster-CCP: please define non-zero PCMCCP_REC_BUFFSIZE in pcmccp_cfg.h
#endif

#if !PCMCCP_REC_BUFFSIZE
#error PCMaster-CCP: please define non-zero PCMCCP_REC_BUFFSIZE in pcmccp_cfg.h
#endif

#ifndef PCMCCP_REC_TIMEBASE
#error PCMaster-CCP: please define PCMCCP_REC_TIMEBASE in pcmccp_cfg.h
#endif

/***********************************
*  internal macros
***********************************/

// get UWord32 byte address of structures or 16/32-bit variables
#define GETBYTEADDR(ptr) (2 * ((UWord32)(UWord16*)(ptr)))

/***********************************
*  internal constants
***********************************/

// pcmccp version
#define PCMCCP_VERSION 1

// magic number in high byte of version (to detect mismatch of endiannesses)
#define PCMCCP_VER_MAGIC 		0xfb00
#define PCMCCP_RECBUFF_MAGIC 	0xfba1

// see bellow in PCMCCP_RECSETUP.trgVarInfo
#define PCMCCP_REC_TRG_SIZE_MASK	0x7		// value 1,2,4 allowed only
#define PCMCCP_REC_TRG_SIGNED		0x100	// bit8 set for signed comparing

// trigger slope modes
#define PCMCCP_REC_TRGMODE_NONE		0
#define PCMCCP_REC_TRGMODE_RISE		1
#define PCMCCP_REC_TRGMODE_FALL		2

// PC Master CCP commands (delivered through first 16bit parameter (word[1]) of Action Service CRO)
#define PCMCCP_CMD_GETINFO		0x0000	// get PC Master services information (mta=PCMCCP_INFO)
#define PCMCCP_CMD_SETUPREC0	0x0002	// preconfigure recorder (mta=PCMCCP_RECSETUP)
#define PCMCCP_CMD_SETUPREC		0x0003	// apply downloaded configuration
#define PCMCCP_CMD_STARTREC		0x0004	// start recorder
#define PCMCCP_CMD_STOPREC		0x0005	// stop recorder
#define PCMCCP_CMD_GETRECSTS	0x0006	// get recoder status
#define PCMCCP_CMD_GETRECBUFF	0x0007	// set mta to PCMCCP_RECBUFF

// responses (returned in byte[4] of Action Service DTO)
#define PCMCCP_STC_OK		0x00	// no error
#define PCMCCP_STC_RECRUN	0x01	// no error, recorder running
#define PCMCCP_STC_RECDONE	0x02	// no error, recorder stopped (mta set to buffer)

#define PCMCCP_STC_INVCMD	0x81	// Unknown command code (unsupported operation).  
#define PCMCCP_STC_INVBUFF  0x85 	// Invalid buffer length or operation 
#define PCMCCP_STC_INVSIZE  0x86 	// Invalid size specified 
#define PCMCCP_STC_SERVBUSY 0x87 	// Service is busy 
#define PCMCCP_STC_NOTINIT	0x88	// Service is not initialised

/***********************************
*  internal data types
***********************************/

// PC Master services information
typedef struct
{
	UWord16 version;		// version (lowbyte) and magic number (highbyte)
	UWord16 flags;			// flags (lowbyte) and data bus width (highbyte)
	UWord16 recMaxVars;		// max variable count
	UWord16 recBuffSize;	// recorder buffer
	UWord16 recTimeBase;	// recorder time base
} PCMCCP_INFO;

// single recorder variable
typedef struct
{
	UWord32 addr;		// variable address
	UWord16 size;		// variable size 
	UWord16 reserved;	// padding
} PCMCCP_RECVAR;

// recorder configuration (written by master)
typedef struct
{
	UWord16 trgMode;		// trigger mode (0 = disabled, 1 = _/ , 2 = \_)
	UWord16 totalSmps;		// required buffer size in samples
	UWord16 postTrigger;	// number of samples after trigger to save
	UWord16 timeDiv;		// time base unit multiplier (0 = fastest)

	UWord32 trgVarAddr;		// trg var address
	union {
		UWord8  b;			// trigger comparing threshold (when size==1)
		UWord16 w;			// trigger comparing threshold (when size==2)
		UWord32 dw;			// trigger comparing threshold (when size==4)
	} trgThreshold;			
	UWord16 trgVarInfo;		// trg var/threshold size (1,2,4) & compare mode (0 = unsigned, 1 = signed)
	
	UWord16 varCnt;			// variable count
	
	PCMCCP_RECVAR vars[PCMCCP_REC_MAXVARS];	// recorded variables
} PCMCCP_RECSETUP;

// recorder data
typedef struct
{
	UWord16 magic;		// magic number to identify our structure
	UWord16 startIx;	// first sample index
	UWord32 buffAddr;	// address of sampled data
} PCMCCP_RECBUFF;

#endif /* __PCMCCP_PRIV_H */
