/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* $File Name: arch.h$
*
* $Date:      Oct-7-2010$
*
* $Version:   2.5.13.0$
*
* Description: Peripheral space map of the MC56F825x device
*
*****************************************************************************/

#ifndef __ARCH_H
#define __ARCH_H

#ifndef __TYPES_H
#error types.h must be included before arch.h
#endif

/* System Integration Module */

#define SIM_VERSION 6
#define SIM_VERSION_6

typedef volatile struct 
{
    ARCH_REG4(UWord16, sim_control, sim_ctrl, control, ControlReg);
    ARCH_REG4(UWord16, sim_rststs,  sim_rstat, rststs, StatusReg);
    ARCH_REG3(UWord16, sim_scr0,    sim_swc0, scr0);
    ARCH_REG3(UWord16, sim_scr1,    sim_swc1, scr1);
    ARCH_REG3(UWord16, sim_scr2,    sim_swc2, scr2);
    ARCH_REG3(UWord16, sim_scr3,    sim_swc3, scr3);
    ARCH_REG3(UWord16, sim_msh_id,  sim_mshid, msh_id);
    ARCH_REG3(UWord16, sim_lsh_id,  sim_lshid, lsh_id);
    ARCH_REG3(UWord16, sim_power,   sim_pwr, power);
    ARCH_REG1(UWord16, sim_test);
    ARCH_REG3(UWord16, sim_clkosr,  sim_clkout, clkosr);
    ARCH_REG1(UWord16, sim_pcr);
    ARCH_REG1(UWord16, sim_pce0);
    ARCH_REG1(UWord16, sim_pce1);
    ARCH_REG1(UWord16, sim_pce2);
    ARCH_REG1(UWord16, sim_sd0);
    ARCH_REG1(UWord16, sim_sd1);
    ARCH_REG1(UWord16, sim_sd2);
    ARCH_REG3(UWord16, sim_isalh,   sim_iosahi, isalh);
    ARCH_REG3(UWord16, sim_isall,   sim_iosalo, isall);
    ARCH_REG1(UWord16, sim_prot);
    ARCH_REG1(UWord16, sim_gps0);
    ARCH_REG1(UWord16, sim_gps1);
    ARCH_REG1(UWord16, sim_gps2);
    ARCH_REG1(UWord16, sim_gps3);
    ARCH_REG1(UWord16, reserved2[7]);

} arch_sSIM;

/* Quad Timer Module */

#define QT_VERSION 4
#define QT_VERSION_4

typedef volatile struct
{
    ARCH_REG4(UWord16, tmrcmp1,   comp1, cmp1, CompareReg1);
    ARCH_REG4(UWord16, tmrcmp2,   comp2, cmp2, CompareReg2);
    ARCH_REG4(UWord16, tmrcap,    capt, cap, CaptureReg);
    ARCH_REG3(UWord16, tmrload,   load, LoadReg);
    ARCH_REG3(UWord16, tmrhold,   hold, HoldReg);
    ARCH_REG3(UWord16, tmrcntr,   cntr, CounterReg);
    ARCH_REG3(UWord16, tmrctrl,   ctrl, ControlReg);
    ARCH_REG4(UWord16, tmrscr,    sctrl, scr, StatusControlReg);
    ARCH_REG2(UWord16, tmrcmpld1, cmpld1);
    ARCH_REG2(UWord16, tmrcmpld2, cmpld2);
    ARCH_REG3(UWord16, tmrcomscr, csctrl, comscr);
    ARCH_REG1(UWord16, filt);
    ARCH_REG1(UWord16, reserved[3]);
    ARCH_REG1(UWord16, enbl);

} arch_sTimerChannel;

typedef volatile struct
{
    ARCH_REG2(arch_sTimerChannel, ch0, Channel0);
    ARCH_REG2(arch_sTimerChannel, ch1, Channel1);
    ARCH_REG2(arch_sTimerChannel, ch2, Channel2);
    ARCH_REG2(arch_sTimerChannel, ch3, Channel3);

} arch_sTimer;

/* EFPWM Module */

#define EFPWM_VERSION 1
#define EFPWM_VERSION_1
#define EFPWM_HAS_FAULTS  0xf

typedef volatile struct
{
	ARCH_REG1(Word16, smcnt);
    ARCH_REG1(Word16, sminit);
    ARCH_REG1(UWord16, smctrl2);
    ARCH_REG1(UWord16, smctrl);
    ARCH_REG1(UWord16, reserved1);
	ARCH_REG1(Word16, smval0);
    ARCH_REG1(UWord16, smfracval1);
    ARCH_REG1(Word16, smval1);
    ARCH_REG1(UWord16, smfracval2);
    ARCH_REG1(Word16, smval2);
    ARCH_REG1(UWord16, smfracval3);
    ARCH_REG1(Word16, smval3);
    ARCH_REG1(UWord16, smfracval4);
    ARCH_REG1(Word16, smval4);
    ARCH_REG1(UWord16, smfracval5);
    ARCH_REG1(Word16, smval5);
    ARCH_REG1(UWord16, smfrctrl);
    ARCH_REG1(UWord16, smoctrl);
    ARCH_REG1(UWord16, smsts);
    ARCH_REG1(UWord16, sminten);
    ARCH_REG1(UWord16, reserved2);
    ARCH_REG1(UWord16, smtctrl);
    ARCH_REG1(UWord16, smdismap);
    ARCH_REG1(UWord16, smdtcnt0);
    ARCH_REG1(UWord16, smdtcnt1);
    ARCH_REG1(UWord16, reserved3[23]);
    
} arch_sEFPWMSubFracModule;

typedef volatile struct
{
	ARCH_REG1(Word16, smcnt);
    ARCH_REG1(Word16, sminit);
    ARCH_REG1(UWord16, smctrl2);
    ARCH_REG1(UWord16, smctrl);
    ARCH_REG1(UWord16, reserved1);
	ARCH_REG1(Word16, smval0);
    ARCH_REG1(UWord16, reserved10);
    ARCH_REG1(Word16,  smval1);
    ARCH_REG1(UWord16, reserved11);
    ARCH_REG1(Word16, smval2);
    ARCH_REG1(UWord16, reserved12);
    ARCH_REG1(Word16, smval3);
    ARCH_REG1(UWord16, reserved13);
    ARCH_REG1(Word16, smval4);
    ARCH_REG1(UWord16, reserved14);
    ARCH_REG1(Word16, smval5);
    ARCH_REG1(UWord16, reserved15);
    ARCH_REG1(UWord16, smoctrl);
    ARCH_REG1(UWord16, smsts);
    ARCH_REG1(UWord16, sminten);
    ARCH_REG1(UWord16, reserved2);
    ARCH_REG1(UWord16, smtctrl);
    ARCH_REG1(UWord16, smdismap);
    ARCH_REG1(UWord16, smdtcnt0);
    ARCH_REG1(UWord16, smdtcnt1);
    ARCH_REG1(UWord16, reserved3);
    ARCH_REG1(UWord16, smcaptctrla);
    ARCH_REG1(UWord16, smcaptcompa);
    ARCH_REG1(UWord16, smcaptctrlb);
    ARCH_REG1(UWord16, smcaptcompb);
    ARCH_REG1(UWord16, smcaptctrlx);
    ARCH_REG1(UWord16, smcaptcompx);
    ARCH_REG1(Word16, smcval0);
    ARCH_REG1(UWord16, reserved4);
    ARCH_REG1(Word16, smcval1);
    ARCH_REG1(UWord16, reserved5);
    ARCH_REG1(Word16, smcval2);
    ARCH_REG1(UWord16, reserved6);
    ARCH_REG1(Word16, smcval3);
    ARCH_REG1(UWord16, reserved7);
    ARCH_REG1(Word16, smcval4);
    ARCH_REG1(UWord16, reserved8);
    ARCH_REG1(Word16, smcval5);
    ARCH_REG1(UWord16, reserved9[5]);
    
} arch_sEFPWMSubCaptModule;


typedef volatile struct
{
    ARCH_REG2(arch_sEFPWMSubFracModule, Sub0, Submodule0);
    ARCH_REG2(arch_sEFPWMSubFracModule, Sub1, Submodule1);
    ARCH_REG2(arch_sEFPWMSubFracModule, Sub2, Submodule2);
    ARCH_REG2(arch_sEFPWMSubCaptModule, Sub3, Submodule3);
	ARCH_REG1(UWord16, outen);
    ARCH_REG1(UWord16, mask);
    ARCH_REG1(UWord16, swcount);
    ARCH_REG1(UWord16, dtsrcsel);
    ARCH_REG1(UWord16, mctrl);
    ARCH_REG1(UWord16, mctrl2);
    ARCH_REG1(UWord16, fctrl);
    ARCH_REG1(UWord16, fsts);
    ARCH_REG1(UWord16, ffilt);
    
} arch_sEFPWM;

/* Interrupt Controller */

#define INTC_VERSION 5
#define INTC_VERSION_5
#define INTC_HAS_IRQPINS 0

typedef volatile struct
{
    ARCH_REG2(UWord16, ipr[8],     PriorityReg[8]);
    ARCH_REG2(UWord16, vba,        VecBaseReg);
    ARCH_REG2(UWord16, fim0,       FastInt0MatchReg);
    ARCH_REG2(UWord16, fival0,     FastInt0AddrLReg);
    ARCH_REG2(UWord16, fivah0,     FastInt0AddrHReg);
    ARCH_REG2(UWord16, fim1,       FastInt1MatchReg);
    ARCH_REG2(UWord16, fival1,     FastInt1AddrLReg);
    ARCH_REG2(UWord16, fivah1,     FastInt1AddrHReg);
    ARCH_REG2(UWord16, irqp[5],    IntPendingReg[5]);
    ARCH_REG2(UWord16, ictl,       ControlReg);
    ARCH_REG1(UWord16, reserved1[11]);

} arch_sIntc;

/* A/D Converter */

#define ADC_VERSION 5
#define ADC_VERSION_5

typedef volatile struct
{
    ARCH_REG4(UWord16, adctl1,    ctrl1, adcr1, Control1Reg);
    ARCH_REG4(UWord16, adctl2,    ctrl2, adcr2, Control2Reg);
    ARCH_REG3(UWord16, adzcc,     zxctrl, ZeroCrossControlReg);
    ARCH_REG3(UWord16, adlst1,    clist1, ChannelList1Reg);
    ARCH_REG3(UWord16, adlst2,    clist2, ChannelList2Reg);
    ARCH_REG3(UWord16, adlst3,    clist3, ChannelList3Reg);
    ARCH_REG3(UWord16, adlst4,    clist4, ChannelList4Reg);
    ARCH_REG3(UWord16, adsdis,    sdis, DisableReg);
    ARCH_REG3(UWord16, adstat,    stat, StatusReg);
    ARCH_REG1(UWord16, cnrdy);
    ARCH_REG3(UWord16, adlstat,   limstat, LimitReg);
    ARCH_REG3(UWord16, adzcstat,  zxstat, ZeroCrossStatusReg);
    ARCH_REG3(UWord16, adrslt[16], rslt[16], ResultReg[16]);
    ARCH_REG3(UWord16, adllmt[8], lolim[8], LowLimitReg[8]);
    ARCH_REG3(UWord16, adhlmt[8], hilim[8], HighLimitReg[8]);
    ARCH_REG3(UWord16, adofs[8],  offst[8], OffsetReg[8]);
    ARCH_REG2(UWord16, adcpower,  pwr);
    ARCH_REG2(UWord16, adc_cal,   cal);
    ARCH_REG2(UWord16, adc_gc1,   gc1);
    ARCH_REG2(UWord16, adc_gc2,   gc2);
    ARCH_REG2(UWord16, adc_sctrl,   sctrl);
    ARCH_REG2(UWord16, adc_pwr2,   pwr2);
    ARCH_REG1(UWord16, reserved1[6]);

} arch_sADC;

/* Queued Serial Communication Interface */

#define SCI_VERSION 3
#define SCI_VERSION_3

typedef volatile struct
{
    ARCH_REG2(UWord16, scibr,    BaudRateReg);
    ARCH_REG2(UWord16, scicr,    ControlReg);
    ARCH_REG2(UWord16, scicr2,   ControlReg2); /* VERSION_2,3-specific */
    ARCH_REG2(UWord16, scisr,    StatusReg);
    ARCH_REG2(UWord16, scidr,    DataReg);
    ARCH_REG1(UWord16, reserved2[11]);

} arch_sSCI;

/* Serial Peripheral Interface */

#define SPI_VERSION 4
#define SPI_VERSION_4

typedef volatile struct
{
    ARCH_REG3(UWord16, spscr,    sctrl, ControlReg);
    ARCH_REG4(UWord16, spdsr,    dsctrl, spdscr, DataSizeReg);
    ARCH_REG3(UWord16, spdrr,    drcv, DataRxReg);
    ARCH_REG3(UWord16, spdtr,    dxmit, DataTxReg);
    ARCH_REG1(UWord16, fifo);
    ARCH_REG1(UWord16, delay);
    ARCH_REG1(UWord16, reserved1[10]);

} arch_sSPI;

//* IIC Interface */

#define IIC_VERSION 4
#define IIC_VERSION_4

typedef volatile struct
{
	ARCH_REG2(UWord16, iica1, addr1);
	ARCH_REG3(UWord16, iicf,  ibfd,  fdiv);
	ARCH_REG3(UWord16, iicc1, ctrl1, cr1);
	ARCH_REG3(UWord16, iics,  stat,  ibsr);
	ARCH_REG3(UWord16, iicd,  data, ibdr);
	ARCH_REG3(UWord16, iicc2, ctrl2, cr2);
	ARCH_REG2(UWord16, iicfilt, iic_filt);
	ARCH_REG2(UWord16, iicsmb, iic_smbcsr);
	ARCH_REG2(UWord16, iica2, addr2);
	ARCH_REG1(UWord16, iicslth);
	ARCH_REG1(UWord16, iicsltl);
	ARCH_REG1(UWord16, reserved1[5]);
	
} arch_sIIC;

/* Watchdog Module */

#define COP_VERSION 3
#define COP_VERSION_3

typedef volatile struct
{
    ARCH_REG2(UWord16, copctl,   ControlReg);
    ARCH_REG2(UWord16, copto,    TimeoutReg);
    ARCH_REG2(UWord16, copctr,   ServiceReg);
    ARCH_REG1(UWord16, reserved1[13]);

} arch_sCOP;

/* PLL/OCCS Module */

#define OCCS_VERSION 5
#define OCCS_VERSION_5
#define OCCS_HAS_RXOSC 1

typedef volatile struct
{
    ARCH_REG3(UWord16, pllcr,   ctrl, ControlReg);
    ARCH_REG3(UWord16, plldb,   divby, DivideReg);
    ARCH_REG3(UWord16, pllsr,   stat, StatusReg);
    ARCH_REG1(UWord16, testr);
    ARCH_REG2(UWord16, osctl,   octrl);
    ARCH_REG1(UWord16, clkchkr);
    ARCH_REG1(UWord16, clkchkt);
    ARCH_REG1(UWord16, prot);
    ARCH_REG1(UWord16, reserved1[8]);

} arch_sPLL;

/* General Purpose I/O */

#define GPIO_VERSION 2
#define GPIO_VERSION_2

typedef volatile struct
{
    ARCH_REG3(UWord16, pur,      pupen, PullUpReg);
    ARCH_REG3(UWord16, dr,       data, DataReg);
    ARCH_REG3(UWord16, ddr,      ddir, DataDirectionReg);
    ARCH_REG3(UWord16, per,      peren, PeripheralReg);
    ARCH_REG3(UWord16, iar,      iassrt, IntAssertReg);
    ARCH_REG3(UWord16, ienr,     ien, IntEnableReg);
    ARCH_REG3(UWord16, ipolr,    iepol, IntPolarityReg);
    ARCH_REG3(UWord16, ipr,      ipend, IntPendingReg);
    ARCH_REG3(UWord16, iesr,     iedge, IntEdgeSensReg);
    ARCH_REG3(UWord16, ppmode,   ppoutm, PushPullModeReg);
    ARCH_REG3(UWord16, rawdata,  rdata, RawInputReg);
    ARCH_REG2(UWord16, drive,    DriveStrengthReg); /* VERSION_2,3-specific */
    ARCH_REG1(UWord16, reserved1[4]);

} arch_sPort;

/* Lov-Voltage Detector */

#define LVI_VERSION 2
#define LVI_VERSION_2

typedef volatile struct
{
    ARCH_REG4(UWord16, ps_ctlr,  ctrl, control, lvictlr);
    ARCH_REG4(UWord16, ps_stat,    stat, status, lvisr);
    ARCH_REG1(UWord16, reserved1[14]);

} arch_sLVI;

/* Flash Memory Module */

#define HFM_VERSION 2
#define HFM_VERSION_2

typedef volatile struct
{
    ARCH_REG2(UWord16, fmclkd,     clkd);
    ARCH_REG3(UWord16, fmcr,       cnfg, mcr);
    ARCH_REG1(UWord16, fmtst);
    ARCH_REG3(UWord16, fmsech,     sechi, sech);
    ARCH_REG3(UWord16, fmsecl,     seclo, secl);
    ARCH_REG2(UWord16, fmmntr,     mntr);
    ARCH_REG1(UWord16, reserved1[10]);
    ARCH_REG2(UWord16, fmprot,     prot);
    ARCH_REG1(UWord16, reserved2);
    ARCH_REG2(UWord16, fmstat,     stat);
    ARCH_REG2(UWord16, fmustat,    ustat);
    ARCH_REG2(UWord16, fmcmd,      cmd);
    ARCH_REG2(UWord16, fmctl,      ctl);
    ARCH_REG1(UWord16, fhadr);
    ARCH_REG1(UWord16, reserved3);
    ARCH_REG1(UWord16, fmdata);
    ARCH_REG1(UWord16, reserved4);
    ARCH_REG2(UWord16, fmopt0,     ifropt0);
    ARCH_REG3(UWord16, fmopt1,     opt1, ifropt1);
    ARCH_REG2(UWord16, fmmemsel,   ifrmemsel);
    ARCH_REG1(UWord16, fmtstsig);
    ARCH_REG1(UWord16, reserved5[34]);

} arch_sHFM;

/* Digital to Analog Converter */

#define DAC_VERSION 1
#define DAC_VERSION_1

typedef volatile struct {
    ARCH_REG1(UWord16, ctrl);
    ARCH_REG1(UWord16, data);
    ARCH_REG1(UWord16, step);
    ARCH_REG1(UWord16, minval);
    ARCH_REG1(UWord16, maxval);
    ARCH_REG1(UWord16, reserved1[11]);

} arch_sDAC;

/* Analog Comparator */

#define HSCMP_VERSION 2
#define HSCMP_VERSION_2

typedef volatile struct 
{
    ARCH_REG1(UWord16, cr0);
    ARCH_REG1(UWord16, cr1);
    ARCH_REG1(UWord16, fpr);
    ARCH_REG1(UWord16, scr);
	ARCH_REG1(UWord16, reserved1[12]);

} arch_sHSCMP;

/* msCAN */

#define MSCAN_VERSION 2
#define MSCAN_VERSION_2

typedef volatile struct {
    ARCH_REG1(UWord16, idr0);
    ARCH_REG1(UWord16, idr1);
    ARCH_REG1(UWord16, idr2);
    ARCH_REG1(UWord16, idr3);
    ARCH_REG1(UWord16, dsr0);
    ARCH_REG1(UWord16, dsr1);
    ARCH_REG1(UWord16, dsr2);
    ARCH_REG1(UWord16, dsr3);
    ARCH_REG1(UWord16, dsr4);
    ARCH_REG1(UWord16, dsr5);
    ARCH_REG1(UWord16, dsr6);
    ARCH_REG1(UWord16, dsr7);
    ARCH_REG1(UWord16, dlr);
    ARCH_REG1(UWord16, tbpr);
    ARCH_REG1(UWord16, tsrh);
    ARCH_REG1(UWord16, tsrl);
    
} arch_sMSCAN_MB;

typedef volatile struct {
     ARCH_REG2(UWord16, canctl0, ctrl0); 
     ARCH_REG2(UWord16, canctl1, ctrl1); 
     ARCH_REG2(UWord16, canbtr0, btr0); 
     ARCH_REG2(UWord16, canbtr1, btr1); 
     ARCH_REG2(UWord16, canrflg, rflg); 
     ARCH_REG2(UWord16, canrier, rier); 
     ARCH_REG2(UWord16, cantflg, tflg); 
     ARCH_REG2(UWord16, cantcr,  tier); 
     ARCH_REG2(UWord16, cantarq, tarq); 
     ARCH_REG2(UWord16, cantaak, taak); 
     ARCH_REG2(UWord16, cantbsel, bsel); 
     ARCH_REG2(UWord16, canidac, idac); 
     ARCH_REG1(UWord16, reserved1);
     ARCH_REG2(UWord16, canmisc, misc);
     ARCH_REG2(UWord16, canrxerr, rxerr); 
     ARCH_REG2(UWord16, cantxerr, txerr); 
     ARCH_REG2(UWord16, canidar0, idar0);
     ARCH_REG2(UWord16, canidar1, idar1);
     ARCH_REG2(UWord16, canidar2, idar2);
     ARCH_REG2(UWord16, canidar3, idar3);
     ARCH_REG2(UWord16, canidmr0, idmr0);
     ARCH_REG2(UWord16, canidmr1, idmr1);
     ARCH_REG2(UWord16, canidmr2, idmr2);
     ARCH_REG2(UWord16, canidmr3, idmr3);
     ARCH_REG2(UWord16, canidar4, idar4);
     ARCH_REG2(UWord16, canidar5, idar5);
     ARCH_REG2(UWord16, canidar6, idar6);
     ARCH_REG2(UWord16, canidar7, idar7);
     ARCH_REG2(UWord16, canidmr4, idmr4);
     ARCH_REG2(UWord16, canidmr5, idmr5);
     ARCH_REG2(UWord16, canidmr6, idmr6);
     ARCH_REG2(UWord16, canidmr7, idmr7);

     arch_sMSCAN_MB canrb;
     arch_sMSCAN_MB cantb;

     ARCH_REG1(UWord16, reserved2[192]);
         
} arch_sMSCAN;

/* Crossbar switch */

#define XBAR_VERSION 1
#define XBAR_VERSION_1

typedef volatile struct {
    ARCH_REG2(UWord16, xb_xbc0, xbc0);
    ARCH_REG2(UWord16, xb_xbc1, xbc1);
    ARCH_REG2(UWord16, xb_xbc2, xbc2);
    ARCH_REG2(UWord16, xb_xbc3, xbc3);
    ARCH_REG2(UWord16, xb_xbc4, xbc4);
    ARCH_REG2(UWord16, xb_xbc5, xbc5);
    ARCH_REG2(UWord16, xb_xbc6, xbc6);
    ARCH_REG2(UWord16, xb_xbc7, xbc7);
    ARCH_REG2(UWord16, xb_xbc8, xbc8);
    ARCH_REG2(UWord16, xb_xbc9, xbc9);
    ARCH_REG2(UWord16, xb_xbc10, xbc10);
    ARCH_REG2(UWord16, xb_xbc11, xbc11);
    ARCH_REG2(UWord16, xb_xbc12, xbc12);
    ARCH_REG2(UWord16, xb_xbc13, xbc13);
    ARCH_REG2(UWord16, xb_xbc14, xbc14);
    ARCH_REG1(UWord16, reserved1);
    
} arch_sXBAR;

/* CRC generator */

#define CRC_VERSION 1
#define CRC_VERSION_1

typedef volatile struct {
    ARCH_REG2(UWord16, crc_crch, crch);
    ARCH_REG2(UWord16, crc_crcl, crcl);
    ARCH_REG2(UWord16, crc_transponse, transponse);
    ARCH_REG1(UWord16, reserved1[13]);
    
} arch_sCRC;

/* VREF module */

#define VREF_VERSION 1
#define VREF_VERSION_1

typedef volatile struct {
    ARCH_REG2(UWord16, vref_dacctrl,dacctrl);
    ARCH_REG1(UWord16, reserved1[15]);
    
} arch_sVREF;


/* EOnCE Module */

typedef volatile struct {

    ARCH_REG1(UWord16, reserved1[0xfd]);
    ARCH_REG2(UWord16, otxrxsr, TxRxStatusControlReg);
    ARCH_REG3(UWord32, orx, otx, RxTxReg);

} arch_sEOnCE;

/* peripheral space base addresses */

#define TMRA_BASE    0xF000
#define TMRB_BASE    0xF040
#define ADC_BASE     0xF080
#define INTC_BASE    0xF0C0
#define SIM_BASE     0xF0E0
#define XBAR_BASE    0xF100
#define COP_BASE     0xF110
#define PLL_BASE     0xF120
#define LVI_BASE     0xF130
#define GPIO_A_BASE  0xF140
#define GPIO_B_BASE  0xF150
#define GPIO_C_BASE  0xF160
#define GPIO_D_BASE  0xF170
#define GPIO_E_BASE  0xF180
#define GPIO_F_BASE  0xF190
#define DAC_BASE     0xF1A0
#define HSCMPA_BASE  0xF1B0
#define HSCMPB_BASE  0xF1C0
#define HSCMPC_BASE  0xF1D0
#define SCI0_BASE    0xF1E0
#define SCI1_BASE    0xF1F0
#define SPI_BASE     0xF200
#define IIC0_BASE    0xF210
#define IIC1_BASE    0xF220
#define CRC_BASE     0xF230
#define VREFA_BASE   0xF240
#define VREFB_BASE   0xF250
#define VREFC_BASE   0xF260
#define EFPWM_BASE   0xF300
#define HFM_BASE     0xF400
#define CAN_BASE     0xF440

#define EONCE_BASE   0xFFFF00

/* complete periphiperal space described by single structure */

typedef volatile struct
{
    arch_sTimer    TimerA;         /* TMRA_BASE    0xF000 */
    arch_sTimer    TimerB;         /* TMRB_BASE    0xF040 */
    arch_sADC      Adc;            /* ADC_BASE     0xF080 */
    arch_sIntc     Intc;           /* INTC_BASE    0xF0C0 */
    arch_sSIM      Sim;            /* SIM_BASE     0xF0E0 */
    arch_sXBAR     Xbar;           /* XBAR_BASE    0xF110 */
    arch_sCOP      Cop;            /* COP_BASE     0xF110 */
    arch_sPLL      Pll;            /* PLL_BASE     0xF120 */
    arch_sLVI      Lvi;            /* LVI_BASE     0xF130 */
    arch_sPort     PortA;          /* GPIO_A_BASE  0xF140 */
    arch_sPort     PortB;          /* GPIO_B_BASE  0xF150 */
    arch_sPort     PortC;          /* GPIO_C_BASE  0xF160 */
    arch_sPort     PortD;          /* GPIO_D_BASE  0xF170 */
    arch_sPort     PortE;          /* GPIO_E_BASE  0xF180 */
    arch_sPort     PortF;          /* GPIO_F_BASE  0xF190 */
    arch_sDAC      Dac;            /* DAC_BASE     0xF1A0 */
    arch_sHSCMP    HscmpA;         /* HSCMPA_BASE  0xF1B0 */
    arch_sHSCMP    HscmpB;         /* HSCMPB_BASE  0xF1C0 */
    arch_sHSCMP    HscmpC;         /* HSCMPC_BASE  0xF1D0 */
    arch_sSCI      Sci0;           /* SCI0_BASE    0xF1E0 */
    arch_sSCI      Sci1;           /* SCI1_BASE    0xF1F0 */
    arch_sSPI      Spi;            /* SPI_BASE     0xF200 */
    arch_sIIC      Iic0;           /* IIC0_BASE    0xF210 */
    arch_sIIC      Iic1;           /* IIC1_BASE    0xF220 */
    arch_sCRC      Crc;            /* CRC_BASE     0xF230 */
    arch_sVREF     VrefA;          /* VREFA_BASE   0xF240 */
    arch_sVREF     VrefB;          /* VREFB_BASE   0xF250 */
    arch_sVREF     VrefC;          /* VREFC_BASE   0xF260 */
    UWord16        reserved1[0x90];
    arch_sEFPWM    Efpwm;          /* EFPWM_BASE   0xF300 */
    UWord16        reserved2[0x37];
    arch_sHFM      Hfm;            /* HFM_BASE     0xF400 */
    arch_sMSCAN    MSCan;          /* CAN_BASE     0xF440 */  
    UWord16        reserved4[0xFF09C0];
    arch_sEOnCE    EOnCE;          /* EOnCE_BASE   0xFFFF00 */ 
    
} arch_sIO;

/* The location of the following structure is defined in linker.cmd */
extern arch_sIO    ArchIO;

/* you can try to use direct address access too */
//#define ArchIO (*(volatile arch_sIO*) 0xf000)

#endif

