/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* File Name:  xbar.h
*
* $Date:      Oct-12-2010$
*
* $Version:   2.5.5.0$
*
* Description: Header file for the XBAR driver
*
* This file supports different hardware versions of the module. A version
* of module used in your project is defined in the "arch.h" processor 
* architecture definition file.
*
*  XBAR_VERSION_1 .. 56F82xx devices, see MC56F82xxRM.pdf
*
*******************************************************************************/

#ifndef __XBAR_H
#define __XBAR_H

/* qs.h is a master header file, which must be included */
#if !defined(__ARCH_H) || !defined(__PERIPH_H) || !defined(__APPCONFIG_H)
#error Please include qs.h before xbar.h
#endif

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************
*
*                      General Interface Description
*
* The CrossBar Switch module (XBAR) implements an array of 30 outputs and 22 
* inputs of combination digital multiplexes. All 30 multiplexes share the same 
* 22 inputs in same order. All XBAR registers can by write prodected by SYS module.
*
******************************************************************************/

/************************************************************
* XBAR module identifiers, correspond to module base address
*************************************************************/

#ifdef XBAR_BASE
#define XBAR    (&ArchIO.Xbar)
#endif

/*************************************************************
* arch.h should define device-specific information about XBAR
**************************************************************/

#if !defined(XBAR_VERSION)
#error XBAR not properly described in arch.h (old Quick_Start version?)
#endif

/****************************************************
* Configurable items, i.e. defines, for appconfig.h
*****************************************************

  #define  XBAR_XBC0_INIT     0x0000 
  #define  XBAR_XBC1_INIT     0x0000
  #define  XBAR_XBC2_INIT     0x0000
  #define  XBAR_XBC3_INIT     0x0000
  #define  XBAR_XBC4_INIT     0x0000
  #define  XBAR_XBC5_INIT     0x0000
  #define  XBAR_XBC6_INIT     0x0000
  #define  XBAR_XBC7_INIT     0x0000
  #define  XBAR_XBC8_INIT     0x0000
  #define  XBAR_XBC9_INIT     0x0000
  #define  XBAR_XBC10_INIT    0x0000
  #define  XBAR_XBC11_INIT    0x0000
  #define  XBAR_XBC12_INIT    0x0000
  #define  XBAR_XBC13_INIT    0x0000
  #define  XBAR_XBC14_INIT    0x0000

*/

/*****************************************************************
* Single-Instruction  ioctl() commands
*
*  Word16 ioctl( XBAR_module_identifier, Command_name, Parameter );
*
******************************************************************

        COMMAND NAME                      PARAMETERS, COMMENTS
------------------------------------------------------------------ */
#define XBAR_WRITE_CROSSBAR_REG_0  /* UWord16, writes in to Crossbar Control Register 0 (XBC0) */
#define XBAR_WRITE_CROSSBAR_REG_1  /* UWord16, writes in to Crossbar Control Register 0 (XBC1) */
#define XBAR_WRITE_CROSSBAR_REG_2  /* UWord16, writes in to Crossbar Control Register 0 (XBC2) */
#define XBAR_WRITE_CROSSBAR_REG_3  /* UWord16, writes in to Crossbar Control Register 0 (XBC3) */
#define XBAR_WRITE_CROSSBAR_REG_4  /* UWord16, writes in to Crossbar Control Register 0 (XBC4) */
#define XBAR_WRITE_CROSSBAR_REG_5  /* UWord16, writes in to Crossbar Control Register 0 (XBC5) */
#define XBAR_WRITE_CROSSBAR_REG_6  /* UWord16, writes in to Crossbar Control Register 0 (XBC6) */
#define XBAR_WRITE_CROSSBAR_REG_7  /* UWord16, writes in to Crossbar Control Register 0 (XBC7) */
#define XBAR_WRITE_CROSSBAR_REG_8  /* UWord16, writes in to Crossbar Control Register 0 (XBC8) */
#define XBAR_WRITE_CROSSBAR_REG_9  /* UWord16, writes in to Crossbar Control Register 0 (XBC9) */
#define XBAR_WRITE_CROSSBAR_REG_10 /* UWord16, writes in to Crossbar Control Register 0 (XBC10) */
#define XBAR_WRITE_CROSSBAR_REG_11 /* UWord16, writes in to Crossbar Control Register 0 (XBC11) */
#define XBAR_WRITE_CROSSBAR_REG_12 /* UWord16, writes in to Crossbar Control Register 0 (XBC12) */
#define XBAR_WRITE_CROSSBAR_REG_13 /* UWord16, writes in to Crossbar Control Register 0 (XBC13) */
#define XBAR_WRITE_CROSSBAR_REG_14 /* UWord16, writes in to Crossbar Control Register 0 (XBC14) */

#define XBAR_READ_CROSSBAR_REG_0  /* NULL, returns UWord16, value of the Crossbar Control Register 0  (XBC0) */
#define XBAR_READ_CROSSBAR_REG_1  /* NULL, returns UWord16, value of the Crossbar Control Register 1  (XBC1) */
#define XBAR_READ_CROSSBAR_REG_2  /* NULL, returns UWord16, value of the Crossbar Control Register 2  (XBC2) */
#define XBAR_READ_CROSSBAR_REG_3  /* NULL, returns UWord16, value of the Crossbar Control Register 3  (XBC3) */
#define XBAR_READ_CROSSBAR_REG_4  /* NULL, returns UWord16, value of the Crossbar Control Register 4  (XBC4) */
#define XBAR_READ_CROSSBAR_REG_5  /* NULL, returns UWord16, value of the Crossbar Control Register 5  (XBC5) */
#define XBAR_READ_CROSSBAR_REG_6  /* NULL, returns UWord16, value of the Crossbar Control Register 6  (XBC6) */
#define XBAR_READ_CROSSBAR_REG_7  /* NULL, returns UWord16, value of the Crossbar Control Register 7  (XBC7) */
#define XBAR_READ_CROSSBAR_REG_8  /* NULL, returns UWord16, value of the Crossbar Control Register 8  (XBC8) */
#define XBAR_READ_CROSSBAR_REG_9  /* NULL, returns UWord16, value of the Crossbar Control Register 9  (XBC9) */
#define XBAR_READ_CROSSBAR_REG_10 /* NULL, returns UWord16, value of the Crossbar Control Register 10 (XBC10)*/
#define XBAR_READ_CROSSBAR_REG_11 /* NULL, returns UWord16, value of the Crossbar Control Register 11 (XBC11)*/
#define XBAR_READ_CROSSBAR_REG_12 /* NULL, returns UWord16, value of the Crossbar Control Register 12 (XBC12)*/
#define XBAR_READ_CROSSBAR_REG_13 /* NULL, returns UWord16, value of the Crossbar Control Register 13 (XBC13)*/
#define XBAR_READ_CROSSBAR_REG_14 /* NULL, returns UWord16, value of the Crossbar Control Register 14 (XBC14)*/


/*****************************************************************
* Multi-Instruction ioctl() commands
*
*  Word16 ioctl( XBAR_module_identifier, Command_name, Parameter );
*
******************************************************************

        COMMAND NAME                      PARAMETERS, COMMENTS
------------------------------------------------------------------ */
#define XBAR_SET_OUT_GPIO_C_14      /* XBAR_INPUT_xxx (LOGIC_0/LOGIC_1/GPIO_C_2/GPIO_E_4/GPIO_C_6/GPIO_E_5/GPIO_C_9/
                                                       GPIO_E_6/GPIO_C_10/GPIO_E_7/GPIO_C_13/GPIO_F_0/GPIO_F_1/CMPA_OUT/
													   CMPB_OUT/CMPC_OUT/QT_B0_OUT/QT_B1_OUT/QT_B2_OUT/QT_B3_OUT/
													   PWM0_TRIG_COMB/PWM1_TRIG_COMB/PWM2_TRIG_COMB/PWM012_TRIG_COMB/
													   PWM3_TRIG0/PWM3_TRIG1)
													   sets XBAR_OUT0 input (XBC0->CODE0) */
#define XBAR_SET_OUT_GPIO_C_15      /* XBAR_INPUT_xxx, sets XBAR_OUT1 input (XBC0->CODE1) */
#define XBAR_SET_OUT_GPIO_F_2       /* XBAR_INPUT_xxx, sets XBAR_OUT2 input (XBC1->CODE2) */
#define XBAR_SET_OUT_GPIO_F_3       /* XBAR_INPUT_xxx, sets XBAR_OUT3 input (XBC1->CODE3) */
#define XBAR_SET_OUT_GPIO_F_4       /* XBAR_INPUT_xxx, sets XBAR_OUT4 input (XBC2->CODE4) */
#define XBAR_SET_OUT_GPIO_F_5       /* XBAR_INPUT_xxx, sets XBAR_OUT5 input (XBC2->CODE5) */
#define XBAR_SET_OUT_ADCA_TRIGGER   /* XBAR_INPUT_xxx, sets XBAR_OUT6 input (XBC3->CODE6) */
#define XBAR_SET_OUT_ADCB_TRIGGER   /* XBAR_INPUT_xxx, sets XBAR_OUT7 input (XBC3->CODE7) */
#define XBAR_SET_OUT_DAC_SYNC       /* XBAR_INPUT_xxx, sets XBAR_OUT8 input (XBC4->CODE8) */
#define XBAR_SET_OUT_CMPA_SAMPLE    /* XBAR_INPUT_xxx, sets XBAR_OUT9 input (XBC4->CODE9) */
#define XBAR_SET_OUT_CMPB_SAMPLE    /* XBAR_INPUT_xxx, sets XBAR_OUT10 input (XBC5->CODE10) */
#define XBAR_SET_OUT_CMPC_SAMPLE    /* XBAR_INPUT_xxx, sets XBAR_OUT11 input (XBC5->CODE11) */
#define XBAR_SET_OUT_PWM0_EXTA      /* XBAR_INPUT_xxx, sets XBAR_OUT12 input (XBC6->CODE12) */
#define XBAR_SET_OUT_PWM1_EXTA      /* XBAR_INPUT_xxx, sets XBAR_OUT13 input (XBC6->CODE13) */
#define XBAR_SET_OUT_PWM2_EXTA      /* XBAR_INPUT_xxx, sets XBAR_OUT14 input (XBC7->CODE14) */
#define XBAR_SET_OUT_PWM3_EXTA      /* XBAR_INPUT_xxx, sets XBAR_OUT15 input (XBC7->CODE15) */
#define XBAR_SET_OUT_PWM0_EXT_SYNC  /* XBAR_INPUT_xxx, sets XBAR_OUT16 input (XBC8->CODE16) */
#define XBAR_SET_OUT_PWM1_EXT_SYNC  /* XBAR_INPUT_xxx, sets XBAR_OUT17 input (XBC8->CODE17) */
#define XBAR_SET_OUT_PWM2_EXT_SYNC  /* XBAR_INPUT_xxx, sets XBAR_OUT18 input (XBC9->CODE18) */
#define XBAR_SET_OUT_PWM3_EXT_SYNC  /* XBAR_INPUT_xxx, sets XBAR_OUT19 input (XBC9->CODE19) */
#define XBAR_SET_OUT_PWM_EXT_CLK    /* XBAR_INPUT_xxx, sets XBAR_OUT20 input (XBC10->CODE20) */
#define XBAR_SET_OUT_PWM_FAULT0     /* XBAR_INPUT_xxx, sets XBAR_OUT21 input (XBC10->CODE21) */
#define XBAR_SET_OUT_PWM_FAULT1     /* XBAR_INPUT_xxx, sets XBAR_OUT22 input (XBC11->CODE22) */
#define XBAR_SET_OUT_PWM_FAULT2     /* XBAR_INPUT_xxx, sets XBAR_OUT23 input (XBC11->CODE23) */
#define XBAR_SET_OUT_PWM_FAULT3     /* XBAR_INPUT_xxx, sets XBAR_OUT24 input (XBC12->CODE24) */
#define XBAR_SET_OUT_PWM_FORCE      /* XBAR_INPUT_xxx, sets XBAR_OUT25 input (XBC12->CODE25) */
#define XBAR_SET_OUT_QT_B0          /* XBAR_INPUT_xxx, sets XBAR_OUT26 input (XBC13->CODE26) */
#define XBAR_SET_OUT_QT_B1          /* XBAR_INPUT_xxx, sets XBAR_OUT27 input (XBC13->CODE27) */
#define XBAR_SET_OUT_QT_B2          /* XBAR_INPUT_xxx, sets XBAR_OUT28 input (XBC14->CODE28) */
#define XBAR_SET_OUT_QT_B3          /* XBAR_INPUT_xxx, sets XBAR_OUT29 input (XBC14->CODE29) */


/*****************************************************************
* Software Layer ioctl() commands
*
*  Word16 ioctl( XBAR_module_identifier, Command_name, Parameter );
*
******************************************************************

 COMMAND NAME                         PARAMETERS, COMMENTS
----------------------------------------------------------------*/
#define XBAR_INIT                          /* NULL */



/****************************************************************************
* XBAR constants and type declarations use in the ioctl functions
*****************************************************************************/

#define XBAR_INPUT_LOGIC_0          0x00
#define XBAR_INPUT_LOGIC_1          0x01
#define XBAR_INPUT_GPIO_C_2         0x02
#define XBAR_INPUT_GPIO_E_4         0x02
#define XBAR_INPUT_GPIO_C_6         0x03
#define XBAR_INPUT_GPIO_E_5         0x03
#define XBAR_INPUT_GPIO_C_9         0x04
#define XBAR_INPUT_GPIO_E_6         0x04
#define XBAR_INPUT_GPIO_C_10        0x05
#define XBAR_INPUT_GPIO_E_7         0x05
#define XBAR_INPUT_GPIO_C_13        0x06
#define XBAR_INPUT_GPIO_F_0         0x06
#define XBAR_INPUT_GPIO_C_5         0x07
#define XBAR_INPUT_GPIO_F_1         0x07
#define XBAR_INPUT_CMPA_OUT         0x09
#define XBAR_INPUT_CMPB_OUT         0x0A
#define XBAR_INPUT_CMPC_OUT         0x0B
#define XBAR_INPUT_QT_B0_OUT        0x0C
#define XBAR_INPUT_QT_B1_OUT        0x0D
#define XBAR_INPUT_QT_B2_OUT        0x0E
#define XBAR_INPUT_QT_B3_OUT        0x0F
#define XBAR_INPUT_PWM0_TRIG_COMB   0x10
#define XBAR_INPUT_PWM1_TRIG_COMB   0x11
#define XBAR_INPUT_PWM2_TRIG_COMB   0x12
#define XBAR_INPUT_PWM012_TRIG_COMB 0x13
#define XBAR_INPUT_PWM3_TRIG0       0x14
#define XBAR_INPUT_PWM3_TRIG1       0x15

                               
/*****************************************************************
* XBAR Register Bits Defines, used in ioct command implementation
******************************************************************/
                               
/* XBAR Crossbar Control Register */
#define XBAR_XBCX_CODE1_MASK   0x1f00   /* Crossbar odd mask */  
#define XBAR_XBCX_CODE0_MASK   0x001f   /* Crossbar even mask */
                               
/***********************************************************************
* XBAR init                    
***********************************************************************/

void xbarInit(arch_sXBAR *pXbarBase);
#define ioctlXBAR_INIT(pXbarBase, param) xbarInit(pXbarBase)

/* Crossbar Control Register 0 */
#define ioctlXBAR_SET_OUT_GPIO_C_14(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc0))

#define ioctlXBAR_SET_OUT_GPIO_C_15(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc0))

/* Crossbar Control Register 1 */
#define ioctlXBAR_SET_OUT_GPIO_F_2(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc1))

#define ioctlXBAR_SET_OUT_GPIO_F_3(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc1))

/* Crossbar Control Register 2 */
#define ioctlXBAR_SET_OUT_GPIO_F_4(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc2))

#define ioctlXBAR_SET_OUT_GPIO_F_5(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc2))

/* Crossbar Control Register 3 */
#define ioctlXBAR_SET_OUT_ADCA_TRIGGER(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc3))

#define ioctlXBAR_SET_OUT_ADCB_TRIGGER(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc3))

/* Crossbar Control Register 4 */
#define ioctlXBAR_SET_OUT_DAC_SYNC(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc4))

#define ioctlXBAR_SET_OUT_CMPA_SAMPLE(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc4))

/* Crossbar Control Register 5 */
#define ioctlXBAR_SET_OUT_CMPB_SAMPLE(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc5))

#define ioctlXBAR_SET_OUT_CMPC_SAMPLE(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc5))

/* Crossbar Control Register 6 */
#define ioctlXBAR_SET_OUT_PWM0_EXTA(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc6))

#define ioctlXBAR_SET_OUT_PWM1_EXTA(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc6))

/* Crossbar Control Register 7 */
#define ioctlXBAR_SET_OUT_PWM2_EXTA(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc7))

#define ioctlXBAR_SET_OUT_PWM3_EXTA(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc7))

/* Crossbar Control Register 8 */
#define ioctlXBAR_SET_OUT_PWM0_EXT_SYNC(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc8))

#define ioctlXBAR_SET_OUT_PWM1_EXT_SYNC(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc8))

/* Crossbar Control Register 9 */
#define ioctlXBAR_SET_OUT_PWM2_EXT_SYNC(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc9))

#define ioctlXBAR_SET_OUT_PWM3_EXT_SYNC(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc9))

/* Crossbar Control Register 10 */
#define ioctlXBAR_SET_OUT_PWM_EXT_CLK(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc10))

#define ioctlXBAR_SET_OUT_PWM_FAULT0(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc10))

/* Crossbar Control Register 11 */
#define ioctlXBAR_SET_OUT_PWM_FAULT1(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc11))

#define ioctlXBAR_SET_OUT_PWM_FAULT2(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc11))

/* Crossbar Control Register 12 */
#define ioctlXBAR_SET_OUT_PWM_FAULT3(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc12))

#define ioctlXBAR_SET_OUT_PWM_FORCE(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc12))

/* Crossbar Control Register 13 */
#define ioctlXBAR_SET_OUT_QT_B0(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc13))

#define ioctlXBAR_SET_OUT_QT_B1(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc13))

/* Crossbar Control Register 14 */
#define ioctlXBAR_SET_OUT_QT_B2(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE0_MASK, param, &((pXbarBase)->xbc14))

#define ioctlXBAR_SET_OUT_QT_B3(pXbarBase, param) \
  periphBitGrpSet(XBAR_XBCX_CODE1_MASK, ((param) << 8), &((pXbarBase)->xbc14))

/* writes data in to Xbar control registers */
#define ioctlXBAR_WRITE_CROSSBARR_REG_0(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc0))

#define ioctlXBAR_WRITE_CROSSBARR_REG_1(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc1))

#define ioctlXBAR_WRITE_CROSSBARR_REG_2(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc2))

#define ioctlXBAR_WRITE_CROSSBARR_REG_3(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc3))

#define ioctlXBAR_WRITE_CROSSBARR_REG_4(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc4))

#define ioctlXBAR_WRITE_CROSSBARR_REG_5(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc5))

#define ioctlXBAR_WRITE_CROSSBARR_REG_6(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc6))

#define ioctlXBAR_WRITE_CROSSBARR_REG_7(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc7))

#define ioctlXBAR_WRITE_CROSSBARR_REG_8(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc8))

#define ioctlXBAR_WRITE_CROSSBARR_REG_9(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc9))

#define ioctlXBAR_WRITE_CROSSBARR_REG_10(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc10))

#define ioctlXBAR_WRITE_CROSSBARR_REG_11(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc11))

#define ioctlXBAR_WRITE_CROSSBARR_REG_12(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc12))

#define ioctlXBAR_WRITE_CROSSBARR_REG_13(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc13))

#define ioctlXBAR_WRITE_CROSSBARR_REG_14(pXbarBase, param) \
  periphMemWrite(param, &((pXbarBase)->xbc14))

/* reads data from Xbar control registers */
#define ioctlXBAR_READ_CROSSBARR_REG_0(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc0))

#define ioctlXBAR_READ_CROSSBARR_REG_1(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc1))

#define ioctlXBAR_READ_CROSSBARR_REG_2(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc2))

#define ioctlXBAR_READ_CROSSBARR_REG_3(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc3))

#define ioctlXBAR_READ_CROSSBARR_REG_4(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc4))

#define ioctlXBAR_READ_CROSSBARR_REG_5(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc5))

#define ioctlXBAR_READ_CROSSBARR_REG_6(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc6))

#define ioctlXBAR_READ_CROSSBARR_REG_7(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc7))

#define ioctlXBAR_READ_CROSSBARR_REG_8(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc8))

#define ioctlXBAR_READ_CROSSBARR_REG_9(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc9))

#define ioctlXBAR_READ_CROSSBARR_REG_10(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc10))

#define ioctlXBAR_READ_CROSSBARR_REG_11(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc11))

#define ioctlXBAR_READ_CROSSBARR_REG_12(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc12))

#define ioctlXBAR_READ_CROSSBARR_REG_13(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc13))

#define ioctlXBAR_READ_CROSSBARR_REG_14(pXbarBase, param) \
  periphMemRead(&((pXbarBase)->xbc14))

  
#ifdef __cplusplus
}
#endif

#endif
