/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* File Name:  rtc_8xxx.h
*
* $Date:      Oct-12-2010$
*
* $Version:   2.5.9.0$
*
* Description: Header file for the VREF low-level driver
*
*  VREF_VERSION_1 .. 56F82xx devices, see MC56F82xxRM.pdf
*
*****************************************************************************/

#ifndef __VREF_H
#define __VREF_H

/* qs.h is a master header file, which must be included */
#if !defined(__ARCH_H) || !defined(__PERIPH_H) || !defined(__APPCONFIG_H)
#error Please include qs.h before vref.h
#endif

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************
*
*                      General Interface Description
*
* The VREF device driver interface uses "ioctl" call to control specific VREF functions
* during operation. For details see "ioctl" call.
*
******************************************************************************/

/************************************************************
* VREF module identifiers
*************************************************************/

#ifdef VREFA_BASE
#define VREF_A     (&ArchIO.VrefA)
#endif

#ifdef VREFB_BASE
#define VREF_B     (&ArchIO.VrefB)
#endif

#ifdef VREFC_BASE
#define VREF_C     (&ArchIO.VrefC)
#endif


/*************************************************************
* arch.h should define device-specific information about VREF
**************************************************************/

#if !defined(VREF_VERSION)
#error VREF module is not properly described in arch.h (old Quick_Start version?)
#endif

/**************************************************************
* Configuration items for appconfig.h (init values, ...),
**************************************************************/

/* Configuration items for appconfig.h  *

    VREF_x_DACCTRL_INIT        // Control Register
    
*/

/*****************************************************************
* Single-Instruction  ioctl() commands
*
*  Word16 ioctl( VREF_module_identifier, Command_name, Parameter );
*
******************************************************************

        COMMAND NAME                      PARAMETERS, COMMENTS
------------------------------------------------------------------ */
/* DACCTRL */
#define VREF_SET_DEVICE                 /* VREF_ENABLE/VREF_DISABLE, enables / disables VREF module (DACCTRL->DACEN) */

#define VREF_WRITE_CONTROL_REG          /* 16 bit value (DACCTRL) */
#define VREF_READ_CONTROL_REG           /* NULL, return modulo register value (DACCTRL)  */



/*****************************************************************
* Multi-Instruction ioctl() commands
*
*  Word16 ioctl( VREF_module_identifier, Command_name, Parameter );
*
******************************************************************

        COMMAND NAME                      PARAMETERS, COMMENTS
------------------------------------------------------------------ */
/* DACCTRL */
#define VREF_SET_OUTPUT_LEVEL           /* UWord16 value (0-31) or one of predefined macros:
										   VREF_LEVEL_3_1\VREF_LEVEL_6_3\VREF_LEVEL_9_4\VREF_LEVEL_12_5\VREF_LEVEL_15_6\
										   VREF_LEVEL_18_8\VREF_LEVEL_21_9\VREF_LEVEL_25_0\VREF_LEVEL_28_1\VREF_LEVEL_31_3\
										   VREF_LEVEL_34_4\VREF_LEVEL_37_5\VREF_LEVEL_40_6\VREF_LEVEL_43_8\VREF_LEVEL_46_9\
										   VREF_LEVEL_50_0\VREF_LEVEL_53_1\VREF_LEVEL_56_3\VREF_LEVEL_59_4\VREF_LEVEL_62_5\
										   VREF_LEVEL_65_6\VREF_LEVEL_68_8\VREF_LEVEL_71_9\VREF_LEVEL_75_0\VREF_LEVEL_78_1\
										   VREF_LEVEL_81_3\VREF_LEVEL_84_4\VREF_LEVEL_87_5\VREF_LEVEL_90_6\VREF_LEVEL_93_8\
										   VREF_LEVEL_96_9\VREF_LEVEL_100_0\
										   , Sets reference output level (DACCTRL->VOSEL) */



/*****************************************************************
* Software Layer ioctl() commands
*
*  Word16 ioctl( VREF_module_identifier, Command_name, Parameter );
*
******************************************************************

 COMMAND NAME                         PARAMETERS, COMMENTS
----------------------------------------------------------------*/
#define VREF_INIT                       /* NULL */



/****************************************************************************
* VREF command parameters
*****************************************************************************/

#define VREF_ENABLE         1
#define VREF_DISABLE        0

#define VREF_LEVEL_3_1		0	//Sets Output level to 3.1% of the reference voltage 
#define VREF_LEVEL_6_3		1	//Sets Output level to 6.3% of the reference voltage 
#define VREF_LEVEL_9_4		2	//Sets Output level to 9.4% of the reference voltage 
#define VREF_LEVEL_12_5		3	//Sets Output level to 12.5% of the reference voltage 
#define VREF_LEVEL_15_6		4	//Sets Output level to 15.6% of the reference voltage 
#define VREF_LEVEL_18_8		5	//Sets Output level to 18.8% of the reference voltage 
#define VREF_LEVEL_21_9		6	//Sets Output level to 21.9% of the reference voltage 
#define VREF_LEVEL_25_0		7	//Sets Output level to 25.0% of the reference voltage 
#define VREF_LEVEL_28_1		8	//Sets Output level to 28.1% of the reference voltage 
#define VREF_LEVEL_31_3		9	//Sets Output level to 31.3% of the reference voltage 
#define VREF_LEVEL_34_4		10	//Sets Output level to 34.4% of the reference voltage 
#define VREF_LEVEL_37_5		11	//Sets Output level to 37.5% of the reference voltage 
#define VREF_LEVEL_40_6		12	//Sets Output level to 40.6% of the reference voltage 
#define VREF_LEVEL_43_8		13	//Sets Output level to 43.8% of the reference voltage 
#define VREF_LEVEL_46_9		14	//Sets Output level to 46.9% of the reference voltage 
#define VREF_LEVEL_50_0		15	//Sets Output level to 50.0% of the reference voltage 
#define VREF_LEVEL_53_1		16	//Sets Output level to 53.1% of the reference voltage 
#define VREF_LEVEL_56_3		17	//Sets Output level to 56.3% of the reference voltage 
#define VREF_LEVEL_59_4		18	//Sets Output level to 59.4% of the reference voltage 
#define VREF_LEVEL_62_5		19	//Sets Output level to 62.5% of the reference voltage 
#define VREF_LEVEL_65_6		20	//Sets Output level to 65.6% of the reference voltage 
#define VREF_LEVEL_68_8		21	//Sets Output level to 68.8% of the reference voltage 
#define VREF_LEVEL_71_9		22	//Sets Output level to 71.9% of the reference voltage 
#define VREF_LEVEL_75_0		23	//Sets Output level to 75.0% of the reference voltage 
#define VREF_LEVEL_78_1		24	//Sets Output level to 78.1% of the reference voltage 
#define VREF_LEVEL_81_3		25	//Sets Output level to 81.3% of the reference voltage 
#define VREF_LEVEL_84_4		26	//Sets Output level to 84.4% of the reference voltage 
#define VREF_LEVEL_87_5		27	//Sets Output level to 87.5% of the reference voltage 
#define VREF_LEVEL_90_6		28	//Sets Output level to 90.6% of the reference voltage 
#define VREF_LEVEL_93_8		29	//Sets Output level to 93.8% of the reference voltage 
#define VREF_LEVEL_96_9		30	//Sets Output level to 96.9% of the reference voltage 
#define VREF_LEVEL_100_0	31	//Sets Output level to 100.0% of the reference voltage 



/****************************************************************************
* register and bit names used in the ioctl functions below
*****************************************************************************/

/* control register (DACCTRL) */
#define VREF_DACCTRL_VOSEL_MASK         0x001F
#define VREF_DACCTRL_DACEN              0x0080

/***********************************************************************
* VREF init
***********************************************************************/

void vrefInit(arch_sVREF *pVrefBase);
#define ioctlVREF_INIT(pVrefBase, param) vrefInit(pVrefBase)

/***********************************************************************
* VREF Control Register
***********************************************************************/

/* DACCTRL */
/* Enables/ disables VREF module */
#define ioctlVREF_SET_DEVICE(pVrefBase, param) \
  if (param) periphBitSet(VREF_DACCTRL_DACEN, &((pVrefBase)->dacctrl)); \
  else periphBitClear(VREF_DACCTRL_DACEN, &((pVrefBase)->dacctrl))

/* Sets voltage output level */
#define ioctlVREF_SET_OUTPUT_LEVEL(pVrefBase, param)        \
  periphBitGrpSet( VREF_DACCTRL_VOSEL_MASK, param, &((pVrefBase)->dacctrl))

/* writes in to control register */
#define ioctlVREF_WRITE_CONTROL_REG(pVrefBase, param) \
    periphMemWrite(param, &((pVrefBase)->dacctrl))

/* reads and returns contriol register */
#define ioctlVREF_READ_CONTROL_REG(pVrefBase, param) \
    periphMemRead(&((pVrefBase)->dacctrl))

#ifdef __cplusplus
}
#endif

#endif
