/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* $File Name: vref_8xxx.c$
*
* $Date:      Oct-12-2010$
*
* $Version:   2.5.4.0$
*
* Description: Source file for the VREF Driver
*
*****************************************************************************/

#include "qs.h"
#include "vref.h"
#include "initconfig.h"

#ifdef __cplusplus
extern "C" {
#endif

/* initialization of VREF  */

void vrefInit(arch_sVREF *pVrefBase)
{
#pragma unused(pVrefBase)

#if VREF_A_INIT_USED && defined(VREF_A)
	if (pVrefBase == VREF_A)
	{
		#ifdef VREF_A_DACCTRL_INIT
		periphMemWrite(VREF_A_DACCTRL_INIT, &pVrefBase->dacctrl);
		#endif
	}
	else
#endif	

#if VREF_B_INIT_USED && defined(VREF_B)
	if (pVrefBase == VREF_B)
	{
		#ifdef VREF_B_DACCTRL_INIT
		periphMemWrite(VREF_B_DACCTRL_INIT, &pVrefBase->dacctrl);
		#endif
	}
	else
#endif	

#if VREF_C_INIT_USED && defined(VREF_C)
	if (pVrefBase == VREF_C)
	{
		#ifdef VREF_C_DACCTRL_INIT
		periphMemWrite(VREF_C_DACCTRL_INIT, &pVrefBase->dacctrl);
		#endif
	}
	else
#endif	

	; /* last else case */
}

#ifdef __cplusplus
}
#endif
