/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* $File Name: pwm_82xx.c$
*
* $Date:      Oct-12-2010$
*
* $Version:   2.5.14.0$
*
* Description: Source file for the  EFPWM driver
*
*****************************************************************************/

#include "qs.h"
#include "pwm.h"
#include "initconfig.h"

/********************************************************************************
 pwmInit() function performs the PEFWM module static configuration
 based on the configurable items from appconfig.h 
********************************************************************************/

void efpwmCommonInit(arch_sEFPWM *pEfpwmBase)
{
#pragma unused(pEfpwmBase)

#if EFPWM_COMMON_INIT_USED && defined(EFPWM) 


		#ifdef PWM_SWCOUT_INIT
		periphMemWrite(PWM_SWCOUT_INIT, (UWord16*) &pEfpwmBase->swcount);
		#endif

		#ifdef PWM_DTSRCSEL_INIT
		periphMemWrite(PWM_DTSRCSEL_INIT, (UWord16*) &pEfpwmBase->dtsrcsel);
		#endif

		#ifdef PWM_MCTRL_INIT
		periphMemDummyRead((UWord16*) &pEfpwmBase->mctrl);
		periphMemWrite(PWM_MCTRL_INIT & (EFPWM_MCTRL_IPOL_MASK | EFPWM_MCTRL_LDOK_MASK), (UWord16*) &pEfpwmBase->mctrl);
		periphMemWrite(PWM_MCTRL_INIT, (UWord16*) &pEfpwmBase->mctrl);
		#endif

		#ifdef PWM_MCTRL2_INIT
		periphMemWrite(PWM_MCTRL2_INIT, (UWord16*) &pEfpwmBase->mctrl2);
		#endif

		#ifdef PWM_FCTRL_INIT
		periphMemWrite(PWM_FCTRL_INIT, (UWord16*) &pEfpwmBase->fctrl);
		#endif

		#ifdef PWM_FSTS_INIT
		periphMemWrite(PWM_FSTS_INIT, (UWord16*) &pEfpwmBase->fsts);
		#endif

		#ifdef PWM_FFILT_INIT
		periphMemWrite(PWM_FFILT_INIT, (UWord16*) &pEfpwmBase->ffilt);
		#endif

		#ifdef PWM_MASK_INIT
		periphMemWrite(PWM_MASK_INIT, (UWord16*) &pEfpwmBase->mask);
		#endif

		#ifdef PWM_OUTEN_INIT
		periphMemWrite(PWM_OUTEN_INIT, (UWord16*) &pEfpwmBase->outen);
		#endif


#endif
}


void efpwmInit(void)
{
	#if EFPWM_SUB0_INIT_USED
   	efpwmSubFracInit(EFPWM_SUB0);
	#endif
	#if EFPWM_SUB1_INIT_USED
   	efpwmSubFracInit(EFPWM_SUB1);
	#endif
	#if EFPWM_SUB2_INIT_USED
   	efpwmSubFracInit(EFPWM_SUB2);
	#endif
	#if EFPWM_SUB3_INIT_USED
   	efpwmSubCaptInit(EFPWM_SUB3);
	#endif
	#if EFPWM_COMMON_INIT_USED
	efpwmCommonInit(EFPWM);
	#endif
}



void efpwmSubFracInit(arch_sEFPWMSubFracModule *pEfpwmBase)
{
#pragma unused(pEfpwmBase)

#if EFPWM_SUB0_INIT_USED && defined(EFPWM_SUB0) 

	if(pEfpwmBase == EFPWM_SUB0)
	{  
		#if PWM_0_USE_PWMVAL
			#ifdef PWM_0_VAL2_INIT
			periphMemWrite(PWM_0_VAL2_INIT, (UWord16*) &pEfpwmBase->smval2);
			#endif
			#ifdef PWM_0_FRACVAL2_INIT
			periphMemWrite(PWM_0_FRACVAL2_INIT, (UWord16*) &pEfpwmBase->smfracval2);
			#endif
			#ifdef PWM_0_VAL3_INIT
			periphMemWrite(PWM_0_VAL3_INIT, (UWord16*) &pEfpwmBase->smval3);
			#endif
			#ifdef PWM_0_FRACVAL3_INIT
			periphMemWrite(PWM_0_FRACVAL3_INIT, (UWord16*) &pEfpwmBase->smfracval3);
			#endif
			#ifdef PWM_0_VAL4_INIT
			periphMemWrite(PWM_0_VAL4_INIT, (UWord16*) &pEfpwmBase->smval4);
			#endif
			#ifdef PWM_0_FRACVAL4_INIT
			periphMemWrite(PWM_0_FRACVAL4_INIT, (UWord16*) &pEfpwmBase->smfracval4);
			#endif
			#ifdef PWM_0_VAL5_INIT
			periphMemWrite(PWM_0_VAL5_INIT, (UWord16*) &pEfpwmBase->smval5);
			#endif
			#ifdef PWM_0_FRACVAL5_INIT
			periphMemWrite(PWM_0_FRACVAL5_INIT, (UWord16*) &pEfpwmBase->smfracval5);
			#endif
		#endif

		#ifdef PWM_0_VAL1_INIT
		periphMemWrite(PWM_0_VAL1_INIT, (UWord16*) &pEfpwmBase->smval1);
		#endif

		#ifdef PWM_0_FRACVAL1_INIT
		periphMemWrite(PWM_0_FRACVAL1_INIT, (UWord16*) &pEfpwmBase->smfracval1);
		#endif

		#ifdef PWM_0_INIT_INIT
		periphMemWrite(PWM_0_INIT_INIT, (UWord16*) &pEfpwmBase->sminit);
		#endif

		#ifdef PWM_0_DTCNT0_INIT
		periphMemWrite(PWM_0_DTCNT0_INIT, (UWord16*) &pEfpwmBase->smdtcnt0);
		#endif

		#ifdef PWM_0_DTCNT1_INIT
		periphMemWrite(PWM_0_DTCNT1_INIT, (UWord16*) &pEfpwmBase->smdtcnt1);
		#endif

		#ifdef PWM_0_CTRL_INIT
		periphMemWrite(PWM_0_CTRL_INIT, (UWord16*) &pEfpwmBase->smctrl);
		#endif

		#ifdef PWM_0_CTRL2_INIT
		periphMemWrite(PWM_0_CTRL2_INIT, (UWord16*) &pEfpwmBase->smctrl2);
		#endif

		#ifdef PWM_0_INTEN_INIT
		periphMemWrite(PWM_0_INTEN_INIT, (UWord16*) &pEfpwmBase->sminten);
		#endif

		#ifdef PWM_0_TCTRL_INIT
		periphMemWrite(PWM_0_TCTRL_INIT, (UWord16*) &pEfpwmBase->smtctrl);
		#endif

		#ifdef PWM_0_DISMAP_INIT
		periphMemWrite(PWM_0_DISMAP_INIT, (UWord16*) &pEfpwmBase->smdismap);
		#endif

		#ifdef PWM_0_FRCTRL_INIT
		periphMemWrite(PWM_0_FRCTRL_INIT, (UWord16*) &pEfpwmBase->smfrctrl);
		#endif

		#ifdef PWM_0_VAL0_INIT
		periphMemWrite(PWM_0_VAL0_INIT, (UWord16*) &pEfpwmBase->smval0);
		#endif

		#ifdef PWM_0_OCTRL_INIT
		periphMemWrite(PWM_0_OCTRL_INIT, (UWord16*) &pEfpwmBase->smoctrl);
		#endif

	}
	else

#endif

#if EFPWM_SUB1_INIT_USED && defined(EFPWM_SUB1) 

	if(pEfpwmBase == EFPWM_SUB1)
	{  
		#if PWM_1_USE_PWMVAL
			#ifdef PWM_1_VAL2_INIT
			periphMemWrite(PWM_1_VAL2_INIT, (UWord16*) &pEfpwmBase->smval2);
			#endif
			#ifdef PWM_1_FRACVAL2_INIT
			periphMemWrite(PWM_1_FRACVAL2_INIT, (UWord16*) &pEfpwmBase->smfracval2);
			#endif
			#ifdef PWM_1_VAL3_INIT
			periphMemWrite(PWM_1_VAL3_INIT, (UWord16*) &pEfpwmBase->smval3);
			#endif
			#ifdef PWM_1_FRACVAL3_INIT
			periphMemWrite(PWM_1_FRACVAL3_INIT, (UWord16*) &pEfpwmBase->smfracval3);
			#endif
			#ifdef PWM_1_VAL4_INIT
			periphMemWrite(PWM_1_VAL4_INIT, (UWord16*) &pEfpwmBase->smval4);
			#endif
			#ifdef PWM_1_FRACVAL4_INIT
			periphMemWrite(PWM_1_FRACVAL4_INIT, (UWord16*) &pEfpwmBase->smfracval4);
			#endif
			#ifdef PWM_1_VAL5_INIT
			periphMemWrite(PWM_1_VAL5_INIT, (UWord16*) &pEfpwmBase->smval5);
			#endif
			#ifdef PWM_1_FRACVAL5_INIT
			periphMemWrite(PWM_1_FRACVAL5_INIT, (UWord16*) &pEfpwmBase->smfracval5);
			#endif
		#endif

		#ifdef PWM_1_VAL0_INIT
		periphMemWrite(PWM_1_VAL0_INIT, (UWord16*) &pEfpwmBase->smval0);
		#endif

		#ifdef PWM_1_VAL1_INIT
		periphMemWrite(PWM_1_VAL1_INIT, (UWord16*) &pEfpwmBase->smval1);
		#endif

		#ifdef PWM_1_FRACVAL1_INIT
		periphMemWrite(PWM_1_FRACVAL1_INIT, (UWord16*) &pEfpwmBase->smfracval1);
		#endif

		#ifdef PWM_1_INIT_INIT
		periphMemWrite(PWM_1_INIT_INIT, (UWord16*) &pEfpwmBase->sminit);
		#endif

		#ifdef PWM_1_CTRL_INIT
		periphMemWrite(PWM_1_CTRL_INIT, (UWord16*) &pEfpwmBase->smctrl);
		#endif

		#ifdef PWM_1_CTRL2_INIT
		periphMemWrite(PWM_1_CTRL2_INIT, (UWord16*) &pEfpwmBase->smctrl2);
		#endif

		#ifdef PWM_1_FRCTRL_INIT
		periphMemWrite(PWM_1_FRCTRL_INIT, (UWord16*) &pEfpwmBase->smfrctrl);
		#endif

		#ifdef PWM_1_OCTRL_INIT
		periphMemWrite(PWM_1_OCTRL_INIT, (UWord16*) &pEfpwmBase->smoctrl);
		#endif

		#ifdef PWM_1_INTEN_INIT
		periphMemWrite(PWM_1_INTEN_INIT, (UWord16*) &pEfpwmBase->sminten);
		#endif

		#ifdef PWM_1_TCTRL_INIT
		periphMemWrite(PWM_1_TCTRL_INIT, (UWord16*) &pEfpwmBase->smtctrl);
		#endif

		#ifdef PWM_1_DISMAP_INIT
		periphMemWrite(PWM_1_DISMAP_INIT, (UWord16*) &pEfpwmBase->smdismap);
		#endif

		#ifdef PWM_1_DTCNT0_INIT
		periphMemWrite(PWM_1_DTCNT0_INIT, (UWord16*) &pEfpwmBase->smdtcnt0);
		#endif

		#ifdef PWM_1_DTCNT1_INIT
		periphMemWrite(PWM_1_DTCNT1_INIT, (UWord16*) &pEfpwmBase->smdtcnt1);
		#endif
	}
	else

#endif

#if EFPWM_SUB2_INIT_USED && defined(EFPWM_SUB2) 

	if(pEfpwmBase == EFPWM_SUB2)
	{  
		#if PWM_2_USE_PWMVAL
			#ifdef PWM_2_VAL2_INIT
			periphMemWrite(PWM_2_VAL2_INIT, (UWord16*) &pEfpwmBase->smval2);
			#endif
			#ifdef PWM_2_FRACVAL2_INIT
			periphMemWrite(PWM_2_FRACVAL2_INIT, (UWord16*) &pEfpwmBase->smfracval2);
			#endif
			#ifdef PWM_2_VAL3_INIT
			periphMemWrite(PWM_2_VAL3_INIT, (UWord16*) &pEfpwmBase->smval3);
			#endif
			#ifdef PWM_2_FRACVAL3_INIT
			periphMemWrite(PWM_2_FRACVAL3_INIT, (UWord16*) &pEfpwmBase->smfracval3);
			#endif
			#ifdef PWM_2_VAL4_INIT
			periphMemWrite(PWM_2_VAL4_INIT, (UWord16*) &pEfpwmBase->smval4);
			#endif
			#ifdef PWM_2_FRACVAL4_INIT
			periphMemWrite(PWM_2_FRACVAL4_INIT, (UWord16*) &pEfpwmBase->smfracval4);
			#endif
			#ifdef PWM_2_VAL5_INIT
			periphMemWrite(PWM_2_VAL5_INIT, (UWord16*) &pEfpwmBase->smval5);
			#endif
			#ifdef PWM_2_FRACVAL5_INIT
			periphMemWrite(PWM_2_FRACVAL5_INIT, (UWord16*) &pEfpwmBase->smfracval5);
			#endif
		#endif

		#ifdef PWM_2_VAL0_INIT
		periphMemWrite(PWM_2_VAL0_INIT, (UWord16*) &pEfpwmBase->smval0);
		#endif

		#ifdef PWM_2_VAL1_INIT
		periphMemWrite(PWM_2_VAL1_INIT, (UWord16*) &pEfpwmBase->smval1);
		#endif

		#ifdef PWM_2_FRACVAL1_INIT
		periphMemWrite(PWM_2_FRACVAL1_INIT, (UWord16*) &pEfpwmBase->smfracval1);
		#endif

		#ifdef PWM_2_INIT_INIT
		periphMemWrite(PWM_2_INIT_INIT, (UWord16*) &pEfpwmBase->sminit);
		#endif

		#ifdef PWM_2_CTRL_INIT
		periphMemWrite(PWM_2_CTRL_INIT, (UWord16*) &pEfpwmBase->smctrl);
		#endif

		#ifdef PWM_2_CTRL2_INIT
		periphMemWrite(PWM_2_CTRL2_INIT, (UWord16*) &pEfpwmBase->smctrl2);
		#endif

		#ifdef PWM_2_FRCTRL_INIT
		periphMemWrite(PWM_2_FRCTRL_INIT, (UWord16*) &pEfpwmBase->smfrctrl);
		#endif

		#ifdef PWM_2_OCTRL_INIT
		periphMemWrite(PWM_2_OCTRL_INIT, (UWord16*) &pEfpwmBase->smoctrl);
		#endif

		#ifdef PWM_2_INTEN_INIT
		periphMemWrite(PWM_2_INTEN_INIT, (UWord16*) &pEfpwmBase->sminten);
		#endif

		#ifdef PWM_2_TCTRL_INIT
		periphMemWrite(PWM_2_TCTRL_INIT, (UWord16*) &pEfpwmBase->smtctrl);
		#endif

		#ifdef PWM_2_DISMAP_INIT
		periphMemWrite(PWM_2_DISMAP_INIT, (UWord16*) &pEfpwmBase->smdismap);
		#endif

		#ifdef PWM_2_DTCNT0_INIT
		periphMemWrite(PWM_2_DTCNT0_INIT, (UWord16*) &pEfpwmBase->smdtcnt0);
		#endif

		#ifdef PWM_2_DTCNT1_INIT
		periphMemWrite(PWM_2_DTCNT1_INIT, (UWord16*) &pEfpwmBase->smdtcnt1);
		#endif
	}
	else

#endif

	; /* last else case */
}



void efpwmSubCaptInit(arch_sEFPWMSubCaptModule *pEfpwmBase)
{
#pragma unused(pEfpwmBase)

#if EFPWM_SUB3_INIT_USED && defined(EFPWM_SUB3) 

	if(pEfpwmBase == EFPWM_SUB3)
	{  
		#if PWM_3_USE_PWMVAL
			#ifdef PWM_3_VAL2_INIT
			periphMemWrite(PWM_3_VAL2_INIT, (UWord16*) &pEfpwmBase->smval2);
			#endif
			#ifdef PWM_3_VAL3_INIT
			periphMemWrite(PWM_3_VAL3_INIT, (UWord16*) &pEfpwmBase->smval3);
			#endif
			#ifdef PWM_3_VAL4_INIT
			periphMemWrite(PWM_3_VAL4_INIT, (UWord16*) &pEfpwmBase->smval4);
			#endif
			#ifdef PWM_3_VAL5_INIT
			periphMemWrite(PWM_3_VAL5_INIT, (UWord16*) &pEfpwmBase->smval5);
			#endif
		#endif

		#ifdef PWM_3_VAL1_INIT
		periphMemWrite(PWM_3_VAL1_INIT, (UWord16*) &pEfpwmBase->smval1);
		#endif

		#ifdef PWM_3_INIT_INIT
		periphMemWrite(PWM_3_INIT_INIT, (UWord16*) &pEfpwmBase->sminit);
		#endif

		#ifdef PWM_3_DISMAP_INIT
		periphMemWrite(PWM_3_DISMAP_INIT, (UWord16*) &pEfpwmBase->smdismap);
		#endif

		#ifdef PWM_3_DTCNT0_INIT
		periphMemWrite(PWM_3_DTCNT0_INIT, (UWord16*) &pEfpwmBase->smdtcnt0);
		#endif

		#ifdef PWM_3_DTCNT1_INIT
		periphMemWrite(PWM_3_DTCNT1_INIT, (UWord16*) &pEfpwmBase->smdtcnt1);
		#endif

		#ifdef PWM_3_CTRL_INIT
		periphMemWrite(PWM_3_CTRL_INIT, (UWord16*) &pEfpwmBase->smctrl);
		#endif

		#ifdef PWM_3_CTRL2_INIT
		periphMemWrite(PWM_3_CTRL2_INIT, (UWord16*) &pEfpwmBase->smctrl2);
		#endif

		#ifdef PWM_3_INTEN_INIT
		periphMemWrite(PWM_3_INTEN_INIT, (UWord16*) &pEfpwmBase->sminten);
		#endif

		#ifdef PWM_3_TCTRL_INIT
		periphMemWrite(PWM_3_TCTRL_INIT, (UWord16*) &pEfpwmBase->smtctrl);
		#endif


		#ifdef PWM_3_VAL0_INIT
		periphMemWrite(PWM_3_VAL0_INIT, (UWord16*) &pEfpwmBase->smval0);
		#endif

		#ifdef PWM_3_CAPTCTRLA_INIT
		periphMemWrite(PWM_3_CAPTCTRLA_INIT, (UWord16*) &pEfpwmBase->smcaptctrla);
		#endif

		#ifdef PWM_3_CAPTCOMPA_INIT
		periphMemWrite(PWM_3_CAPTCOMPA_INIT, (UWord16*) &pEfpwmBase->smcaptcompa);
		#endif

		#ifdef PWM_3_CAPTCTRLB_INIT
		periphMemWrite(PWM_3_CAPTCTRLB_INIT, (UWord16*) &pEfpwmBase->smcaptctrlb);
		#endif

		#ifdef PWM_3_CAPTCOMPB_INIT
		periphMemWrite(PWM_3_CAPTCOMPB_INIT, (UWord16*) &pEfpwmBase->smcaptcompb);
		#endif

		#ifdef PWM_3_CAPTCTRLX_INIT
		periphMemWrite(PWM_3_CAPTCTRLX_INIT, (UWord16*) &pEfpwmBase->smcaptctrlx);
		#endif

		#ifdef PWM_3_CAPTCOMPX_INIT
		periphMemWrite(PWM_3_CAPTCOMPX_INIT, (UWord16*) &pEfpwmBase->smcaptcompx);
		#endif

		#ifdef PWM_3_OCTRL_INIT
		periphMemWrite(PWM_3_OCTRL_INIT, (UWord16*) &pEfpwmBase->smoctrl);
		#endif

	}
	else

#endif
	; /* last else case */
}

