/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* File Name:  crc_8xxx.h
*
* $Date:      Oct-12-2010$
*
* $Version:   2.5.7.0$
*
* Description: Header file for the CRC low-level driver
*
*  CRC_VERSION_1 .. 56F82xx devices, see MC56F82xxRM.pdf
*
*****************************************************************************/

#ifndef __CRC_H
#define __CRC_H

/* qs.h is a master header file, which must be included */
#if !defined(__ARCH_H) || !defined(__PERIPH_H) || !defined(__APPCONFIG_H)
#error Please include qs.h before crc.h
#endif

#ifdef __cplusplus
extern "C" {
#endif

/******************************************************************************
*
*                      General Interface Description
*
* The CRC device driver interface uses "ioctl" call to control specific CRC functions
* during operation. For details see "ioctl" call.
*
******************************************************************************/

/************************************************************
* CRC module identifiers
*************************************************************/

/* single ("anonymous") module on some devices */
#ifdef CRC_BASE
#define CRC     (&ArchIO.Crc)
#endif

/*************************************************************
* arch.h should define device-specific information about CRC
**************************************************************/

#if !defined(CRC_VERSION)
#error CRC not properly described in arch.h (old Quick_Start version?)
#endif


/*****************************************************************
* Single-Instruction  ioctl() commands
*
*  Word16 ioctl( CRC_module_identifier, Command_name, Parameter );
*
******************************************************************

        COMMAND NAME                      PARAMETERS, COMMENTS
------------------------------------------------------------------ */
#define CRC_WRITE_CRC_LOW_REG          /* UWord16, (0-255) value to CRC low byte (CRCL) */
#define CRC_WRITE_CRC_HIGH_REG         /* UWord16, (0-255) value to CRC high byte (CRCH) */
#define CRC_WRITE_CRC_DATA             /* UWord16, (0-255) value to CRC low byte (CRCL) */

#define CRC_READ_CRC_LOW_REG           /* NULL, Returns value of CRC low byte (CRCL) */
#define CRC_READ_CRC_HIGH_REG          /* NULL, Returns value of CRC high byte (CRCH) */

#define CRC_WRITE_CRC_TRANSPOSE        /* UWord16, value of CRC high byte (TRANSPOSE) */
#define CRC_READ_CRC_TRANSPOSE         /* NULL, Returns value of CRC high byte (TRANSPOSE) */


/*****************************************************************
* Multi-Instruction ioctl() commands
*
*  Word16 ioctl( CRC_module_identifier, Command_name, Parameter );
*
******************************************************************

        COMMAND NAME                      PARAMETERS, COMMENTS
------------------------------------------------------------------ */
#define CRC_WRITE_INIT_VALUE           /* UWord16, to initialize the CRC function (CRCH,CRCL) */
#define CRC_READ_CRC_RESULT            /* NULL, Returns value of CRC result bytes (CRCH,CRCL) */
#define CRC_WRITE_CRC_TRANSPOSED_DATA  /* UWord16, (0-255) value, command writes data in to transpose register, transposed data are writed in to CRC low byte (TRANSPOSE,CRCL) */





/****************************************************************************
* CRC command parameters
*****************************************************************************/

#define CRC_CRCH_CRCH_MASK             0xff
#define CRC_CRCL_CRCL_MASK             0xff
#define CRC_TRANSPOSE_TRANSPOSE_MASK   0xff

/****************************************************************************
* CRC ioctl macro implementation
*****************************************************************************/

/* Writes to CRC Low byte */
#define ioctlCRC_WRITE_CRC_LOW_REG(pCrcBase, param)        \
    periphMemWrite((param), &((pCrcBase)->crc_crcl))

/* Writes to CRC Low byte */
#define ioctlCRC_WRITE_CRC_DATA(pCrcBase, param)        \
    periphMemWrite((param), &((pCrcBase)->crc_crcl))

/* Writes to CRC High byte */
#define ioctlCRC_WRITE_CRC_HIGH_REG(pCrcBase, param)        \
    periphMemWrite((param), &((pCrcBase)->crc_crch))

/* Writes to transpose byte of CRC module */
#define ioctlCRC_WRITE_CRC_TRANSPOSE(pCrcBase, param)        \
    periphMemWrite((param), &((pCrcBase)->crc_transponse))

/* Reads and returns CRC Low byte */
#define ioctlCRC_READ_CRC_LOW_REG(pCrcBase, param)        \
    ((periphMemRead( &((pCrcBase)->crc_crcl))))

/* Reads and returns CRC High byte */
#define ioctlCRC_READ_CRC_HIGH_REG(pCrcBase, param)        \
    ((periphMemRead( &((pCrcBase)->crc_crch))))

/* Reads and returns CRC Transpose byte */
#define ioctlCRC_READ_CRC_TRANSPOSE(pCrcBase, param)        \
    ((periphMemRead( &((pCrcBase)->crc_transponse))))

/* writes to byte of CRC */
#define ioctlCRC_WRITE_INIT_VALUE(pCrcBase, param)        \
    periphMemWrite( ((param)>>8), &((pCrcBase)->crc_crch) ); \
    periphMemWrite( (param)&CRC_CRCL_CRCL_MASK, &((pCrcBase)->crc_crcl) )

/*  Low byte of CRC */
#define ioctlCRC_READ_CRC_RESULT(pCrcBase, param)        \
    (( (periphMemRead( &((pCrcBase)->crc_crcl) ))&CRC_CRCL_CRCL_MASK ) | ( ((periphMemRead( &((pCrcBase)->crc_crch) )))<<8 ))

#define ioctlCRC_WRITE_CRC_TRANSPOSED_DATA(pCrcBase, param)        \
    periphMemWrite( (param), &((pCrcBase)->crc_transponse) ); \
    periphMemWrite( periphMemRead( &((pCrcBase)->crc_transponse) ), &((pCrcBase)->crc_crcl) )




#ifdef __cplusplus
}
#endif

#endif
