/*******************************************************************************
*
* Freescale Semiconductor Inc.
* (c) Copyright 2004-2009 Freescale Semiconductor, Inc.
* (c) Copyright 2001-2004 Motorola, Inc.
* ALL RIGHTS RESERVED.
*
********************************************************************************
*
* $File Name: vectors.c$
*
* $Date:      Aug-26-2009$
*
* $Version:   2.5.1.0$
*
* Description: 56F824x/5x Interrupt Vector Table (66 interrupts, INTC_VERSION_5)
*
*****************************************************************************/

#include "qs.h"

#ifndef INTC_VERSION_5
#error Bad INTC version defined in arch.h, or wrong vectors.c used
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* reference to startup code */

void Start(void);

/* for each interrupt vector, we (re)define HERE its correct prototype -
   - So, in the case the user defines BAD prototype himself e.g. in appconfig.h,
     the compiler warns him here about function prototype redefinition */
     
#ifdef INT_VECTOR_ADDR_1			/* 0x02: COP Reset */
void INT_VECTOR_ADDR_1(void);
#endif
#ifdef INT_VECTOR_ADDR_2			/* 0x04: Illegal Instruction */
void INT_VECTOR_ADDR_2(void);
#endif
#ifdef INT_VECTOR_ADDR_3			/* 0x08: HW Stack Overflow */
void INT_VECTOR_ADDR_3(void);
#endif
#ifdef INT_VECTOR_ADDR_4			/* 0x08: HW Stack Overflow */
void INT_VECTOR_ADDR_4(void);
#endif
#ifdef INT_VECTOR_ADDR_5			/* 0x0A: Misaligned Long Word Access */
void INT_VECTOR_ADDR_5(void);
#endif
#ifdef INT_VECTOR_ADDR_6			/* 0x0C: OnCE Step Counter */
void INT_VECTOR_ADDR_6(void);
#endif
#ifdef INT_VECTOR_ADDR_7			/* 0x0E: OnCE Breakpoint Unit */
void INT_VECTOR_ADDR_7(void);
#endif
#ifdef INT_VECTOR_ADDR_8			/* 0x10: OnCE Trace Buffer */
void INT_VECTOR_ADDR_8(void);
#endif
#ifdef INT_VECTOR_ADDR_9			/* 0x12: OnCE Transmit Register Empty */
void INT_VECTOR_ADDR_9(void);
#endif
#ifdef INT_VECTOR_ADDR_10			/* 0x14: OnCE Receive Register Full */
void INT_VECTOR_ADDR_10(void);
#endif
#ifdef INT_VECTOR_ADDR_11			/* 0x16: SW Interrupt 2 */
void INT_VECTOR_ADDR_11(void);
#endif
#ifdef INT_VECTOR_ADDR_12			/* 0x18: SW Interrupt 1 */
void INT_VECTOR_ADDR_12(void);
#endif
#ifdef INT_VECTOR_ADDR_13			/* 0x1A: SW Interrupt 0 */
void INT_VECTOR_ADDR_13(void);
#endif
#ifdef INT_VECTOR_ADDR_14			/* 0x1C: Low-Voltage Interrupt */
void INT_VECTOR_ADDR_14(void);
#endif
#ifdef INT_VECTOR_ADDR_15			/* 0x1E: PLL */
void INT_VECTOR_ADDR_15(void);
#endif
#ifdef INT_VECTOR_ADDR_16			/* 0x20: Quad Timer B, Channel 3 Interrupt */
void INT_VECTOR_ADDR_16(void);
#endif
#ifdef INT_VECTOR_ADDR_17			/* 0x22: Quad Timer B, Channel 2Interrupt */
void INT_VECTOR_ADDR_17(void);
#endif
#ifdef INT_VECTOR_ADDR_18			/* 0x24: Quad Timer B, Channel 1Interrupt */
void INT_VECTOR_ADDR_18(void);
#endif
#ifdef INT_VECTOR_ADDR_19			/* 0x26: Quad Timer B, Channel 0 Interrupt */
void INT_VECTOR_ADDR_19(void);
#endif
#ifdef INT_VECTOR_ADDR_20			/* 0x28: ADCB Conversion Complete Interrupt */
void INT_VECTOR_ADDR_20(void);
#endif
#ifdef INT_VECTOR_ADDR_21			/* 0x2A: ADCA Conversion Complete Interrupt */
void INT_VECTOR_ADDR_21(void);
#endif
#ifdef INT_VECTOR_ADDR_22			/* 0x2C: ADC Zero crossing, Low limit, and high limit interrupt */
void INT_VECTOR_ADDR_22(void);
#endif
#ifdef INT_VECTOR_ADDR_23			/* 0x2E: Reserved */
void INT_VECTOR_ADDR_23(void);
#endif
#ifdef INT_VECTOR_ADDR_24			/* 0x30: Reserved */
void INT_VECTOR_ADDR_24(void);
#endif
#ifdef INT_VECTOR_ADDR_25			/* 0x32: Reserved */
void INT_VECTOR_ADDR_25(void);
#endif
#ifdef INT_VECTOR_ADDR_26			/* 0x34: Reserved */
void INT_VECTOR_ADDR_26(void);
#endif
#ifdef INT_VECTOR_ADDR_27			/* 0x36: QSCI1 Receiver Overrun/Errors */
void INT_VECTOR_ADDR_27(void);
#endif
#ifdef INT_VECTOR_ADDR_28			/* 0x38: QSCI1 Receiver Full */
void INT_VECTOR_ADDR_28(void);
#endif
#ifdef INT_VECTOR_ADDR_29			/* 0x3A: QSCI1 Transmitter Idle */
void INT_VECTOR_ADDR_29(void);
#endif
#ifdef INT_VECTOR_ADDR_30			/* 0x3C: QSCI1 Transmitter Empty */
void INT_VECTOR_ADDR_30(void);
#endif
#ifdef INT_VECTOR_ADDR_31			/* 0x3E: QSCI0 Receiver Overrun/Errors */
void INT_VECTOR_ADDR_31(void);
#endif
#ifdef INT_VECTOR_ADDR_32			/* 0x40: QSCI0 Receiver Full */
void INT_VECTOR_ADDR_32(void);
#endif
#ifdef INT_VECTOR_ADDR_33			/* 0x42: QSCI0 Transmitter Idle */
void INT_VECTOR_ADDR_33(void);
#endif
#ifdef INT_VECTOR_ADDR_34			/* 0x44: QSCI0 Transmitter Empty */
void INT_VECTOR_ADDR_34(void);
#endif
#ifdef INT_VECTOR_ADDR_35			/* 0x46: SPI Transmitter Empty */
void INT_VECTOR_ADDR_35(void);
#endif
#ifdef INT_VECTOR_ADDR_36			/* 0x48: SPI Receiver Full */
void INT_VECTOR_ADDR_36(void);
#endif
#ifdef INT_VECTOR_ADDR_37			/* 0x4a: I2C1 Interrupt */
void INT_VECTOR_ADDR_37(void);
#endif
#ifdef INT_VECTOR_ADDR_38			/* 0x4c: I2C0 Interrupt */
void INT_VECTOR_ADDR_38(void);
#endif
#ifdef INT_VECTOR_ADDR_39			/* 0x4e: Quad Timer A, Channel 3 Interrupt */
void INT_VECTOR_ADDR_39(void);
#endif
#ifdef INT_VECTOR_ADDR_40			/* 0x50: Quad Timer A, Channel 2 Interrupt */
void INT_VECTOR_ADDR_40(void);
#endif
#ifdef INT_VECTOR_ADDR_41			/* 0x52: Quad Timer A, Channel 1 Interrupt */
void INT_VECTOR_ADDR_41(void);
#endif
#ifdef INT_VECTOR_ADDR_42			/* 0x54: Quad Timer A, Channel 0 Interrupt */
void INT_VECTOR_ADDR_42(void);
#endif
#ifdef INT_VECTOR_ADDR_43			/* 0x56: PWM Fault */
void INT_VECTOR_ADDR_43(void);
#endif
#ifdef INT_VECTOR_ADDR_44			/* 0x58: PWM Reload Error */
void INT_VECTOR_ADDR_44(void);
#endif
#ifdef INT_VECTOR_ADDR_45			/* 0x5a: PWM Sub-Module 3 Reload */
void INT_VECTOR_ADDR_45(void);
#endif
#ifdef INT_VECTOR_ADDR_46			/* 0x5c: PWM Sub-Module 3 input capture */
void INT_VECTOR_ADDR_46(void);
#endif
#ifdef INT_VECTOR_ADDR_47			/* 0x5e: PWM Sub-Module 3 Compare */
void INT_VECTOR_ADDR_47(void);
#endif
#ifdef INT_VECTOR_ADDR_48			/* 0x60: PWM Sub-Module 2 Reload */
void INT_VECTOR_ADDR_48(void);
#endif
#ifdef INT_VECTOR_ADDR_49			/* 0x62: PWM Sub-Module 2 Compare */
void INT_VECTOR_ADDR_49(void);
#endif
#ifdef INT_VECTOR_ADDR_50			/* 0x64: PWM Sub-Module 1 Reload */
void INT_VECTOR_ADDR_50(void);
#endif
#ifdef INT_VECTOR_ADDR_51			/* 0x66: PWM Sub-Module 1 Compare */
void INT_VECTOR_ADDR_51(void);
#endif
#ifdef INT_VECTOR_ADDR_52			/* 0x68: PWM Sub-Module 0 Reload */
void INT_VECTOR_ADDR_52(void);
#endif
#ifdef INT_VECTOR_ADDR_53			/* 0x6a: PWM Sub-Module 0 Compare */
void INT_VECTOR_ADDR_53(void);
#endif
#ifdef INT_VECTOR_ADDR_54			/* 0x6c: Flash Memory Access Error */
void INT_VECTOR_ADDR_54(void);
#endif
#ifdef INT_VECTOR_ADDR_55			/* 0x6e: Flash Memory Programming Command Complete */
void INT_VECTOR_ADDR_55(void);
#endif
#ifdef INT_VECTOR_ADDR_56			/* 0x70: Flash Memory Buffer Empty Request */
void INT_VECTOR_ADDR_56(void);
#endif
#ifdef INT_VECTOR_ADDR_57			/* 0x72: Comparator 0 Rising/Falling Flag */
void INT_VECTOR_ADDR_57(void);
#endif
#ifdef INT_VECTOR_ADDR_58			/* 0x74: Comparator 1 Rising/Falling Flag */
void INT_VECTOR_ADDR_58(void);
#endif
#ifdef INT_VECTOR_ADDR_59			/* 0x76: Comparator 2 Rising/Falling Flag */
void INT_VECTOR_ADDR_59(void);
#endif
#ifdef INT_VECTOR_ADDR_60			/* 0x78: GPIOF Interrupt */
void INT_VECTOR_ADDR_60(void);
#endif
#ifdef INT_VECTOR_ADDR_61			/* 0x7a: GPIOE Interrupt */
void INT_VECTOR_ADDR_61(void);
#endif
#ifdef INT_VECTOR_ADDR_62			/* 0x7c: GPIOD Interrupt */
void INT_VECTOR_ADDR_62(void);
#endif
#ifdef INT_VECTOR_ADDR_63			/* 0x7e: GPIOC Interrupt */
void INT_VECTOR_ADDR_63(void);
#endif
#ifdef INT_VECTOR_ADDR_64			/* 0x7e: GPIOB Interrupt */
void INT_VECTOR_ADDR_64(void);
#endif
#ifdef INT_VECTOR_ADDR_65			/* 0x7e: GPIOA Interrupt */
void INT_VECTOR_ADDR_65(void);
#endif
#ifdef INT_VECTOR_ADDR_66			/* 0x7e: SW Interrupt Low Priority */
void INT_VECTOR_ADDR_66(void);
#endif

/* unhandled exception "handler" */

static asm void unhandled_interrupt(void)
{
	/* retrieve VAB field from ICTL register */
	move.l  #ArchIO.Intc.ictl,R0
	move.w  X:(R0),X0
	asrr.w  #6,X0
	bfclr   #0xff80,X0

	/* Interrupt number is stored in X0 register */	
	debughlt
	
	/* Loop forever */
	bra *+0
}

/* illegal instruction interrupt ($04) */

#ifndef INT_VECTOR_ADDR_2
#define INT_VECTOR_ADDR_2 ill_op

static asm void ill_op(void)
{
	debughlt	
	nop
	rti
}

#endif

/* hardware stack overflow interrupt ($08) */

#ifndef INT_VECTOR_ADDR_4
#define INT_VECTOR_ADDR_4 hws_overflow

static asm void hws_overflow(void)
{
	debughlt	
	nop
	rti
}

#endif
	
/* misaligned long word access interrupt ($0A) */

#ifndef INT_VECTOR_ADDR_5
#define INT_VECTOR_ADDR_5 misalign

static asm void misalign(void)
{
	debughlt	
	nop
	rti
}

#endif

/* PLL lost of lock interrupt ($20) */

#ifndef INT_VECTOR_ADDR_15
#define INT_VECTOR_ADDR_15 pll_losslock

static asm void pll_losslock(void)
{
	debughlt
	nop
	rti
}

#endif

/***************************
 *
 * Interrupt vectors table
 *
 ***************************/

#pragma define_section interrupt_vectors "interrupt_vectors.text"  RX
#pragma section interrupt_vectors begin

static asm void int_vec(void)
{
	jmp >Start;           	/* Reset */
	
#ifdef INT_VECTOR_ADDR_1	
	jmp >INT_VECTOR_ADDR_1	/* 0x02: COP Reset */							
#else
	jmp >Start;		
#endif
	
#ifdef INT_VECTOR_ADDR_2	/* 0x04: Illegal Instruction */
	jsr >INT_VECTOR_ADDR_2
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_3	/* 0x06: SW Interrupt 3 */
	jsr >INT_VECTOR_ADDR_3
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_4	/* 0x08: HW Stack Overflow */
	jsr >INT_VECTOR_ADDR_4
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_5	/* 0x0A: Misaligned Long Word Access */
	jsr >INT_VECTOR_ADDR_5
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_6	/* 0x0C: OnCE Step Counter */
	jsr >INT_VECTOR_ADDR_6
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_7	/* 0x0E: OnCE Breakpoint Unit */
	jsr >INT_VECTOR_ADDR_7
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_8	/* 0x10: OnCE Trace Buffer */
	jsr >INT_VECTOR_ADDR_8
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_9	/* 0x12: OnCE Transmit Register Empty */
	jsr >INT_VECTOR_ADDR_9
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_10	/* 0x14: OnCE Receive Register Full */
	jsr >INT_VECTOR_ADDR_10
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_11	/* 0x16: SW Interrupt 2 */
	jsr >INT_VECTOR_ADDR_11
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_12	/* 0x18: SW Interrupt 1 */
	jsr >INT_VECTOR_ADDR_12
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_13	/* 0x1A: SW Interrupt 0 */
	jsr >INT_VECTOR_ADDR_13
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_14	/* 0x1C: Low-Voltage Interrupt */
	jsr >INT_VECTOR_ADDR_14
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_15	/* 0x1E: PLL */
	jsr >INT_VECTOR_ADDR_15
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_16	/* 0x20: Quad Timer B, Channel 3 Interrupt */
	jsr >INT_VECTOR_ADDR_16
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_17	/* 0x22: Quad Timer B, Channel 2Interrupt */
	jsr >INT_VECTOR_ADDR_17
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_18	/* 0x24: Quad Timer B, Channel 1Interrupt */
	jsr >INT_VECTOR_ADDR_18
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_19	/* 0x26: Quad Timer B, Channel 0 Interrupt */
	jsr >INT_VECTOR_ADDR_19
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_20	/* 0x28: ADCB Conversion Complete Interrupt */
	jsr >INT_VECTOR_ADDR_20
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_21	/* 0x2A: ADCA Conversion Complete Interrupt */
	jsr >INT_VECTOR_ADDR_21
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_22	/* 0x2C: ADC Zero crossing, Low limit, and high limit interrupt */
	jsr >INT_VECTOR_ADDR_22
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_23	/* 0x2E: Reserved */
	jsr >INT_VECTOR_ADDR_23
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_24	/* 0x30: Reserved */
	jsr >INT_VECTOR_ADDR_24
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_25	/* 0x32: Reserved */
	jsr >INT_VECTOR_ADDR_25
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_26	/* 0x34: Reserved */
	jsr >INT_VECTOR_ADDR_26
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_27	/* 0x36: QSCI1 Receiver Overrun/Errors */
	jsr >INT_VECTOR_ADDR_27
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_28	/* 0x38: QSCI1 Receiver Full */
	jsr >INT_VECTOR_ADDR_28
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_29	/* 0x3A: QSCI1 Transmitter Idle */
	jsr >INT_VECTOR_ADDR_29
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_30	/* 0x3C: QSCI1 Transmitter Empty */
	jsr >INT_VECTOR_ADDR_30
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_31	/* 0x3E: QSCI0 Receiver Overrun/Errors */
	jsr >INT_VECTOR_ADDR_31
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_32	/* 0x40: QSCI0 Receiver Full */
	jsr >INT_VECTOR_ADDR_32
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_33	/* 0x42: QSCI0 Transmitter Idle */
	jsr >INT_VECTOR_ADDR_33
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_34	/* 0x44: QSCI0 Transmitter Empty */
	jsr >INT_VECTOR_ADDR_34
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_35	/* 0x46: SPI Transmitter Empty */
	jsr >INT_VECTOR_ADDR_35
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_36	/* 0x48: SPI Receiver Full */
	jsr >INT_VECTOR_ADDR_36
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_37	/* 0x4a: I2C1 Interrupt */
	jsr >INT_VECTOR_ADDR_37
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_38	/* 0x4c: I2C0 Interrupt */
	jsr >INT_VECTOR_ADDR_38
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_39	/* 0x4e: Quad Timer A, Channel 3 Interrupt */
	jsr >INT_VECTOR_ADDR_39
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_40	/* 0x50: Quad Timer A, Channel 2 Interrupt */
	jsr >INT_VECTOR_ADDR_40
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_41	/* 0x52: Quad Timer A, Channel 1 Interrupt */
	jsr >INT_VECTOR_ADDR_41
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_42	/* 0x54: Quad Timer A, Channel 0 Interrupt */
	jsr >INT_VECTOR_ADDR_42
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_43	/* 0x56: PWM Fault */
	jsr >INT_VECTOR_ADDR_43
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_44	/* 0x58: PWM Reload Error */
	jsr >INT_VECTOR_ADDR_44
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_45	/* 0x5a: PWM Sub-Module 3 Reload */
	jsr >INT_VECTOR_ADDR_45
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_46	/* 0x5c: PWM Sub-Module 3 input capture */
	jsr >INT_VECTOR_ADDR_46
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_47	/* 0x5e: PWM Sub-Module 3 Compare */
	jsr >INT_VECTOR_ADDR_47	
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_48	/* 0x60: PWM Sub-Module 2 Reload */
	jsr >INT_VECTOR_ADDR_48
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_49	/* 0x62: PWM Sub-Module 2 Compare */
	jsr >INT_VECTOR_ADDR_49
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_50	/* 0x64: PWM Sub-Module 1 Reload */
	jsr >INT_VECTOR_ADDR_50
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_51	/* 0x66: PWM Sub-Module 1 Compare */
	jsr >INT_VECTOR_ADDR_51
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_52	/* 0x68: PWM Sub-Module 0 Reload */
	jsr >INT_VECTOR_ADDR_52
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_53	/* 0x6a: PWM Sub-Module 0 Compare */
	jsr >INT_VECTOR_ADDR_53
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_54	/* 0x6c: Flash Memory Access Error */
	jsr >INT_VECTOR_ADDR_54
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_55	/* 0x6e: Flash Memory Programming Command Complete */
	jsr >INT_VECTOR_ADDR_55
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_56	/* 0x70: Flash Memory Buffer Empty Request */
	jsr >INT_VECTOR_ADDR_56
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_57	/* 0x72: Comparator 0 Rising/Falling Flag */
	jsr >INT_VECTOR_ADDR_57
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_58	/* 0x74: Comparator 1 Rising/Falling Flag */
	jsr >INT_VECTOR_ADDR_58
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_59	/* 0x76: Comparator 2 Rising/Falling Flag */
	jsr >INT_VECTOR_ADDR_59
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_60	/* 0x78: GPIOF Interrupt */
	jsr >INT_VECTOR_ADDR_60
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_61	/* 0x7a: GPIOE Interrupt */
	jsr >INT_VECTOR_ADDR_61
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_62	/* 0x7c: GPIOD Interrupt */
	jsr >INT_VECTOR_ADDR_62
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_63	/* 0x7e: GPIOC Interrupt */
	jsr >INT_VECTOR_ADDR_63
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_64	/* 0x7e: GPIOB Interrupt */
	jsr >INT_VECTOR_ADDR_64
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_65	/* 0x7e: GPIOA Interrupt */
	jsr >INT_VECTOR_ADDR_65
#else
	jsr >unhandled_interrupt
#endif
#ifdef INT_VECTOR_ADDR_66	/* 0x7e: SW Interrupt Low Priority */
	jsr >INT_VECTOR_ADDR_66
#else
	jsr >unhandled_interrupt
#endif

}

#pragma section interrupt_vectors end

#ifdef __cplusplus
}
#endif

