#include "bsp_51JF128.h"
#include "mcg.h"


/* Actual system clock frequency */
int core_clk_khz;
int core_clk_mhz;

void init_hw(void)
{
	EnableInterrupts;
	
	//Disable Watchdog Timer
	SIM_COPC = SIM_COPC_COPT(0);

	// Enable Clocks of all the modules
	SIM_SCGC1 = 0xFF;
	SIM_SCGC2 = 0xFF;
	SIM_SCGC3 = 0xFF;
	SIM_SCGC4 = 0xFF;
	SIM_SCGC5 = 0xFF;
	SIM_SCGC6 = 0xFF; 	

	core_clk_mhz = pll_init(PLL48,XTAL8);
	core_clk_khz = core_clk_mhz*1000;

	/** Set USB fractional divider to one */
	SIM_CLKDIV1 = 0;
	
	/** Enable PTB1 like BUSCLOCK */
	SIM_CLKOUT |= SIM_CLKOUT_CS(5);
	MXC_PTBPF4 = MXC_PTBPF4_B1(7);
	
	/* Enable the pins for the selected UART */
	if (TERM_PORT == UART0_BASE_PTR)
	{
		// Enable Port mux of Uart0, TXD on PTA7
		MXC_PTAPF1 |= MXC_PTAPF1_A7(2);
		// Enable Port mux of Uart0, RXD on PTD6
		MXC_PTDPF1 |= MXC_PTDPF1_D6(2);
		
	}	
	uart_init (TERM_PORT, core_clk_khz, TERMINAL_BAUD);		

}
/********************************************************************/
void fb_clk_init(void)
{
	/* Enable the clock to the FlexBus module */
        SIM_SCGC5 |= SIM_SCGC5_MFBUS_MASK;

 	/* Enable the FB_CLKOUT function on PTB1 (alt7 function) */
        MXC_PTBPF4 = MXC_PTBPF4_B1(7);
        PCTLB_DS |= 0x02;			// enable high drive strength to support high toggle rate	// enable high drive strength to support high toggle rate
}
/********************************************************************/
void clkout_init(unsigned char clockout_select, unsigned char clkoutdiv)
{
	/* Set the trace clock to the core clock frequency */
	// should add test of clkoutdiv to check it is is range 0 to 7
	SIM_CLKOUT = SIM_CLKOUT_CLKOUTDIV(clkoutdiv)|SIM_CLKOUT_CS(clockout_select);
        	
	//Enable CLKOUT on PTA5
	MXC_PTAPF2 = MXC_PTAPF2_A5(6);
	PCTLA_DS |= 0x20;			// enable high drive strength to support high toggle rate
}

