/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 **************************************************************************//*!
 *
 * @file audio_speaker.c
 *
 * @author
 *
 * @version
 *
 * @date 
 *
 * @brief  The file emulates a audio speaker.
 *****************************************************************************/

/******************************************************************************
 * Includes
 *****************************************************************************/
#include "common.h"          /* Contains User Defined Data Types */
#include "bsp_51JF128.h"
#include "usb_audio.h"        /* USB AUDIO Class Header File */
#include "audio_speaker.h"    /* AUDIO Speaker Application Header File */
#include "audio_dac.h"
#include "audio_mtim.h"
/*****************************************************************************
 * Constant and Macro's - None
 *****************************************************************************/

/*****************************************************************************
 * Global Functions Prototypes
 *****************************************************************************/
void TestApp_Init(void);
void TestApp_Task(void);
/****************************************************************************
 * Global Variables
 ****************************************************************************/
 uint_8 audio_sample;
 uint_8 audio_event;
 uint_8 audio_data_recv[DATA_RECV_BUFFER_SIZE];

/*****************************************************************************
 * Local Types - None
 *****************************************************************************/

/*****************************************************************************
 * Local Functions Prototypes
 *****************************************************************************/
static void USB_App_Callback(uint_8 controller_ID,uint_8 event_type, void* val);

/*****************************************************************************
 * Local Variables
 *****************************************************************************/
#ifdef _MC9S08JS16_H
#pragma DATA_SEG APP_DATA
#endif
/* Audio speaker Application start Init Flag */
static volatile boolean start_app = FALSE;
/* Receive Buffer */
static uint_8 g_curr_recv_buf[DATA_BUFF_SIZE];

/*****************************************************************************
 * Local Functions
 *****************************************************************************/
 /******************************************************************************
 *
 *   @name        TestApp_Init
 *
 *   @brief       This function is the entry for Audio Speaker application
 *
 *   @param       None
 *
 *   @return      None
 *****************************************************************************
 * This function starts the Audio Speaker application
 *****************************************************************************/

void TestApp_Init(void)
{
    uint_8   error;

    DisableInterrupts;

	init_hw();
	dac_init();
	mtim_init();
	
	print_str("Hello MCF51JF128 Microcontroller\n"); 
	
    /* Initialize the USB interface */
    error = USB_Class_Audio_Init(CONTROLLER_ID,USB_App_Callback,NULL,NULL);
    
    EnableInterrupts;

}

/******************************************************************************
 *
 *   @name        TestApp_Task
 *
 *   @brief       Application task function. It is called from the main loop
 *
 *   @param       None
 *
 *   @return      None
 *
 *****************************************************************************
 * Application task function. It is called from the main loop
 *****************************************************************************/
void TestApp_Task(void)
{

}

/******************************************************************************
 *
 *    @name        USB_App_Callback
 *
 *    @brief       This function handles Class callback
 *
 *    @param       controller_ID    : Controller ID
 *    @param       event_type       : Value of the event
 *    @param       val              : gives the configuration value
 *
 *    @return      None
 *
 *****************************************************************************
 * This function is called from the class layer whenever reset occurs or enum
 * is completed. After the enum is completed this function sets a variable so
 * that the application can start.
 * This function also receives DATA Send and RECEIVED Events
 *****************************************************************************/
static void USB_App_Callback (
    uint_8 controller_ID,   /* [IN] Controller ID */
    uint_8 event_type,      /* [IN] value of the event */
    void* val               /* [IN] gives the configuration value */
)
{
    uint_8 i;
    uint_8 temp;
    
  	static APP_DATA_STRUCT* data_receive;
  	
    if(event_type == USB_APP_BUS_RESET)
    {
        start_app=FALSE;
    }
    else if(event_type == USB_APP_ENUM_COMPLETE)
    {
        start_app=TRUE;
        
        #if (!(defined _MC9S08JS16_H))
        (void)print_str("Audio Speaker is working ... \r\n");
        #endif
    } 
    else if ((event_type == USB_APP_DATA_RECEIVED) && (TRUE == start_app))
    {
        (void)USB_Class_Audio_Recv_Data(controller_ID, AUDIO_ENDPOINT, g_curr_recv_buf, 8);
        
        audio_event =  USB_APP_DATA_RECEIVED;
        data_receive = (APP_DATA_STRUCT*)val;
      	
        for(i=0;i<data_receive->data_size;i++)
      	{
      		audio_data_recv[i]= (uint_8)(data_receive->data_ptr[i]);

      	}
        
  		/** Send the firs sample */
		temp = audio_data_recv[0];
        DAC0_DAT0H = (uint_8)(temp >> 6); 
		DAC0_DAT0L = (uint_8)(temp << 2);	
		DAC0_C0 |= DAC_C0_DACSWTRG_MASK;
        

    }
    return;
}

/* EOF */
