/******************************************************************************
 *
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2010 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
 ******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************//*!
 *
 * @file cmt.c
 *
 * @author
 *
 * @version
 *
 * @date    
 *
 * @brief   This file configures Pulse Width Modulation (RTC) for Timer 
 *          Implementation
 *****************************************************************************/

/******************************************************************************
 * Includes
 *****************************************************************************/
#include <string.h>
#include "derivative.h"     /* include peripheral declarations */
#include "types.h"          /* Contains User Defined Data Types */
#include "audio_mtim.h"
#include "usb_class.h"
#include "common.h"          /* Contains User Defined Data Types */

#define BUSCLK 0

#define MOD125US		3001
#define MTIMPSL			MTIM_CLK_PS(0)
#define MTIMCLK			MTIM_CLK_CLKS(BUSCLK)


extern uint_8 audio_sample;
extern uint_8 audio_event;
extern uint_8 audio_data_recv[];

volatile uint_8 index_counter = 1;

interrupt 110 void MTIM_ISR (void);

/******************************************************************************
 * @name   mtim_init   
 *
 * @brief   Init real-time counter   
 *
 * @param	   None
 *
 * @return     None
 *
 *****************************************************************************
 * This function init the real-time counter
 *****************************************************************************/
void mtim_init (void)
{
	/**Enable clock to MTIM module */
	SIM_SCGC3 |= SIM_SCGC3_MTIM_MASK;
	
	/** Reassigned MTIM interrupt priority level*/
	INTC_PL6P6 = 39; //110 -71 
	
	/**CLKS:00 Bus clock;
	PS:000 Clock source  1 */
	MTIM0_CLK = MTIMCLK | MTIMPSL;
	
	/**Delay =  (Preescaler * MOD ) / Clock )
	Delay =  1  * 3000 / 24M = 100 us    */
	MTIM0_MOD = MOD125US;

	/**TOF:0 clear flag  TOIE:1 interrupt enable TRST:1 Counter reset TSTP:1 timer is stoped*/
	MTIM0_SC = MTIM_SC_TOIE_MASK +  MTIM_SC_TRST_MASK + MTIM_SC_TSTP_MASK;
	//MTIM0_SC = MTIM_SC_TOIE_MASK +  MTIM_SC_TRST_MASK ;
}

/******************************************************************************
 * @name  rtc_isr     
 *
 * @brief  Interrupt service routine of real-time counter 
 *
 * @param	 None
 *
 * @return   None
 *
 *****************************************************************************
 * This function responses to Interrupt service routine of real-time counter
 *****************************************************************************/
interrupt 110 void MTIM_ISR (void)
{

	uint_8 u8AudioData;
	
	PTA_D ^= 1;
	/** Clear TOF flag */
	
	(void)MTIM0_SC;
	MTIM0_SC&=~0x80;
	
	  if (audio_event == USB_APP_DATA_RECEIVED)
	  {
		  /* The PC sends 8 bit sample for one channel */ 		 
		  u8AudioData = audio_data_recv[index_counter];
		  
		  DAC0_DAT0H = (uint_8)(u8AudioData >> 6); 
		  DAC0_DAT0L = (uint_8)(u8AudioData << 2);	  
		  DAC0_C0 |= DAC_C0_DACSWTRG_MASK;
		  
		  index_counter++;
		  if( index_counter ==  DATA_RECV_BUFFER_SIZE)
		  {
			  /** Clear audio event and reset the index counter to the second sample */
			  index_counter = 1;
			  audio_event = 0;
			  
			  /** Stop MTIM counter */
			  MTIM0_SC |= MTIM_SC_TSTP_MASK;
		  }
	  }

}

