#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */


#include "exceptions.h"
#include "startcf.h"
#include "stdlib.h"
/* 
 * Include common utilities
 */
#include "io.h"
#include "uart.h"
#include "types.h"


/*
* Include driver header files
*/
//#include "register_check.h"

extern int print_str(const char *fmt, ...);
extern int error(const char *fmt, ...);

/*
 * Misc. Defines
 */
#ifdef	FALSE
#undef	FALSE
#endif
#define FALSE	(0)

#ifdef	TRUE
#undef	TRUE
#endif
#define	TRUE	(1)

#ifdef	NULL
#undef	NULL
#endif
#define NULL	(0)

#ifdef  ON
#undef  ON
#endif
#define ON      (1)

#ifdef  OFF
#undef  OFF
#endif
#define OFF     (0)


/*
* System Bus Clock Info
*/
#define REF_CLK             XTAL8
#define CORE_CLK_MHZ        48      /* system/core frequency in MHz */

/* Serial Port Info */
#define TERM_PORT           UART0_BASE_PTR
//#define TERM_PORT           UART1_BASE_PTR
#define TERMINAL_BAUD       115200    

//RAM TARGET
//#define RAM_TARGET 1


// Global pass and fail counts
#define global_pass_count (*(volatile uint_32*)(0x807FF4))
#define global_fail_count (*(volatile uint_32*)(0x807FF8))

/*****************************************************************************
* Macros For Pass / Fail
******************************************************************************/

/* macro to be called for pass event */
#define test_pass() global_pass_count++
/* macro to be called for fail event */
#define test_fail() global_fail_count++; \
	          print_str("\n TEST FAIL")

