#include "devices.h"

#ifndef _FLASH_H_
#define _FLASH_H_

/*FSTAT masks*/

#define CCIF_MASK               0x80
#define ACCERR_MASK             0x20
#define FPVIOL_MASK             0x10
#define CCIF_FPVIOL_MASK        0x90
#define CCIF_ACCERR_MASK        0xA0
#define CCIF_ACCERR_FPVIOL_MASK 0xB0
#define CCIF_MGSTAT1_MASK       0x82
#define CCIF_MGSTAT_MASK        0x83

/*Flash States*/

#define FLASH_OK                0
#define FLASH_BUSY              1
#define FLASH_PROGRAM_ERROR     2
#define FLASH_PROTECT_ERROR     4  
#define FLASH_COMMAND_ERROR     8
#define FLASH_ACCESS_ERROR      16

/*Flash Data*/
#define EEPROM_MAX_PROG_WORDS   4
#define EEPROM_MIN_PROG_WORDS   1


/***********EEPROM COMMANDS******************/
#define ERASE_VERIFY_ALL_BLOCKS  0x01 
/* Verify that all program and data Flash blocks are erased. */
/* CCOBIX end = 0 */
/* CCOB Params - NONE */

#define ERASE_VERIFY_BLOCK       0X02
#define ER_VER_BLK_PAR_NUM       0x01
/*Erase Verify Fixed Number to select EEPROM*/
#define ER_VER_BLK_PAR_VAL       0x00

/* Verify that a Flash block is erased. */
/* CCOBIX end = 0 */
/* CCOB Params - gpage */

#define ERASE_ALL_BLOCKS         0x08 
/* Erase all program and data Flash blocks.
   An erase of all Flash blocks is only possible when the FPLDIS, FPHDIS, and FPOPEN
   bits in the FPROT register and the EPDIS and EPOPEN bits in the EPROM register are
   set prior to launching the command. */
/* CCOBIX end = 0 */
/* CCOB Params - NONE */

#define ERASE_EEPROM_FLASH_BLOCK      0x09
#define ER_EEPROM_FLA_BLK_PAR_NUM     0x02
 
/* Erase a program Flash block.
   An erase of the full program Flash block is only possible when DPOPEN bit in the DFPROT
   register is set prior to launching the command. */
/* CCOBIX end = 1 */
/* CCOB Params - global address */

#define ERASE_VERIFY_EEPROM_FLASH_SECTION 0x10
#define ER_VER_EEPROM_FLA_SEC_PAR_NUM     0x03 
/* Verify that a given number of words starting at the address provided are erased. */
/* CCOBIX end = 2 */
/* CCOB Params - global address of first word, number of words to verify CCOB[2]*/

#define PROGRAM_EEPROM         0x11 
/* Program up to four words in the data Flash block (see Load Data Field command). */
/* CCOBIX end = 2 */
/* CCOB Params - global address, up to 4 data words in CCOB [2:5] */

#define ERASE_EEPROM_SECTOR    0x12
#define ER_EEPROM_SEC_PAR_NUM  0x02

/* Erase all bytes in a data Flash sector. */
/* CCOBIX end = 2 */
/* CCOB Params - global address */

/********FUNCTION PROTOTYPES*************/

unsigned char FlshProgramEEPROM(unsigned long _address, unsigned char _wordNumber, \
                                unsigned int  _word1,   unsigned int  _word2, \
                                unsigned int  _word3,   unsigned int  _word4);
unsigned char FlashEraseVerifyEEPROM(void);
unsigned char FlashEraseEEPROMSector(unsigned long _address);
unsigned char FlashEraseVerifyEEPROMSection(unsigned long _address, unsigned int _wordNumber);
unsigned char FlashEraseEEPROMBlock(void);
                                
void FlashConfigFLClock(void);

#endif /*_FLASH_H_*/